<?php

declare(strict_types = 1);

namespace App\Controller\Admin;

use App\Controller\AppController;
use Cake\I18n\FrozenTime;
use Cake\Mailer\Mailer;
use Cake\Datasource\ConnectionManager;

/**
 * DepartmentSchemes Controller
 *
 * @property \App\Model\Table\DepartmentSchemesTable $DepartmentSchemes
 * @method \App\Model\Entity\DepartmentScheme[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class DepartmentSchemesController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        //$this->Auth->allow(['index']);
        $this->Authentication->addUnauthenticatedActions(['checkstatusofallschemes']);
        if ($this->Authentication->getResult()->getData() && $this->Authentication->getResult()->getData()->users_roles_id == 'cpo') {
            $this->Flash->error(__('Oops, you are not allowed that location'));

            $this->redirect(['controller' => 'Departments', 'action' => 'view', 'prefix' => false]);
        }
//        if ($this->Authentication->getResult()->getData() && $this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
//            if (in_array($this->getRequest()->getParam('action'), ['schemeprofile', 'reldistricts', 'step1', 'step2', 'step3', 'step4', 'step5', 'step6', 'step7', 'finish', 'edit'])) {
////                debug($this->getRequest()->getParam('action'));exit;
//                $this->Flash->error(__('You are not allowed to access that location.'));
//                $this->redirect(['controller' => 'Users', 'action' => 'view']);
//            }
//        }
    }

    public function custom($id = null) {
        $cond = array();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'sub-admin') {
            $cond = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'conditions' => $cond,
        ]);
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('CustomMilestones');
        $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['department_scheme_id' => $id], 'order' => ['display_order' => 'asc', 'id' => 'asc']])->all();

        $this->loadModel('SchemeRequests');
        $schemeRequests = $this->SchemeRequests->find('all', [
                    'conditions' => [
//                        'department_id' => $this->Authentication->getResult()->getData()->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'custom'
            ]])->count();

        $this->set(compact('departmentScheme', 'departments', 'fetch_custom_details', 'schemeRequests'));
        if ($this->request->is(['patch', 'post', 'put'])) {
//            debug($this->request->getData());
//            exit;
            $post = $this->request->getData();
            $all_statuses = array();
//            $this->CustomMilestones->deleteAll(['department_scheme_id' => $id]);

            if ($post['custom_milestone_required'] == 'Yes') {


                foreach ($this->request->getData()['way_forward'] as $key => $data):



                    if (isset($this->request->getData()['pid'][$key])) {
                        //update query
                        $customMilestone = $this->CustomMilestones->get($this->request->getData()['pid'][$key]);

                        $status = ($this->request->getData()['is_completed'][$key] == 'Yes') ? '2' : '9';
//                    debug($status);
                        if ($status == '9') {
                            $compare_date = isset($this->request->getData()['completion_date'][$key]) ? date('Y-m-d', strtotime($this->request->getData()['completion_date'][$key])) : $customMilestone->completion_date->i18nFormat('YYY-MM-dd');
                            if ($compare_date >= date('Y-m-d')) {
                                $status = '3';
                            } else {
                                $now = time(); // or your date as well
                                $your_date = isset($this->request->getData()['completion_date'][$key]) ? strtotime($this->request->getData()['completion_date'][$key]) : strtotime($customMilestone->completion_date->i18nFormat('YYY-MM-dd'));
                                $datediff = $now - $your_date;

                                $diff = round($datediff / (60 * 60 * 24));
                                if ($diff > 15) { //danger zone
                                    $status = '5';
                                } else { //off track
                                    $status = '4';
                                }
                            }
                        }
                        array_push($all_statuses, $status);
                        if (isset($this->request->getData()['completion_date'][$key])) {
                            $customMilestone->completion_date = date('Y-m-d', strtotime($this->request->getData()['completion_date'][$key]));

                            $customMilestone->milestone_name = $this->request->getData()['milestone_name'][$key];
//                            debug(.'-'.);
                        }
//                        $customMilestone->milestone_name = $this->request->getData()['milestone_name'][$key] ;
                        $customMilestone->display_order = $this->request->getData()['display_order'][$key];
                        $customMilestone->way_forward = $data;
                        if (trim($data) !== trim($this->request->getData()['way_forward_old'][$key])) {
                            $customMilestone->last_modified = date('Y-m-d');
                        }
                        $customMilestone->is_completed = $this->request->getData()['is_completed'][$key];
                        $customMilestone->responsibility = $this->request->getData()['responsibility'][$key];
                        $customMilestone->milestone_status = $status;


                        $this->CustomMilestones->save($customMilestone);
                    } else {
//                        debug($this->request->getData());exit;
                        $status = ($this->request->getData()['is_completed'][$key] == 'Yes') ? '2' : '9';
//                    debug($status);
                        if ($status == '9') {
                            $compare_date = date('Y-m-d', strtotime($this->request->getData()['completion_date'][$key]));
                            if ($compare_date >= date('Y-m-d')) {
                                $status = '3';
                            } else {
                                $now = time(); // or your date as well
                                $your_date = strtotime($this->request->getData()['completion_date'][$key]);
                                $datediff = $now - $your_date;

                                $diff = round($datediff / (60 * 60 * 24));
                                if ($diff > 15) { //danger zone
                                    $status = '5';
                                } else { //off track
                                    $status = '4';
                                }
                            }
                        }
                        array_push($all_statuses, $status);

                        $articles = $this->getTableLocator()->get('CustomMilestones');
                        $query = $articles->query();
                        $query->insert(['milestone_name', 'department_scheme_id', 'display_order', 'way_forward', 'is_completed', 'completion_date', 'responsibility', 'created', 'modified', 'milestone_status'])
                                ->values([
                                    'milestone_name' => $this->request->getData()['milestone_name'][$key],
                                    'department_scheme_id' => $id,
                                    'display_order' => $this->request->getData()['display_order'][$key],
                                    'way_forward' => $this->request->getData()['way_forward'][$key],
                                    'is_completed' => $this->request->getData()['is_completed'][$key],
                                    'completion_date' => ($this->request->getData()['completion_date'][$key]) ? date('Y-m-d', strtotime($this->request->getData()['completion_date'][$key])) : '',
                                    'responsibility' => $this->request->getData()['responsibility'][$key],
                                    'milestone_status' => $status,
                                    'created' => date('Y-m-d'),
                                    'modified' => date('Y-m-d'),
                                ])
                                ->execute();
                    }
                endforeach;
            } else {
                array_push($all_statuses, 2);
            }
//            debug($all_statuses);exit;
            //calculating over_all_status

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
            $departmentScheme->last_modified = date('Y-m-d h:i:s');

            $departmentScheme->custom_status = max($all_statuses);
            $post['steps_array'][8] = max($all_statuses);
//            debug($post['steps_array']);exit;
            //calculating over_all_status
            if ($departmentScheme->custom_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->custom_status;

// && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            } else {
                $departmentScheme->overall_status = 5;
            }

//            debug($departmentScheme);
//            exit;
//status thing ends here
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
//                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('Custom milestone has been saved.'));

                return $this->redirect(['action' => 'finish', $id]);
            }
//            debug($departmentScheme);exit;
            $this->Flash->error(__('Custom milestone could not be saved. Please, try again.'));

//            exit;
        }
    }

    public function beforeFilter(\Cake\Event\EventInterface $event) {
        parent::beforeFilter($event);
        // Configure the login action to not require authentication, preventing
        // the infinite redirect loop issue
        $this->Authentication->addUnauthenticatedActions(['update_scheme_status', 'getschemes', 'view', 'getcounters', 'exportpdf', 'exportmultipdf', 'forshahab']);
    }

    public function getcounters() {
//        echo $_GET['type'];

        $cond = array();
        $cond[] = ['DepartmentSchemes.deleted' => 0, 'DepartmentSchemes.flag' => $_GET['flag']];

        if ($_GET['type'] == 'Mega') {
            $cond[] = ['DepartmentSchemes.mega_project' => 'Yes'];
        } else if ($_GET['type'] == 'Normal') {
            $cond[] = ['DepartmentSchemes.scheme_category' => 'Normal'];
        } else if ($_GET['type'] == 'High Priority') {
            $cond[] = ['DepartmentSchemes.scheme_category' => 'High Priority'];
        } else if ($_GET['type'] == 'DFC (Two Years)') {
            $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Two Years)'];
        } else if ($_GET['type'] == 'DFC (Current Year)') {
            $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Current Year)'];
        } else if ($_GET['type'] == 'After Assembly') {
            $cond[] = ['DepartmentSchemes.scheme_category' => 'After Assembly'];
        } else if ($_GET['type'] == 'Mega-high') {
            $cond['OR'] = ['DepartmentSchemes.mega_project' => 'Yes', 'DepartmentSchemes.scheme_category' => 'High Priority'];
        }

        $all_Schemes = $this->DepartmentSchemes->find('all', ['conditions' => $cond])->count();
        $critical_Schemes = $this->DepartmentSchemes->find('all', ['conditions' => [$cond, 'overall_status' => 5]])->count();
        $off_Schemes = $this->DepartmentSchemes->find('all', ['conditions' => [$cond, 'overall_status' => 4]])->count();
        $on_Schemes = $this->DepartmentSchemes->find('all', ['conditions' => [$cond, 'overall_status' => 3]])->count();
        $compl_Schemes = $this->DepartmentSchemes->find('all', ['conditions' => [$cond, 'overall_status' => 2]])->count();
        $not_started_Schemes = $this->DepartmentSchemes->find('all', ['conditions' => [$cond, 'overall_status' => 1]])->count();

        echo json_encode(['all' => $all_Schemes, 'critical' => $critical_Schemes, 'off' => $off_Schemes, 'on' => $on_Schemes, 'not' => $not_started_Schemes, 'comp' => $compl_Schemes]);
//        debug($all_Schemes);
//                $all_Schemes = $this->DepartmentSchemes->find('all', ['conditions' => ['overall_status' => 4, 'mega_project' => 'Yes']])->count()->toArray();

        exit;
    }

    public function checkstatusofallschemes() {

        $dangerSchemes = $this->DepartmentSchemes->find('all', ['contain' => ['Departments'], 'conditions' => ['DepartmentSchemes.deleted' => 0, 'overall_status' => 5, 'mega_project' => 'Yes']])->all()->toArray();
//        debug($dangerSchemes);
        $danger_array = array();
        foreach ($dangerSchemes as $danger):
//            debug($danger->scheme_name);
//            debug($danger->department->department_name);
            $danger_array[$danger->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($danger->scheme_name)) . ' (' . $danger->scheme_type . ')'] = $danger->department->department_name;
        endforeach;
//        debug($danger_array);


        $off_target_Schemes = $this->DepartmentSchemes->find('all', ['contain' => ['Departments'], 'conditions' => ['DepartmentSchemes.deleted' => 0, 'overall_status' => 4, 'mega_project' => 'Yes']])->all()->toArray();
//        debug($off_target_Schemes);
        $off_target_array = array();
        foreach ($off_target_Schemes as $danger):
//            debug($danger->scheme_name);
//            debug($danger->department->department_name);
            $off_target_array[$danger->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($danger->scheme_name)) . ' (' . $danger->scheme_type . ')'] = $danger->department->department_name;
        endforeach;
//        debug($off_target_array);
        if ($danger_array || $off_target_array) {
            $this->send_email_to_admin($danger_array, $off_target_array);
        }

        //send emails to CE & SS PND
//        $this->loadModel('Departments');
        $ce_schemes = $this->DepartmentSchemes->find('all', ['contain' => ['Departments'], 'order' => ['overall_status' => 'desc'], 'conditions' => ['DepartmentSchemes.deleted' => 0, 'id_chief_economist' => '1', 'overall_status IN ' => ['5', '4', '1']]])->all()->toArray();
        if ($ce_schemes) {
            $ce_array = [];
            foreach ($ce_schemes as $danger):
                $ce_array[] = '<img width="20" src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $danger->overall_status . '.PNG" />' . ' ' . $danger->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($danger->scheme_name)) . ' (' . $danger->scheme_type . ')' . ' - "' . $danger->department->department_name . '" Department ';
            endforeach;
//            debug($ce_array);
            $this->ceemail($ce_array);

            echo "sent on " . date('Y-m-d h:i a') . ' to CE M Ali Asghar.<br/>';
        }

        $ss_schemes = $this->DepartmentSchemes->find('all', ['contain' => ['Departments'], 'order' => ['overall_status' => 'desc'], 'conditions' => ['DepartmentSchemes.deleted' => 0, 'id_chief_economist' => '0', 'scheme_category' => 'High Priority', 'department_id NOT IN' => ['16', '5'], 'overall_status IN ' => ['5', '4', '1']]])->all()->toArray();
//        debug($ss_schemes);
//        exit;
        if ($ss_schemes) {
            $ss_array = [];
            foreach ($ss_schemes as $danger):
                $ss_array[] = '<img width="20" src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $danger->overall_status . '.PNG" />' . ' ' . $danger->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($danger->scheme_name)) . ' (' . $danger->scheme_type . ')' . ' - "' . $danger->department->department_name . '" Department ';
            endforeach;
//            debug($ss_array);exit;
            $this->ssemail($ss_array);

            echo "sent on " . date('Y-m-d h:i a') . ' to SS abid wazir.<br/>';
        }


        //send email to cpec
//        $cpec_schemes=$this->DepartmentSchemes->find('all', ['contain' => ['Departments'], 'order' => ['overall_status' => 'desc'], 'conditions' => ['DepartmentSchemes.deleted' => 0, 'scheme_type' => 'CPEC', 'overall_status IN ' => ['5', '4', '1']]])->all()->toArray();
//        
//        if ($cpec_schemes) {
//            $cpec_array = [];
//            foreach ($cpec_schemes as $danger):
//                $cpec_array[] = '<img width="25" src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $danger->overall_status . '.PNG" />' . ' ' . $danger->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($danger->scheme_name)) . ' (' . $danger->scheme_type . ')' . ' - "' . $danger->department->department_name . '" Department ';
//            endforeach;
////            debug($ss_array);exit;
//            $this->cpecschemes($cpec_array);
//            
//             echo "sent on " . date('Y-m-d h:i a').' to SS abid wazir.<br/>';
//        }
//        
//        debug($cpec_schemes);
        exit; //dont have view files thats why ending here
    }

    private function send_email_to_admin($danger_array = null, $off_target_array = null) {

//        debug($danger_array);
//        debug($off_target_array);
        //email code starts here
        $email = new Email();
        $email->viewBuilder()->setTemplate('admin_email_schemes', 'default');
        $email->setEmailFormat('html')
                ->setTo('cmdukp@gmail.com')
//                ->setTo('ahsan.cc@gmail.com')
                ->setFrom(['info@cmdu.kp.gov.pk' => 'cmdu.kp.gov.pk'])
//                ->setBcc('ahsan.cc@gmail.com')
                //->from($this->request->getData()['email'])
                ->setSubject('cmdu.kp.gov.pk - List of All Critically Delayed & Off Target Departmental Schemes')
                ->setViewVars(['danger_array' => $danger_array, 'off_target_array' => $off_target_array])
                ->send();
        echo "sent on " . date('Y-m-d h:i a') . ' to Admins.<br/>';
    }

    private function ceemail($list) {
        $email = new Mailer();
        $email->viewBuilder()->setTemplate('ce_email', 'default');
        $email->setEmailFormat('html')
                ->setTo('maliasghar@gmail.com')
                ->setTransport('gmail')
//                ->setTo('ahsan.cc@gmail.com')
                ->setFrom(['info@cmdu.kp.gov.pk' => 'cmdu.kp.gov.pk'])
                ->setBcc('ahsan.cc@gmail.com')
                //->from($this->request->getData()['email'])
                ->setSubject('cmdu.kp.gov.pk - List of All Critically Delayed, Off Target and Non Started Departmental Schemes')
                ->setViewVars(['schemes' => $list])
                ->send();
    }

    private function ssemail($list) {
        $email = new Mailer();
        $email->viewBuilder()->setTemplate('ss_email', 'default');
        $email->setEmailFormat('html')
                ->setTo('wazir_2@yahoo.com')
                ->setTransport('gmail')
//                ->setTo('ahsan.cc@gmail.com')
                ->setFrom(['info@cmdu.kp.gov.pk' => 'cmdu.kp.gov.pk'])
                ->setBcc('ahsan.cc@gmail.com')
                //->from($this->request->getData()['email'])
                ->setSubject('cmdu.kp.gov.pk - List of All Critically Delayed, Off Target and Non Started Departmental Schemes')
                ->setViewVars(['schemes' => $list])
                ->send();
    }

    public function forshahab() {
//        echo __LINE__;
        $this->loadModel('Districts');
        $districts = $this->Districts->find('list')->toArray();
        $connection = ConnectionManager::get('default');

        foreach ($districts as $key => $district):
            $statement = $connection->execute('SELECT department_scheme_id FROM `scheme_districts` s where s.district_id =' . $key . ' and s.`department_scheme_id` not in (select si.`department_scheme_id` from scheme_districts si where si.`district_id` !=' . $key . ')')->fetchAll('assoc');


            $fresh_array = array();
            foreach ($statement as $st):
//            debug($st['department_scheme_id']);
                array_push($fresh_array, $st['department_scheme_id']);
            endforeach;
//            debug($fresh_array);
            $this->DepartmentSchemes->updateAll(
                    [// fields
                'district_id' => $key
                    ], [// conditions
                'id in' => $fresh_array
                    ]
            );
        endforeach;
        echo "updated...";
        exit;
    }

    public function getschemes() {
//        echo implode(',',$_GET['dist']);exit;
        $cond = array();
        $cond[] = ['DepartmentSchemes.deleted' => 0];
        $get_comments = '';

        if (isset($_GET['flag'])) {
            $cond[] = ['DepartmentSchemes.flag' => $_GET['flag']];
        }

        if (isset($_GET['dist'])) {
//            $this->loadModel('SchemeDistricts');
//            $fetch_schemes = $this->SchemeDistricts->find('list', ['conditions' => [
//                            'SchemeDistricts.district_id IN ' => $_GET['dist'],
////                            'SchemeDistricts.department_id IN ' => $_GET['department']
//                ]])->all()->toArray();
////            debug($fetch_schemes);
////            exit;
//            if ($fetch_schemes) {
//                $cond[] = ['DepartmentSchemes.id IN' => $fetch_schemes];
//            }

            $connection = ConnectionManager::get('default');
//        $statement = $connection->execute(
//                        'SELECT * FROM table WHERE table.id = :id', ['id' => $id]
//                )->fetchAll('assoc');
//echo implode(',',$_GET['dist']);exit;
//            echo 'SELECT department_scheme_id FROM `scheme_districts` s where s.district_id IN ('.implode(',',$_GET['dist']).') and s.`department_scheme_id`  not in (select si.`department_scheme_id` '
//                        . 'from scheme_districts si where si.`district_id` NOT IN ('.implode(',',$_GET['dist']).'))';exit;
            $statement = $connection->execute('SELECT department_scheme_id FROM `scheme_districts` s where s.district_id IN (' . implode(',', $_GET['dist']) . ') and s.`department_scheme_id`  not in (select si.`department_scheme_id` from scheme_districts si where si.`district_id` NOT IN (' . implode(',', $_GET['dist']) . '))')->fetchAll('assoc');

//        debug($statement);

            $fresh_array = array();
            foreach ($statement as $st):
//            debug($st['department_scheme_id']);
                array_push($fresh_array, $st['department_scheme_id']);
            endforeach;

            if ($fresh_array) {
                $cond[] = ['DepartmentSchemes.id IN' => $fresh_array];
            }
        }

        if (is_numeric($_GET['department_id'])) {
            if ($_GET['department_id'] == 99 && $_GET['name']) {
                $cond[] = ['OR' => ['DepartmentSchemes.scheme_code like ' => '%' . $_GET['name'] . '%', 'DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
            } else {
                $cond[] = ['DepartmentSchemes.department_id' => $_GET['department_id']];
                $this->loadModel('Comments');
                $get_comments = $this->Comments->find('all', ['contain' => ['Users'], 'conditions' => ['Comments.department_id' => $_GET['department_id'], 'Comments.department_scheme_id IS NULL']])->all();
            }
        } else {
            switch ($_GET['department_id']) {
                case 'PPP':
                    $cond[] = ['DepartmentSchemes.is_ppp' => 'Yes'];


                    break;
                case 'IDS':
                    $cond[] = ['DepartmentSchemes.foreign_funded' => 'Yes'];


                    break;
                case 'PSDP':
                    $cond[] = ['DepartmentSchemes.scheme_type' => 'PSDP'];


                    break;

                case 'CPEC':
                    $cond[] = ['DepartmentSchemes.scheme_type' => 'CPEC'];


                    break;

                case 'Not Started':
                    $cond[] = ['DepartmentSchemes.overall_status' => '1'];


                    break;
                case 'Critically Delayed':
                    $cond[] = ['DepartmentSchemes.overall_status' => '5'];


                    break;
                case 'Off Target':
                    $cond[] = ['DepartmentSchemes.overall_status' => '4'];


                    break;
                case 'On Target':
                    $cond[] = ['DepartmentSchemes.overall_status' => '3'];


                    break;
                case 'Completed':
                    $cond[] = ['DepartmentSchemes.overall_status' => '2'];


                    break;

                default:
                    break;
            }
        }

        if ($_GET['type'] == 'Mega') {
            $cond[] = ['DepartmentSchemes.mega_project' => 'Yes'];
        } else if ($_GET['type'] == 'Normal') {
            $cond[] = ['DepartmentSchemes.scheme_category' => 'Normal'];
        } else if ($_GET['type'] == 'High Priority') {
            $cond[] = ['DepartmentSchemes.scheme_category' => 'High Priority'];
        } else if ($_GET['type'] == 'DFC (Two Years)') {
            $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Two Years)'];
        } else if ($_GET['type'] == 'DFC (Current Year)') {
            $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Current Year)'];
        } else if ($_GET['type'] == 'After Assembly') {
            $cond[] = ['DepartmentSchemes.scheme_category' => 'After Assembly'];
        } else if ($_GET['type'] == 'Mega-high') {
            $cond['OR'] = ['DepartmentSchemes.mega_project' => 'Yes', 'DepartmentSchemes.scheme_category' => 'High Priority'];
        }

        if (isset($_GET['is_peshawar'])) {
            $cond[] = ['DepartmentSchemes.is_peshawar' => '1'];
        }
        if (isset($_GET['scheme_type']) && !empty($_GET['scheme_type'])) {
            $cond[] = ['DepartmentSchemes.scheme_type' => $_GET['scheme_type']];
        }

        if (isset($_GET['is_chief'])) {
            $cond[] = ['DepartmentSchemes.id_chief_economist' => '1'];
        }

        if (isset($_GET['is_ss'])) {
            $cond[] = ['DepartmentSchemes.id_chief_economist' => '0'];
            $cond[] = ['DepartmentSchemes.scheme_category' => 'High Priority'];
        }
//        debug($cond);exit;
        $get_all_Schemes = $this->DepartmentSchemes->find('all', [
                    'conditions' => $cond,
                    'fields' => ['overall_status', 'id', 'scheme_name', 'scheme_code', 'mega_project', 'department_id'],
                    'order' => ['overall_status' => 'desc']
                ])->all()->toArray();
        echo json_encode(array('schemes_list' => $get_all_Schemes, 'comments' => $get_comments));

        exit;
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index($dept_id = null) {

        $cond = array();
        $cond[] = ['DepartmentSchemes.deleted' => 0];


        if ($dept_id) {
            $cond[] = ['DepartmentSchemes.department_id' => $dept_id];

            $this->loadModel('Departments');

            $department = $this->Departments->find('all', ['conditions' => ['id' => $dept_id]])->first();

            $this->set(compact('department'));
        }
//        debug($department);exit;
        if (isset($_GET['status']) && $_GET['status'] !== '') {
            $cond[] = ['DepartmentSchemes.overall_status' => $_GET['status']];
        }

        if (isset($_GET['name']) && $_GET['name'] !== '') {
            if (is_numeric($_GET['name'])) {
                $cond[] = ['OR' => ['DepartmentSchemes.scheme_code' => $_GET['name']]];
            }
            if (!is_numeric($_GET['name'])) {
                $cond[] = ['OR' => ['DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
            }
        }

        if (isset($_GET['directive']) && $_GET['directive'] !== '') {
            $cond[] = ['DepartmentSchemes.directive' => $_GET['directive']];
        }

        if (isset($_GET['scheme_type']) && $_GET['scheme_type'] !== '') {
            $cond[] = ['DepartmentSchemes.scheme_type' => $_GET['scheme_type']];
        }

        if (isset($_GET['district']) && $_GET['district'] !== '') {
//            debug($_GET['district']);
//            exit;
            $this->loadModel('SchemeDistricts');
            $fetch_schemes = $this->SchemeDistricts->find('list', ['conditions' => [
                            'SchemeDistricts.district_id IN ' => $_GET['district'],
                            'SchemeDistricts.department_id' => $dept_id
                ]])->all()->toArray();
//            debug($fetch_schemes);
//            exit;
            if ($fetch_schemes) {
                $cond[] = ['DepartmentSchemes.id IN' => $fetch_schemes];
            } else {
                $cond[] = ['DepartmentSchemes.id IN' => array('1234567890')];
            }
        }
//        debug($cond);exit;
//        $this->loadModel('SchemeDistricts');

        $this->paginate = [
            'conditions' => $cond,
            'order' => ['id' => 'desc'],
//            'contain' => ['SchemeDistricts'],
//            'fields' => ['id', 'overall_status', 'scheme_name','scheme_code','SchemeDistricts.*']//,'SchemeStatuses.status_color_pattern'
        ];
        $departmentSchemes = $this->paginate($this->DepartmentSchemes);

        $this->loadModel('Districts');
        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();
//        debug($districts);exit;
        $this->set(compact('departmentSchemes', 'districts'));
    }

    private function send_types() {
        return ["ADP" => "ADP", 'MA-ADP' => 'MA-ADP', "AIP" => "AIP", 'PSDP' => 'PSDP', 'Own_source' => 'Own Source', 'CPEC' => 'CPEC', 'Other' => 'Other'];
    }

    public function ppp() {
        $this->paginate = [
            'conditions' => ['DepartmentSchemes.is_ppp' => 'Yes', 'DepartmentSchemes.deleted' => 0],
            'order' => ['id' => 'desc'],
            'contain' => ['Departments'],
//            'fields' => ['id', 'overall_status', 'scheme_name','scheme_code','SchemeDistricts.*']//,'SchemeStatuses.status_color_pattern'
        ];
        $departmentSchemes = $this->paginate($this->DepartmentSchemes);
        $this->set(compact('departmentSchemes'));
    }

    public function ff() {
        $this->paginate = [
            'limit' => 30,
            'conditions' => ['DepartmentSchemes.foreign_funded' => 'Yes', 'DepartmentSchemes.deleted' => 0],
            'order' => ['id' => 'desc'],
            'contain' => ['Departments'],
//            'fields' => ['id', 'overall_status', 'scheme_name','scheme_code','SchemeDistricts.*']//,'SchemeStatuses.status_color_pattern'
        ];
        $departmentSchemes = $this->paginate($this->DepartmentSchemes);
        $this->set(compact('departmentSchemes'));
    }

    public function reportall() {
        $cond = array();
        $cond[] = ['DepartmentSchemes.deleted' => 0];

        if (isset($_GET['department'])) {
            $cond[] = ['DepartmentSchemes.department_id IN' => $_GET['department']];

//            $this->loadModel('Departments');
//
//            $department = $this->Departments->find('all', ['conditions' => ['id' => $dept_id]])->first();
//
//            $this->set(compact('department'));
        }
//        debug($department);exit;
        if (isset($_GET['status']) && $_GET['status'] !== '') {
            $cond[] = ['DepartmentSchemes.overall_status' => $_GET['status']];
        }

        if (isset($_GET['directive_search']) && $_GET['directive_search'] !== '') {
            $cond[] = ['DepartmentSchemes.directive' => $_GET['directive_search']];
        }
        if (isset($_GET['mega_project_search']) && $_GET['mega_project_search'] !== '') {
            if ($_GET['mega_project_search'] == 'Mega') {
                $cond[] = ['DepartmentSchemes.mega_project' => 'Yes'];
            } else if ($_GET['mega_project_search'] == 'Normal') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'Normal'];
            } else if ($_GET['mega_project_search'] == 'High Priority') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'High Priority'];
            } else if ($_GET['mega_project_search'] == 'DFC (Two Years)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Two Years)'];
            } else if ($_GET['mega_project_search'] == 'DFC (Current Year)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Current Year)'];
            } else if ($_GET['mega_project_search'] == 'After Assembly') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'After Assembly'];
            }
        }
        if (isset($_GET['foreign_funded']) && $_GET['foreign_funded'] !== '') {
            $cond[] = ['DepartmentSchemes.foreign_funded' => $_GET['foreign_funded']];
        }

        if (isset($_GET['scheme_type']) && $_GET['scheme_type'] !== '') {
            $cond[] = ['DepartmentSchemes.scheme_type' => $_GET['scheme_type']];
        }

        if (isset($_GET['name']) && $_GET['name'] !== '') {
//            if (is_numeric($_GET['name'])) {
//                $cond[] = ['OR' => ['DepartmentSchemes.scheme_code' => $_GET['name']]];
//            }
//            if (!is_numeric($_GET['name'])) {
//                $cond[] = ['OR' => ['DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
//            }
            $cond[] = ['OR' => ['DepartmentSchemes.scheme_code like ' => '%' . $_GET['name'] . '%', 'DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
        }

        if (isset($_GET['district']) && $_GET['district'] !== '') {
//            debug($_GET['district']);
//            exit;
            $connection = ConnectionManager::get('default');

            $statement = $connection->execute('SELECT department_scheme_id FROM `scheme_districts` s where s.district_id IN (' . implode(',', $_GET['district']) . ') and s.`department_scheme_id`  not in (select si.`department_scheme_id` from scheme_districts si where si.`district_id` NOT IN (' . implode(',', $_GET['district']) . '))')->fetchAll('assoc');

//        debug($statement);

            $fresh_array = array();
            foreach ($statement as $st):
//            debug($st['department_scheme_id']);
                array_push($fresh_array, $st['department_scheme_id']);
            endforeach;

            if ($fresh_array) {
                $cond[] = ['DepartmentSchemes.id IN' => $fresh_array];
            } else {
                $cond[] = ['DepartmentSchemes.id IN' => array('1234567890')];
            }
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }

//        debug($cond);exit;
//        $this->loadModel('SchemeDistricts');
//        $this->paginate = [
//            'limit' => 200,
//            'conditions' => $cond,
//            'order' => ['id' => 'desc'],
////            'contain' => ['SchemeDistricts'],
//            'fields' => ['id', 'id_chief_economist', 'overall_status', 'scheme_name', 'scheme_code', 'scheme_type', 'department_id', 'last_modified', 'locked', 'directive', 'mega_project', 'issues_list']//,'SchemeStatuses.status_color_pattern'
//        ];
        $departmentSchemes = $this->DepartmentSchemes->find('all', [
                    'conditions' => $cond,
                    'order' => ['id' => 'desc'],
//            'contain' => ['SchemeDistricts'],
                    'fields' => ['id', 'created_by', 'id_chief_economist', 'overall_status', 'scheme_name', 'scheme_code', 'scheme_type', 'department_id', 'last_modified', 'locked', 'directive', 'mega_project', 'issues_list']
                ])->all();

        $this->loadModel('Districts');
        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();

        $cond = array();
//        $cond[] = ['Departments.deleted' => 0
////            ,'Departments.department_name NOT LIKE'=>'Other'
//        ];
        $this->loadModel('Departments');
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['Departments.id IN ' => $get_departments];
        }
//        $departments_assigned = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();
        $departments = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();

//        debug($districts);exit;
        $project_types = $this->send_types();

        $this->set(compact('departmentSchemes', 'districts', 'departments', 'project_types'));
    }

    public function flaggedreport() {

        $cond = array();
        $cond[] = ['DepartmentSchemes.deleted' => 0, 'DepartmentSchemes.flag' => 1];

        if (isset($_GET['department'])) {
            $cond[] = ['DepartmentSchemes.department_id IN' => $_GET['department']];

//            $this->loadModel('Departments');
//
//            $department = $this->Departments->find('all', ['conditions' => ['id' => $dept_id]])->first();
//
//            $this->set(compact('department'));
        }
//        debug($department);exit;
        if (isset($_GET['status']) && $_GET['status'] !== '') {
            $cond[] = ['DepartmentSchemes.overall_status' => $_GET['status']];
        }

        if (isset($_GET['directive_search']) && $_GET['directive_search'] !== '') {
            $cond[] = ['DepartmentSchemes.directive' => $_GET['directive_search']];
        }
        if (isset($_GET['mega_project_search']) && $_GET['mega_project_search'] !== '') {
            if ($_GET['mega_project_search'] == 'Mega') {
                $cond[] = ['DepartmentSchemes.mega_project' => 'Yes'];
            } else if ($_GET['mega_project_search'] == 'Normal') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'Normal'];
            } else if ($_GET['mega_project_search'] == 'High Priority') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'High Priority'];
            } else if ($_GET['mega_project_search'] == 'DFC (Two Years)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Two Years)'];
            } else if ($_GET['mega_project_search'] == 'DFC (Current Year)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Current Year)'];
            } else if ($_GET['mega_project_search'] == 'After Assembly') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'After Assembly'];
            }
        }
        if (isset($_GET['foreign_funded']) && $_GET['foreign_funded'] !== '') {
            $cond[] = ['DepartmentSchemes.foreign_funded' => $_GET['foreign_funded']];
        }

        if (isset($_GET['scheme_type']) && $_GET['scheme_type'] !== '') {
            $cond[] = ['DepartmentSchemes.scheme_type' => $_GET['scheme_type']];
        }

        if (isset($_GET['name']) && $_GET['name'] !== '') {
//            if (is_numeric($_GET['name'])) {
//                $cond[] = ['OR' => ['DepartmentSchemes.scheme_code' => $_GET['name']]];
//            }
//            if (!is_numeric($_GET['name'])) {
//                $cond[] = ['OR' => ['DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
//            }
            $cond[] = ['OR' => ['DepartmentSchemes.scheme_code like ' => '%' . $_GET['name'] . '%', 'DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
        }

        if (isset($_GET['district']) && $_GET['district'] !== '') {
//            debug($_GET['district']);
//            exit;
            $connection = ConnectionManager::get('default');

            $statement = $connection->execute('SELECT department_scheme_id FROM `scheme_districts` s where s.district_id IN (' . implode(',', $_GET['district']) . ') and s.`department_scheme_id`  not in (select si.`department_scheme_id` from scheme_districts si where si.`district_id` NOT IN (' . implode(',', $_GET['district']) . '))')->fetchAll('assoc');

//        debug($statement);

            $fresh_array = array();
            foreach ($statement as $st):
//            debug($st['department_scheme_id']);
                array_push($fresh_array, $st['department_scheme_id']);
            endforeach;

            if ($fresh_array) {
                $cond[] = ['DepartmentSchemes.id IN' => $fresh_array];
            } else {
                $cond[] = ['DepartmentSchemes.id IN' => array('1234567890')];
            }
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }

//        debug($cond);exit;
//        $this->loadModel('SchemeDistricts');

        $this->paginate = [
            'limit' => 200,
            'conditions' => $cond,
            'order' => ['id' => 'desc'],
//            'contain' => ['SchemeDistricts'],
            'fields' => ['id', 'created_by', 'id_chief_economist', 'overall_status', 'scheme_name', 'scheme_code', 'scheme_type', 'department_id', 'last_modified', 'locked', 'directive', 'mega_project', 'issues_list']//,'SchemeStatuses.status_color_pattern'
        ];

        $departmentSchemes = $this->paginate($this->DepartmentSchemes);

        $this->loadModel('Districts');
        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();

        $cond = array();
//        $cond[] = ['Departments.deleted' => 0
////            ,'Departments.department_name NOT LIKE'=>'Other'
//        ];
        $this->loadModel('Departments');
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['Departments.id IN ' => $get_departments];
        }
//        
//        $departments_assigned = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();
        $departments = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();


        $project_types = $this->send_types();
//debug($project_types);exit;
        $this->set(compact('departmentSchemes', 'districts', 'departments', 'project_types'));
    }

    public function report() {

        $cond = array();
        $cond[] = ['DepartmentSchemes.deleted' => 0];

        if (isset($_GET['department'])) {
            $cond[] = ['DepartmentSchemes.department_id IN' => $_GET['department']];

//            $this->loadModel('Departments');
//
//            $department = $this->Departments->find('all', ['conditions' => ['id' => $dept_id]])->first();
//
//            $this->set(compact('department'));
        }
//        debug($department);exit;
        if (isset($_GET['status']) && $_GET['status'] !== '') {
            $cond[] = ['DepartmentSchemes.overall_status' => $_GET['status']];
        }

        if (isset($_GET['directive_search']) && $_GET['directive_search'] !== '') {
            $cond[] = ['DepartmentSchemes.directive' => $_GET['directive_search']];
        }
        if (isset($_GET['mega_project_search']) && $_GET['mega_project_search'] !== '') {
            if ($_GET['mega_project_search'] == 'Mega') {
                $cond[] = ['DepartmentSchemes.mega_project' => 'Yes'];
            } else if ($_GET['mega_project_search'] == 'Normal') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'Normal'];
            } else if ($_GET['mega_project_search'] == 'High Priority') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'High Priority'];
            } else if ($_GET['mega_project_search'] == 'DFC (Two Years)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Two Years)'];
            } else if ($_GET['mega_project_search'] == 'DFC (Current Year)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Current Year)'];
            } else if ($_GET['mega_project_search'] == 'After Assembly') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'After Assembly'];
            }
        }
        if (isset($_GET['foreign_funded']) && $_GET['foreign_funded'] !== '') {
            $cond[] = ['DepartmentSchemes.foreign_funded' => $_GET['foreign_funded']];
        }

        if (isset($_GET['scheme_type']) && $_GET['scheme_type'] !== '') {
            $cond[] = ['DepartmentSchemes.scheme_type' => $_GET['scheme_type']];
        }

        if (isset($_GET['name']) && $_GET['name'] !== '') {
//            if (is_numeric($_GET['name'])) {
//                $cond[] = ['OR' => ['DepartmentSchemes.scheme_code' => $_GET['name']]];
//            }
//            if (!is_numeric($_GET['name'])) {
//                $cond[] = ['OR' => ['DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
//            }
            $cond[] = ['OR' => ['DepartmentSchemes.scheme_code like ' => '%' . $_GET['name'] . '%', 'DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
        }

        if (isset($_GET['district']) && $_GET['district'] !== '') {
//            debug($_GET['district']);
//            exit;
            $connection = ConnectionManager::get('default');

            $statement = $connection->execute('SELECT department_scheme_id FROM `scheme_districts` s where s.district_id IN (' . implode(',', $_GET['district']) . ') and s.`department_scheme_id`  not in (select si.`department_scheme_id` from scheme_districts si where si.`district_id` NOT IN (' . implode(',', $_GET['district']) . '))')->fetchAll('assoc');

//        debug($statement);

            $fresh_array = array();
            foreach ($statement as $st):
//            debug($st['department_scheme_id']);
                array_push($fresh_array, $st['department_scheme_id']);
            endforeach;

            if ($fresh_array) {
                $cond[] = ['DepartmentSchemes.id IN' => $fresh_array];
            } else {
                $cond[] = ['DepartmentSchemes.id IN' => array('1234567890')];
            }
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }

//        debug($cond);exit;
//        $this->loadModel('SchemeDistricts');

        $this->paginate = [
            'limit' => 200,
            'conditions' => $cond,
            'order' => ['id' => 'desc'],
//            'contain' => ['SchemeDistricts'],
            'fields' => ['id', 'created_by', 'id_chief_economist', 'overall_status', 'scheme_name', 'scheme_code', 'scheme_type', 'department_id', 'last_modified', 'locked', 'directive', 'mega_project', 'issues_list']//,'SchemeStatuses.status_color_pattern'
        ];
        $departmentSchemes = $this->paginate($this->DepartmentSchemes);

        $this->loadModel('Districts');
        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();

        $cond = array();
//        $cond[] = ['Departments.deleted' => 0
////            ,'Departments.department_name NOT LIKE'=>'Other'
//        ];
        $this->loadModel('Departments');
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['Departments.id IN ' => $get_departments];
        }
//        $departments_assigned = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();
        $departments = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();

//        debug($districts);exit;
        $project_types = $this->send_types();

        $this->set(compact('departmentSchemes', 'districts', 'departments', 'project_types'));
    }

    public function update_scheme_status() {
        $departmentScheme = $this->DepartmentSchemes->get($_GET['id']);
        $departmentScheme->overall_status = $_GET['overall_status'] == 2.5 ? 1 : $_GET['overall_status'];
        $this->DepartmentSchemes->save($departmentScheme);
        echo json_encode('yes');
        exit;
    }

    public function update_all_schemes_status() {
        $schemes = $this->DepartmentSchemes->find('all', ['deleted' => 0])->all();
        $this->loadModel('CustomMilestones');
        $this->loadModel('SubActivity');

        foreach ($schemes as $scheme) {
            $scheme_overall_status = 0;
            $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['department_scheme_id' => $scheme->id]])->all();
            foreach ($fetch_custom_details as $activity) {
                $activity_name = $activity->milestone_name;
                $all_subactivities = $this->SubActivity->find('all', ['conditions' => ['activity' => $activity->id]])->all();
                $overall_status = 0;
                if (!empty($all_subactivities)) {
                    foreach ($all_subactivities as $rec) {
                        $rec = json_decode(json_encode($rec));
                        //echo '<pre>';print_r($rec);exit;
                        if ($rec->status != 2) {
                            if ($rec->start_date > date('Y-m-d')) {
                                $rec->status = 2.5;
                            }

                            if ($rec->start_date <= date('Y-m-d')) {
                                $rec->status = 3;
                            }

                            if ($rec->end_date < date('Y-m-d')) {
                                $rec->status = 4;
                            }

                            $now = strtotime(date('Y-m-d')); // or your date as well
                            $your_date = strtotime($rec->end_date);
                            $datediff = $now - $your_date;
                            $datediff = round($datediff / (60 * 60 * 24));

                            //if(strtotime($rec->end_date) < strtotime('-15 days')) {
                            if ($datediff > 0 && $datediff <= 15) {
                                $rec->status = 4;
                            } else if ($datediff > 15) {
                                $rec->status = 5;
                            }
                        }

                        if ($rec->status * 10 > $overall_status * 10) {
                            if ($overall_status == 2 && strtolower($activity_name) == 'civil works') {
                                $overall_status = 3;
                            } else {
                                $overall_status = $rec->status;
                            }
                        }
                    }
                }

                if ($overall_status > $scheme_overall_status) {
                    $scheme_overall_status = $overall_status;
                }
            }

            $departmentScheme = $this->DepartmentSchemes->get($scheme->id);
            $departmentScheme->overall_status = $scheme_overall_status == 2.5 ? 1 : $scheme_overall_status;
            $this->DepartmentSchemes->save($departmentScheme);
        }
        echo json_encode('yes');
        exit;
    }

    public function changestatus() {
//        debug($_GET);
        $departmentScheme = $this->DepartmentSchemes->get($_GET['id']);
        $departmentScheme->directive = $_GET['directive'];
        $this->DepartmentSchemes->save($departmentScheme);
        echo json_encode('yes');
        exit;
    }

    public function megaproject() {
//        debug($_GET);
        $departmentScheme = $this->DepartmentSchemes->get($_GET['id']);
        $departmentScheme->mega_project = $_GET['mega_project'];
        $this->DepartmentSchemes->save($departmentScheme);
        echo json_encode('yes');
        exit;
    }

    public function flagproject() {
//        debug($_GET);
        $departmentScheme = $this->DepartmentSchemes->get($_GET['id']);
        $departmentScheme->flag = $_GET['flag'];
        $this->DepartmentSchemes->save($departmentScheme);
        echo json_encode('yes');
        exit;
    }

    public function lockproject() {
//        debug($_GET);
        $departmentScheme = $this->DepartmentSchemes->get($_GET['id']);
        $departmentScheme->locked = ($_GET['locked'] == 'Yes') ? 1 : 0;
        $this->DepartmentSchemes->save($departmentScheme);
        echo json_encode('yes');
        exit;
    }

    public function ceproject() {
//        debug($_GET);
        $departmentScheme = $this->DepartmentSchemes->get($_GET['id']);
        $departmentScheme->id_chief_economist = ($_GET['ceproject'] == 'Yes') ? 1 : 0;
        $this->DepartmentSchemes->save($departmentScheme);
        echo json_encode('yes');
        exit;
    }

    /**
     * View method
     *
     * @param string|null $id Department Scheme id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null, $detail = null) {

        if ($detail) {
            $this->viewBuilder()->setLayout(null);
            $this->set(compact('detail'));
        }
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'contain' => ['Comments' => ['sort' => ['Comments.id' => 'desc'], 'Users', 'Departments']],
        ]);

        if ($departmentScheme->parent_scheme_code && $departmentScheme->parent_scheme_code !== '0' && $departmentScheme->parent_scheme_code !== 0) {
            $get_parent = $this->DepartmentSchemes->find('all', ['conditions' => ['scheme_code' => $departmentScheme->parent_scheme_code, 'deleted' => 0]])->first();
//           debug($get_parent);exit;
            $this->set(compact('get_parent'));
        }

        if ($departmentScheme->scheme_code && $departmentScheme->scheme_code !== '0' && $departmentScheme->scheme_code !== 0) {
            $get_childs = $this->DepartmentSchemes->find('all', ['conditions' => ['parent_scheme_code' => $departmentScheme->scheme_code, 'deleted' => 0]])->all();
//           debug($get_parent);exit;
            $this->set(compact('get_childs'));
        }

        $this->loadModel('Departments');

        $departments = $this->Departments->find('list')->all()->toArray();
//        debug($departments);
//        exit;
        $this->loadModel('CustomMilestones');
        //if ($departmentScheme->custom_milestone_required == 'Yes') {
        $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['department_scheme_id' => $id], 'order' => ['completion_date' => 'asc','start_date' => 'asc',]])->all();
//        debug($fetch_custom_details);exit;
        //}
        $this->set(compact('departmentScheme', 'departments', 'fetch_custom_details'));
    }

    public function view_gantt_chart($id = null, $detail = null) {

        if ($detail) {
            $this->viewBuilder()->setLayout(null);
            $this->set(compact('detail'));
        }
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'contain' => ['Comments' => ['sort' => ['Comments.id' => 'desc'], 'Users', 'Departments']],
        ]);


        $this->loadModel('CustomMilestones');

        $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['department_scheme_id' => $id], 'order' => ['start_date' => 'asc', 'id' => 'asc']])->all();
        $fetch_custom_details = json_decode(json_encode($fetch_custom_details));

        $this->loadModel('Districts');
        $this->loadModel('SubActivity');
        $department_scheme_overall_status = 0;
        if (!empty($fetch_custom_details)) {
            foreach ($fetch_custom_details as $i => $details) {
                $SubActivity = $this->SubActivity->find('all', ['conditions' => ['SubActivity.department_scheme_id' => $id, 'SubActivity.activity' => $details->id], 'order' => ['SubActivity.start_date' => 'asc']])->all();
                $SubActivity = json_decode(json_encode($SubActivity));
                $overall_status = 0;

                if (!empty($SubActivity)) {
                    foreach ($SubActivity as $i => $rec) {
                        $rec->status = ($rec->status == 1) ? 3 : $rec->status;

                        if ($rec->status != 2) {

                            if (strtotime($rec->start_date) > strtotime(date('Y-m-d'))) {
                                $rec->status = 2.5;
                            }

                            if (strtotime($rec->start_date) <= strtotime(date('Y-m-d'))) {
                                $rec->status = 3;
                            }

                            if (strtotime($rec->end_date) < strtotime(date('Y-m-d'))) {
                                $rec->status = 4;
                            }

                            $now = strtotime(date('Y-m-d')); // or your date as well
                            $your_date = strtotime($rec->end_date);
                            $datediff = $now - $your_date;
                            $datediff = round($datediff / (60 * 60 * 24));

                            //if(strtotime($rec->end_date) < strtotime('-15 days')) {
                            if ($datediff > 0 && $datediff <= 15) {
                                $rec->status = 4;
                            } else if ($datediff > 15) {
                                $rec->status = 5;
                            }
                        }

                        if ($rec->status * 10 > $overall_status * 10) {
                            if (($overall_status == 2 || strtotime(date('Y-m-d')) >= strtotime($details->start_date)) && strtolower($details->milestone_name) == 'civil works') {
                                $overall_status = 3;
                            } else {
                                $overall_status = $rec->status;
                            }
                        }

                        $rec->img = $this->request->getAttribute("webroot") . 'img/milestones_status/' . $rec->status . '.PNG';
                    }
                }

                $details->activity_milestone_status = $overall_status;
                $details->overall_status = $this->request->getAttribute("webroot") . 'img/milestones_status/' . $overall_status . '.PNG';
                ;
                $details->subactivities = $SubActivity;

                if ($overall_status * 10 > $department_scheme_overall_status * 10) {
                    $department_scheme_overall_status = $overall_status;
                }

                //if($i > 1){unset($details);}
            }
        }

        //echo '<pre>';print_r($fetch_custom_details);exit;
        $this->set(compact('departmentScheme', 'fetch_custom_details', 'department_scheme_overall_status'));
    }

    public function sub_activities($id = null, $detail = null) {
        $this->loadModel('DepartmentSchemes');
        $this->loadModel('CustomMilestones');
        $this->loadModel('SubActivity');
        $this->loadModel('Districts');

        $conditions['DepartmentSchemes.id != '] = 0;

        if (isset($_GET['department']) && trim($_GET['department']) != 'All') {
            $conditions['DepartmentSchemes.department_id'] = trim($_GET['department']);
        }

        if (isset($_GET['scheme_name']) && trim($_GET['scheme_name']) != '') {
            $conditions['DepartmentSchemes.scheme_name LIKE '] = '%' . trim($_GET['scheme_name']) . '%';
        }

        if (isset($_GET['start_date']) && trim($_GET['start_date']) != '') {
            $conditions['scheme_start_date'] = trim(date('Y-m-d', strtotime($_GET['start_date'])));
        }

        if (isset($_GET['end_date']) && trim($_GET['end_date']) != '') {
            $conditions['scheme_end_date'] = trim(date('Y-m-d', strtotime($_GET['end_date'])));
        }

        if (isset($_GET['year']) && trim($_GET['year']) != 'Any') {
            $conditions['scheme_end_date LIKE'] = trim($_GET['year']) . '%';
        }

        if (isset($_GET['type']) && trim($_GET['type']) != 'All') {
            $conditions['DepartmentSchemes.scheme_type'] = trim($_GET['type']);
        }

        if (isset($_GET['category']) && trim($_GET['category']) != 'All') {
            $conditions['DepartmentSchemes.scheme_category'] = trim($_GET['category']);
        }

        if (isset($_GET['tl']) && $_GET['tl'] != 'All') {
            $conditions['DepartmentSchemes.overall_status'] = trim($_GET['tl']);
        }

        $sub_activity_id = [];
        $activity_id = [];
        if (isset($_GET['tl']) && $_GET['tl'] != 'All') {
            $tl = $_GET['tl'];
            $sub_conditions['status'] = 2;
            if (trim($_GET['tl']) == 2) {
                $sub_conditions['status'] = 2;
            } else if (trim($_GET['tl']) == 3) {
                $sub_conditions['status'] = 1;
                $sub_conditions['end_date > '] = date('Y-m-d');
            } else if (trim($_GET['tl']) == 4) {
                $sub_conditions['status'] = 1;
                $sub_conditions['end_date < '] = date('Y-m-d');
                $sub_conditions['end_date > '] = date('Y-m-d', strtotime('-14 days'));
            } else if (trim($_GET['tl']) == 5) {
                $sub_conditions['status'] = 1;
                $sub_conditions['end_date < '] = date('Y-m-d', strtotime('-14 days'));
            }
            //echo '<pre>';print_r($sub_conditions);exit;
            $SubActivity = $this->SubActivity->find('all', ['fields' => ['department_scheme_id', 'id', 'activity'], 'conditions' => $sub_conditions]);
            $department_scheme_id = [];
            $SubActivity = json_decode(json_encode($SubActivity));
            if (!empty($SubActivity)) {

                foreach ($SubActivity as $rec) {
                    $department_scheme_id[] = $rec->department_scheme_id;
                    $sub_activity_id[] = $rec->id;
                    $activity_id[] = $rec->activity;
                }
            }

            if (!empty($department_scheme_id)) {
                //$conditions['DepartmentSchemes.id IN '] = $department_scheme_id;
            }
            //echo '<pre>';print_r($sub_activity_id);exit;
        }

        $DepartmentSchemes = $this->DepartmentSchemes->find('all', ['fields' => ['id', 'created', 'modified', 'department_id', 'overall_status', 'scheme_code', 'parent_scheme_code', 'scheme_name', 'scheme_type', 'scheme_category', 'scheme_start_date', 'scheme_end_date', 'd.department_name', 'overall_status'], 'conditions' => $conditions])->join(['table' => 'departments', 'alias' => 'd', 'type' => 'LEFT', 'conditions' => 'DepartmentSchemes.department_id = d.id'])->order(['scheme_start_date ASC']);
        $this->set('DepartmentSchemes', $this->paginate($DepartmentSchemes, ['limit' => '10']));

        $DepartmentSchemes = json_decode(json_encode($DepartmentSchemes));
        if (!empty($DepartmentSchemes)) {
            foreach ($DepartmentSchemes as $DepartmentScheme) {
                $scheme_status = 0;
                $DepartmentScheme->scheme_status_img = $this->request->getAttribute("webroot") . 'img/milestones_status/' . $DepartmentScheme->overall_status . '.PNG';
                $activity_where = ['department_scheme_id' => $DepartmentScheme->id];
                if (!empty($activity_id)) {
                    $activity_where['CustomMilestones.id IN '] = $activity_id;
                }
                $activities = $this->CustomMilestones->find('all', ['fields' => ['id', 'milestone_name', 'start_date', 'completion_date', 'responsibility', 'remarks', 'district_id', 'type', 'milestone_status'], 'conditions' => $activity_where])->order(['start_date ASC']);
                $DepartmentScheme->activities = json_decode(json_encode($activities));
                if (!empty($DepartmentScheme->activities)) {

                    foreach ($DepartmentScheme->activities as $activity) {
                        $where['activity'] = $activity->id;
                        if (!empty($sub_activity_id)) {
                            $where['SubActivity.id IN '] = $sub_activity_id;
                        }
                        $sub_activities = $this->SubActivity->find('all', ['conditions' => $where])->order(['start_date ASC']);
                        $activity->sub_activities = json_decode(json_encode($sub_activities));
                        $activity->overall_status = $overall_status = 0;
                        $activity->overall_status_img = $this->request->getAttribute("webroot") . 'img/milestones_status/' . $overall_status . '.PNG';

                        if (!empty($activity->sub_activities)) {
                            foreach ($activity->sub_activities as $sub_activity) {
                                if ($sub_activity->status != 2) {
                                    if ($sub_activity->end_date < date('Y-m-d')) {
                                        $sub_activity->status = 3;
                                    }

                                    $now = time(); // or your date as well
                                    $your_date = strtotime($sub_activity->end_date);
                                    $datediff = $now - $your_date;
                                    $datediff = round($datediff / (60 * 60 * 24));

                                    //if(strtotime($rec->end_date) < strtotime('-15 days')) {
                                    if ($datediff > 0 && $datediff <= 15) {
                                        $sub_activity->status = 4;
                                    } else if ($datediff > 15) {
                                        $sub_activity->status = 5;
                                    }
                                }
                                $sub_activity->img = $this->request->getAttribute("webroot") . 'img/milestones_status/' . $sub_activity->status . '.PNG';

                                if ($sub_activity->status > $overall_status) {
                                    $overall_status = $sub_activity->status;
                                }

                                $activity->overall_status = $overall_status;
                                $activity->overall_status_img = $this->request->getAttribute("webroot") . 'img/milestones_status/' . $overall_status . '.PNG';
                            }
                        }
                        //echo '<pre>';print_r($sub_activities);exit;
                        $activity->district = '';
                        if ($activity->district_id != 0 && $activity->district_id != '') {
                            $district = $this->Districts->find('all', ['conditions' => ['id' => $activity->district_id]]);
                            //echo '<pre>';print_r(json_decode(json_encode($district)));exit;
                            $district = json_decode(json_encode($district));
                            $activity->district = !empty($district) ? $district[0]->name : '';
                        }

                        if ($activity->overall_status > $scheme_status) {
                            $scheme_status = $activity->overall_status;
                        }
                    }

                    //$DepartmentScheme->scheme_status_img = $this->request->getAttribute("webroot").'img/milestones_status/'.$scheme_status.'.PNG';
                    $DepartmentScheme->scheme_status_img = $this->request->getAttribute("webroot") . 'img/milestones_status/' . $DepartmentScheme->overall_status . '.PNG';
                }
            }
        }

        //echo '<pre>';print_r($DepartmentSchemes);exit;		
        $this->loadModel('Departments');
        $departments = $this->Departments->find('list')->all()->toArray();

        $this->set(compact('DepartmentSchemes', 'departments'));
    }

    public function sub_activities_excel($id = null) {

        $this->loadModel('DepartmentSchemes');
        $this->loadModel('CustomMilestones');
        $this->loadModel('SubActivity');
        $this->loadModel('Districts');

        $conditions['DepartmentSchemes.id != '] = 0;

        if (isset($_GET['department']) && trim($_GET['department']) != 'All') {
            $conditions['DepartmentSchemes.department_id'] = trim($_GET['department']);
        }

        if (isset($_GET['scheme_name']) && trim($_GET['scheme_name']) != '') {
            $conditions['DepartmentSchemes.scheme_name LIKE '] = '%' . trim($_GET['scheme_name']) . '%';
        }

        if (isset($_GET['start_date']) && trim($_GET['start_date']) != '') {
            $conditions['scheme_start_date'] = trim(date('Y-m-d', strtotime($_GET['start_date'])));
        }

        if (isset($_GET['end_date']) && trim($_GET['end_date']) != '') {
            $conditions['scheme_end_date'] = trim(date('Y-m-d', strtotime($_GET['end_date'])));
        }

        if (isset($_GET['year']) && trim($_GET['year']) != 'Any') {
            $conditions['scheme_end_date LIKE'] = trim($_GET['year']) . '%';
        }

        if (isset($_GET['type']) && trim($_GET['type']) != 'All') {
            $conditions['DepartmentSchemes.scheme_type'] = trim($_GET['type']);
        }

        if (isset($_GET['category']) && trim($_GET['category']) != 'All') {
            $conditions['DepartmentSchemes.scheme_category'] = trim($_GET['category']);
        }

        if (isset($_GET['tl']) && $_GET['tl'] != 'All') {
            $conditions['DepartmentSchemes.overall_status'] = trim($_GET['tl']);
        }

        $sub_activity_id = [];
        $activity_id = [];
        if (isset($_GET['tll']) && $_GET['tll'] != 'All') {
            $sub_conditions['status'] = 2;
            if (trim($_GET['tl']) == 'Completed') {
                $sub_conditions['status'] = 2;
            } else if (trim($_GET['tl']) == 'On Target') {
                $sub_conditions['status'] = 1;
                $sub_conditions['end_date > '] = date('Y-m-d');
            } else if (trim($_GET['tl']) == 'Off Target') {
                $sub_conditions['status'] = 1;
                $sub_conditions['end_date < '] = date('Y-m-d');
                $sub_conditions['end_date > '] = date('Y-m-d', strtotime('-14 days'));
            } else if (trim($_GET['tl']) == 'Critically Delayed') {
                $sub_conditions['status'] = 1;
                $sub_conditions['end_date < '] = date('Y-m-d', strtotime('-14 days'));
            }
            //echo '<pre>';print_r($sub_conditions);exit;
            $SubActivity = $this->SubActivity->find('all', ['fields' => ['department_scheme_id', 'id', 'activity'], 'conditions' => $sub_conditions]);
            $department_scheme_id = [];
            $SubActivity = json_decode(json_encode($SubActivity));
            if (!empty($SubActivity)) {
                foreach ($SubActivity as $rec) {
                    $department_scheme_id[] = $rec->department_scheme_id;
                    $sub_activity_id[] = $rec->id;
                    $activity_id[] = $rec->activity;
                }
            }

            if (!empty($department_scheme_id)) {
                $conditions['DepartmentSchemes.id IN '] = $department_scheme_id;
            }
            //echo '<pre>';print_r($sub_activity_id);exit;
        }

        $DepartmentSchemes = $this->DepartmentSchemes->find('all', ['fields' => ['id', 'modified', 'department_id', 'overall_status', 'scheme_code', 'parent_scheme_code', 'scheme_name', 'scheme_type', 'scheme_category', 'scheme_start_date', 'scheme_end_date', 'd.department_name'], 'conditions' => $conditions])->join(['table' => 'departments', 'alias' => 'd', 'type' => 'LEFT', 'conditions' => 'DepartmentSchemes.department_id = d.id'])->order(['scheme_start_date ASC']);
        $this->set('DepartmentSchemes', $DepartmentSchemes);

        $DepartmentSchemes = json_decode(json_encode($DepartmentSchemes));
        if (!empty($DepartmentSchemes)) {
            foreach ($DepartmentSchemes as $DepartmentScheme) {
                $scheme_status = 0;
                $DepartmentScheme->milestone_status = $DepartmentScheme->overall_status; // $scheme_status;
                $activity_where = ['department_scheme_id' => $DepartmentScheme->id];
                if (!empty($activity_id)) {
                    $activity_where['CustomMilestones.id IN '] = $activity_id;
                }
                $activities = $this->CustomMilestones->find('all', ['fields' => ['id', 'milestone_name', 'start_date', 'completion_date', 'responsibility', 'remarks', 'district_id', 'type', 'milestone_status'], 'conditions' => $activity_where])->order(['start_date ASC']);
                $DepartmentScheme->activities = json_decode(json_encode($activities));
                if (!empty($DepartmentScheme->activities)) {

                    foreach ($DepartmentScheme->activities as $activity) {
                        $where['activity'] = $activity->id;
                        if (!empty($sub_activity_id)) {
                            $where['SubActivity.id IN '] = $sub_activity_id;
                        }
                        $sub_activities = $this->SubActivity->find('all', ['conditions' => $where])->order(['start_date ASC']);
                        $activity->sub_activities = json_decode(json_encode($sub_activities));
                        $activity->overall_status = $overall_status = 0;
                        $activity->overall_status_img = $overall_status;

                        if (!empty($activity->sub_activities)) {
                            foreach ($activity->sub_activities as $sub_activity) {
                                if ($sub_activity->status != 2) {
                                    if ($sub_activity->end_date < date('Y-m-d')) {
                                        $sub_activity->status = 3;
                                    }

                                    $now = time(); // or your date as well
                                    $your_date = strtotime($sub_activity->end_date);
                                    $datediff = $now - $your_date;
                                    $datediff = round($datediff / (60 * 60 * 24));

                                    //if(strtotime($rec->end_date) < strtotime('-15 days')) {
                                    if ($datediff > 0 && $datediff <= 15) {
                                        $sub_activity->status = 4;
                                    } else if ($datediff > 15) {
                                        $sub_activity->status = 5;
                                    }
                                }
                                $sub_activity->img = $sub_activity->status;

                                if ($sub_activity->status > $overall_status) {
                                    $overall_status = $sub_activity->status;
                                }

                                $activity->overall_status = $overall_status;
                                $activity->overall_status_img = $overall_status;
                            }
                        }
                        //echo '<pre>';print_r($sub_activities);exit;
                        $activity->district = '';
                        if ($activity->district_id != 0 && $activity->district_id != '') {
                            $district = $this->Districts->find('all', ['conditions' => ['id' => $activity->district_id]]);
                            //echo '<pre>';print_r(json_decode(json_encode($district)));exit;
                            $district = json_decode(json_encode($district));
                            $activity->district = !empty($district) ? $district[0]->name : '';
                        }

                        if ($activity->overall_status > $scheme_status) {
                            $scheme_status = $activity->overall_status;
                        }
                    }

                    $DepartmentScheme->milestone_status = $DepartmentScheme->overall_status; // $scheme_status;
                }
            }
        }
        $DepartmentScheme = json_decode(json_encode($DepartmentScheme));
        //echo '<pre>';print_r($DepartmentSchemes);exit;
        $output_type = 'D';
        $file = 'schemes_list.xlsx';
        $this->set(compact('DepartmentSchemes', 'output_type', 'file'));
        $this->viewBuilder()->setLayout('xls/default');
        $this->viewBuilder()->setTemplate('xls/sub_activities_excel');
        $this->RequestHandler->respondAs('xlsx');
        $this->render();
    }

    public function sub_activities_pdf($id = null) {

        $this->loadModel('DepartmentSchemes');
        $this->loadModel('CustomMilestones');
        $this->loadModel('SubActivity');
        $this->loadModel('Districts');

        $conditions['DepartmentSchemes.id != '] = 0;

        if (isset($_GET['department']) && trim($_GET['department']) != 'All') {
            $conditions['DepartmentSchemes.department_id'] = trim($_GET['department']);
        }

        if (isset($_GET['scheme_name']) && trim($_GET['scheme_name']) != '') {
            $conditions['DepartmentSchemes.scheme_name LIKE '] = '%' . trim($_GET['scheme_name']) . '%';
        }

        if (isset($_GET['start_date']) && trim($_GET['start_date']) != '') {
            $conditions['scheme_start_date'] = trim(date('Y-m-d', strtotime($_GET['start_date'])));
        }

        if (isset($_GET['end_date']) && trim($_GET['end_date']) != '') {
            $conditions['scheme_end_date'] = trim(date('Y-m-d', strtotime($_GET['end_date'])));
        }

        if (isset($_GET['year']) && trim($_GET['year']) != 'Any') {
            $conditions['scheme_end_date LIKE'] = trim($_GET['year']) . '%';
        }

        if (isset($_GET['type']) && trim($_GET['type']) != 'All') {
            $conditions['DepartmentSchemes.scheme_type'] = trim($_GET['type']);
        }

        if (isset($_GET['category']) && trim($_GET['category']) != 'All') {
            $conditions['DepartmentSchemes.scheme_category'] = trim($_GET['category']);
        }

        if (isset($_GET['tl']) && $_GET['tl'] != 'All') {
            $conditions['DepartmentSchemes.overall_status'] = trim($_GET['tl']);
        }

        $sub_activity_id = [];
        $activity_id = [];
        if (isset($_GET['tll']) && $_GET['tll'] != 'All') {
            $sub_conditions['status'] = 2;
            if (trim($_GET['tl']) == 'Completed') {
                $sub_conditions['status'] = 2;
            } else if (trim($_GET['tl']) == 'On Target') {
                $sub_conditions['status'] = 1;
                $sub_conditions['end_date > '] = date('Y-m-d');
            } else if (trim($_GET['tl']) == 'Off Target') {
                $sub_conditions['status'] = 1;
                $sub_conditions['end_date < '] = date('Y-m-d');
                $sub_conditions['end_date > '] = date('Y-m-d', strtotime('-14 days'));
            } else if (trim($_GET['tl']) == 'Critically Delayed') {
                $sub_conditions['status'] = 1;
                $sub_conditions['end_date < '] = date('Y-m-d', strtotime('-14 days'));
            }
            //echo '<pre>';print_r($sub_conditions);exit;
            $SubActivity = $this->SubActivity->find('all', ['fields' => ['department_scheme_id', 'id', 'activity'], 'conditions' => $sub_conditions]);
            $department_scheme_id = [];
            $SubActivity = json_decode(json_encode($SubActivity));
            if (!empty($SubActivity)) {
                foreach ($SubActivity as $rec) {
                    $department_scheme_id[] = $rec->department_scheme_id;
                    $sub_activity_id[] = $rec->id;
                    $activity_id[] = $rec->activity;
                }
            }

            if (!empty($department_scheme_id)) {
                $conditions['DepartmentSchemes.id IN '] = $department_scheme_id;
            }
            //echo '<pre>';print_r($sub_activity_id);exit;
        }

        $DepartmentSchemes = $this->DepartmentSchemes->find('all', ['fields' => ['id', 'department_id', 'overall_status', 'scheme_code', 'parent_scheme_code', 'scheme_name', 'scheme_type', 'scheme_category', 'scheme_start_date', 'scheme_end_date', 'd.department_name'], 'conditions' => $conditions])->join(['table' => 'departments', 'alias' => 'd', 'type' => 'LEFT', 'conditions' => 'DepartmentSchemes.department_id = d.id'])->order(['scheme_start_date ASC']);
        $this->set('DepartmentSchemes', $DepartmentSchemes);

        $DepartmentSchemes = json_decode(json_encode($DepartmentSchemes));
        if (!empty($DepartmentSchemes)) {
            foreach ($DepartmentSchemes as $DepartmentScheme) {
                $scheme_status = 0;
                $DepartmentScheme->milestone_status = $DepartmentScheme->overall_status; // $scheme_status;
                $activity_where = ['department_scheme_id' => $DepartmentScheme->id];
                if (!empty($activity_id)) {
                    $activity_where['CustomMilestones.id IN '] = $activity_id;
                }
                $activities = $this->CustomMilestones->find('all', ['fields' => ['id', 'milestone_name', 'start_date', 'completion_date', 'responsibility', 'remarks', 'district_id', 'type', 'milestone_status'], 'conditions' => $activity_where])->order(['start_date ASC']);
                $DepartmentScheme->activities = json_decode(json_encode($activities));
                if (!empty($DepartmentScheme->activities)) {

                    foreach ($DepartmentScheme->activities as $activity) {
                        $where['activity'] = $activity->id;
                        if (!empty($sub_activity_id)) {
                            $where['SubActivity.id IN '] = $sub_activity_id;
                        }
                        $sub_activities = $this->SubActivity->find('all', ['conditions' => $where])->order(['start_date ASC']);
                        $activity->sub_activities = json_decode(json_encode($sub_activities));
                        //echo '<pre>';print_r($activity);exit;
                        $activity->overall_status = $overall_status = 0;
                        $activity->overall_status_img = $overall_status;

                        if (!empty($activity->sub_activities)) {
                            foreach ($activity->sub_activities as $sub_activity) {
                                if ($sub_activity->status != 2) {
                                    if ($sub_activity->end_date < date('Y-m-d')) {
                                        $sub_activity->status = 3;
                                    }

                                    $now = time(); // or your date as well
                                    $your_date = strtotime($sub_activity->end_date);
                                    $datediff = $now - $your_date;
                                    $datediff = round($datediff / (60 * 60 * 24));

                                    //if(strtotime($rec->end_date) < strtotime('-15 days')) {
                                    if ($datediff > 0 && $datediff <= 15) {
                                        $sub_activity->status = 4;
                                    } else if ($datediff > 15) {
                                        $sub_activity->status = 5;
                                    }
                                }
                                $sub_activity->img = $sub_activity->status;

                                if ($sub_activity->status > $overall_status) {
                                    $overall_status = $sub_activity->status;
                                }

                                $activity->overall_status = $overall_status;
                                $activity->overall_status_img = $overall_status;
                            }
                        }
                        //echo '<pre>';print_r($sub_activities);exit;
                        $activity->district = '';
                        if ($activity->district_id != 0 && $activity->district_id != '') {
                            $district = $this->Districts->find('all', ['conditions' => ['id' => $activity->district_id]]);
                            //echo '<pre>';print_r(json_decode(json_encode($district)));exit;
                            $district = json_decode(json_encode($district));
                            $activity->district = !empty($district) ? $district[0]->name : '';
                        }

                        if ($activity->overall_status > $scheme_status) {
                            $scheme_status = $activity->overall_status;
                        }
                    }

                    $DepartmentScheme->milestone_status = $DepartmentScheme->overall_status; // $scheme_status;
                }
            }
        }

        $DepartmentSchemes = json_decode(json_encode($DepartmentSchemes));
        //echo '<pre>';print_r($DepartmentSchemes);exit;
        $this->viewBuilder()->setLayout('');
        $this->set(compact('DepartmentSchemes'));
    }

    public function sub_activities_bk($id = null, $detail = null) {
        $this->loadModel('SubActivity');

        /* $connection = ConnectionManager::get('default');
          $where = 'WHERE id != 0';
          if(isset($_GET['department']) && trim($_GET['department']) != 'All'){
          $where .= ' AND responsibility = "'.trim($_GET['department']).'"';
          }

          if(isset($_GET['start_date']) && trim($_GET['start_date']) != ''){
          $where .= ' AND start_date = "'.trim(date('Y-m-d', strtotime($_GET['start_date']))).'"';
          }

          if(isset($_GET['end_date']) && trim($_GET['end_date']) != ''){
          $where .= ' AND end_date = "'.trim(date('Y-m-d', strtotime($_GET['end_date']))).'"';
          }

          if(isset($_GET['tl']) && trim($_GET['tl']) == 'Completed'){
          $where .= ' AND status = 2';
          }else if(isset($_GET['tl']) && trim($_GET['tl']) == 'On Target'){
          $where .= ' AND status = 1 AND end_date > "'.date('Y-m-d').'"';
          }
          else if(isset($_GET['tl']) && trim($_GET['tl']) == 'Off Target'){
          $where .= ' AND status = 1 AND end_date < "'.date('Y-m-d').'"';
          }
          else if(isset($_GET['tl']) && trim($_GET['tl']) == 'Critically Delayed'){
          $where .= ' AND status = 1 AND end_date < "'.date('Y-m-d', strtotime('-14 days')).'"';
          }
          //echo date('Y-m-d', strtotime('-15 days'));exit;
          $SubActivity = $connection->execute('SELECT * FROM sub_activities '.$where.' LIMIT 5')->fetchAll('assoc'); */

        $conditions['SubActivity.id != '] = 0;

        if (isset($_GET['department']) && trim($_GET['department']) != 'All') {
            $conditions['ds.department_id'] = trim($_GET['department']);
        }

        if (isset($_GET['start_date']) && trim($_GET['start_date']) != '') {
            $conditions['start_date'] = trim(date('Y-m-d', strtotime($_GET['start_date'])));
        }

        if (isset($_GET['end_date']) && trim($_GET['end_date']) != '') {
            $conditions['end_date'] = trim(date('Y-m-d', strtotime($_GET['end_date'])));
        }

        if (isset($_GET['tl']) && trim($_GET['tl']) == 'Completed') {
            $conditions['status'] = 2;
        } else if (isset($_GET['tl']) && trim($_GET['tl']) == 'On Target') {
            $conditions['status'] = 1;
            $conditions['end_date > '] = date('Y-m-d');
        } else if (isset($_GET['tl']) && trim($_GET['tl']) == 'Off Target') {
            $conditions['status'] = 1;
            $conditions['end_date < '] = date('Y-m-d');
        } else if (isset($_GET['tl']) && trim($_GET['tl']) == 'Critically Delayed') {
            $conditions['status'] = 1;
            $conditions['end_date < '] = date('Y-m-d', strtotime('-14 days'));
        }

        $SubActivity = $this->SubActivity->find('all', ['conditions' => $conditions])->join(['table' => 'department_schemes', 'alias' => 'ds', 'type' => 'LEFT', 'conditions' => 'SubActivity.department_scheme_id = ds.id'])->order(['start_date ASC']);
        $this->set('SubActivities', $this->paginate($SubActivity, ['limit' => '20']));

        //$SubActivity = $this->SubActivity->find('all', ['order' => ['start_date' => 'asc']])->all();
        $SubActivities = json_decode(json_encode($SubActivity));

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list')->all()->toArray();

        $this->set(compact('SubActivities', 'departments'));
    }

    public function add_activity($id = null, $detail = null) {

        if (isset($_POST) && !empty($_POST)) {

            $this->DepartmentSchemes->updateAll(['custom_milestone_required' => 'Yes'], ['id in' => [$id]]);

            $milestone = $this->getTableLocator()->get('CustomMilestones');
            $query = $milestone->query();

            $mean_of_verification = '';
            $root_dir = str_replace(basename($_SERVER['SCRIPT_NAME']), '', $_SERVER['SCRIPT_NAME']);
            ;
            $uploads_root_dir = $_SERVER['DOCUMENT_ROOT'] . $root_dir . 'uploads/mov/';

            if (!empty($_FILES) && isset($_FILES["mean_of_verification"]["name"])) {
                //echo '<pre>';print_r($uploads_root_dir);exit;
                $name = $_FILES["mean_of_verification"]["name"];
                $ext = explode('.', $_FILES["mean_of_verification"]["name"]);
                $ext = trim(strtolower($ext[count($ext) - 1]));
                $exts = array('jpeq', 'jpg', 'png', 'pdf');
                if (in_array($ext, $exts)) {
                    $filename = preg_replace('/[^A-Za-z0-9\-]/', '', str_replace($ext, '', $_FILES["mean_of_verification"]['name']));
                    $filename = date('ymdhis') . $filename . '.' . $ext;

                    if (move_uploaded_file($_FILES["mean_of_verification"]["tmp_name"], $uploads_root_dir . basename($filename))) {
                        $mean_of_verification = $filename;
                    }
                }
            }

            $this->loadModel('CustomMilestones');
            $CustomMilestone = $this->CustomMilestones->newEmptyEntity();
            $CustomMilestone->department_scheme_id = $id;
            $CustomMilestone->milestone_name = $this->request->getData()['milestone_name'];
            $CustomMilestone->mean_of_verification = $mean_of_verification;
            if ($CustomMilestone->milestone_name == 'Other') {
                $CustomMilestone->milestone_name = $this->request->getData()['other_milestone_name'];
            }
            $CustomMilestone->is_completed = $this->request->getData()['is_completed'];
            $CustomMilestone->responsibility = $this->request->getData()['responsibility'];
            $CustomMilestone->district_id = $this->request->getData()['district'];
            $CustomMilestone->type = $this->request->getData()['milestone_name'];
            $CustomMilestone->completed_percent = $this->request->getData()['completed_percent'];
            if ($CustomMilestone->type == 'Other') {
                if ($this->request->getData()['other_type'] != '') {
                    $CustomMilestone->type = $this->request->getData()['other_type'];
                }
            }
            $CustomMilestone->completion_date = '';
            $CustomMilestone->milestone_status = 2;
            $CustomMilestone->display_order = 1;
            $CustomMilestone->created = date('Y-m-d');
            $CustomMilestone->modified = date('Y-m-d');
            $this->CustomMilestones->save($CustomMilestone);
            $last_id = $CustomMilestone->id;

            $completion_date = date('Y-m-d');
            $activity_start_date = '2050-01-01';
            if (!empty($_POST['title'])) {
                foreach ($_POST['title'] as $i => $title) {

                    $end_date = ($this->request->getData()['end_date'][$i]) ? date('Y-m-d', strtotime($this->request->getData()['end_date'][$i])) : date('Y-m-d');
                    $start_date = ($this->request->getData()['start_date'][$i]) ? date('Y-m-d', strtotime($this->request->getData()['start_date'][$i])) : date('Y-m-d');
                    if (strtotime($end_date) > strtotime($completion_date)) {
                        $completion_date = $end_date;
                    }

                    if (strtotime($start_date) < strtotime($activity_start_date)) {
                        $activity_start_date = $start_date;
                    }

                    $sub_activity = $this->getTableLocator()->get('SubActivity');
                    $query = $sub_activity->query();
                    $query->insert(['department_scheme_id', 'activity', 'title', 'start_date', 'end_date', 'responsibility', 'remarks', 'created', 'modified', 'status'])
                            ->values([
                                'department_scheme_id' => $id,
                                'activity' => $last_id,
                                'title' => $this->request->getData()['title'][$i],
                                'responsibility' => $this->request->getData()['department'][$i],
                                'start_date' => $start_date,
                                'end_date' => $end_date,
                                'remarks' => $this->request->getData()['remarks'][$i],
                                'status' => $this->request->getData()['status'][$i],
                                'created' => date('Y-m-d'),
                                'modified' => date('Y-m-d'),
                            ])
                            ->execute();
                }
            }

            //$this->CustomMilestones->updateAll(['completion_date' => $completion_date, 'start_date' => $activity_start_date], ['id in' => [$last_id]]);			
            //$this->DepartmentSchemes->updateAll(['scheme_end_date' => $completion_date, 'scheme_start_date' => $activity_start_date], ['id in' => [$id]]);

            $connection = ConnectionManager::get('default');
            $sub_activities = $connection->execute('SELECT MAX(end_date) as end_date FROM `sub_activities` WHERE activity = ' . $last_id)->fetchAll('assoc');
            if (!empty($sub_activities)) {
                $this->CustomMilestones->updateAll(['completion_date' => $sub_activities[0]['end_date']], ['id in' => [$last_id]]);
            }

            $sub_activities = $connection->execute('SELECT MIN(start_date) as start_date FROM `sub_activities` WHERE activity = ' . $last_id)->fetchAll('assoc');
            if (!empty($sub_activities)) {
                $this->CustomMilestones->updateAll(['start_date' => $sub_activities[0]['start_date']], ['id in' => [$last_id]]);
            }

            $custom_milestones = $connection->execute('SELECT MAX(completion_date) as completion_date FROM `custom_milestones` WHERE department_scheme_id = ' . $id)->fetchAll('assoc');
            if (!empty($custom_milestones)) {
                $this->DepartmentSchemes->updateAll(['scheme_end_date' => $custom_milestones[0]['completion_date']], ['id in' => [$id]]);
            }

            $custom_milestones = $connection->execute('SELECT MIN(start_date) as start_date FROM `custom_milestones` WHERE department_scheme_id = ' . $id)->fetchAll('assoc');
            if (!empty($custom_milestones)) {
                $this->DepartmentSchemes->updateAll(['scheme_start_date' => $custom_milestones[0]['start_date']], ['id in' => [$id]]);
            }
            $this->DepartmentSchemes->updateAll(['last_modified' => date('Y-m-d h:i:s')], ['id in' => [$id]]);

            //return $this->redirect(['action' => 'view', $id]);		
            $this->redirect('/admin/department_schemes/finish/' . $id);
        } else {
            $this->loadModel('DepartmentSchemes');
            $departmentScheme = $this->DepartmentSchemes->get($id);
            $this->loadModel('Departments');
            $departments = $this->Departments->find('list')->all()->toArray();
            $this->loadModel('Districts');
            $districts = $this->Districts->find('list')->all()->toArray();
            $this->set(compact('id', 'departments', 'departmentScheme', 'districts'));
        }
    }

    public function edit_activity($departmentScheme_id = null, $id = null) {

        if (isset($_POST) && !empty($_POST)) {

            $this->loadModel('CustomMilestones');
            $completion_date = ''; //date('Y-m-d');
            $activity_start_date = '2050-01-01';

            $mean_of_verification = '';
            $root_dir = str_replace(basename($_SERVER['SCRIPT_NAME']), '', $_SERVER['SCRIPT_NAME']);
            ;
            $uploads_root_dir = $_SERVER['DOCUMENT_ROOT'] . $root_dir . 'uploads/mov/';

            if (!empty($_FILES) && isset($_FILES["mean_of_verification"]["name"])) {

                $name = $_FILES["mean_of_verification"]["name"];
                $ext = explode('.', $_FILES["mean_of_verification"]["name"]);
                $ext = trim(strtolower($ext[count($ext) - 1]));
                $exts = array('jpeq', 'jpg', 'png', 'pdf');
                if (in_array($ext, $exts)) {
                    $filename = preg_replace('/[^A-Za-z0-9\-]/', '', str_replace($ext, '', $_FILES["mean_of_verification"]['name']));
                    $filename = date('ymdhis') . $filename . '.' . $ext;

                    if (move_uploaded_file($_FILES["mean_of_verification"]["tmp_name"], $uploads_root_dir . basename($filename))) {
                        $mean_of_verification = $filename;
                    }
                }
            }

            if (!empty($_POST['title'])) {
                $this->loadModel('SubActivity');
                $this->SubActivity->deleteAll(['activity' => $id]);

                foreach ($_POST['title'] as $i => $title) {
                    if ($this->request->getData()['title'][$i] != '' && $this->request->getData()['start_date'][$i] != '' && $this->request->getData()['end_date'][$i] != '') {
                        $sub_activity = $this->getTableLocator()->get('SubActivity');
                        $query = $sub_activity->query();

                        $end_date = ($this->request->getData()['end_date'][$i]) ? date('Y-m-d', strtotime($this->request->getData()['end_date'][$i])) : date('Y-m-d');
                        $start_date = ($this->request->getData()['start_date'][$i]) ? date('Y-m-d', strtotime($this->request->getData()['start_date'][$i])) : date('Y-m-d');
                        if ($completion_date == '') {
                            $completion_date = $end_date;
                        }

                        if (strtotime($end_date) > strtotime($completion_date)) {
                            $completion_date = $end_date;
                        }

                        if (strtotime($start_date) < strtotime($activity_start_date)) {
                            $activity_start_date = $start_date;
                        }

                        $query->insert(['department_scheme_id', 'activity', 'title', 'start_date', 'end_date', 'responsibility', 'remarks', 'created', 'modified', 'status'])
                                ->values([
                                    'department_scheme_id' => $departmentScheme_id,
                                    'activity' => $id,
                                    'title' => $this->request->getData()['title'][$i],
                                    'responsibility' => $this->request->getData()['department'][$i],
                                    'start_date' => $start_date,
                                    'end_date' => $end_date,
                                    'remarks' => $this->request->getData()['remarks'][$i],
                                    'status' => $this->request->getData()['status'][$i],
                                    'created' => date('Y-m-d'),
                                    'modified' => date('Y-m-d'),
                                ])
                                ->execute();
                    }
                }
            }

            $milestone_type = $this->request->getData()['type'];

            /* if($milestone_type == 'Other'){

              $milestone_type = '---';
              }
              } */

            $district_id = $this->request->getData()['district'];
            if (!in_array(strtolower($this->request->getData()['milestone_name']), array('civil works'))) {
                $district_id = 0;
            }


            $params = ['milestone_name' => $this->request->getData()['milestone_name'], 'completed_percent' => $this->request->getData()['completed_percent'], 'is_completed' => $this->request->getData()['is_completed'], 'responsibility' => $this->request->getData()['responsibility'], 'district_id' => $district_id, 'type' => $milestone_type, 'completion_date' => $completion_date, 'start_date' => $activity_start_date];
            if ($mean_of_verification != '') {
                $params['mean_of_verification'] = $mean_of_verification;
            }

            $this->CustomMilestones->updateAll($params, ['id in' => [$id]]);



            $connection = ConnectionManager::get('default');
            $sub_activities = $connection->execute('SELECT MAX(end_date) as end_date FROM `sub_activities` WHERE activity = ' . $id)->fetchAll('assoc');
            if (!empty($sub_activities)) {
                $this->CustomMilestones->updateAll(['completion_date' => $sub_activities[0]['end_date']], ['id in' => [$id]]);
            }

            $sub_activities = $connection->execute('SELECT MIN(start_date) as start_date FROM `sub_activities` WHERE activity = ' . $id)->fetchAll('assoc');
            if (!empty($sub_activities)) {
                $this->CustomMilestones->updateAll(['start_date' => $sub_activities[0]['start_date']], ['id in' => [$id]]);
            }

            $custom_milestones = $connection->execute('SELECT MAX(completion_date) as completion_date FROM `custom_milestones` WHERE department_scheme_id = ' . $departmentScheme_id)->fetchAll('assoc');
            if (!empty($custom_milestones)) {
                $this->DepartmentSchemes->updateAll(['scheme_end_date' => $custom_milestones[0]['completion_date']], ['id in' => [$departmentScheme_id]]);
            }

            $custom_milestones = $connection->execute('SELECT MIN(start_date) as start_date FROM `custom_milestones` WHERE department_scheme_id = ' . $departmentScheme_id)->fetchAll('assoc');
            if (!empty($custom_milestones)) {
                $this->DepartmentSchemes->updateAll(['scheme_start_date' => $custom_milestones[0]['start_date']], ['id in' => [$departmentScheme_id]]);
            }

            $this->DepartmentSchemes->updateAll(['last_modified' => date('Y-m-d h:i:s')], ['id in' => [$departmentScheme_id]]);

            $this->redirect('/admin/department_schemes/view/' . $departmentScheme_id);
        } else {
            $this->loadModel('Departments');
            $departments = $this->Departments->find('list')->all()->toArray();

            $this->loadModel('CustomMilestones');
            $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['id' => $id], 'order' => ['display_order' => 'asc', 'id' => 'asc']])->all();

            $fetch_custom_details = json_decode(json_encode($fetch_custom_details));



            $this->loadModel('SubActivity');
            $SubActivity = $this->SubActivity->find('all', ['conditions' => ['activity' => $id], 'order' => ['start_date' => 'asc']])->all();
            $SubActivity = json_decode(json_encode($SubActivity));
            $this->loadModel('Districts');
            $districts = $this->Districts->find('list')->all()->toArray();


            $this->set(compact('id', 'departments', 'fetch_custom_details', 'SubActivity', 'departmentScheme_id', 'districts'));
        }
    }

    function sub_activity_remove() {
        $this->loadModel('SubActivity');
        $SubActivity = $this->SubActivity->get($_GET['id']);
        $this->SubActivity->delete($SubActivity);
        echo json_encode('yes');
        exit;
    }

    function delete_activity($id, $departmentScheme_id) {
        $this->loadModel('CustomMilestones');
        $CustomMilestones = $this->CustomMilestones->get($id);
        $this->CustomMilestones->delete($CustomMilestones);
        $this->redirect('/admin/department_schemes/view/' . $departmentScheme_id);
    }

    function delete_all_activity($departmentScheme_id) {
        $this->loadModel('CustomMilestones');
        //$CustomMilestones = $this->CustomMilestones->get($id);
        ///$this->CustomMilestones->delete($CustomMilestones);
        $this->CustomMilestones->deleteAll(['department_scheme_id' => $departmentScheme_id]);
        $this->loadModel('SubActivity');
        $this->SubActivity->deleteAll(['department_scheme_id' => $departmentScheme_id]);
        $this->redirect('/admin/department_schemes/view/' . $departmentScheme_id);
    }

//    public function detailview($id = null) {
//        $this->viewBuilder()->setLayout(null);
//
//        $departmentScheme = $this->DepartmentSchemes->get($id, [
////            'contain' => ['Departments', 'SchemeStatuses', 'SchemeDistricts'],
//        ]);
//
//        if ($departmentScheme->parent_scheme_code) {
//            $get_parent = $this->DepartmentSchemes->find('all', ['conditions' => ['scheme_code' => $departmentScheme->parent_scheme_code]])->first();
////           debug($get_parent);exit;
//            $this->set(compact('get_parent'));
//        }
//
//        if ($departmentScheme->scheme_code) {
//            $get_childs = $this->DepartmentSchemes->find('all', ['conditions' => ['parent_scheme_code' => $departmentScheme->scheme_code]])->all();
////           debug($get_parent);exit;
//            $this->set(compact('get_childs'));
//        }
//
//        $this->loadModel('Departments');
//
//        $departments = $this->Departments->find('list')->all()->toArray();
////        debug($departments);
////        exit;
//        $this->set(compact('departmentScheme', 'departments'));
//    }

    public function exportpdf($id = null) {
        $this->viewBuilder()->setLayout('');


        $departmentScheme = $this->DepartmentSchemes->get($id, [
//            'contain' => ['Departments', 'SchemeStatuses', 'SchemeDistricts'],
        ]);

        $this->loadModel('Departments');

        $departments = $this->Departments->find('list')->all()->toArray();
//        debug($departments);
//        exit;
        $this->loadModel('CustomMilestones');
        $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['department_scheme_id' => $id], 'order' => ['id' => 'asc']])->all();

        $this->set(compact('departmentScheme', 'departments', 'fetch_custom_details'));
    }

    public function exportmultipdf($multi_ids = null, $title = null) {

        $this->viewBuilder()->setLayout('');


        $departmentSchemes = $this->DepartmentSchemes->find('all', ['order' => ['overall_status' => 'desc'], 'contain' => ['CustomMilestones'], 'conditions' => ['id IN' => explode(',', $multi_ids)]])->all();

        $this->loadModel('CustomMilestones');
        $this->loadModel('SubActivity');
        $subactivities = array();
        foreach ($departmentSchemes as $scheme) {

            $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['department_scheme_id' => $scheme->id]])->all();


            foreach ($fetch_custom_details as $activity) {

                $all_subactivities = $this->SubActivity->find('all', ['conditions' => ['activity' => $activity->id]])->all();
                if (!empty($all_subactivities)) {

                    foreach ($all_subactivities as $rec) {
                        $subactivities[] = $rec;
                        //     $subactivities[] = json_decode(json_encode($rec));
                    }
                }
            }
        }

        $this->loadModel('Departments');

        $departments = $this->Departments->find('list')->all()->toArray();

        $this->set(compact('departmentSchemes', 'subactivities', 'departments', 'title'));
    }

    public function exportall() {
        $output_type = 'D';

        $file = 'schemes_list.xlsx';
        $cond = array();
        $cond[] = ['DepartmentSchemes.deleted' => 0];

        if (isset($_GET['department'])) {
            $cond[] = ['DepartmentSchemes.department_id IN' => $_GET['department']];
        }
//        debug($department);exit;
        if (isset($_GET['status']) && $_GET['status'] !== '') {
            $cond[] = ['DepartmentSchemes.overall_status' => $_GET['status']];
        }

        if (isset($_GET['directive_search']) && $_GET['directive_search'] !== '') {
            $cond[] = ['DepartmentSchemes.directive' => $_GET['directive_search']];
        }
        if (isset($_GET['mega_project_search']) && $_GET['mega_project_search'] !== '') {
            if ($_GET['mega_project_search'] == 'Mega') {
                $cond[] = ['DepartmentSchemes.mega_project' => 'Yes'];
            } else if ($_GET['mega_project_search'] == 'Normal') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'Normal'];
            } else if ($_GET['mega_project_search'] == 'High Priority') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'High Priority'];
            } else if ($_GET['mega_project_search'] == 'DFC (Two Years)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Two Years)'];
            } else if ($_GET['mega_project_search'] == 'DFC (Current Year)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Current Year)'];
            } else if ($_GET['mega_project_search'] == 'After Assembly') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'After Assembly'];
            }
        }
        if (isset($_GET['foreign_funded']) && $_GET['foreign_funded'] !== '') {
            $cond[] = ['DepartmentSchemes.foreign_funded' => $_GET['foreign_funded']];
        }

        if (isset($_GET['scheme_type']) && $_GET['scheme_type'] !== '') {
            $cond[] = ['DepartmentSchemes.scheme_type' => $_GET['scheme_type']];
        }

        if (isset($_GET['name']) && $_GET['name'] !== '') {
//            if (is_numeric($_GET['name'])) {
//                $cond[] = ['OR' => ['DepartmentSchemes.scheme_code' => $_GET['name']]];
//            }
//            if (!is_numeric($_GET['name'])) {
//                $cond[] = ['OR' => ['DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
//            }
            $cond[] = ['OR' => ['DepartmentSchemes.scheme_code like ' => '%' . $_GET['name'] . '%', 'DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
        }

        if (isset($_GET['district']) && $_GET['district'] !== '') {
//            debug($_GET['district']);
//            exit;
            $this->loadModel('SchemeDistricts');
            $fetch_schemes = $this->SchemeDistricts->find('list', ['conditions' => [
                            'SchemeDistricts.district_id IN ' => $_GET['district'],
//                            'SchemeDistricts.department_id IN ' => $_GET['department']
                ]])->all()->toArray();
//            debug($fetch_schemes);
//            exit;
            if ($fetch_schemes) {
                $cond[] = ['DepartmentSchemes.id IN' => $fetch_schemes];
            } else {
                $cond[] = ['DepartmentSchemes.id IN' => array('1234567890')];
            }
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }

//        debug($cond);exit;
//        $this->loadModel('SchemeDistricts');
//        $this->paginate = [
//            'limit' => 200,
//            'conditions' => $cond,
//            'order' => ['id' => 'desc'],
////            'contain' => ['SchemeDistricts'],
//            'fields' => ['id', 'id_chief_economist', 'overall_status', 'scheme_name', 'scheme_code', 'scheme_type', 'department_id', 'last_modified', 'locked', 'directive', 'mega_project', 'issues_list']//,'SchemeStatuses.status_color_pattern'
//        ];
        $departmentSchemes = $this->DepartmentSchemes->find('all', [
                    'conditions' => $cond,
                    'order' => ['id' => 'desc'],
//            'contain' => ['SchemeDistricts'],
                    'fields' => ['id', 'id_chief_economist', 'overall_status', 'scheme_name', 'scheme_code', 'scheme_type', 'department_id', 'last_modified', 'locked', 'directive', 'mega_project', 'issues_list']
                ])->all();

        $this->loadModel('Districts');
        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();

        $cond = array();
//        $cond[] = ['Departments.deleted' => 0
////            ,'Departments.department_name NOT LIKE'=>'Other'
//        ];
        $this->loadModel('Departments');
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['Departments.id IN ' => $get_departments];
        }
//        $departments_assigned = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();
        $departments = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();

//        debug($districts);exit;
        $project_types = $this->send_types();

        $this->set(compact('departmentSchemes', 'districts', 'departments', 'project_types', 'output_type', 'file'));

        $this->viewBuilder()->setLayout('xls/default');
        $this->viewBuilder()->setTemplate('xls/exportall');
        $this->RequestHandler->respondAs('xlsx');
        $this->render();
    }

    public function exportlist() {
        $this->viewBuilder()->setLayout('');
        $cond = array();
        $cond[] = ['DepartmentSchemes.deleted' => 0];

        if (isset($_GET['department'])) {
            $cond[] = ['DepartmentSchemes.department_id IN' => $_GET['department']];

//            $this->loadModel('Departments');
//
//            $department = $this->Departments->find('all', ['conditions' => ['id' => $dept_id]])->first();
//
//            $this->set(compact('department'));
        }
//        debug($department);exit;
        if (isset($_GET['status']) && $_GET['status'] !== '') {
            $cond[] = ['DepartmentSchemes.overall_status' => $_GET['status']];
        }

        if (isset($_GET['directive_search']) && $_GET['directive_search'] !== '') {
            $cond[] = ['DepartmentSchemes.directive' => $_GET['directive_search']];
        }
        if (isset($_GET['mega_project_search']) && $_GET['mega_project_search'] !== '') {
            if ($_GET['mega_project_search'] == 'Mega') {
                $cond[] = ['DepartmentSchemes.mega_project' => 'Yes'];
            } else if ($_GET['mega_project_search'] == 'Normal') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'Normal'];
            } else if ($_GET['mega_project_search'] == 'High Priority') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'High Priority'];
            } else if ($_GET['mega_project_search'] == 'DFC (Two Years)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Two Years)'];
            } else if ($_GET['mega_project_search'] == 'DFC (Current Year)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Current Year)'];
            } else if ($_GET['mega_project_search'] == 'After Assembly') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'After Assembly'];
            }
        }
        if (isset($_GET['foreign_funded']) && $_GET['foreign_funded'] !== '') {
            $cond[] = ['DepartmentSchemes.foreign_funded' => $_GET['foreign_funded']];
        }

        if (isset($_GET['scheme_type']) && $_GET['scheme_type'] !== '') {
            $cond[] = ['DepartmentSchemes.scheme_type' => $_GET['scheme_type']];
        }

        if (isset($_GET['name']) && $_GET['name'] !== '') {

            $cond[] = ['OR' => ['DepartmentSchemes.scheme_code like ' => '%' . $_GET['name'] . '%', 'DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
        }

        if (isset($_GET['district']) && $_GET['district'] !== '') {
//            debug($_GET['district']);
//            exit;
            $this->loadModel('SchemeDistricts');
            $fetch_schemes = $this->SchemeDistricts->find('list', ['conditions' => [
                            'SchemeDistricts.district_id IN ' => $_GET['district'],
//                            'SchemeDistricts.department_id IN ' => $_GET['department']
                ]])->all()->toArray();
//            debug($fetch_schemes);
//            exit;
            if ($fetch_schemes) {
                $cond[] = ['DepartmentSchemes.id IN' => $fetch_schemes];
            } else {
                $cond[] = ['DepartmentSchemes.id IN' => array('1234567890')];
            }
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }

        $departmentSchemes = $this->DepartmentSchemes->find('all', [
                    'conditions' => $cond,
                    'order' => ['id' => 'desc'],
//            'contain' => ['SchemeDistricts'],
                    'fields' => ['id', 'id_chief_economist', 'overall_status', 'scheme_name', 'scheme_code', 'scheme_type', 'department_id', 'last_modified', 'locked', 'directive', 'mega_project', 'issues_list']
                ])->all();

        $this->loadModel('Districts');
        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();

        $cond = array();
//        $cond[] = ['Departments.deleted' => 0
////            ,'Departments.department_name NOT LIKE'=>'Other'
//        ];
        $this->loadModel('Departments');
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['Departments.id IN ' => $get_departments];
        }
//        $departments_assigned = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();
        $departments = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();

//        debug($districts);exit;
        $project_types = $this->send_types();

        $this->set(compact('departmentSchemes', 'districts', 'departments', 'project_types'));
    }

    public function exportexcel($id = null) {
        $output_type = 'D';

        $departmentScheme = $this->DepartmentSchemes->get($id, [
//            'contain' => ['Departments', 'SchemeStatuses', 'SchemeDistricts'],
        ]);

        $file = 'tracker_' . preg_replace('/\s+/', '_', $departmentScheme->scheme_name) . '.xlsx';

        $this->loadModel('Departments');

        $departments = $this->Departments->find('list')->all()->toArray();

        $this->loadModel('CustomMilestones');
        $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['department_scheme_id' => $id], 'order' => ['id' => 'asc']])->all();

//        debug($departments);
//        exit;
        $this->set(compact('departmentScheme', 'departments', 'output_type', 'file', 'fetch_custom_details'));
        $this->viewBuilder()->setLayout('xls/default');
        $this->viewBuilder()->setTemplate('xls/exportexcel');
        $this->RequestHandler->respondAs('xlsx');
        $this->render();
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add_full() {
        $departmentScheme = $this->DepartmentSchemes->newEmptyEntity();
        if ($this->request->is('post')) {
            $mValidated = true;

            //password
            $mPostData = $this->request->getData();

//            debug($mPostData);
//            exit;


            unset($mPostData['scheme_file']);
            unset($mPostData['proc_goods_evidence_of_distribution']);

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $mPostData);
//            debug($this->request->getData()['scheme_file']);
//            exit;
            $scheme_file = $this->request->getData()['scheme_file'];
            $evidence = $this->request->getData()['proc_goods_evidence_of_distribution'];


            if ($scheme_file->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $scheme_file->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $new_name;
                    $scheme_file->moveTo($path);
                    $departmentScheme->scheme_file = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                unset($departmentScheme->scheme_file);
            }
            if ($evidence->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $evidence->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $new_name;
                    $evidence->moveTo($path);
                    $departmentScheme->scheme_file = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                unset($departmentScheme->scheme_file);
            }
//            debug($departmentScheme);
//            exit;
            if ($mValidated == true) {
                $departmentScheme->active = 1;
                $departmentScheme->created_by = $this->request->getAttribute('identity')->getIdentifier();
                $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
                $departmentScheme->department_id = $this->Authentication->getResult()->getData()->department_id;
                $departmentScheme->scheme_status_id = 1;


                if ($this->DepartmentSchemes->save($departmentScheme)) {
                    $this->Flash->success(__('The department scheme has been saved.'));

                    return $this->redirect(['action' => 'index']);
                }
                debug($departmentScheme);
                $this->Flash->error(__('The department scheme could not be saved. Please, try again.'));
            }
        }
//        $departments = $this->DepartmentSchemes->Departments->find('list', ['limit' => 200]);  'departments', 
        $schemeStatuses = $this->DepartmentSchemes->SchemeStatuses->find('list', ['limit' => 200, 'keyField' => 'status_name', 'valueField' => 'status_name']);
        $this->set(compact('departmentScheme', 'schemeStatuses'));
    }

    private function savelog($dept_id = null, $id = null, $form_data = null) {
        //scheme saving starts here
        $array_to_Save = array();
        $this->loadModel('SchemesLogs');
        foreach ($form_data as $key => $data):
            $array_to_Save['department_scheme_id'] = $id;
            $array_to_Save['department_id'] = $dept_id;
            $array_to_Save['field_name'] = $key;
            $array_to_Save['answer'] = $data;
            $array_to_Save['user_id'] = $this->request->getAttribute('identity')->getIdentifier();

            if ($data) {
                $check_before = $this->SchemesLogs->find('all', ['conditions' => ['SchemesLogs.department_id' => $dept_id, 'SchemesLogs.department_scheme_id' => $id, 'SchemesLogs.field_name' => $key, 'SchemesLogs.answer' => $data]])->first();
//            debug($array_to_Save);
//            exit;

                if ($check_before == null) {

                    $entity = $this->SchemesLogs->newEntity($array_to_Save);
                    if ($this->SchemesLogs->save($entity)) {
                        //saved
                        $schemeRequest = $this->DepartmentSchemes->get($id);
                        $schemeRequest->last_modified = date('Y-m-d G:i:s');
//                        exit;

                        $this->DepartmentSchemes->save($schemeRequest);
                    } else {
//                        debug($entity);
//                        exit;
                    }
                }
            }
        endforeach;
        //scheme saving ends here
    }

    public function import() {
        if ($this->request->is('post')) {

            // If the file is uploaded
            if (is_uploaded_file($_FILES['scheme_name']['tmp_name'])) {

                // Open uploaded CSV file with read-only mode
                $csvFile = fopen($_FILES['scheme_name']['tmp_name'], 'r');

                // Skip the first line
                fgetcsv($csvFile);


                ini_set('max_execution_time', '300'); //300 seconds = 5 minutes
                while (($line = fgetcsv($csvFile)) !== FALSE) {

                    $find_existing = $this->DepartmentSchemes->find('all', ['conditions' => ['scheme_code' => $line[1], 'deleted' => 0]])->first();
                    if ($find_existing == null) {

                        $departmentScheme = $this->DepartmentSchemes->newEmptyEntity();
                        // Get row data
//                    $name = $line[0];

                        if ($line[0] == '1.KP') {
                            $type = 'ADP';
                            $geo = 'provincial';
                        } else if ($line[0] == '2.MA') {
                            $type = 'ADP';
                            $geo = 'merged';
                        } else { //4.AIP
                            $type = 'AIP';
                            $geo = 'settled';
                        }

//                        debug($line);
//                        exit;
                        $dept_id = 0;

                        switch ($line[3]) {
                            case 'Agriculture':
                                $dept_id = 2;

                                break;
                            case 'Auqaf':
                                $dept_id = 4;

                                break;
                            case 'Board of Revenue':
                                $dept_id = 31;

                                break;
                            case 'C&W':
                                $dept_id = 3;

                                break;
                            case 'Culture, Sports, Tourism, Archaeology & Youth Affairs':
                                $dept_id = 35;

                                break;
                            case 'E&SE':
                                $dept_id = 7;

                                break;
                            case 'Energy & Power':
                                $dept_id = 5;

                                break;
                            case 'Establishment':
                                $dept_id = 12;

                                break;
                            case 'Excise & Taxation':
                                $dept_id = 13;

                                break;
                            case 'Social Welfare':
                                $dept_id = 32;

                                break;
                            case 'Finance':
                                $dept_id = 14;

                                break;
                            case 'Food':
                                $dept_id = 15;

                                break;
                            case 'Forest, Environment and Wildlife':
                                $dept_id = 10;

                                break;
                            case 'Health':
                                $dept_id = 16;

                                break;
                            case 'Higher Education':
                                $dept_id = 21;

                                break;
                            case 'Home & Tribal Affairs':
                                $dept_id = 22;

                                break;
                            case 'Housing':
                                $dept_id = 23;

                                break;
                            case 'Industries':
                                $dept_id = 18;

                                break;
                            case 'Information & Public Relations':
                                $dept_id = 8;

                                break;
                            case 'Irrigation':
                                $dept_id = 19;

                                break;
                            case 'Labour':
                                $dept_id = 20;

                                break;
                            case 'Law':
                                $dept_id = 6;

                                break;
                            case 'LG & RDD':
                                $dept_id = 26;

                                break;
                            case 'Minerals Development':
                                $dept_id = 27;

                                break;
                            case 'PHE':
                                $dept_id = 30;

                                break;
                            case 'Planning & Development':
                                $dept_id = 28;

                                break;
                            case 'Population Welfare':
                                $dept_id = 29;

                                break;
                            case 'Relief Rehabilitation & Settlement':
                                $dept_id = 11;

                                break;
                            case 'ST & IT':
                                $dept_id = 9;

                                break;
                            case 'Transport':
                                $dept_id = 34;

                                break;
                        }
                        if ($dept_id) {
//                            debug($dept_id);

                            $mpostData['locked'] = 0;
                            $mpostData['year'] = 2021;
                            $mpostData['department_id'] = $dept_id;
                            $mpostData['attached_formation_id'] = 0;
                            $mpostData['user_id'] = 15071;
                            $mpostData['id_chief_economist'] = 0;
                            $mpostData['is_peshawar'] = 0;
                            $mpostData['overall_status'] = 1;
                            $mpostData['scheme_code'] = $line[1];
                            $mpostData['parent_scheme_code'] = 0;
                            $mpostData['scheme_name'] = $line[2];
                            $mpostData['scheme_type'] = $type;
                            $mpostData['scheme_category'] = $line[8];
                            $mpostData['active'] = 1;
                            $mpostData['flag'] = 1;
                            $mpostData['geo_coverage'] = $geo;
                            $mpostData['cost_of_scheme'] = $line[12];
                            $mpostData['expenditure_till_date'] = $line[13];


                            //                    exit;
                            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $mpostData);

                            $departmentScheme->created_by = $this->request->getAttribute('identity')->getIdentifier();
                            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
                            $departmentScheme->user_id = $this->request->getAttribute('identity')->getIdentifier();
                            $departmentScheme->flag = 1;
                            $departmentScheme->scheme_start_date = '2021-07-01';
                            $departmentScheme->scheme_end_date = '2022-06-30';

                            if ($result = $this->DepartmentSchemes->save($departmentScheme)) {
                                //                        $this->Flash->success(__('New scheme has been saved.'));
                                //
                              //                        return $this->redirect(['action' => 'import']);
                            } else {
                                debug($departmentScheme);
                            }
                        }
                    } else {
//                        debug($find_existing);
                    }
                }
            }
            exit;
        }
    }

    public function add() {
        $departmentScheme = $this->DepartmentSchemes->newEmptyEntity();
        if ($this->request->is('post')) {

            $mPostData = $this->request->getData();
//            debug($mPostData);
//            exit;
            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $mPostData);


            $departmentScheme->active = 1;
            $departmentScheme->flag = 0;
            $departmentScheme->created_by = $this->request->getAttribute('identity')->getIdentifier();
            $departmentScheme->user_id = $this->request->getAttribute('identity')->getIdentifier();
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
//            $departmentScheme->department_id = $this->Authentication->getResult()->getData()->department_id;
            $departmentScheme->attached_formation_id = $this->Authentication->getResult()->getData()->attached_formation_id;
            $departmentScheme->scheme_start_date = date('Y-m-d', strtotime($mPostData['scheme_start_date']));
            $departmentScheme->scheme_end_date = date('Y-m-d', strtotime($mPostData['scheme_end_date']));
            if ($mPostData['pc1_approval_date']) {
                $departmentScheme->pc1_approval_date = date('Y-m-d', strtotime($mPostData['pc1_approval_date']));
            }
//            debug($departmentScheme);exit;
//            if ($mPostData['step1_status'] > $mPostData['step2_status']) {
//                $departmentScheme->overall_status = $mPostData['step1_status'];
//            } else {
//                $departmentScheme->overall_status = $mPostData['step2_status'];
//            }
            $departmentScheme->overall_status = 1;



            if ($result = $this->DepartmentSchemes->save($departmentScheme)) {
                $this->Flash->success(__('New scheme has been saved.'));

                return $this->redirect(['action' => 'schemeprofile', $result->id]);
            }
//            debug($departmentScheme);
//            exit;
            $this->Flash->error(__('New scheme could not be saved. Please, try again.'));
        }
//        $departments = $this->DepartmentSchemes->Departments->find('list', ['limit' => 200]);  'departments', 
//        $schemeStatuses = $this->DepartmentSchemes->SchemeStatuses->find('list', ['limit' => 200, 'keyField' => 'status_name', 'valueField' => 'status_name']); , 'schemeStatuses'
        $project_types = $this->send_types();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
//            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
            $this->loadModel('Departments');
            $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'conditions' => ['Departments.id IN' => $get_departments], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();
        } else {
            $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();
        }
        $this->set(compact('departmentScheme', 'project_types', 'departments'));
    }

    public function schemeprofile($id = null) {
        $cond = array();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'sub-admin') {
            $cond = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }

        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }

        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'conditions' => $cond,
        ]);

        if ($this->request->is(['patch', 'post', 'put'])) {

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $this->request->getData());
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();

            if (isset($this->request->getData()['scheme_start_date'])) {
                $departmentScheme->scheme_start_date = date('Y-m-d', strtotime($this->request->getData()['scheme_start_date']));
                $departmentScheme->scheme_end_date = date('Y-m-d', strtotime($this->request->getData()['scheme_end_date']));
            }
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                $this->savelog($departmentScheme->department_id, $id, $this->request->getData());

                $this->Flash->success(__('The scheme profile has been saved.'));

                return $this->redirect(['action' => 'reldistricts', $id]);
            }
            // debug($departmentScheme);
            $this->Flash->error(__('The scheme profile could not be saved. Please, try again.'));
        }

        $project_types = $this->send_types();

        $this->loadModel('SchemeRequests');
        $get_Request = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $departmentScheme->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'schemeprofile'
            ]])->first();
        // debug($get_Request);exit;

        $this->set(compact('departmentScheme', 'project_types', 'get_Request'));
    }

    public function reldistricts($id = null) {

        $cond = array();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'sub-admin') {
            $cond = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }

        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }

        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'conditions' => $cond,
        ]);

        $this->loadModel('SchemeDistricts');

        if ($this->request->is(['patch', 'post', 'put'])) {

            if ($this->request->getData()) {
                $single_array = [];
                // debug($this->request->getData());exit;
                $this->SchemeDistricts->deleteAll(['department_scheme_id' => $id]);
                foreach ($this->request->getData()['disid'] as $data):

                    $articles = $this->getTableLocator()->get('SchemeDistricts');
                    $query = $articles->query();
                    $query->insert(['district_id', 'department_scheme_id', 'department_id', 'created_by', 'modified_by', 'created', 'modified'])
                            ->values([
                                'district_id' => $data,
                                'department_scheme_id' => $id,
                                'department_id' => $departmentScheme->department_id,
                                'created_by' => $this->request->getAttribute('identity')->getIdentifier(),
                                'modified_by' => $this->request->getAttribute('identity')->getIdentifier(),
                                'created' => date('Y-m-d'),
                                'modified' => date('Y-m-d'),
                            ])
                            ->execute();
                endforeach;

                // $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $this->request->getData());
                // if ($this->DepartmentSchemes->save($departmentScheme)) {
                $this->Flash->success(__('Related districts has been saved.'));

                return $this->redirect(['action' => 'add_activity', $id]);
                //}
                //$this->Flash->error(__('The department scheme could not be saved. Please, try again.'));
            } else {
                $this->Flash->error(__('You must Choose atleast 1 district'));
            }
        }

        $choosen_districts = $this->SchemeDistricts->find('list', ['keyField' => 'district_id', 'valueField' => 'district_id', 'conditions' => ['SchemeDistricts.department_scheme_id' => $id]])->all()->toArray();
        //debug($choosen_districts);
        //exit;
        $this->loadModel('Districts');
        //debug($departmentScheme->geo_coverage);//exit;
        $districts = $this->Districts->find('list', ['conditions' => ['Districts.deleted' => 0, 'Districts.type like' => '%' . $departmentScheme->geo_coverage . '%'], 'order' => ['name' => 'asc']])->all();

        $this->set(compact('departmentScheme', 'districts', 'choosen_districts'));
    }

    public function step1($id = null) {
        $cond = array();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'sub-admin') {
            $cond = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }

        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }

        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'conditions' => $cond,
        ]);

        if ($this->request->is(['patch', 'post', 'put'])) {
            $post = $this->request->getData();
            if (trim($post['step1_remarks']) !== trim($post['step1_old_remarks'])) {
                $post['step1_date_change'] = date('Y-m-d');
            }
            if (isset($post['pc2_compl_date']) && $post['pc2_compl_date']) {
//                echo __LINE__;exit;
                $post['pc2_compl_date'] = ($post['pc2_compl_date']) ? date('Y-m-d', strtotime($post['pc2_compl_date'])) : '';
            } else {
                $post['pc2_compl_date'] = ($departmentScheme->pc2_compl_date) ? $departmentScheme->pc2_compl_date->i18nFormat('YYY-MM-dd') : '';
            }
            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
            //status thing starts here
            // debug($post);exit;
            if ($post['pc2_required'] == 'Yes') {
                //required, now need to check if completed,on_track or off_track or critically_delayed
                if ($post['pc2_approved'] == 'Yes' && $post['consultant_hired'] == 'Yes' && $post['cons_subt_report'] == 'Yes') {
                    $departmentScheme->step1_status = '2';
                } else {

                    if ($post['pc2_compl_date'] >= date('Y-m-d')) {
                        $departmentScheme->step1_status = '3';
                    } else { //off_track zone or danger zone
                        $now = time(); // or your date as well
                        $your_date = strtotime($post['pc2_compl_date']);
                        $datediff = $now - $your_date;

                        $diff = round($datediff / (60 * 60 * 24));
                        if ($diff > 15) { //danger zone
                            $departmentScheme->step1_status = '5';
                            $departmentScheme->overall_status = '5';
                        } else { //off_track zone
                            $departmentScheme->step1_status = '4';
                        }
                    }
                }
            } else if ($post['pc2_required'] == 'No') {
                //not required so kind of completed
                $departmentScheme->step1_status = '2';
            } else {
                //if null or empty as from the first time
                $departmentScheme->step1_status = '1';
            }

            // debug($departmentScheme->step1_status);
            //calculating over_all_status

            if ($departmentScheme->step1_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step1_status; //commented to know about the status of other milesstones
                $post['steps_array'][1] = $departmentScheme->step1_status;
                // && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            }
            //status thing ends here
            //debug($departmentScheme->overall_status);
            //exit;
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                //call log here
                unset($post['steps_array']);
                //debug($post);exit;
                $this->savelog($departmentScheme->department_id, $id, $post);

                $this->Flash->success(__('PC-2 requirement has been saved.'));

                return $this->redirect(['action' => 'step2', $id]);
            }
            //debug($departmentScheme);exit;
            $this->Flash->error(__('PC-2 requirement could not be saved. Please, try again.'));
        }

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();
        $this->loadModel('SchemeRequests');
        $get_Request = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $departmentScheme->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step1'
            ]])->first();

        $this->set(compact('departmentScheme', 'departments', 'get_Request'));
    }

    public function step2($id = null) {
        $cond = array();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'sub-admin') {
            $cond = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'conditions' => $cond,
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $post = $this->request->getData();

            if (trim($post['step2_remarks']) !== trim($post['step2_old_remarks'])) {
                $post['step2_date_change'] = date('Y-m-d');
            }
//            debug($post);
//            exit;
            if (isset($post['pc1_approval_date']) && $post['pc1_approval_date']) {
                $post['pc1_approval_date'] = date('Y-m-d', strtotime($post['pc1_approval_date']));
            } else {
                $post['pc1_approval_date'] = ($departmentScheme->pc1_approval_date) ? $departmentScheme->pc1_approval_date->i18nFormat('YYY-MM-dd') : '';
            }
            if (isset($post['pc1_compl_date']) && $post['pc1_compl_date']) {
                $post['pc1_compl_date'] = date('Y-m-d', strtotime($post['pc1_compl_date']));
            } else {
                $post['pc1_compl_date'] = ($departmentScheme->pc1_compl_date) ? $departmentScheme->pc1_compl_date->i18nFormat('YYY-MM-dd') : '';
            }
//                debug($post['pc1_compl_date']);exit;
            if ($post['pc1_required'] == 'Yes') {

                if ($post['pc1_approved'] == 'No') {
                    //required, now need to check if completed,on_track or off_track or critically_delayed

                    if ($post['pc1_compl_date'] >= date('Y-m-d')) {
                        $departmentScheme->step2_status = '3';
                    } else { //off_track zone or danger zone
                        $now = time(); // or your date as well
                        $your_date = strtotime($post['pc1_compl_date']);
                        $datediff = $now - $your_date;

                        $diff = round($datediff / (60 * 60 * 24));
                        if ($diff > 15) { //danger zone
                            $departmentScheme->step2_status = '5';
                            $departmentScheme->overall_status = '5';
                        } else { //off_track zone
                            $departmentScheme->step2_status = '4';
                        }
                    }
                } else if ($post['pc1_approved'] == 'Yes') {
                    //not required so kind of completed
                    $departmentScheme->step2_status = '2';
                } else {
                    //if null or empty as from the first time
                    $departmentScheme->step2_status = '1';
                }
            } else {
                $departmentScheme->step2_status = '2';
            }


            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
//status thing starts here
//            debug($departmentScheme->step1_status);
            //calculating over_all_status

            if ($departmentScheme->step2_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step2_status;
                $post['steps_array'][2] = $departmentScheme->step2_status;
// && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            }
            //status thing ends here
//            debug($departmentScheme->overall_status);
//            exit;
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('PC-1 requirement has been saved.'));

                return $this->redirect(['action' => 'step3', $id]);
            }
            debug($departmentScheme);
            exit;
            $this->Flash->error(__('PC-1 requirement could not be saved. Please, try again.'));
        }
        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $get_Request = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $departmentScheme->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step2'
            ]])->first();

        $this->set(compact('departmentScheme', 'departments', 'get_Request'));
    }

    public function step3($id = null) {
        $cond = array();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'sub-admin') {
            $cond = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'conditions' => $cond,
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {

            $post = $this->request->getData();

            if (trim($post['step3_remarks']) !== trim($post['step3_old_remarks'])) {
                $post['step3_date_change'] = date('Y-m-d');
            }

            if (isset($post['hiring_compl_date_psc']) && $post['hiring_compl_date_psc']) {
                $post['hiring_compl_date_psc'] = date('Y-m-d', strtotime($post['hiring_compl_date_psc']));
            } else {
                $post['hiring_compl_date_psc'] = ($departmentScheme->hiring_compl_date_psc) ? $departmentScheme->hiring_compl_date_psc->i18nFormat('YYY-MM-dd') : '';
            }

            if (isset($post['hiring_compl_date_internal_posting']) && $post['hiring_compl_date_internal_posting']) {
                $post['hiring_compl_date_internal_posting'] = date('Y-m-d', strtotime($post['hiring_compl_date_internal_posting']));
            } else {
                $post['hiring_compl_date_internal_posting'] = ($departmentScheme->hiring_compl_date_internal_posting) ? $departmentScheme->hiring_compl_date_internal_posting->i18nFormat('YYY-MM-dd') : '';
            }

            if (isset($post['hiring_market_compl_date']) && $post['hiring_market_compl_date']) {
                $post['hiring_market_compl_date'] = date('Y-m-d', strtotime($post['hiring_market_compl_date']));
            } else {
                $post['hiring_market_compl_date'] = ($departmentScheme->hiring_market_compl_date) ? $departmentScheme->hiring_market_compl_date->i18nFormat('YYY-MM-dd') : '';
            }

            if (isset($post['sne_submission_date']) && $post['sne_submission_date']) {
                $post['sne_submission_date'] = date('Y-m-d', strtotime($post['sne_submission_date']));
            } else {
                $post['sne_submission_date'] = ($departmentScheme->sne_submission_date) ? $departmentScheme->sne_submission_date->i18nFormat('YYY-MM-dd') : '';
            }
            if (isset($post['sne_approval_date']) && $post['sne_approval_date']) {
                $post['sne_approval_date'] = date('Y-m-d', strtotime($post['sne_approval_date']));
            } else {
                $post['sne_approval_date'] = ($departmentScheme->sne_approval_date) ? $departmentScheme->sne_approval_date->i18nFormat('YYY-MM-dd') : '';
            }

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();

            //status thing starts here
//            debug($post);
//            exit;
            if ($post['hiring_required'] == 'Yes') {
                if ($post['sne_required'] == 'Yes') {
                    if ($post['sne_submitted'] == 'Yes') {
                        if ($post['sne_approved'] == 'Yes') {
                            //other hiring questions

                            if ($post['will_hiring_through_psc'] == 'Yes' && $post['will_hiring_through_internal_posting'] == 'Yes' && $post['will_hiring_through_market'] == 'Yes' &&
                                    $post['hiring_through_psc'] == 'Yes' && $post['hiring_through_internal_posting'] == 'Yes' && $post['hiring_through_market'] == 'Yes') {
//all three + three are yes then green signal and nohting to do
                                $departmentScheme->step3_status = '2';
                            } else {
                                $step3_hiring_array = array();
                                if ($post['will_hiring_through_psc'] == 'Yes') {
                                    if ($post['hiring_through_psc'] == 'Yes') {
                                        array_push($step3_hiring_array, 2);
                                    } else {
                                        if ($post['hiring_compl_date_psc'] >= date('Y-m-d')) {

                                            array_push($step3_hiring_array, 3);
                                        } else {
                                            //check date thing
                                            $now = time(); // or your date as well
                                            $your_date = strtotime($post['hiring_compl_date_psc']);
                                            $datediff = $now - $your_date;

                                            $diff = round($datediff / (60 * 60 * 24));
                                            if ($diff > 15) { //danger zone
                                                array_push($step3_hiring_array, 5);
                                                $departmentScheme->overall_status = '5';
                                            } else { //off_track zone
                                                array_push($step3_hiring_array, 4);
                                            }
                                        }
                                    }
                                }
                                if ($post['will_hiring_through_internal_posting'] == 'Yes') {
                                    if ($post['hiring_through_internal_posting'] == 'Yes') {
                                        array_push($step3_hiring_array, 2);
                                    } else {
                                        if ($post['hiring_compl_date_internal_posting'] >= date('Y-m-d')) {

                                            array_push($step3_hiring_array, 3);
                                        } else {
                                            //check date thing
                                            $now = time(); // or your date as well
                                            $your_date = strtotime($post['hiring_compl_date_internal_posting']);
                                            $datediff = $now - $your_date;

                                            $diff = round($datediff / (60 * 60 * 24));
                                            if ($diff > 15) { //danger zone
                                                array_push($step3_hiring_array, 5);
                                                $departmentScheme->overall_status = '5';
                                            } else { //off_track zone
                                                array_push($step3_hiring_array, 4);
                                            }
                                        }
                                    }
                                }
                                if ($post['will_hiring_through_market'] == 'Yes') {
                                    if ($post['hiring_through_market'] == 'Yes' && $post['posting_though_market_media'] == 'Yes' && $post['hiring_market_entries_recorded'] == 'Yes' &&
                                            $post['hiring_market_scrutiny_compl'] == 'Yes' && $post['hiring_market_intervies_cond'] == 'Yes' && $post['hiring_market_appoint_letter_issues'] == 'Yes') {
                                        array_push($step3_hiring_array, 2);
                                    } else {
                                        if ($post['hiring_market_compl_date'] >= date('Y-m-d')) {

                                            array_push($step3_hiring_array, 3);
                                        } else {
                                            //check date thing
                                            $now = time(); // or your date as well
                                            $your_date = strtotime($post['hiring_market_compl_date']);
                                            $datediff = $now - $your_date;

                                            $diff = round($datediff / (60 * 60 * 24));
                                            if ($diff > 15) { //danger zone
                                                array_push($step3_hiring_array, 5);
                                                $departmentScheme->overall_status = '5';
                                            } else { //off_track zone
                                                array_push($step3_hiring_array, 4);
                                            }
                                        }
                                    }
                                }

//                        debug($post);
//                        exit;
//                        debug($step3_hiring_array);exit;
                                //count max of it and that will be the status
                                $departmentScheme->step3_status = (int) max($step3_hiring_array);
                            }
                        } else { //SNE -> NO => Directly compare the dates and make status thing
                            if ($post['sne_approval_date'] >= date('Y-m-d')) {
                                $departmentScheme->step3_status = '3';
                            } else { //off_track zone or danger zone
                                $now = time(); // or your date as well
                                $your_date = strtotime($post['sne_approval_date']);
                                $datediff = $now - $your_date;

                                $diff = round($datediff / (60 * 60 * 24));
                                if ($diff > 15) { //danger zone
                                    $departmentScheme->step3_status = '5';
                                    $departmentScheme->overall_status = '5';
                                } else { //off_track zone
                                    $departmentScheme->step3_status = '4';
                                }
                            }
                        }
                    } else {
                        if ($post['sne_submission_date'] >= date('Y-m-d')) {
                            $departmentScheme->step3_status = '3';
                        } else { //off_track zone or danger zone
                            $now = time(); // or your date as well
                            $your_date = strtotime($post['sne_submission_date']);
                            $datediff = $now - $your_date;

                            $diff = round($datediff / (60 * 60 * 24));
                            if ($diff > 15) { //danger zone
                                $departmentScheme->step3_status = '5';
                                $departmentScheme->overall_status = '5';
                            } else { //off_track zone
                                $departmentScheme->step3_status = '4';
                            }
                        }
                    }
                } else {
                    //directly check the answers for hiring through other 3 steps
                    if ($post['will_hiring_through_psc'] == 'Yes' && $post['will_hiring_through_internal_posting'] == 'Yes' && $post['will_hiring_through_market'] == 'Yes' &&
                            $post['hiring_through_psc'] == 'Yes' && $post['hiring_through_internal_posting'] == 'Yes' && $post['hiring_through_market'] == 'Yes') {
//all three + three are yes then green signal and nohting to do
                        $departmentScheme->step3_status = '2';
                    } else {
                        $step3_hiring_array = array();
                        if ($post['will_hiring_through_psc'] == 'Yes') {
                            if ($post['hiring_through_psc'] == 'Yes') {
                                array_push($step3_hiring_array, 2);
                            } else {
                                if ($post['hiring_compl_date_psc'] >= date('Y-m-d')) {

                                    array_push($step3_hiring_array, 3);
                                } else {
                                    //check date thing
                                    $now = time(); // or your date as well
                                    $your_date = strtotime($post['hiring_compl_date_psc']);
                                    $datediff = $now - $your_date;

                                    $diff = round($datediff / (60 * 60 * 24));
                                    if ($diff > 15) { //danger zone
                                        array_push($step3_hiring_array, 5);
                                        $departmentScheme->overall_status = '5';
                                    } else { //off_track zone
                                        array_push($step3_hiring_array, 4);
                                    }
                                }
                            }
                        }
                        if ($post['will_hiring_through_internal_posting'] == 'Yes') {
                            if ($post['hiring_through_internal_posting'] == 'Yes') {
                                array_push($step3_hiring_array, 2);
                            } else {
                                if ($post['hiring_compl_date_internal_posting'] >= date('Y-m-d')) {

                                    array_push($step3_hiring_array, 3);
                                } else {
                                    //check date thing
                                    $now = time(); // or your date as well
                                    $your_date = strtotime($post['hiring_compl_date_internal_posting']);
                                    $datediff = $now - $your_date;

                                    $diff = round($datediff / (60 * 60 * 24));
                                    if ($diff > 15) { //danger zone
                                        array_push($step3_hiring_array, 5);
                                        $departmentScheme->overall_status = '5';
                                    } else { //off_track zone
                                        array_push($step3_hiring_array, 4);
                                    }
                                }
                            }
                        }
                        if ($post['will_hiring_through_market'] == 'Yes') {
                            if ($post['hiring_through_market'] == 'Yes' && $post['posting_though_market_media'] == 'Yes' && $post['hiring_market_entries_recorded'] == 'Yes' &&
                                    $post['hiring_market_scrutiny_compl'] == 'Yes' && $post['hiring_market_intervies_cond'] == 'Yes' && $post['hiring_market_appoint_letter_issues'] == 'Yes') {
                                array_push($step3_hiring_array, 2);
                            } else {
                                if ($post['hiring_market_compl_date'] >= date('Y-m-d')) {

                                    array_push($step3_hiring_array, 3);
                                } else {
                                    //check date thing
                                    $now = time(); // or your date as well
                                    $your_date = strtotime($post['hiring_market_compl_date']);
                                    $datediff = $now - $your_date;

                                    $diff = round($datediff / (60 * 60 * 24));
                                    if ($diff > 15) { //danger zone
                                        array_push($step3_hiring_array, 5);
                                        $departmentScheme->overall_status = '5';
                                    } else { //off_track zone
                                        array_push($step3_hiring_array, 4);
                                    }
                                }
                            }
                        }

//                        debug($post);
//                        exit;
//                        debug($step3_hiring_array);exit;
                        //count max of it and that will be the status
                        $departmentScheme->step3_status = (int) max($step3_hiring_array);
                    }
                }
            } else if ($post['hiring_required'] == 'No') {
                //not required so kind of completed
                $departmentScheme->step3_status = '2';
            } else {
                //if null or empty as from the first time
                $departmentScheme->step3_status = '1';
            }

//            debug($departmentScheme->step1_status);
            //calculating over_all_status

            if ($departmentScheme->step3_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step3_status;
                $post['steps_array'][3] = $departmentScheme->step3_status;
//                debug($post['steps_array']);exit; 
//                 && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            }
            //status thing ends here
//            debug($departmentScheme->overall_status);
//            exit;

            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('Hiring requirement has been saved.'));

                return $this->redirect(['action' => 'step4', $id]);
            }
            $this->Flash->error(__('Hiring requirement could not be saved. Please, try again.'));
        }

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $get_Request = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $departmentScheme->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step3'
            ]])->first();

        $this->set(compact('departmentScheme', 'departments', 'get_Request'));
    }

    public function step4($id = null) {
        $cond = array();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'sub-admin') {
            $cond = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'conditions' => $cond,
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {

            $post = $this->request->getData();

            if (trim($post['step4_remarks']) !== trim($post['step4_old_remarks'])) {
                $post['step4_date_change'] = date('Y-m-d');
            }

            if (isset($post['land_acquisition_compl_date']) && $post['land_acquisition_compl_date']) {
                $post['land_acquisition_compl_date'] = date('Y-m-d', strtotime($post['land_acquisition_compl_date']));
            } else {
                $post['land_acquisition_compl_date'] = ($departmentScheme->land_acquisition_compl_date) ? $departmentScheme->land_acquisition_compl_date->i18nFormat('YYY-MM-dd') : '';
            }

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
//status thing starts here
//            debug($post);exit;
            if ($post['land_acquisition_required'] == 'Yes') {
                //required, now need to check if completed,on_track or off_track or critically_delayed 
                if ($post['land_identified'] == 'Yes' && $post['land_section4_compl'] == 'Yes' && $post['land_section6_comp'] == 'Yes' &&
                        $post['land_possision_taken_over'] == 'Yes' && $post['land_award_been_issued'] == 'Yes' && $post['land_payment_made'] == 'Yes') {
                    $departmentScheme->step4_status = '2';
                } else {

                    if ($post['land_acquisition_compl_date'] >= date('Y-m-d')) {
                        $departmentScheme->step4_status = '3';
                    } else {
                        $now = time(); // or your date as well
                        $your_date = strtotime($post['land_acquisition_compl_date']);
                        $datediff = $now - $your_date;

                        $diff = round($datediff / (60 * 60 * 24));
                        if ($diff > 15) { //danger zone
                            $departmentScheme->step4_status = '5';
                            $departmentScheme->overall_status = '5';
                        } else { //off track
                            $departmentScheme->step4_status = '4';
                        }
                    }
                }
            } else if ($post['land_acquisition_required'] == 'No') {
                //not required so kind of completed
                $departmentScheme->step4_status = '2';
            } else {
                //if null or empty as from the first time
                $departmentScheme->step4_status = '1';
            }
            //calculating over_all_status
            if ($departmentScheme->step4_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step4_status;
                $post['steps_array'][4] = $departmentScheme->step4_status;
// && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            }
//status thing ends here
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('Land requirement has been saved.'));

                return $this->redirect(['action' => 'step5', $id]);
            }
            $this->Flash->error(__('Land requirement could not be saved. Please, try again.'));
        }

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $get_Request = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $departmentScheme->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step4'
            ]])->first();

        $this->set(compact('departmentScheme', 'departments', 'get_Request'));
    }

    public function step5($id = null) {
        $cond = array();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'sub-admin') {
            $cond = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'conditions' => $cond,
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $mValidated = true;

            //password
            $post = $this->request->getData();

            if (trim($post['step5_remarks']) !== trim($post['step5_old_remarks'])) {
                $post['step5_date_change'] = date('Y-m-d');
            }

            if (isset($post['proc_goods_compl_date']) && $post['proc_goods_compl_date']) {
                $post['proc_goods_compl_date'] = date('Y-m-d', strtotime($post['proc_goods_compl_date']));
            } else {
                $post['proc_goods_compl_date'] = ($departmentScheme->proc_goods_compl_date) ? $departmentScheme->proc_goods_compl_date->i18nFormat('YYY-MM-dd') : '';
            }


//            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);


            unset($post['proc_goods_evidence_of_distribution']);

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();


            $evidence = $this->request->getData()['proc_goods_evidence_of_distribution'];
//            debug($mPostData);
//            exit;
            if ($evidence->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $evidence->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $new_name;
                    $evidence->moveTo($path);
                    $departmentScheme->proc_goods_evidence_of_distribution = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                if ($departmentScheme->proc_goods_required == 'Yes') {
                    unset($departmentScheme->proc_goods_evidence_of_distribution);
                } else {
                    $departmentScheme->proc_goods_evidence_of_distribution = '';
                }
            }
//            debug($departmentScheme);
//            exit;
            if ($mValidated == true) {

//status thing starts here
//                $post = $this->request->getData();
//            debug($post['pc2_compl_date']);
                if ($post['proc_goods_required'] == 'Yes') {
                    //required, now need to check if completed,on_track or off_track or critically_delayed 
                    if ($post['proc_goods_tender_advertised'] == 'Yes' && $post['proc_goods_bidding_complete'] == 'Yes' && $post['proc_goods_po_issued'] == 'Yes' &&
                            $post['proc_goods_delivery_physical_verification_done'] == 'Yes' && $post['proc_goods_distribution_equipments'] == 'Yes') {
                        $departmentScheme->step5_status = '2';
                    } else {

                        if ($post['proc_goods_compl_date'] >= date('Y-m-d')) {
                            $departmentScheme->step5_status = '3';
                        } else {
                            $now = time(); // or your date as well
                            $your_date = strtotime($post['proc_goods_compl_date']);
                            $datediff = $now - $your_date;

                            $diff = round($datediff / (60 * 60 * 24));
                            if ($diff > 15) {
                                $departmentScheme->step5_status = '5';
                                $departmentScheme->overall_status = '5';
                            } else {
                                $departmentScheme->step5_status = '4';
                            }
                        }
                    }
                } else if ($post['proc_goods_required'] == 'No') {
                    //not required so kind of completed
                    $departmentScheme->step5_status = '2';
                } else {
                    //if null or empty as from the first time
                    $departmentScheme->step5_status = '1';
                }
                //calculating over_all_status
                if ($departmentScheme->step5_status !== '5') { //skip this step
                    $departmentScheme->overall_status = (int) $departmentScheme->step5_status;
                    $post['steps_array'][5] = $departmentScheme->step5_status;
// && array_sum($post['steps_array']) > 10
                    if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                        $departmentScheme->overall_status = (int) max($post['steps_array']);
                    } else {
                        $departmentScheme->overall_status = 1;
                    }
                }
//status thing ends here

                if ($this->DepartmentSchemes->save($departmentScheme)) {
                    unset($post['steps_array']);
                    $this->savelog($departmentScheme->department_id, $id, $post);


                    $this->Flash->success(__('Goods requirement has been saved.'));

                    return $this->redirect(['action' => 'step6', $id]);
                }
            }
            $this->Flash->error(__('Goods requirement could not be saved. Please, try again.'));
        }
        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $get_Request = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $departmentScheme->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step5'
            ]])->first();

        $this->set(compact('departmentScheme', 'departments', 'get_Request'));
    }

    public function remove_step5_evidence($id = null) {
        $departmentScheme = $this->DepartmentSchemes->get($id);
        unlink(WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $departmentScheme->proc_goods_evidence_of_distribution);
        $departmentScheme->proc_goods_evidence_of_distribution = '';
        if ($this->DepartmentSchemes->save($departmentScheme)) {

            $this->Flash->success(__('Evidence of distribution file details has been removed.'));

            return $this->redirect(['action' => 'step5', $id]);
        }
    }

    public function step6($id = null) {
        $cond = array();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'sub-admin') {
            $cond = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'conditions' => $cond,
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();

//status thing starts here
            $post = $this->request->getData();

            if (trim($post['step6_remarks']) !== trim($post['step6_old_remarks'])) {
                $post['step6_date_change'] = date('Y-m-d');
            }

            if (isset($post['proc_services_compl_date']) && $post['proc_services_compl_date']) {
                $post['proc_services_compl_date'] = date('Y-m-d', strtotime($post['proc_services_compl_date']));
            } else {
                $post['proc_services_compl_date'] = ($departmentScheme->proc_services_compl_date) ? $departmentScheme->proc_services_compl_date->i18nFormat('YYY-MM-dd') : '';
            }

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);


//            debug($post['pc2_compl_date']);
            if ($post['proc_services_required'] == 'Yes') {
                //required, now need to check if completed,on_track or off_track or critically_delayed 
                if ($post['proc_services_tender_advertised'] == 'Yes' && $post['proc_services_tech_finance_proposal_received'] == 'Yes' && $post['proc_services_evaluation_process_compl'] == 'Yes' &&
                        $post['proc_services_contract_awarded'] == 'Yes' && $post['proc_services_status'] == '100') {
                    $departmentScheme->step6_status = '2';
                } else {

                    if ($post['proc_services_compl_date'] >= date('Y-m-d')) {
                        $departmentScheme->step6_status = '3';
                    } else {
                        $now = time(); // or your date as well
                        $your_date = strtotime($post['proc_services_compl_date']);
                        $datediff = $now - $your_date;

                        $diff = round($datediff / (60 * 60 * 24));
                        if ($diff > 15) { //danger zone
                            $departmentScheme->step6_status = '5';
                            $departmentScheme->overall_status = '5';
                        } else { //off track
                            $departmentScheme->step6_status = '4';
                        }
                    }
                }
            } else if ($post['proc_services_required'] == 'No') {
                //not required so kind of completed
                $departmentScheme->step6_status = '2';
            } else {
                //if null or empty as from the first time
                $departmentScheme->step6_status = '1';
            }

            if ($departmentScheme->step6_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step6_status;
                $post['steps_array'][6] = $departmentScheme->step6_status;
//                 && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            }
//status thing ends here
//            debug($departmentScheme->step6_status);
//            debug($departmentScheme->overall_status);
//            exit;
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('Land requirement has been saved.'));

                return $this->redirect(['action' => 'step7', $id]);
            }
            $this->Flash->error(__('Land requirement could not be saved. Please, try again.'));
        }

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $get_Request = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $departmentScheme->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step6'
            ]])->first();

        $this->set(compact('departmentScheme', 'departments', 'get_Request'));
    }

    public function step7($id = null) {
        $cond = array();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'sub-admin') {
            $cond = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'conditions' => $cond,
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();

            //status thing starts here
            $post = $this->request->getData();
            if (trim($post['step7_remarks']) !== trim($post['step7_old_remarks'])) {
                $post['step7_date_change'] = date('Y-m-d');
            }
            if (isset($post['cons_civil_compl_date']) && $post['cons_civil_compl_date']) {
                $post['cons_civil_compl_date'] = date('Y-m-d', strtotime($post['cons_civil_compl_date']));
            } else {
                $post['cons_civil_compl_date'] = ($departmentScheme->cons_civil_compl_date) ? $departmentScheme->cons_civil_compl_date->i18nFormat('YYY-MM-dd') : '';
            }

            if (isset($post['cons_start_date']) && $post['cons_start_date']) {
                $post['cons_start_date'] = date('Y-m-d', strtotime($post['cons_start_date']));
            } else {
                $post['cons_start_date'] = ($departmentScheme->cons_start_date) ? $departmentScheme->cons_start_date->i18nFormat('YYY-MM-dd') : '';
            }

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);

//            debug($post);
//            exit;
            if ($post['cons_civil_work_required'] == 'Yes') {
                //required, now need to check if completed,on_track or off_track or critically_delayed 

                $step7_cons_array = array();

                if ($post['is_work_carried_by_civil_works'] == 'Yes') {
                    if ($post['is_work_begun'] == 'Yes' && $post['level_of_work_compl'] == '100') {
                        array_push($step7_cons_array, 2);
                    } else {
                        //check date thing

                        if ($post['cons_civil_compl_date'] >= date('Y-m-d')) {
                            array_push($step7_cons_array, 3);
                        } else {
                            $now = time(); // or your date as well
                            $your_date = strtotime($post['cons_civil_compl_date']);
                            $datediff = $now - $your_date;

                            $diff = round($datediff / (60 * 60 * 24));
                            if ($diff > 15) { //danger zone
                                array_push($step7_cons_array, 5);
                                $departmentScheme->overall_status = '5';
                            } else { //off_track zone
                                array_push($step7_cons_array, 4);
                            }
                        }
                    }
                }
//                debug($post);
//                exit;
                if ($post['is_work_commisioned_privately'] == 'Yes') {
                    if ($post['cons_civil_private_type'] == 'single_source') {
                        if ($post['is_work_begun'] == 'Yes' && $post['level_of_work_compl'] == '100') {
                            array_push($step7_cons_array, 2);
                        } else {
                            //check date thing
                            if ($post['cons_civil_compl_date'] >= date('Y-m-d')) {
                                array_push($step7_cons_array, 3);
                            } else {
                                $now = time(); // or your date as well
                                $your_date = strtotime($post['cons_civil_compl_date']);
                                $datediff = $now - $your_date;

                                $diff = round($datediff / (60 * 60 * 24));
                                if ($diff > 15) { //danger zone
                                    array_push($step7_cons_array, 5);
                                    $departmentScheme->overall_status = '5';
                                } else { //off_track zone
                                    array_push($step7_cons_array, 4);
                                }
                            }
                        }
                    } else {
                        if ($post['is_work_begun'] == 'Yes' && $post['level_of_work_compl'] == '100' && $post['is_work_tender_advertised'] == 'Yes' &&
                                $post['is_work_bidding_compl'] == 'Yes' && $post['is_work_order_issued'] == 'Yes') {
                            array_push($step7_cons_array, 2);
                        } else {
                            if ($post['cons_civil_compl_date'] >= date('Y-m-d')) {
                                array_push($step7_cons_array, 3);
                            } else {
                                //check date thing
                                $now = time(); // or your date as well
                                $your_date = strtotime($post['cons_civil_compl_date']);
                                $datediff = $now - $your_date;

                                $diff = round($datediff / (60 * 60 * 24));
                                if ($diff > 15) { //danger zone
                                    array_push($step7_cons_array, 5);
                                    $departmentScheme->overall_status = '5';
                                } else { //off_track zone
                                    array_push($step7_cons_array, 4);
                                }
                            }
                        }
                    }
                }

//                        debug($post);
//                        exit;
//                        debug($step3_hiring_array);exit;
                //count max of it and that will be the status
                $departmentScheme->step7_status = (int) max($step7_cons_array);
            } else if ($post['cons_civil_work_required'] == 'No') {
                //not required so kind of completed
                $departmentScheme->step7_status = '2';
            } else {
                //if null or empty as from the first time
                $departmentScheme->step7_status = '1';
            }
//status thing ends here
//            debug($departmentScheme->step7_status);
//            exit;
            if ($departmentScheme->step7_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step7_status;
                $post['steps_array'][7] = $departmentScheme->step7_status;
//                 && array_sum($post['steps_array']) > 10
//                debug(count(array_filter($post['steps_array'])));
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
//                debug($departmentScheme->overall_status);exit;
            }
//debug($departmentScheme->overall_status);exit;
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('Construction requirement has been saved.'));

                return $this->redirect(['action' => 'custom', $id]);
            }
//            debug($departmentScheme);exit;
            $this->Flash->error(__('Construction requirement could not be saved. Please, try again.'));
        }

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $get_Request = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $departmentScheme->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step7'
            ]])->first();

        $this->set(compact('departmentScheme', 'departments', 'get_Request'));
    }

    public function finish($id = null) {
        $cond = array();
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'sub-admin') {
            $cond = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'conditions' => $cond,
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $mValidated = true;

            //password
            $mPostData = $this->request->getData();

            unset($mPostData['scheme_file']);

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $mPostData);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();


            $evidence = $this->request->getData()['scheme_file'];
//            debug($mPostData);
//            exit;
            if ($evidence->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $evidence->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $new_name;
                    $evidence->moveTo($path);
                    $departmentScheme->scheme_file = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {

                unset($departmentScheme->scheme_file);
            }
//            debug($departmentScheme);
//            exit;
            if ($mValidated == true) {
                if (max($mPostData['steps_array']) && count(array_filter($mPostData['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($mPostData['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
                if ($this->DepartmentSchemes->save($departmentScheme)) {
                    $this->Flash->success(__('This scheme details has been saved.'));

                    return $this->redirect(['action' => 'view', $id]);
                }
            }
            $this->Flash->error(__('This scheme details could not be saved. Please, try again.'));
        }

        $this->set(compact('departmentScheme'));
    }

    public function finish_evidence($id = null) {
        $departmentScheme = $this->DepartmentSchemes->get($id);
        unlink(WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $departmentScheme->scheme_file);

        $departmentScheme->scheme_file = '';
        if ($this->DepartmentSchemes->save($departmentScheme)) {
            $this->Flash->success(__('Document file has been removed.'));

            return $this->redirect(['action' => 'finish', $id]);
        }
    }

    /**
     * Edit method
     *
     * @param string|null $id Department Scheme id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null) {
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $this->request->getData());
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                $this->Flash->success(__('The department scheme has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The department scheme could not be saved. Please, try again.'));
        }
        $departments = $this->DepartmentSchemes->Departments->find('list', ['limit' => 200]);
        $schemeStatuses = $this->DepartmentSchemes->SchemeStatuses->find('list', ['limit' => 200]);
        $this->set(compact('departmentScheme', 'departments', 'schemeStatuses'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Department Scheme id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
//        $this->request->allowMethod(['post', 'delete']);
//        $departmentScheme = $this->DepartmentSchemes->get($id);
//        if ($this->DepartmentSchemes->delete($departmentScheme)) {
//            $this->Flash->success(__('The department scheme has been deleted.'));
//        } else {
//            $this->Flash->error(__('The department scheme could not be deleted. Please, try again.'));
//        }

        return $this->redirect(['action' => 'index']);
    }

    public function import_activities($id = null) {
        //$file = 'C:\Users\Bilal\Desktop\import.csv';
        //echo '<pre>';print_r($_FILES);exit;
        $filename = $_FILES["file"]["tmp_name"];
        //echo '<pre>';print_r($filename);exit;  
        if ($_FILES["file"]["size"] > 0) {
            $row = 1;
            $activity_ids = [];
            if (($handle = fopen($filename, "r")) !== FALSE) {
                while (($data = fgetcsv($handle, 1000000, ",")) !== FALSE) {
                    //echo '<pre>';print_r($data);exit;  
                    $num = count($data);
                    $row++;
                    if ($row > 2) {
                        //for ($c = 0; $c < $num; $c++) {
                        //echo $data[$c] . "<br />\n\n";
                        //}

                        $activity = $data[0];
                        $district_type = $data[1];
                        $type = $district_id = '';
                        $type = $district_type;
                        if (strtolower($activity) == 'procurement of goods' || strtolower($activity) == 'procurement of services') {
                            //$type = $district_type;//apply for activities 
                        } else if (strtolower($activity) == 'civil works') {

                            $Districts = $this->getTableLocator()->get('Districts');
                            $Districts = $Districts->find('all', ['conditions' => ['name' => $district_type]])->all();
                            $Districts = json_decode(json_encode($Districts));
                            //echo '<pre>';print_r($Districts);exit;  
                            $district_id = count($Districts) > 0 ? $Districts[0]->id : 0;
                            $type = '';
                            if ($district_id == 0) {

                                $this->loadModel('Districts');
                                $District = $this->Districts->newEmptyEntity();
                                $District->name = $district_type;
                                $District->created = date('Y-m-d');
                                $District->modified = date('Y-m-d');
                                $this->Districts->save($District);
                                $district_id = $District->id;
                            }
                        }

                        $sub_activity_title = $data[2];
                        $start_date = $data[3];
                        $end_date = $data[4];
                        $responsibility = $data[5];
                        $mean_of_verification = ''; //$data[6];
                        $remarks = isset($data[6]) ? $data[6] : '';

                        //$departments = $this->getTableLocator()->get('Departments');
                        //$departments = $departments->find('all', ['conditions' => ['department_name' => $responsibility]])->all();
                        //$departments = json_decode(json_encode($departments));
                        //echo '<pre>';print_r($departments);exit;	
                        if (strtolower(trim($data[1])) == 'approval of pc111') {
                            $this->DepartmentSchemes->updateAll(['pc1_required' => 'Yes', 'pc1_approved' => 'Yes', 'custom_milestone_required' => 'Yes'], ['id in' => [$id]]);

                            //add sub activity
                            $sub_activity = $this->getTableLocator()->get('SubActivity');
                            $query = $sub_activity->query();
                            $query->insert(['department_scheme_id', 'activity', 'title', 'start_date', 'end_date', 'responsibility', 'remarks', 'created', 'modified', 'status'])
                                    ->values([
                                        'department_scheme_id' => $id,
                                        'activity' => 'pc1_approved',
                                        'title' => $data[2],
                                        'responsibility' => $data[6],
                                        'start_date' => date('Y-m-d', strtotime($data[3])),
                                        'end_date' => date('Y-m-d', strtotime($data[4])),
                                        'remarks' => '',
                                        'status' => 1,
                                        'created' => date('Y-m-d'),
                                        'modified' => date('Y-m-d'),
                                    ])
                                    ->execute();
                        } else {
                            //add sub activity
                            if (!in_array(strtolower($activity), array('procurement of goods', 'procurement of services', 'civil works')) && $district_type != '') {
                                //$activity = $activity.' - '.$district_type;
                            }
                            $identifier = strtolower(str_replace(' ', '-', ($id . '-' . $activity . '-' . $district_id . '-' . $type)));

                            $custom_milestone = $this->getTableLocator()->get('CustomMilestones');
                            /* if(strtolower($activity) == 'procurement of goods' || strtolower($activity) == 'procurement of services'){
                              $custom_milestone_exists = $custom_milestone->find('all', ['conditions' => ['CustomMilestones.department_scheme_id' => $id, 'CustomMilestones.milestone_name' => $activity, 'CustomMilestones.type' => $type]])->all();
                              }else if(strtolower($activity) == 'civil works'){
                              $custom_milestone_exists = $custom_milestone->find('all', ['conditions' => ['CustomMilestones.department_scheme_id' => $id, 'CustomMilestones.milestone_name' => $activity, 'CustomMilestones.district_id' => $district_id]])->all();
                              }else{
                              $custom_milestone_exists = $custom_milestone->find('all', ['conditions' => ['CustomMilestones.department_scheme_id' => $id, 'CustomMilestones.milestone_name' => $activity]])->all();
                              } */
                            $custom_milestone_exists = $custom_milestone->find('all', ['conditions' => ['CustomMilestones.department_scheme_id' => $id, 'CustomMilestones.identifier' => $identifier]])->all();
                            //echo '<pre>';print_r(json_decode(json_encode($custom_milestone_exists)));exit;
                            $custom_milestone_exists = json_decode(json_encode($custom_milestone_exists));
                            if (count($custom_milestone_exists) == 0) {
                                $query = $custom_milestone->query();
                                //$aa = [];
                                //echo '<pre>';print_r($aa);exit;	-

                                $query->insert(['department_scheme_id', 'milestone_name', 'way_forward', 'is_completed', 'completion_date', 'responsibility', 'milestone_status', 'created', 'modified', 'district_id', 'type', 'identifier'])
                                        ->values([
                                            'department_scheme_id' => $id,
                                            'milestone_name' => $activity,
                                            'way_forward' => $activity,
                                            'district_id' => $district_id,
                                            'type' => $type,
                                            'responsibility' => $responsibility,
                                            'identifier' => $identifier,
                                            'is_completed' => 'No',
                                            'completion_date' => '',
                                            'milestone_status' => 3,
                                            'created' => date('Y-m-d'),
                                            'modified' => date('Y-m-d'),
                                        ])
                                        ->execute();

                                $custom_milestone_exists = $custom_milestone->find('all', ['conditions' => ['CustomMilestones.department_scheme_id' => $id, 'CustomMilestones.identifier' => $identifier]])->all();
                                $custom_milestone_exists = json_decode(json_encode($custom_milestone_exists));
                            }

                            $custom_milestone_id = $custom_milestone_exists[0]->id;
                            $activity_ids[] = $custom_milestone_id;
                            //add sub activity
                            $sub_activity = $this->getTableLocator()->get('SubActivity');
                            $query = $sub_activity->query();
                            $query->insert(['department_scheme_id', 'activity', 'title', 'start_date', 'end_date', 'responsibility', 'remarks', 'created', 'modified', 'status', 'mean_of_verification'])
                                    ->values([
                                        'department_scheme_id' => $id,
                                        'activity' => $custom_milestone_id,
                                        'title' => $sub_activity_title,
                                        'responsibility' => $responsibility,
                                        'start_date' => date('Y-m-d', strtotime($start_date)),
                                        'end_date' => date('Y-m-d', strtotime($end_date)),
                                        'remarks' => $remarks,
                                        'mean_of_verification' => $mean_of_verification,
                                        'status' => 1, //(strtotime($end_date) > strtotime(date('Y-m-d'))) ? '1' : '2',
                                        'created' => date('Y-m-d'),
                                        'modified' => date('Y-m-d'),
                                    ])
                                    ->execute();
                        }
                    }
                }
            }

            $connection = ConnectionManager::get('default');
            if (!empty($activity_ids)) {
                foreach ($activity_ids as $activity_id) {
                    $SubActivities = $this->getTableLocator()->get('SubActivity');
                    $SubActivities = $SubActivities->find('all', ['conditions' => ['activity' => $activity_id]])->all();
                    $SubActivities = json_decode(json_encode($SubActivities));
                    if (count($SubActivities) > 0) {
                        $completion_date = '2000-01-01';
                        $activity_start_date = '2050-01-01';

                        foreach ($SubActivities as $sub_activity) {
                            if (strtotime($sub_activity->end_date) > strtotime($completion_date)) {
                                $completion_date = $sub_activity->end_date;
                            }

                            if (strtotime($sub_activity->start_date) < strtotime($activity_start_date)) {
                                $activity_start_date = $sub_activity->start_date;
                            }
                        }
                        $this->loadModel('CustomMilestones');
                        //$this->CustomMilestones->updateAll(['completion_date' => $completion_date, 'start_date' => $activity_start_date], ['id in' => [$activity_id]]);			
                        $sub_activities = $connection->execute('SELECT MAX(end_date) as end_date FROM `sub_activities` WHERE activity = ' . $activity_id)->fetchAll('assoc');
                        if (!empty($sub_activities)) {
                            $this->CustomMilestones->updateAll(['completion_date' => $sub_activities[0]['end_date']], ['id in' => [$activity_id]]);
                        }

                        $sub_activities = $connection->execute('SELECT MIN(start_date) as start_date FROM `sub_activities` WHERE activity = ' . $activity_id)->fetchAll('assoc');
                        if (!empty($sub_activities)) {
                            $this->CustomMilestones->updateAll(['start_date' => $sub_activities[0]['start_date']], ['id in' => [$activity_id]]);
                        }
                    }
                }
            }
        }

        $custom_milestones = $connection->execute('SELECT MAX(completion_date) as completion_date FROM `custom_milestones` WHERE department_scheme_id = ' . $id)->fetchAll('assoc');
        if (!empty($custom_milestones)) {
            $this->DepartmentSchemes->updateAll(['scheme_end_date' => $custom_milestones[0]['completion_date']], ['id in' => [$id]]);
        }

        $custom_milestones = $connection->execute('SELECT MIN(start_date) as start_date FROM `custom_milestones` WHERE department_scheme_id = ' . $id)->fetchAll('assoc');
        if (!empty($custom_milestones)) {
            $this->DepartmentSchemes->updateAll(['scheme_start_date' => $custom_milestones[0]['start_date']], ['id in' => [$id]]);
        }

        $this->redirect($this->referer());
    }

    function update_activate_dates($activity_id) {
        $connection = ConnectionManager::get('default');
        $sub_activities = $connection->execute('SELECT MAX(end_date) as end_date FROM `sub_activities` WHERE activity = ' . $activity_id)->fetchAll('assoc');
        if (!empty($sub_activities)) {
            $this->CustomMilestones->updateAll(['completion_date' => $sub_activities[0]['end_date']], ['id in' => [$activity_id]]);
        }

        $custom_milestones = $connection->execute('SELECT MAX(start_date) as start_date FROM `sub_activities` WHERE activity = ' . $activity_id)->fetchAll('assoc');
        if (!empty($custom_milestones)) {
            $this->CustomMilestones->updateAll(['start_date' => $sub_activities[0]['start_date']], ['id in' => [$activity_id]]);
        }
        //echo '<pre>';print_r($custom_milestones);exit;
    }

    function update_schemes_dates($department_scheme_id) {
        $connection = ConnectionManager::get('default');
        $custom_milestones = $connection->execute('SELECT MAX(completion_date) as completion_date FROM `custom_milestones` WHERE department_scheme_id = ' . $department_scheme_id)->fetchAll('assoc');
        if (!empty($custom_milestones)) {
            $this->DepartmentSchemes->updateAll(['scheme_end_date' => $custom_milestones[0]['completion_date']], ['id in' => [$department_scheme_id]]);
        }

        $custom_milestones = $connection->execute('SELECT MIN(start_date) as start_date FROM `custom_milestones` WHERE department_scheme_id = ' . $department_scheme_id)->fetchAll('assoc');
        if (!empty($custom_milestones)) {
            $this->DepartmentSchemes->updateAll(['scheme_start_date' => $custom_milestones[0]['start_date']], ['id in' => [$department_scheme_id]]);
        }
        //echo '<pre>';print_r($custom_milestones);exit;
    }

    function send_sms_unreplied_comments() {
        $connection = ConnectionManager::get('default');
        $yesterday = date('Y-m-d', strtotime("-2 days"));
        $comments = $connection->execute('SELECT id FROM `comments` WHERE parent_id = 0 AND DATE_FORMAT(created,"%Y-%m-%d") = "' . $yesterday . '"')->fetchAll('assoc');
        echo '<pre>';
        print_r($comments);
        exit;
        if (!empty($comments)) {
            
        }
        //echo '<pre>';print_r($custom_milestones);exit;
    }

}
