<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * RecordNoteDetails Controller
 *
 * @property \App\Model\Table\RecordNoteDetailsTable $RecordNoteDetails
 * @method \App\Model\Entity\RecordNoteDetail[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class RecordNoteDetailsController extends AppController
{

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void
    {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        //$this->Auth->allow(['index']);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['RecordNotes'],
        ];
        $recordNoteDetails = $this->paginate($this->RecordNoteDetails);

        $this->set(compact('recordNoteDetails'));
    }

    /**
     * View method
     *
     * @param string|null $id Record Note Detail id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $recordNoteDetail = $this->RecordNoteDetails->get($id, [
            'contain' => ['RecordNotes'],
        ]);

        $this->set(compact('recordNoteDetail'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $recordNoteDetail = $this->RecordNoteDetails->newEmptyEntity();
        if ($this->request->is('post')) {
            $recordNoteDetail = $this->RecordNoteDetails->patchEntity($recordNoteDetail, $this->request->getData());
            if ($this->RecordNoteDetails->save($recordNoteDetail)) {
                $this->Flash->success(__('The record note detail has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The record note detail could not be saved. Please, try again.'));
        }
        $recordNotes = $this->RecordNoteDetails->RecordNotes->find('list', ['limit' => 200]);
        $this->set(compact('recordNoteDetail', 'recordNotes'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Record Note Detail id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $recordNoteDetail = $this->RecordNoteDetails->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $recordNoteDetail = $this->RecordNoteDetails->patchEntity($recordNoteDetail, $this->request->getData());
            if ($this->RecordNoteDetails->save($recordNoteDetail)) {
                $this->Flash->success(__('The record note detail has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The record note detail could not be saved. Please, try again.'));
        }
        $recordNotes = $this->RecordNoteDetails->RecordNotes->find('list', ['limit' => 200]);
        $this->set(compact('recordNoteDetail', 'recordNotes'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Record Note Detail id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $recordNoteDetail = $this->RecordNoteDetails->get($id);
        if ($this->RecordNoteDetails->delete($recordNoteDetail)) {
            $this->Flash->success(__('The record note detail has been deleted.'));
        } else {
            $this->Flash->error(__('The record note detail could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
