<?php
declare(strict_types=1);

namespace App\Model\Entity;
use Authentication\PasswordHasher\DefaultPasswordHasher; // Add this line

use Cake\ORM\Entity;

/**
 * User Entity
 *
 * @property int $id
 * @property string|null $fname
 * @property string|null $lname
 * @property string|null $email
 * @property string $password
 * @property int $locked
 * @property int|null $active
 * @property string $users_roles_id
 * @property string|null $avatar
 * @property string|null $tel1
 * @property string|null $tel2
 * @property string|null $fax
 * @property string|null $addr1
 * @property string|null $addr2
 * @property string|null $city
 * @property string|null $state
 * @property string|null $postal
 * @property string|null $country
 * @property string|null $comments
 * @property int|null $login_failures
 * @property \Cake\I18n\FrozenTime|null $last_login_failure
 * @property \Cake\I18n\FrozenTime|null $last_login_success
 * @property int $created_by
 * @property \Cake\I18n\FrozenTime $created
 * @property int $modified_by
 * @property \Cake\I18n\FrozenTime $modified
 * @property int|null $deleted
 *
 * @property \App\Model\Entity\UsersRole $users_role
 */
class User extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
    ];

    /**
     * Fields that are excluded from JSON versions of the entity.
     *
     * @var array
     */
    protected $_hidden = [
        'password',
    ];
    
    // Add this method
    protected function _setPassword(string $password) : ?string
    {
        if (strlen($password) > 0) {
            return (new DefaultPasswordHasher())->hash($password);
        }
    }
    
    
    
    protected function _getFullName()
    {
        return $this->fname . '  ' . $this->lname;
    }
}
