<?php

declare(strict_types = 1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * DepartmentSchemes Model
 *
 * @property \App\Model\Table\DepartmentsTable&\Cake\ORM\Association\BelongsTo $Departments
 * @property \App\Model\Table\SchemeDistrictsTable&\Cake\ORM\Association\HasMany $SchemeDistricts
 *
 * @method \App\Model\Entity\DepartmentScheme newEmptyEntity()
 * @method \App\Model\Entity\DepartmentScheme newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\DepartmentScheme[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\DepartmentScheme get($primaryKey, $options = [])
 * @method \App\Model\Entity\DepartmentScheme findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\DepartmentScheme patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\DepartmentScheme[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\DepartmentScheme|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\DepartmentScheme saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\DepartmentScheme[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\DepartmentScheme[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\DepartmentScheme[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\DepartmentScheme[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class DepartmentSchemesTable extends Table {

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void {
        parent::initialize($config);

        $this->setTable('department_schemes');
        $this->setDisplayField('scheme_name');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Departments', [
            'foreignKey' => 'department_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Users', [
            'foreignKey' => 'user_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('AttachedFormations', [
            'foreignKey' => 'attached_formation_id',
            'joinType' => 'LEFT',
        ]);
        $this->hasMany('Comments', [
            'foreignKey' => 'department_scheme_id',
            'joinType' => 'LEFT',
        ]);
        $this->hasMany('CustomMilestones', [
            'foreignKey' => 'department_scheme_id',
            'joinType' => 'LEFT',
        ]);
        $this->hasMany('SchemeDistricts', [
            'foreignKey' => 'department_scheme_id',
        ]);
        $this->hasMany('SchemesLogs', [
            'foreignKey' => 'department_scheme_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator {
        $validator
                ->integer('id')
                ->allowEmptyString('id', null, 'create');

        $validator
                ->integer('year')
                ->notEmptyString('year');

        $validator
                ->integer('overall_status')
                ->notEmptyString('overall_status');

        $validator
                ->integer('step1_status')
                ->allowEmptyString('step1_status');

        $validator
                ->integer('step2_status')
                ->allowEmptyString('step2_status');

        $validator
                ->integer('step3_status')
                ->allowEmptyString('step3_status');

        $validator
                ->integer('step4_status')
                ->allowEmptyString('step4_status');

        $validator
                ->integer('step5_status')
                ->allowEmptyString('step5_status');

        $validator
                ->integer('step6_status')
                ->allowEmptyString('step6_status');

        $validator
                ->integer('step7_status')
                ->allowEmptyString('step7_status');

        $validator
                ->scalar('scheme_name')
//                ->maxLength('scheme_name', 255)
                ->requirePresence('scheme_code', 'create')
                ->notEmptyString('scheme_code');

//        $validator
//                ->scalar('scheme_name')
//                ->maxLength('scheme_name', 255)
//                ->requirePresence('scheme_name', 'create')
//                ->notEmptyString('scheme_name');

        $validator
                ->scalar('scheme_type')
                ->requirePresence('scheme_type', 'create')
                ->notEmptyString('scheme_type');

        $validator
                ->scalar('scheme_detail')
                ->allowEmptyString('scheme_detail');

        $validator
                ->scalar('active')
                ->requirePresence('active', 'create')
                ->notEmptyString('active');

        $validator
                ->scalar('directive')
                ->allowEmptyString('directive');
        
         $validator
                ->scalar('foreign_funded')
                ->allowEmptyString('foreign_funded');

        $validator
                ->decimal('cost_of_scheme')
                ->allowEmptyString('cost_of_scheme');

        $validator
                ->decimal('expenditure_till_date')
                ->allowEmptyString('expenditure_till_date');

        $validator
                ->decimal('allocation_for_cfy')
                ->allowEmptyString('allocation_for_cfy');

        $validator
                ->decimal('release_for_cfy')
                ->allowEmptyString('release_for_cfy');

        $validator
                ->scalar('geo_coverage')
                ->allowEmptyString('geo_coverage');

        $validator
                ->date('scheme_start_date')
                ->requirePresence('scheme_start_date', 'create')
                ->notEmptyDate('scheme_start_date');

        $validator
                ->date('scheme_end_date')
                ->requirePresence('scheme_end_date', 'create')
                ->notEmptyDate('scheme_end_date');

        $validator
                ->scalar('pc2_required')
                ->allowEmptyString('pc2_required');

        $validator
                ->scalar('pc2_approved')
                ->allowEmptyString('pc2_approved');

        $validator
                ->scalar('consultant_hired')
                ->allowEmptyString('consultant_hired');

        $validator
                ->scalar('cons_subt_report')
                ->allowEmptyString('cons_subt_report');

//        $validator
//            ->date('pc2_compl_date')
//            ->requirePresence('pc2_compl_date', 'create')
//            ->notEmptyDate('pc2_compl_date');
//        $validator
//            ->scalar('responsible_pc2_compl')
//            ->maxLength('responsible_pc2_compl', 90)
//            ->requirePresence('responsible_pc2_compl', 'create')
//            ->notEmptyString('responsible_pc2_compl');

        $validator
                ->scalar('pc1_approved')
                ->allowEmptyString('pc1_approved');

        $validator
                ->date('pc1_approval_date')
                ->allowEmptyDate('pc1_approval_date');

        $validator
                ->scalar('pc1_stage')
                ->allowEmptyString('pc1_stage');

        $validator
                ->date('pc1_compl_date')
                ->allowEmptyDate('pc1_compl_date');

        $validator
                ->scalar('pc1_responsible')
                ->maxLength('pc1_responsible', 90)
                ->allowEmptyString('pc1_responsible');

        $validator
                ->scalar('hiring_required')
                ->allowEmptyString('hiring_required');

        $validator
                ->scalar('sne_approved')
                ->allowEmptyString('sne_approved');

        $validator
                ->date('sne_approval_date')
                ->allowEmptyDate('sne_approval_date');

        $validator
                ->scalar('will_hiring_through_psc')
                ->allowEmptyString('will_hiring_through_psc');

        $validator
                ->scalar('hiring_through_psc')
                ->allowEmptyString('hiring_through_psc');

        $validator
                ->date('hiring_compl_date_psc')
                ->allowEmptyDate('hiring_compl_date_psc');

//        $validator
//            ->scalar('responsible_psc')
//            ->maxLength('responsible_psc', 90)
//            ->requirePresence('responsible_psc', 'create')
//            ->notEmptyString('responsible_psc');

        $validator
                ->scalar('will_hiring_through_internal_posting')
                ->allowEmptyString('will_hiring_through_internal_posting');

        $validator
                ->scalar('hiring_through_internal_posting')
                ->allowEmptyString('hiring_through_internal_posting');

        $validator
                ->date('hiring_compl_date_internal_posting')
                ->allowEmptyDate('hiring_compl_date_internal_posting');

//        $validator
//            ->scalar('responsible_internal_posting')
//            ->maxLength('responsible_internal_posting', 90)
//            ->requirePresence('responsible_internal_posting', 'create')
//            ->notEmptyString('responsible_internal_posting');

        $validator
                ->scalar('will_hiring_through_market')
                ->allowEmptyString('will_hiring_through_market');

        $validator
                ->scalar('hiring_through_market')
                ->allowEmptyString('hiring_through_market');

        $validator
                ->scalar('posting_though_market_media')
                ->allowEmptyString('posting_though_market_media');

        $validator
                ->scalar('hiring_market_entries_recorded')
                ->allowEmptyString('hiring_market_entries_recorded');

        $validator
                ->scalar('hiring_market_scrutiny_compl')
                ->allowEmptyString('hiring_market_scrutiny_compl');

        $validator
                ->scalar('hiring_market_intervies_cond')
                ->allowEmptyString('hiring_market_intervies_cond');

        $validator
                ->scalar('hiring_market_appoint_letter_issues')
                ->allowEmptyString('hiring_market_appoint_letter_issues');

        $validator
                ->date('hiring_market_compl_date')
                ->allowEmptyDate('hiring_market_compl_date');

//        $validator
//            ->scalar('hiring_market_respons_person')
//            ->maxLength('hiring_market_respons_person', 90)
//            ->requirePresence('hiring_market_respons_person', 'create')
//            ->notEmptyString('hiring_market_respons_person');

        $validator
                ->scalar('land_acquisition_required')
                ->allowEmptyString('land_acquisition_required');

        $validator
                ->scalar('land_identified')
                ->allowEmptyString('land_identified');

        $validator
                ->scalar('land_section4_compl')
                ->allowEmptyString('land_section4_compl');

        $validator
                ->scalar('land_section6_comp')
                ->allowEmptyString('land_section6_comp');

        $validator
                ->scalar('land_possision_taken_over')
                ->allowEmptyString('land_possision_taken_over');

        $validator
                ->scalar('land_award_been_issued')
                ->allowEmptyString('land_award_been_issued');

        $validator
                ->scalar('land_payment_made')
                ->allowEmptyString('land_payment_made');

//        $validator
//            ->date('land_acquisition_compl_date')
//            ->requirePresence('land_acquisition_compl_date', 'create')
//            ->notEmptyDate('land_acquisition_compl_date');
//        $validator
//            ->scalar('land_acquisition_responsible')
//            ->maxLength('land_acquisition_responsible', 90)
//            ->requirePresence('land_acquisition_responsible', 'create')
//            ->notEmptyString('land_acquisition_responsible');

        $validator
                ->scalar('proc_goods_required')
                ->allowEmptyString('proc_goods_required');

        $validator
                ->scalar('proc_goods_tender_advertised')
                ->allowEmptyString('proc_goods_tender_advertised');

        $validator
                ->scalar('proc_goods_bidding_complete')
                ->allowEmptyString('proc_goods_bidding_complete');

        $validator
                ->scalar('proc_goods_po_issued')
                ->allowEmptyString('proc_goods_po_issued');

        $validator
                ->scalar('proc_goods_delivery_physical_verification_done')
                ->allowEmptyString('proc_goods_delivery_physical_verification_done');

        $validator
                ->scalar('proc_goods_distribution_equipments')
                ->allowEmptyString('proc_goods_distribution_equipments');

        $validator
                ->scalar('proc_goods_evidence_of_distribution')
                ->maxLength('proc_goods_evidence_of_distribution', 90)
                ->allowEmptyString('proc_goods_evidence_of_distribution');

//        $validator
//            ->date('proc_goods_compl_date')
//            ->requirePresence('proc_goods_compl_date', 'create')
//            ->notEmptyDate('proc_goods_compl_date');
//        $validator
//            ->scalar('proc_goods_responsible')
//            ->maxLength('proc_goods_responsible', 90)
//            ->requirePresence('proc_goods_responsible', 'create')
//            ->notEmptyString('proc_goods_responsible');

        $validator
                ->scalar('proc_services_required')
                ->allowEmptyString('proc_services_required');

        $validator
                ->scalar('proc_services_tender_advertised')
                ->allowEmptyString('proc_services_tender_advertised');

        $validator
                ->scalar('proc_services_tech_finance_proposal_received')
                ->allowEmptyString('proc_services_tech_finance_proposal_received');

        $validator
                ->scalar('proc_services_evaluation_process_compl')
                ->allowEmptyString('proc_services_evaluation_process_compl');

        $validator
                ->scalar('proc_services_contract_awarded')
                ->allowEmptyString('proc_services_contract_awarded');

//        $validator
//            ->scalar('proc_services_status')
//            ->requirePresence('proc_services_status', 'create')
//            ->notEmptyString('proc_services_status');

        $validator
                ->date('proc_services_compl_date')
                ->allowEmptyDate('proc_services_compl_date');

//        $validator
//            ->scalar('proc_services_responsible')
//            ->maxLength('proc_services_responsible', 90)
//            ->requirePresence('proc_services_responsible', 'create')
//            ->notEmptyString('proc_services_responsible');

        $validator
                ->scalar('cons_civil_work_required')
                ->allowEmptyString('cons_civil_work_required');

        $validator
                ->scalar('is_work_carried_by_civil_works')
                ->allowEmptyString('is_work_carried_by_civil_works');

        $validator
                ->scalar('is_work_commisioned_privately')
                ->allowEmptyString('is_work_commisioned_privately');

        $validator
                ->scalar('cons_civil_private_type')
                ->allowEmptyString('cons_civil_private_type');

        $validator
                ->scalar('is_work_tender_advertised')
                ->allowEmptyString('is_work_tender_advertised');

        $validator
                ->scalar('is_work_bidding_compl')
                ->allowEmptyString('is_work_bidding_compl');

        $validator
                ->scalar('is_work_order_issued')
                ->allowEmptyString('is_work_order_issued');

        $validator
                ->scalar('is_work_begun')
                ->allowEmptyString('is_work_begun');

//        $validator
//            ->scalar('level_of_work_compl')
//            ->notEmptyString('level_of_work_compl');
//        $validator
//            ->date('cons_civil_compl_date')
//            ->requirePresence('cons_civil_compl_date', 'create')
//            ->notEmptyDate('cons_civil_compl_date');

        $validator
                ->scalar('cons_civil_responsible')
                ->maxLength('cons_civil_responsible', 90)
                ->allowEmptyString('cons_civil_responsible');

        $validator
                ->scalar('final_comments')
                ->maxLength('final_comments', 255)
                ->allowEmptyString('final_comments');

        $validator
                ->scalar('scheme_file')
                ->maxLength('scheme_file', 90)
                ->allowEmptyFile('scheme_file');

        $validator
                ->scalar('designation_step1')
                ->maxLength('designation_step1', 90)
                ->allowEmptyString('designation_step1');

        $validator
                ->scalar('designation_step2')
                ->maxLength('designation_step2', 90)
                ->allowEmptyString('designation_step2');

        $validator
                ->scalar('designation_step3_psc')
                ->maxLength('designation_step3_psc', 90)
                ->allowEmptyString('designation_step3_psc');

        $validator
                ->scalar('designation_step3_ip')
                ->maxLength('designation_step3_ip', 90)
                ->allowEmptyString('designation_step3_ip');

        $validator
                ->scalar('designation_step3_market')
                ->maxLength('designation_step3_market', 90)
                ->allowEmptyString('designation_step3_market');

        $validator
                ->scalar('designation_step4')
                ->maxLength('designation_step4', 90)
                ->allowEmptyString('designation_step4');

        $validator
                ->scalar('designation_step5')
                ->maxLength('designation_step5', 90)
                ->allowEmptyString('designation_step5');

        $validator
                ->scalar('designation_step6')
                ->maxLength('designation_step6', 90)
                ->allowEmptyString('designation_step6');

        $validator
                ->scalar('designation_step7')
                ->maxLength('designation_step7', 90)
                ->allowEmptyString('designation_step7');

        $validator
                ->date('last_cron_job_date')
                ->allowEmptyDate('last_cron_job_date');

        $validator
                ->integer('created_by')
                ->requirePresence('created_by', 'create')
                ->notEmptyString('created_by');

        $validator
                ->integer('modified_by')
                ->requirePresence('modified_by', 'create')
                ->notEmptyString('modified_by');

        $validator
                ->boolean('deleted')
                ->notEmptyString('deleted');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker {
        $rules->add($rules->existsIn(['department_id'], 'Departments'), ['errorField' => 'department_id']);
        $rules->add($rules->existsIn(['user_id'], 'Users'), ['errorField' => 'user_id']);

        return $rules;
    }

}
