<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SchemeStatuses Model
 *
 * @property \App\Model\Table\DepartmentSchemesTable&\Cake\ORM\Association\HasMany $DepartmentSchemes
 *
 * @method \App\Model\Entity\SchemeStatus newEmptyEntity()
 * @method \App\Model\Entity\SchemeStatus newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\SchemeStatus[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\SchemeStatus get($primaryKey, $options = [])
 * @method \App\Model\Entity\SchemeStatus findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\SchemeStatus patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\SchemeStatus[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\SchemeStatus|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\SchemeStatus saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\SchemeStatus[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\SchemeStatus[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\SchemeStatus[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\SchemeStatus[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class SchemeStatusesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('scheme_statuses');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->hasMany('DepartmentSchemes', [
            'foreignKey' => 'scheme_status_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->scalar('status_name')
            ->maxLength('status_name', 90)
            ->requirePresence('status_name', 'create')
            ->notEmptyString('status_name');

//        $validator
//            ->scalar('status_color_pattern')
//            ->maxLength('status_color_pattern', 90)
//            ->requirePresence('status_color_pattern', 'create')
//            ->notEmptyString('status_color_pattern');
//
//        $validator
//            ->integer('created_by')
//            ->requirePresence('created_by', 'create')
//            ->notEmptyString('created_by');
//
//        $validator
//            ->integer('modified_by')
//            ->requirePresence('modified_by', 'create')
//            ->notEmptyString('modified_by');

        $validator
            ->boolean('deleted')
            ->notEmptyString('deleted');

        return $validator;
    }
}
