<?php
/**
* @var \App\View\AppView $this
* @var \App\Model\Entity\AssignChiefDepartment $assignChiefDepartment
*/
$this->assign('title', 'Viewing Assign Chief Department');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit Assign Chief Department'), ['action' => 'edit', $assignChiefDepartment->id], ['escape'=>false]) ?></li>
        <li><?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete Assign Chief Department'), ['action' => 'delete', $assignChiefDepartment->id], ['confirm' => __('Are you sure you want to delete # {0}?', $assignChiefDepartment->id), 'escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Assign Chief Departments'), ['action' => 'index'], ['escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Assign Chief Department'), ['action' => 'add'], ['escape'=>false]) ?></li>
                                                                                <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                    <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                                                                                </ul>
</nav>
<div class="row">
    <section class="card">

        
        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>

            <h2 class="card-title">Assign Chief Departments</h2>
        </header>

    <div class="assignChiefDepartments card-body content">

        <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                                                                                                <tr>
                            <th scope="row"><?= __('User') ?></th>
                            <td><?= $assignChiefDepartment->has('user') ? $this->Html->link($assignChiefDepartment->user->id, ['controller' => 'Users', 'action' => 'view', $assignChiefDepartment->user->id]) : '' ?></td>
                        </tr>
                                                                                                        <tr>
                            <th scope="row"><?= __('Department') ?></th>
                            <td><?= $assignChiefDepartment->has('department') ? $this->Html->link($assignChiefDepartment->department->department_name, ['controller' => 'Departments', 'action' => 'view', $assignChiefDepartment->department->id]) : '' ?></td>
                        </tr>
                                                                                                            <tr>
                        <th scope="row"><?= __('Id') ?></th>
                        <td><?= $this->Number->format($assignChiefDepartment->id) ?></td>
                    </tr>
                                                                            <tr>
                        <th scope="row"><?= __('Created') ?></th>
                        <td><?= h($assignChiefDepartment->created) ?></td>
                    </tr>
                                                </table>
                            </div><!--/content-->
    </section>
</div><!--/row-->
