<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme[]|\Cake\Collection\CollectionInterface $departmentSchemes
 */
$this->assign('title', 'Listing All Schemes');

//$array_of_7_q = array(5 => 'img-210107074838.jpg', 4 => 'img-210107074652.jpg', 3 => 'img-210107074816.jpg', 2 => 'img-210107073217.jpg', 1 => 'img-210107074900.jpg');
use Cake\ORM\TableRegistry;
?>

<!--<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['action' => 'add'], ['escape' => false]) ?></li>
    </ul>
</nav>-->

<div class="row">

    <div class="col-sm-12 col-md-12">
        <section class="card">

            <header class="card-header">
                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>
                <h3><?= __('All Departments Schemes') ?></h3>
            </header>

            <div class="departmentSchemes card-body content">
                <?php echo $this->Form->create(null, array('role' => 'form', 'class' => 'form-horizontal', 'type' => 'get')); ?>

                <div class="row">

                    <div class="col-sm-4">
                        <?= $this->Form->control('name', ['placeholder' => 'Search by Scheme name or code', 'label' => 'Scheme code or scheme name', 'class' => 'form-control', 'value' => isset($_GET['name']) ? $_GET['name'] : '']); ?>
                        <br/>
                    </div>
                    <div class="col-sm-2">
                        <?php
                        //debug($Departments);
                        echo $this->Form->control('status', ['label' => 'Choose Status', 'options' => [5 => 'Critically Delayed', 4 => 'Off Target', 3 => 'On Target', 2 => 'Completed', 1 => 'Not Started'], 'class' => 'form-control', 'empty' => 'Choose', 'value' => isset($_GET['status']) ? $_GET['status'] : '']);
                        ?>
                    </div>
                    <div class="col-sm-2">

                        <?= $this->Form->control('directive_search', ['class' => 'form-control', 'label' => 'Directive', 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['PM' => 'PM', 'CM' => 'CM', 'Cabinet' => 'Cabinet', 'CS' => 'CS', 'ACS' => 'ACS', 'Court' => 'Court'], 'value' => isset($_GET['directive_search']) ? $_GET['directive_search'] : '']) ?>

                    </div>
                    <div class="col-sm-2">

                        <?= $this->Form->control('mega_project_search', ['class' => 'form-control', 'label' => 'Scheme Category', 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Mega' => 'Mega Schemes', 'High Priority' => 'High Priority Schemes', 'DFC (Two Years)' => 'DFC (Two Years) Schemes', 'DFC (Current Year)' => 'DFC (Current Year) Schemes', 'Normal' => 'Normal Schemes', 'All' => 'All Schemes'], 'value' => isset($_GET['mega_project_search']) ? $_GET['mega_project_search'] : '']) ?>

                    </div>
                    <!--                    <div class="col-sm-2">
                    
                    <?= $this->Form->control('foreign_funded', ['class' => 'form-control', 'label' => 'Foreign Funded?', 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], 'value' => isset($_GET['foreign_funded']) ? $_GET['foreign_funded'] : '']) ?>
                    
                                        </div>-->
                    <div class="col-sm-2">

                        <?= $this->Form->control('scheme_type', ['class' => 'form-control', 'label' => 'Scheme Type', 'empty' => 'Choose', 'options' => $project_types, 'value' => isset($_GET['scheme_type']) ? $_GET['scheme_type'] : '']) ?>

                    </div>
                    <div class="col-sm-5">
                        <label for="district">Choose Department(s)</label><br/>
                        <?php
                        //debug($Departments);
                        echo $this->Form->control('department[]', ['options' => $departments, 'label' => false, 'multiple', 'data-plugin-multiselect', 'data-plugin-options' => '{ "maxHeight": 200, "includeSelectAllOption": true ,"enableCaseInsensitiveFiltering": true}', 'class' => 'form-control', 'value' => isset($_GET['department']) ? $_GET['department'] : '']);
                        ?>

                    </div>
                    <div class="col-sm-5">
                        <label for="district">Choose District(s)</label><br/>
                        <?php
                        //debug($Departments);
                        echo $this->Form->control('district[]', ['options' => $districts, 'label' => false, 'multiple', 'data-plugin-multiselect', 'data-plugin-options' => '{ "maxHeight": 200, "includeSelectAllOption": true ,"enableCaseInsensitiveFiltering": true}', 'class' => 'form-control', 'value' => isset($_GET['district']) ? $_GET['district'] : '']);
                        ?>

                    </div>


                    <div class="col-sm-2">
                        <br/>
                        <?= $this->Form->button(__('Search'), ['class' => 'btn btn-primary']) ?>

                    </div>

                </div>
                <?= $this->Form->end() ?>
                <hr/>
                <?php
                if ($departmentSchemes->toArray()) {
                    $status_array = ['5' => 'Critically Delayed', '4' => 'Off-Target', '3' => 'On-Target', '2' => 'Completed', '1' => 'Not Started'];
//                    debug();
                    ?>
                    <center><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/horizental_status.jpg" style="height:50px;"> '; ?></center>
                    <?php $this->Html->link(__('<i class="fas fa-list"></i> View all schemes without pagination'), ['action' => 'reportall'], ['escape' => false, 'style' => 'float:left;']) ?>
                    <?= $this->Html->link(__('<i class="fas fa-download"></i> Export all schemes to Excel'), ['action' => 'exportallcost'], ['id' => 'makeurl', 'escape' => false, 'style' => 'float:right;']) ?>
                    <?php $this->Html->link(__('<i class="fas fa-download"></i> Export all schemes to PDF'), ['action' => 'exportlist'], ['id' => 'makeurl1', 'escape' => false, 'style' => 'float:right;']) ?>


                    <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                        <thead>
                            <tr>



                                <th scope="col"><?= $this->Paginator->sort('scheme_status_id') ?></th>
                                <th scope="col"><?= $this->Paginator->sort('scheme_code') ?></th>

                                <th scope="col"><?= $this->Paginator->sort('scheme_name') ?></th>

                                <th scope="col"><?= $this->Paginator->sort('scheme_type') ?></th>
                                <th scope="col"><?= $this->Paginator->sort('department_id', 'Department') ?></th>
                                <th scope="col"><?= $this->Paginator->sort('cost_of_scheme') ?></th>
                                <th scope="col"><?= $this->Paginator->sort('expenditure_till_date', 'Previous Expenditure') ?></th>
                                <th scope="col"><?= $this->Paginator->sort('progressive_expenditure') ?></th>
                                <th scope="col"><?= $this->Paginator->sort('allocation_for_cfy') ?></th>
                                <th scope="col"><?= $this->Paginator->sort('release_for_cfy') ?></th>
                                <th scope="col"><?= __('Throw Forward') ?></th>
                                <th scope="col"><?= __('Utlization %') ?></th>

                                <th scope="col" class="actions"><?= __('Actions') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $SchemeDistricts = TableRegistry::get('SchemesLogs');

                            foreach ($departmentSchemes as $departmentScheme):
//                                debug($departmentScheme);exit;
//                                $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id], 'order' => ['SchemesLogs.id' => 'DESC']])->first();
//                                debug($choosen_nav_districts);
                                ?>
                                <tr>

                                    <td><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $departmentScheme->overall_status . '.PNG">'; ?> <?= $status_array[$departmentScheme->overall_status]; ?></td>
                                    <td class="text-right" data-title="Scheme Name"><?= $departmentScheme->scheme_code ?></td>
                                    <td class="text-left" data-title="Scheme Name"><?= ucfirst($departmentScheme->scheme_name) ?></td>
                                    <td class="text-left" data-title="Scheme Type"><?= ucfirst($departmentScheme->scheme_type) ?></td>
                                    <td class="text-left" data-title="Department"><?= $departments[$departmentScheme->department_id]; ?></td>
                                    <td class="text-left" data-title="Cost of Scheme"><?= number_format($departmentScheme->cost_of_scheme, 3); ?></td>
                                    <td class="text-left" data-title="expenditure_till_date"><?= number_format($departmentScheme->expenditure_till_date, 3); ?></td>
                                    <td class="text-left" data-title="progressive_expenditure"><?= number_format($departmentScheme->progressive_expenditure, 3); ?></td>
                                    <td class="text-left" data-title="allocation_for_cfy"><?= number_format($departmentScheme->allocation_for_cfy, 3); ?></td>
                                    <td class="text-left" data-title="release_for_cfy"><?= number_format($departmentScheme->release_for_cfy, 3); ?></td>
                                    <td class="text-left" data-title="Throw Forward"><?= number_format($departmentScheme->cost_of_scheme - $departmentScheme->allocation_for_cfy - $departmentScheme->expenditure_till_date, 3); ?></td>
                                    <td class="text-left" data-title="utlization">
                                        <?= number_format((($departmentScheme->progressive_expenditure + $departmentScheme->expenditure_till_date) / $departmentScheme->cost_of_scheme) * 100); ?>%</td>

                                    <td class="actions" width="130">
                                        <?= $this->Html->link(__('<i class="fas fa-eye"></i> View Details'), ['action' => 'view', $departmentScheme->id], ['escape' => false]) ?>
                                        <?php
//                                        debug($myUser['users_roles_id']);
//                                        debug($departmentScheme->crated_by);
//                                        debug($myUser['id']);
//                                        if ($myUser['users_roles_id'] == 'admin' || ($myUser['users_roles_id'] == 'sub-admin' && $departmentScheme->created_by == $myUser['id'])) {
                                        $this->Html->link(__('<i class="fas fa-edit"></i> Edit Details'), ['action' => 'schemeprofile', $departmentScheme->id], ['escape' => false]);
//                                        }
                                        ?>
                                        <?php $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $departmentScheme->id], ['confirm' => __('Are you sure you want to delete # {0}?', $departmentScheme->id), 'escape' => false]) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    <footer class="card-footer text-right">
                        <div class="paginator">
                            <ul class="pagination">
                                <?= $this->Paginator->first('<< ' . __('first')) ?>
                                <?= $this->Paginator->prev('< ' . __('previous')) ?>
                                <?= $this->Paginator->numbers() ?>
                                <?= $this->Paginator->next(__('next') . ' >') ?>
                                <?= $this->Paginator->last(__('last') . ' >>') ?>
                            </ul>
                            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                        </div>
                    </footer>

                    <?php
                } else {
                    echo "<h4>No Result Found.</h4>";
                }
                ?>
            </div>
        </section>
    </div>

</div><!--/row-->
<script>
    $(function () {
        //directive
        $('.cm_pm_chk').on('change', function () {

            var rec_id = $(this).attr('scheme_id');


            var status = $(this).val();


            $.ajax({
                type: "GET",
                url: '<?php echo $this->request->getAttribute("webroot"); ?>admin/DepartmentSchemes/changestatus',
                data: {id: rec_id, directive: status}, // serializes the form's elements.
                dataType: 'json',
                success: function (data)
                {

                    $('#div_' + rec_id).html(status);
                    $('#small_' + rec_id).html('updated');

                }
            });
        });
//mege project
        $('.mega_project').on('change', function () {
            var rec_id = $(this).attr('scheme_id');

            if ($(this).is(':checked') === true) {
                var status = 'Yes';
            } else {
                var status = "No";
            }

            $.ajax({
                type: "GET",
                url: '<?php echo $this->request->getAttribute("webroot"); ?>admin/DepartmentSchemes/megaproject',
                data: {id: rec_id, mega_project: status}, // serializes the form's elements.
                dataType: 'json',
                success: function (data)
                {

                    $('#mega_div_' + rec_id).html(status);
                    $('#mega_small_' + rec_id).html('updated');

                }
            });
        });
        //Locking project
        $('.locked').on('change', function () {
            var rec_id = $(this).attr('scheme_id');

            if ($(this).is(':checked') === true) {
                var status = 'Yes';
            } else {
                var status = "No";
            }

            $.ajax({
                type: "GET",
                url: '<?php echo $this->request->getAttribute("webroot"); ?>admin/DepartmentSchemes/lockproject',
                data: {id: rec_id, locked: status}, // serializes the form's elements.
                dataType: 'json',
                success: function (data)
                {

                    $('#lock_div_' + rec_id).html(status);
                    $('#lock_small_' + rec_id).html('updated');

                }
            });
        });
        //id_chief_economist
//Locking project
        $('.id_chief_economist').on('change', function () {
            var rec_id = $(this).attr('scheme_id');

            if ($(this).is(':checked') === true) {
                var status = 'Yes';
            } else {
                var status = "No";
            }

            $.ajax({
                type: "GET",
                url: '<?php echo $this->request->getAttribute("webroot"); ?>admin/DepartmentSchemes/ceproject',
                data: {id: rec_id, ceproject: status}, // serializes the form's elements.
                dataType: 'json',
                success: function (data)
                {

                    $('#chief_div_' + rec_id).html(status);
                    $('#chief_small_' + rec_id).html('updated');

                }
            });
        });
    });

    var href_path = window.location.href;
    var rem = href_path.split('?');
    if (rem[1] !== undefined) {
//alert(rem[1]);
//alert($('#makeurl').attr('href'));
        var this_url = $('#makeurl').attr('href') + '?' + rem[1] + '&flag=0';
//alert(this_url);
        $('#makeurl').attr('href', this_url);

        var this_url = $('#makeurl1').attr('href') + '?' + rem[1] + '&flag=0';
//alert(this_url);
        $('#makeurl1').attr('href', this_url);
    }

</script>       