<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');
?>

<div class="column-responsive column-80">
    <div class="departmentSchemes col-lg-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <?= $this->element('scheme_status_bar') ?>

                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Is custom milestone required?') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('custom_milestone_required', ['required', 'class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
                    echo '</div><!--/row-->';
                    ?>
                    <div id="q4" style="display:<?= ($departmentScheme->custom_milestone_required == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">
                        <?php //debug($fetch_custom_details); ?>
                        <table id="tbl_invTruck" cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                            <thead>
                                <tr>
                                    <th scope="col">Display Order</th>
                                    <th scope="col">Milestone Name</th>
                                    <th scope="col">Current Status & Way Forward</th>
                                    <th scope="col">Is this milestone completed?</th>
                                    <th scope="col">Completion Date</th>
                                    <th scope="col">Responsibility</th>
                                    <th scope="col" width="30">&nbsp;</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $checkifany = 1;
                                $key = 0;
                                $departments[36] = 'Other';

                                foreach ($fetch_custom_details as $cu):
                                    echo $this->Form->control('pid[]', ['type' => 'hidden', 'value' => $cu->id])
                                    ?>
                                    <tr class="tr_clone">
                                        <td scope="col" width="75"><?= $this->Form->control('display_order[' . $key . ']', ['type' => 'number', 'min' => 1, 'required', 'class' => 'form-control', 'label' => false, 'value' => $cu->display_order]) ?></td>
                                        <td scope="col">
                                            <?php
                                            if ($departmentScheme->locked == 'Yes' && $cu->milestone_name && !in_array($myUser->users_roles_id, ['admin', 'sub-admin'])) {
//                                                echo __LINE__;
                                                if ($myUser->users_roles_id == 'pm') { //cant do anything
                                                    //display old date
                                                    echo $cu->milestone_name;
                                                } else { //cpo
                                                    //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                                    if ($departmentScheme->mega_project == 'Yes') {
                                                        //cpo cant do anything too-display old date
                                                        echo $cu->milestone_name;
                                                    } else {
                                                        //cpo can do and show fields again
                                                        echo $this->Form->control('milestone_name[' . $key . ']', ['required', 'class' => 'form-control', 'label' => false, 'value' => $cu->milestone_name]);
                                                    }
                                                }
                                            } else {
//                                                echo __LINE__;
                                                //show fields to change
                                                echo $this->Form->control('milestone_name[' . $key . ']', ['required', 'class' => 'form-control', 'label' => false, 'value' => $cu->milestone_name]);
                                            }
                                            ?>

                                            <?php //$this->Form->control('milestone_name[]', ['required', 'class' => 'form-control', 'label' => false, 'value' => $cu->milestone_name]) ?></td>
                                        <?= $this->Form->control('way_forward_old[' . $key . ']', ['type' => 'hidden', 'value' => $cu->way_forward]) ?>
                                        <td scope="col"><?= $this->Form->control('way_forward[' . $key . ']', ['required', 'class' => 'form-control', 'label' => false, 'type' => 'textarea', 'value' => $cu->way_forward]) ?></td>
                                        <td scope="col" width="135"><?= $this->Form->control('is_completed[' . $key . ']', ['required', 'class' => 'form-control', 'label' => false, 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], 'value' => $cu->is_completed]) ?></td>
                                        <td scope="col" width="140">
                                            <?php
                                            if ($departmentScheme->locked == 'Yes' && $cu->completion_date && !in_array($myUser->users_roles_id, ['admin', 'sub-admin'])) {
                                                if ($myUser->users_roles_id == 'pm') { //cant do anything
                                                    //display old date
                                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($cu->completion_date));
                                                } else { //cpo
                                                    //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                                    if ($departmentScheme->mega_project == 'Yes') {
                                                        //cpo cant do anything too-display old date
                                                        echo date('j<\s\up>S</\s\up> F Y', strtotime($cu->completion_date));
                                                    } else {
                                                        //cpo can do and show fields again
                                                        echo $this->Form->control('completion_date[' . $key . ']', ['required', 'class' => 'form-control', 'label' => false, 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($cu->completion_date) ? date('d-m-Y', strtotime($cu->completion_date)) : '', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                                    }
                                                }
                                            } else {
                                                //show fields to change
                                                echo $this->Form->control('completion_date[' . $key . ']', ['required', 'class' => 'form-control', 'label' => false, 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($cu->completion_date) ? date('d-m-Y', strtotime($cu->completion_date)) : '', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                            }
                                            ?>

                                        <td scope="col" width="250"><?= $this->Form->control('responsibility[' . $key . ']', ['required', 'class' => 'form-control', 'label' => false, 'empty' => 'Choose', 'options' => $departments, 'value' => $cu->responsibility]) ?></td>
                                        <td class="add_delete"><a class="delete_parent" remove="<?= $cu->id; ?>" style="cursor:pointer" tabindex="0"><i class="fas fa-trash" style="color:red;"></i></a>&nbsp;</td>

                                    </tr>  
                                    <?php
                                    $checkifany = 0;
                                    $key++;
                                endforeach;
                                if ($checkifany) {
                                    ?>
                                    <tr class="tr_clone">
                                        <td scope="col" width="75"><?= $this->Form->control('display_order[' . $key . ']', ['value' => 1, 'type' => 'number', 'min' => 1, 'class' => 'form-control', 'label' => false]) ?></td>
                                        <td scope="col"><?= $this->Form->control('milestone_name[' . $key . ']', ['class' => 'form-control', 'label' => false]) ?></td>
                                        <td scope="col"><?= $this->Form->control('way_forward[' . $key . ']', ['class' => 'form-control', 'label' => false, 'type' => 'textarea', 'placeholder' => 'You can split each activity line by line']) ?></td>
                                        <td scope="col" width="135"><?= $this->Form->control('is_completed[' . $key . ']', ['class' => 'form-control', 'label' => false, 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) ?></td>
                                        <td scope="col" width="140"><?= $this->Form->control('completion_date[' . $key . ']', ['class' => 'form-control', 'label' => false, 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]) ?></td>
                                        <td scope="col"  width="250"><?= $this->Form->control('responsibility[' . $key . ']', ['class' => 'form-control', 'label' => false, 'default' => $myUser['department_id'], 'empty' => 'Choose', 'options' => $departments]) ?></td>
                                        <td class="add_delete">&nbsp;</td>

                                    </tr>
                                    <?php
                                }
                                if ($key == 0) {
                                    $key++;
                                }
                                ?>
                            </tbody>
                        </table>
                        <a style="cursor:pointer;color:white;" id="add_more" class="btn btn-primary pull-right"> <i aria-hidden="true" class="fas fa-plus-circle"></i> Add more</a>
                    </div>
                    <?php
                    echo $this->Form->hidden('steps_array[1]', ['value' => $departmentScheme->step1_status]);
                    echo $this->Form->hidden('steps_array[2]', ['value' => $departmentScheme->step2_status]);
                    echo $this->Form->hidden('steps_array[3]', ['value' => $departmentScheme->step3_status]);
                    echo $this->Form->hidden('steps_array[4]', ['value' => $departmentScheme->step4_status]);
                    echo $this->Form->hidden('steps_array[5]', ['value' => $departmentScheme->step5_status]);
                    echo $this->Form->hidden('steps_array[6]', ['value' => $departmentScheme->step6_status]);
                    echo $this->Form->hidden('steps_array[7]', ['value' => $departmentScheme->step7_status]);
                    echo $this->Form->hidden('steps_array[8]', ['value' => $departmentScheme->custom_status]);
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <a class="btn btn-primary pull-left" 
                   href="<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/step3/<?php echo $departmentScheme->id; ?>">
                    <i aria-hidden="true" class="fas fa-arrow-left"></i> Previous </a>
                <center>
                    <?php //echo '<strong>Milstones Status </strong><br/><img src="' . $this->request->getAttribute("webroot") . 'img/status.PNG" style="max-height:100px">';      ?>
                    <?php
//                    if ($departmentScheme->locked && $departmentScheme->custom_milestone_required == 'Yes' && $departmentScheme->mega_project == 'Yes') {
//                        if ($schemeRequests == 0) {
                    ?>
                    <!--<a class="modal-with-form" href="#modalForm">Request Change for Expected Completion Date of the Custom milestone?</a>-->
                    <?php
//                        } else {
//
//                            echo "Request already pending to change date.";
//                        }
//                    }
                    ?>
                </center>
                <button class="btn btn-primary" type="submit">Next <i aria-hidden="true" class="fas fa-arrow-right"></i></button>
                    <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>
<script>

    $(function () {


        //q4
        $('body').on('change', '#custom-milestone-required', function () {
            if ($(this).val() == 'Yes') {
//                    alert('q1');
                $('#q4').show('slow');
                $('#q4').find('input').attr('required', true);
                $('#q4').find('select').attr('required', true);
                $('#q4').find('textarea').attr('required', true);

                $('#responsibility').val(<?= $departmentScheme->department_id ?>);

            } else {

                $('#q4').find('input').attr('required', false);
                $('#q4').find('select').attr('required', false);
                $('#q4').find('textarea').attr('required', false);

                $('#q4').find('input').val('');
                $('#q4').find('select').val('');


                $('#q4').hide('slow');
            }
//            $('#designation-step4').attr('required', false);

        });

        $('body').on('click', '#add_more', function () {

            var $tableBody = $('#tbl_invTruck').find("tbody"),
                    $trLast = $tableBody.find("tr:last");
            var attach_key = $('#tbl_invTruck tr').length;
            var mykey = attach_key - 1;
            var last_value = parseInt($trLast.clone().find('[name="display_order[' + mykey + ']"]').val()) + 1;
            var new_row = '<tr class="tr_clone">\n\
                        <td scope="col" width="75"><div class="input number"><input value="' + last_value + '" name="display_order[' + attach_key + ']" min="1" required="required" class="form-control" id="display-order"  type="number"><span class="required-asterisk">*</span></div></td>\n\
                        <td scope="col"><div class="input text"><input name="milestone_name[' + attach_key + ']" required="required" class="form-control" id="milestone-name" type="text"><span class="required-asterisk">*</span></div></td>\n\
                        <td scope="col"><div class="input textarea"><textarea name="way_forward[' + attach_key + ']" placeholder="You can split each activity line by line" required="required" class="form-control" id="way-forward" rows="5"></textarea><span class="required-asterisk">*</span></div></td>\n\
                        <td scope="col"><div class="input select"><select name="is_completed[' + attach_key + ']" required="required" class="form-control" id="is-completed"><option value="">Choose</option><option value="Yes">Yes</option><option value="No">No</option></select><span class="required-asterisk">*</span></div></td>\n\
                        <td scope="col"><div class="input text"><input name="completion_date[' + attach_key + ']" required="required" class="form-control" data-plugin-datepicker="data-plugin-datepicker" data-date-format="dd-mm-yyyy" data-date-end-date="<?= date('d-m-Y', strtotime($departmentScheme->scheme_end_date)); ?>" id="completion-date" type="text"><span class="required-asterisk">*</span></div></td>\n\
                        <td scope="col"><div class="input select"><select name="responsibility[' + attach_key + ']" required="required" class="form-control" id="responsibility"><option value="">Choose</option><option value="1">Administration</option><option value="2">Agriculture</option><option value="4">Auqaf</option><option value="3">C &amp; W</option><option value="35">Culture, Sports, Tourism, Archaeology &amp; Youth Affairs</option><option value="7">E &amp; SE</option><option value="5">Energy &amp; Power</option><option value="12">Establishment</option><option value="13">Excise &amp; Taxation</option><option value="14">Finance</option><option value="15">Food</option><option value="10">Forest, Environment and Wildlife</option><option value="16">Health</option><option value="21">Higher Education</option><option value="22">Home &amp; Tribal Affairs</option><option value="23">Housing</option><option value="18">Industries</option><option value="8">Information &amp; Public Relations</option><option value="24">IPC</option><option value="19">Irrigation</option><option value="20">Labour</option><option value="6">Law</option><option value="26">LG &amp; RDD</option><option value="27">Minerals Development</option><option value="30">PHE</option><option value="28">Planning &amp; Development</option><option value="29">Population Welfare</option><option value="11">Relief Rehabilitation &amp; Settlement</option><option value="31">Revenue</option><option value="32">Social Welfare</option><option value="9">ST &amp; IT</option><option value="34">Transport</option><option value="25">Zakat &amp; Ushr</option><option value="36">Other</option></select><span class="required-asterisk">*</span></div></td>\n\
                        <td class="add_delete"><a class="delete_parent" style="cursor:pointer" tabindex="0"><i class="fas fa-trash" style="color:red;"></i></a>&nbsp;</td>\n\
                    </tr>';

            $('#tbl_invTruck').append(new_row);

//        return false;
//        
////            alert('called');
//            var $tableBody = $('#tbl_invTruck').find("tbody"),
//                    $trLast = $tableBody.find("tr:last");
//            var last_value = parseInt($trLast.clone().find('[name="display_order[]"]').val());
////                    alert(last_value);
//            $trNew = $trLast.clone().find('input').val('').end();
//            $trNew = $trNew.find('textarea').val('').end();
//            $trNew = $trNew.find('select').val('').end();
//
//            // Find by attribute 'id'
//
//
//            $trLast.after($trNew);
//            var m_row = 1;
////            var add_string = '<a onclick = "if (confirm(&quot;Are you sure you want to delete this row?&quot;)) { deleterow(' + m_row + '); } event.returnValue = false; return false;" href="#" tabindex="0"><i class="fas fa-trash" style="color:red;"></i></a>';
//            var add_string = '';
//
//            $('#tbl_invTruck > tbody > tr:last-child').find('td.add_delete').html(add_string);
//            $('#tbl_invTruck > tbody > tr:last-child').find('[name="display_order[]"]').val(last_value + 1);

            $.getScript("<?php echo $this->request->getAttribute("webroot"); ?>porto-admin/js/theme.init.js");

        });

//        $('body').on('change', '#land-acquisition-compl-date', function () {
//
//            if ($('#land_acquisition_old_compl_date').val() !== '1970-01-01' && $('#land_acquisition_old_compl_date').val().trim() !== '') {
////                alert($('#pc2_compl_old_date').val());
//                if ($(this).val() !== $('#land_acquisition_old_compl_date').val()) {
//                    alert('Oops, it looks you have changed the completion date, CMDU will get informed about this change.');
//                }
//            }
//        });

        $('body').on('click', '.delete_parent', function () {

            if (confirm('Are you sure you want to delete this row?')) {
                $(this).parents("tr").remove();
                if ($(this).attr('remove')) {
                    var rem = $(this).attr('remove');
                    $.ajax({
                        type: "GET",
                        url: '<?php echo $this->request->getAttribute("webroot"); ?>CustomMilestones/remove',
                        data: {id: rem}, // serializes the form's elements.
                        dataType: 'json',
                        success: function (data)
                        {

                            $('#chief_div_' + rec_id).html(status);
                            $('#chief_small_' + rec_id).html('updated');

                        }
                    });
                }

            }

        });
    });
</script>
