<?php
/**
* @var \App\View\AppView $this
* @var \App\Model\Entity\RecordNoteDetail[]|\Cake\Collection\CollectionInterface $recordNoteDetails
*/
$this->assign('title', 'Listing Record Note Details');
?>

        <nav class="large-3 medium-4 columns" id="actions-sidebar">
        <ul class="side-nav">
            <li class="heading"><?= __('Actions') ?></li>
                    <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Record Note Detail'), ['action' => 'add'], ['escape'=>false]) ?></li>

                                                                                                    <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Record Notes'), ['controller' => 'RecordNotes', 'action' => 'index'], ['escape'=>false]) ?></li>
                        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Record Note'), ['controller' => 'RecordNotes', 'action' => 'add'], ['escape'=>false]) ?></li>
                                                                                                </ul>
    </nav>

    <div class="row">
        <section class="card">


            <header class="card-header">
                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>
                <h3><?= __('Record Note Details') ?></h3>
            </header>

            <div class="recordNoteDetails card-body content">

                <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                    <thead>
                        <tr>
                                                            <th scope="col"><?= $this->Paginator->sort('id') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('record_note_id') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('progress_made') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('timeline') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('responsibility') ?></th>
                                                                <th scope="col"><?= $this->Paginator->sort('created') ?></th>
                                                            <th scope="col" class="actions"><?= __('Actions') ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($recordNoteDetails as $recordNoteDetail): ?>
                        <tr>
                                                                                                                                                                                                                                                                                                                                                                                            <td class="text-right" data-title="Id"><?= $this->Number->format($recordNoteDetail->id) ?></td>
                                                                                                                                                                                                                                                                                                                                    <td><?= $recordNoteDetail->has('record_note') ? $this->Html->link($recordNoteDetail->record_note->id, ['controller' => 'RecordNotes', 'action' => 'view', $recordNoteDetail->record_note->id]) : '' ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        <td class="text-left" data-title="Progress Made"><?= h($recordNoteDetail->progress_made) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                <td class="text-left" data-title="Timeline"><?= h($recordNoteDetail->timeline) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                <td class="text-left" data-title="Responsibility"><?= h($recordNoteDetail->responsibility) ?></td>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                <td class="text-left" data-title="Created"><?= h($recordNoteDetail->created) ?></td>
                                                                                                                                                        <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['action' => 'view', $recordNoteDetail->id], ['escape'=>false] ) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['action' => 'edit', $recordNoteDetail->id], ['escape'=>false] )  ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $recordNoteDetail->id], ['confirm' => __('Are you sure you want to delete # {0}?', $recordNoteDetail->id), 'escape'=>false]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <footer class="card-footer text-right">
                    <div class="paginator">
                        <ul class="pagination">
                            <?= $this->Paginator->first('<< ' . __('first')) ?>
                            <?= $this->Paginator->prev('< ' . __('previous')) ?>
                            <?= $this->Paginator->numbers() ?>
                            <?= $this->Paginator->next(__('next') . ' >') ?>
                            <?= $this->Paginator->last(__('last') . ' >>') ?>
                        </ul>
                        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                    </div>
                </footer>
            </div>
        </section>
    </div><!--/row-->
