<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\RecordNote $recordNote
 */
$this->assign('title', 'Editing Record Note');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?=
            $this->Form->postLink(
                    __('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $recordNote->id], ['confirm' => __('Are you sure you want to delete # {0}?', $recordNote->id), 'escape' => false]
            )
            ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Record Notes'), ['action' => 'index'], ['escape' => false]) ?></li>
<!--                        <li><?= $this->Html->link(__('List Record Note Details'), ['controller' => 'RecordNoteDetails', 'action' => 'index'], ['escape' => false]) ?></li>
<li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Record Note Detail'), ['controller' => 'RecordNoteDetails', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>
<div class="column-responsive column-80">
    <div class="recordNotes col-lg-6 content">
        <?= $this->Form->create($recordNote, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __('Edit Record Note') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <fieldset>
                    <?php
//                    debug();
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Department') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('department_id', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Subject') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('subject', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Meeting Date') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('meeting_date', ['class' => 'form-control', 'label' => false, 'value' => date('d-m-Y', strtotime($recordNote->meeting_date)), 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Attachment') . '</label></div>';
                    echo '<div class="col-sm-7">';
//                    debug($recordNote->attachment);
                    if (file_exists(WWW_ROOT . 'img/record_notes/' . $recordNote->attachment) && !empty($recordNote->attachment)) {

                        echo '<strong>Existing Attachment: </strong><img src="' . $this->request->getAttribute("webroot") . 'img/record_notes/' . $recordNote->attachment . '" style="max-height:100px">';
                        echo '&nbsp;&nbsp;<a id="delete_evidence" style="color:red;" href="#"><i aria-hidden="true" class="fas fa-trash"></i></a>';
                    }
                    echo $this->Form->control('attachment', ['class' => 'form-control', 'label' => false, 'type' => 'file']);
                    echo '</div>';
                    echo '</div><!--/row-->';

//                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Created By') . '</label></div>';
//                        echo '<div class="col-sm-7">' . $this->Form->control('created_by', ['class'=>'form-control', 'label'=>false]) . '</div>';
//                        echo '</div><!--/row-->';
//
//                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Modified By') . '</label></div>';
//                        echo '<div class="col-sm-7">' . $this->Form->control('modified_by', ['class'=>'form-control', 'label'=>false]) . '</div>';
//                        echo '</div><!--/row-->';
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary']) ?>
                <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
    <script>
//alert(87);
    $(function () {
//alert(87);

        $('body').on('click', '#delete_evidence', function () {
//            alert(92);

            if (confirm('Are you sure want to delete?')) {
                window.location.href = '<?php echo $this->request->getAttribute("webroot"); ?>admin/RecordNotes/finish_attachment/<?php echo $recordNote->id; ?>';
                            }
                        });
                    });
</script>