<?php
/**
* @var \App\View\AppView $this
* @var \App\Model\Entity\RecordNote $recordNote
*/
$this->assign('title', 'Viewing Record Note');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit Record Note'), ['action' => 'edit', $recordNote->id], ['escape'=>false]) ?></li>
        <li><?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete Record Note'), ['action' => 'delete', $recordNote->id], ['confirm' => __('Are you sure you want to delete # {0}?', $recordNote->id), 'escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Record Notes'), ['action' => 'index'], ['escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Record Note'), ['action' => 'add'], ['escape'=>false]) ?></li>
                                                                                                                                        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Record Note Details'), ['controller' => 'RecordNoteDetails', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Record Note Detail'), ['controller' => 'RecordNoteDetails', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                        </ul>
</nav>
<div class="row">
    <section class="card">

        
        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>

            <h2 class="card-title">Record Notes</h2>
        </header>

    <div class="recordNotes card-body content">

        <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                                                                        <tr>
                            <th scope="row"><?= __('Attachment') ?></th>
                            <td><?= h($recordNote->attachment) ?></td>
                        </tr>
                                                                                                            <tr>
                        <th scope="row"><?= __('Id') ?></th>
                        <td><?= $this->Number->format($recordNote->id) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Department Id') ?></th>
                        <td><?= $this->Number->format($recordNote->department_id) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Created By') ?></th>
                        <td><?= $this->Number->format($recordNote->created_by) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Modified By') ?></th>
                        <td><?= $this->Number->format($recordNote->modified_by) ?></td>
                    </tr>
                                                                            <tr>
                        <th scope="row"><?= __('Meeting Date') ?></th>
                        <td><?= h($recordNote->meeting_date) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Created') ?></th>
                        <td><?= h($recordNote->created) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Modified') ?></th>
                        <td><?= h($recordNote->modified) ?></td>
                    </tr>
                                                </table>
                                    <div class="row">
                    <h4><?= __('Subject') ?></h4>
                    
                        <?= $this->Text->autoParagraph(h($recordNote->subject)); ?>
                  
                </div>
                                                                        <div class="related">
                <h4><?= __('Related Record Note Details') ?></h4>
                <?php if (!empty($recordNote->record_note_details)) : ?>
                <div class="table-responsive">
                    <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                        <tr>
                                                            <th scope="col"><?= __('Id') ?></th>
                                                                <th scope="col"><?= __('Record Note Id') ?></th>
                                                                <th scope="col"><?= __('Decision Made') ?></th>
                                                                <th scope="col"><?= __('Progress Made') ?></th>
                                                                <th scope="col"><?= __('Timeline') ?></th>
                                                                <th scope="col"><?= __('Notes') ?></th>
                                                                <th scope="col"><?= __('Responsibility') ?></th>
                                                                <th scope="col"><?= __('Created') ?></th>
                                                            <th  scope="col" class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($recordNote->record_note_details as $recordNoteDetails) : ?>
                        <tr>
                                                            <td><?= h($recordNoteDetails->id) ?></td>
                                                            <td><?= h($recordNoteDetails->record_note_id) ?></td>
                                                            <td><?= h($recordNoteDetails->decision_made) ?></td>
                                                            <td><?= h($recordNoteDetails->progress_made) ?></td>
                                                            <td><?= h($recordNoteDetails->timeline) ?></td>
                                                            <td><?= h($recordNoteDetails->notes) ?></td>
                                                            <td><?= h($recordNoteDetails->responsibility) ?></td>
                                                            <td><?= h($recordNoteDetails->created) ?></td>
                                                                                    <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['controller' => 'RecordNoteDetails', 'action' => 'view', $recordNoteDetails->id], ['escape'=>false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['controller' => 'RecordNoteDetails', 'action' => 'edit', $recordNoteDetails->id], ['escape'=>false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['controller' => 'RecordNoteDetails', 'action' => 'delete', $recordNoteDetails->id], ['confirm' => __('Are you sure you want to delete # {0}?', $recordNoteDetails->id), 'escape'=>false]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            </div><!--/content-->
    </section>
</div><!--/row-->
