<?php

use Cake\ORM\TableRegistry;

require_once (APP . 'Vendor' . DS . 'xtcpdf.php');
$tcpdf = new XTCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$html = '<table><tr><td><img height="50" src="https://cmpo.cmkp.gov.pk/cmpo/public/assets/images/logo.png"></td><td align="right"><img style="float:right;" height="50" src="http://cmdu.kp.gov.pk/portal/img/kp_logo.jpg"></td></tr><tr nobr="true"><td colspan="2" align="center">'
        . '<center><h1>Date Change Request</h1></center></td></tr></table>';
$html .= '<br/><hr><br/><hr><br/>';
$textfont = 'helvetica'; // looks better, finer, and more condensed than 'dejavusans'

$tcpdf->AddPage('L'); // Front Page
///$tcpdf->setY(-240);
//$tcpdf->SetTextColor(0, 0, 0);
$tcpdf->SetFont($textfont, '', 9);
$tcpdf->setListIndentWidth(4);
$html .= '<table cellpadding="2" cellspacing="0" border="1" style="margin-top:20px;width:100%">
                        <tr style="color:white;background-color:darkgreen;">
                            <th width="4%">S.No</th>
                            <th width="10%">Department</th>
                            <th width="20%">Scheme Name</th>
                            <th width="7%">Scheme Type</th>
                            <th width="10%">Step</th>
                            <th width="12%">Old Date</th>
                            <th width="37%">Justification</th>
                        </tr>';

$s = 1;
$steps_Array = ['schemeprofile' => 'Scheme Profile', 'step1' => 'Is PC-II Required?', 'step2' => 'Is the PC-1 approved?', 'step3' => 'Is Hiring Required?', 'step4' => 'Is Land Acquisition Required?', 'step5' => 'Is Procurement of Goods Required?', 'step6' => 'Is Procurement of Services Required?', 'step7' => 'Is Construction/Civil Work Required?', 'custom' => 'Custom Milestone'];

$SchemeDistricts = TableRegistry::get('CustomMilestones');

foreach ($departmentSchemes as $details):
    $old = '';
    switch ($details->step_name) {
        case 'schemeprofile':
            $old = 'Start Date: ' . date('j<\s\up>S</\s\up> F Y', strtotime($details->department_scheme->scheme_start_date)) . ', End Date: ' . date('j<\s\up>S</\s\up> F Y', strtotime($details->department_scheme->scheme_end_date));
            break;


        default:
            //custom
            break;
    }
    if (isset($steps_Array[$details->step_name])) {
        $bold = $steps_Array[$details->step_name];
    } else {
        $value = $SchemeDistricts->find('all', ['conditions' => ['id' => $details->step_name]])->first();
        $old = 'Start Date: ' . date('j<\s\up>S</\s\up> F Y', strtotime($value->start_date)) . ', End Date: ' . date('j<\s\up>S</\s\up> F Y', strtotime($value->completion_date));

//        debug($value);
//        exit;
        $bold = $value->milestone_name;
    }
    $html .= '<tr nobr="true">
                                <td>' . $s++ . '</td>
                                <td>' . ucfirst($details->department->department_name) . '</td>
                                <td>' . ucfirst($details->department_scheme->scheme_name) . '</td>
                                <td>' . ucfirst($details->department_scheme->scheme_type) . '</td>
                                <td>' . $bold . '</td>
                                <td>' . $old . '</td>
                                <td>' . ucfirst($details->request_details) . '</td>

                            </tr>';
    $s++;
endforeach;


//output the HTML content
//debug($html);
//exit();
$html .= '</table>';

$tcpdf->writeHTML($html, true, false, true, false, '');

//reset pointer to the last page
//$tcpdf->lastPage();
$tcpdf->Output($name . '-Date-Change-Request.pdf', 'D');
exit();
//echo "javascript:history.go(-1);";
?>