<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\SchemeStatus $schemeStatus
 */
$this->assign('title', 'Adding Scheme Status');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Scheme Statuses'), ['action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('List Department Schemes'), ['controller' => 'DepartmentSchemes', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['controller' => 'DepartmentSchemes', 'action' => 'add'], ['escape' => false]) ?></li>
    </ul>
</nav>
<div class="column-responsive column-80">
    <div class="schemeStatuses col-lg-6 content">
        <?= $this->Form->create($schemeStatus, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __('Add Scheme Status') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-5"><label>' . __('Status Name') . '</label></div>';
                    echo '<div class="col-7">' . $this->Form->control('status_name', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-5"><label>' . __('Status Color Pattern') . '</label></div>';
                    echo '<div class="col-7">' . $this->Form->control('status_color_pattern', ['required','class' => 'form-control', 'label' => false, 'type' => 'file']) . '</div>';
                    echo '</div><!--/row-->';

//                    echo '<div class="row"><div class="col-5"><label>' . __('Created By') . '</label></div>';
//                    echo '<div class="col-7">' . $this->Form->control('created_by', ['class' => 'form-control', 'label' => false]) . '</div>';
//                    echo '</div><!--/row-->';
//
//                    echo '<div class="row"><div class="col-5"><label>' . __('Modified By') . '</label></div>';
//                    echo '<div class="col-7">' . $this->Form->control('modified_by', ['class' => 'form-control', 'label' => false]) . '</div>';
//                    echo '</div><!--/row-->';
//
//                    echo '<div class="row"><div class="col-5"><label>' . __('Deleted') . '</label></div>';
//                    echo '<div class="col-7">' . $this->Form->control('deleted', ['class' => 'form-control', 'label' => false]) . '</div>';
//                    echo '</div><!--/row-->';
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary']) ?>
                <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>