<?php

use Cake\ORM\TableRegistry;

require_once (APP . 'Vendor' . DS . 'xtcpdf.php');
$tcpdf = new XTCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$html = '<table><tr><td><img height="50" src="https://cmpo.cmkp.gov.pk/cmpo/public/assets/images/logo.png"></td><td align="right"><img style="float:right;" height="50" src="http://cmdu.kp.gov.pk/portal/img/kp_logo.jpg"></td></tr><tr nobr="true"><td colspan="2" align="center">'
        . '<center><h1><img height="15" src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $departmentScheme->overall_status . '.PNG"> ' . $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')' . '</h1></center></td></tr></table>';
$html .= '<br/><hr><br/><hr><br/>';
$textfont = 'helvetica'; // looks better, finer, and more condensed than 'dejavusans'

$tcpdf->AddPage(); // Front Page
///$tcpdf->setY(-240);
//$tcpdf->SetTextColor(0, 0, 0);
$tcpdf->SetFont($textfont, '', 9);
$tcpdf->setListIndentWidth(4);
$html .= '<table cellpadding="2" cellspacing="0" border="1" style="margin-top:20px;width:100%">
                        <tr style="color:white;background-color:darkgreen;">
                            <th style="width:19%">List of Activities </th>
                            <th style="width:23%">Activity Status</th>
                            <th style="width:15%">Responsibility</th>
                            <th style="width:19%">Timeline</th>
                            <th style="width:19%">Remarks</th>
                            <th style="width:5%">T/L</th>
                        </tr>';
$departments['Other'] = 'Other';

if ($departmentScheme->pc2_required == 'Yes') {
    $pc2_approved = ($departmentScheme->pc2_approved == 'Yes') ? 'approved' : 'not approved';
    $consultant_hired = ($departmentScheme->consultant_hired == 'Yes') ? 'hired' : 'not hired yet';
    $responsible_pc2_compl = ($departmentScheme->cons_subt_report == 'Yes') ? 'submitted report' : 'haven\'t submitted report yet ';

    $html .= '<tr nobr="true">
        <td data-title="List of Activities"><b>PC-II</b></td>
        <td data-title="Activity Status">
            <ul>
                                        <li>PC-II ' . $pc2_approved . '</li>
                                        <li>Consultant ' . $consultant_hired . '</li>
                                        <li>Consultant ' . $responsible_pc2_compl . '</li>
                                    </ul>
                
            </td>
        <td data-title="Responsibility">' . $departments[$departmentScheme->responsible_pc2_compl];
    if ($departmentScheme->designation_step1) {
        $html .= "<br/>(" . $departmentScheme->designation_step1 . ')';
    }
    $html .= '</td>
        <td data-title="Timeline"><b>';
    $SchemeDistricts = TableRegistry::get('SchemesLogs');
    $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id, 'field_name' => 'pc2_compl_date'], 'order' => ['SchemesLogs.id' => 'asc']])->all();
//                                        debug($choosen_nav_districts);
    $cons_Array = array();
    foreach ($choosen_nav_districts as $cons_civil_wor):
//                                            debug($departmentScheme->cons_civil_compl_date);
//                                            debug($cons_civil_wor->answer);
        if (date('Y-m-d', strtotime($departmentScheme->pc2_compl_date)) !== $cons_civil_wor->answer) {
            array_push($cons_Array, $cons_civil_wor->answer);
        }

    endforeach;
//                                        debug($cons_Array);
    foreach ($cons_Array as $cons):
        $html .= '<del style="color:red;">' . date('j<\s\up>S</\s\up> F Y', strtotime($cons)) . '</del><br/>';
    endforeach;

    $html .= date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc2_compl_date));
    $html .= '</b></td>
        <td data-title="Remarks" style="color:maroon">' . nl2br($departmentScheme->step1_remarks) . '&nbsp;</td>
        <td  style="width:5%" data-title="T/L"><img height="20" src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $departmentScheme->step1_status . '.PNG"></td>
    </tr>';
}

if ($departmentScheme->pc1_approved) { //we need it in either case
//                    debug($departmentScheme->pc1_approved);
    $pc1_approved = ($departmentScheme->pc1_approved == 'Yes') ? 'Approved' : ucfirst($departmentScheme->pc1_stage) . ' stage';
    $pc1_responsible = ($departmentScheme->pc1_approved && $departmentScheme->pc1_responsible) ? $departments[$departmentScheme->pc1_responsible] : 'Planning & Development';
    $html .= '<tr nobr="true">
                                <td data-title="List of Activities"><b>PC-1</b></td>
                                <td data-title="Activity Status"><ul><li>' . $pc1_approved . '</li></ul></td>
                                 <td data-title="Responsibility">' . $pc1_responsible;

    if ($departmentScheme->designation_step2) {
        $html .= "<br/>(" . $departmentScheme->designation_step2 . ')';
    }
    $pc1_approved = ($departmentScheme->pc1_approved == 'No') ? date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc1_compl_date)) : date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc1_approval_date));
    $html .= '</td>
                                <td data-title="Timeline"><b>' . $pc1_approved . '</b> </td>
                                <td data-title="Remarks" style="color:maroon">' . nl2br($departmentScheme->step2_remarks) . '&nbsp;</td>
                                <td style="width:5%" data-title="T/L"><img height="20" src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $departmentScheme->step2_status . '.PNG"></td>


                            </tr>';
}

if ($departmentScheme->hiring_required == 'Yes') {
    $sne_required = ($departmentScheme->sne_required == 'Yes') ? 'required' : 'not required';
    $html .= '<tr nobr="true">
                                <td data-title="List of Activities"><b>Hiring</b></td>
                                <td data-title="Activity Status">
                                    <ul style="margin-left:-30px;">  
                                        <li>SNE ' . $sne_required . '</li>';
    if ($departmentScheme->sne_required == 'Yes') {
//        $html .= "<br/>";
        $sne_submitted = ($departmentScheme->sne_submitted == 'Yes') ? 'submitted' : 'not submitted';
        $html .= '<li>SNE ' . $sne_submitted . ' to Finance Department</li>';
        if ($departmentScheme->sne_submitted == 'Yes') {

            $sne_approved = ($departmentScheme->sne_approved == 'Yes') ? 'approved' : 'not approved';
            $html .= '<li>SNE ' . $sne_approved . '</li>';
        }
    }


    $html .= '<div style="margin:10px;">';

    if ($departmentScheme->will_hiring_through_psc == 'Yes') {
        $ver = ($departmentScheme->hiring_through_psc == 'Yes') ? 'complete' : 'incomplete';
        $html .= '<li>' . "Hiring through PSC " . $ver . '</li>';
    }
    if ($departmentScheme->will_hiring_through_internal_posting == 'Yes') {
        $ver = ($departmentScheme->hiring_through_internal_posting == 'Yes') ? 'complete' : 'incomplete';
        $html .= '<li>' . "Hiring through Internal Posting " . $ver . '</li>';
    }
    if ($departmentScheme->will_hiring_through_market == 'Yes') {
        $ver = ($departmentScheme->hiring_through_market == 'Yes' && $departmentScheme->posting_though_market_media == 'Yes' &&
                $departmentScheme->hiring_market_entries_recorded == 'Yes' && $departmentScheme->hiring_market_scrutiny_compl == 'Yes' &&
                $departmentScheme->hiring_market_intervies_cond == 'Yes' && $departmentScheme->hiring_market_appoint_letter_issues == 'Yes') ? 'complete' : 'incomplete';
        $html .= '<li>' . "Hiring through Market " . $ver;

        $Advertising = ($departmentScheme->posting_though_market_media == 'Yes') ? 'complete' : 'incomplete';
        $Entries = ($departmentScheme->hiring_market_entries_recorded == 'Yes') ? 'recorded' : 'not recorded';
        $Scrutiny = ($departmentScheme->hiring_market_scrutiny_compl == 'Yes') ? 'completed' : 'incomplete';
        $Interviews = ($departmentScheme->hiring_market_intervies_cond == 'Yes') ? 'conducted' : 'not conducted so far';
        $Appointment = ($departmentScheme->hiring_market_appoint_letter_issues == 'Yes') ? 'issued' : 'not issued';
        $html .= '<div style="margin:10px;">
                                            <ul>
                                                <li>Advertising ' . $Advertising . '</li>
                                                <li>Entries ' . $Entries . '</li>
                                                <li>Scrutiny / Shortlisting  ' . $Scrutiny . '</li>
                                                <li>Interviews ' . $Interviews . '</li>
                                                <li>Appointment letters ' . $Appointment . '</li>
                                            </div> </ul></li>';
    }

    $html .= '</div></ul>
                                </td>
                                <td data-title="Responsibility">';

    $html .= "<br/>";
    if ($departmentScheme->sne_submitted == 'No') {
        $html .= $departments[$departmentScheme->department_id];
    }
    $html .= "<br/>";
    if ($departmentScheme->sne_approved == 'No') {
        $html .= 'Finance';
    }

    $html .= '<div style="margin:10px;">';

    if ($departmentScheme->will_hiring_through_psc == 'Yes') {

        $html .= '<br/><br/>' . "PSC: " . $departments[$departmentScheme->responsible_psc];
        if ($departmentScheme->designation_step3_psc) {
            $html .= "<br/>(" . $departmentScheme->designation_step3_psc . ')';
        }
    }
    if ($departmentScheme->will_hiring_through_internal_posting == 'Yes') {
        $html .= '<br/><br/>' . "Internal Posting: " . $departments[$departmentScheme->responsible_internal_posting];
        if ($departmentScheme->designation_step3_ip) {
            $html .= "<br/>(" . $departmentScheme->designation_step3_ip . ')';
        }
    }
    if ($departmentScheme->will_hiring_through_market == 'Yes') {
        $html .= '<br/><br/>' . "Market: " . $departments[$departmentScheme->hiring_market_respons_person];
        if ($departmentScheme->designation_step3_market) {
            $html .= "<br/>(" . $departmentScheme->designation_step3_market . ')';
        }
    }
    $sne_submitted = ($departmentScheme->sne_submitted == 'No') ? date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->sne_submission_date)) : '';
    $html .= '</div>
                                </td>
                                <td data-title="Timeline">
                                    <b>  <br/>';

    $SchemeDistricts = TableRegistry::get('SchemesLogs');
    $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id, 'field_name' => 'sne_submission_date'], 'order' => ['SchemesLogs.id' => 'asc']])->all();
//                                        debug($choosen_nav_districts);
    $cons_Array = array();
    foreach ($choosen_nav_districts as $cons_civil_wor):
//                                            debug($departmentScheme->cons_civil_compl_date);
//                                            debug($cons_civil_wor->answer);
        if (date('Y-m-d', strtotime($departmentScheme->sne_submission_date)) !== $cons_civil_wor->answer) {
            array_push($cons_Array, $cons_civil_wor->answer);
        }

    endforeach;
//                                        debug($cons_Array);
    foreach ($cons_Array as $cons):
        $html .= '<del style="color:red;">' . date('j<\s\up>S</\s\up> F Y', strtotime($cons)) . '</del><br/>';
    endforeach;
    $html .= $sne_submitted;

    $html .= '<br/>';

    $SchemeDistricts = TableRegistry::get('SchemesLogs');
    $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id, 'field_name' => 'sne_approval_date'], 'order' => ['SchemesLogs.id' => 'asc']])->all();
//                                        debug($choosen_nav_districts);
    $cons_Array = array();
    foreach ($choosen_nav_districts as $cons_civil_wor):
//                                            debug($departmentScheme->cons_civil_compl_date);
//                                            debug($cons_civil_wor->answer);
        if (date('Y-m-d', strtotime($departmentScheme->sne_approval_date)) !== $cons_civil_wor->answer) {
            array_push($cons_Array, $cons_civil_wor->answer);
        }

    endforeach;
//                                        debug($cons_Array);
    foreach ($cons_Array as $cons):
        $html .= '<del style="color:red;">' . date('j<\s\up>S</\s\up> F Y', strtotime($cons)) . '</del><br/>';
    endforeach;
    $sne_approved = ($departmentScheme->sne_approved == 'No') ? '' . date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->sne_approval_date)) : '';
    $html .= $sne_approved;

    $html .= ' <div style="margin:10px;">';

    if ($departmentScheme->will_hiring_through_psc == 'Yes') {

        $SchemeDistricts = TableRegistry::get('SchemesLogs');
        $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id, 'field_name' => 'hiring_compl_date_psc'], 'order' => ['SchemesLogs.id' => 'asc']])->all();
//                                        debug($choosen_nav_districts);
        $cons_Array = array();
        foreach ($choosen_nav_districts as $cons_civil_wor):
//                                            debug($departmentScheme->cons_civil_compl_date);
//                                            debug($cons_civil_wor->answer);
            if (date('Y-m-d', strtotime($departmentScheme->hiring_compl_date_psc)) !== $cons_civil_wor->answer) {
                array_push($cons_Array, $cons_civil_wor->answer);
            }

        endforeach;
//                                        debug($cons_Array);
        foreach ($cons_Array as $cons):
            $html .= '<del style="color:red;">' . date('j<\s\up>S</\s\up> F Y', strtotime($cons)) . '</del><br/>';
        endforeach;

        $html .= '<br/><br/>' . "PSC: " . date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_compl_date_psc));
    }
    $html .= "<br/>";
    if ($departmentScheme->will_hiring_through_internal_posting == 'Yes') {
        $SchemeDistricts = TableRegistry::get('SchemesLogs');
        $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id, 'field_name' => 'hiring_compl_date_internal_posting'], 'order' => ['SchemesLogs.id' => 'asc']])->all();
//                                        debug($choosen_nav_districts);
        $cons_Array = array();
        foreach ($choosen_nav_districts as $cons_civil_wor):
//                                            debug($departmentScheme->cons_civil_compl_date);
//                                            debug($cons_civil_wor->answer);
            if (date('Y-m-d', strtotime($departmentScheme->hiring_compl_date_internal_posting)) !== $cons_civil_wor->answer) {
                array_push($cons_Array, $cons_civil_wor->answer);
            }

        endforeach;
//                                        debug($cons_Array);
        foreach ($cons_Array as $cons):
            $html .= '<del style="color:red;">' . date('j<\s\up>S</\s\up> F Y', strtotime($cons)) . '</del><br/>';
        endforeach;
        $html .= '<br/>' . "Internal Posting: " . date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_compl_date_internal_posting));
    }
    if ($departmentScheme->will_hiring_through_market == 'Yes') {
        $SchemeDistricts = TableRegistry::get('SchemesLogs');
        $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id, 'field_name' => 'hiring_market_compl_date'], 'order' => ['SchemesLogs.id' => 'asc']])->all();
//                                        debug($choosen_nav_districts);
        $cons_Array = array();
        foreach ($choosen_nav_districts as $cons_civil_wor):
//                                            debug($departmentScheme->cons_civil_compl_date);
//                                            debug($cons_civil_wor->answer);
            if (date('Y-m-d', strtotime($departmentScheme->hiring_market_compl_date)) !== $cons_civil_wor->answer) {
                array_push($cons_Array, $cons_civil_wor->answer);
            }

        endforeach;
//                                        debug($cons_Array);
        foreach ($cons_Array as $cons):
            $html .= '<del style="color:red;">' . date('j<\s\up>S</\s\up> F Y', strtotime($cons)) . '</del><br/>';
        endforeach;
        $html .= '<br/>' . "Market: " . date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_market_compl_date));
    }

    $html .= ' </div>
                                    </b>
                                </td>
                                <td data-title="Remarks" style="color:maroon">' . nl2br($departmentScheme->step3_remarks) . '&nbsp;</td>
                                <td style="width:5%" data-title="T/L"><img height="20" src = "http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $departmentScheme->step3_status . '.PNG"></td>
                            </tr>';
}
if ($departmentScheme->land_acquisition_required == 'Yes') {

    $html .= '<tr nobr="true">
                                <td data-title="List of Activities"><b>Land Acquisition</b></td>
                                <td data-title="Activity Status">';
    $land = ($departmentScheme->land_identified == 'Yes') ? 'complete' : 'incomplete';
    $sec4 = ($departmentScheme->land_section4_compl == 'Yes') ? 'complete' : 'incomplete';
    $sec6 = ($departmentScheme->land_section6_comp == 'Yes') ? 'complete' : 'incomplete';
    $poss = ($departmentScheme->land_possision_taken_over == 'Yes') ? 'taken over' : 'not taken over';
    $award = ($departmentScheme->land_award_been_issued == 'Yes') ? 'been issued' : 'not issued';
    $payment = ($departmentScheme->land_payment_made == 'Yes') ? 'made' : 'not made';
    $html .= '<ul>
                                        <li>Land Identification ' . $land . '</li>
                                    <li>Section 4 ' . $sec4 . '</li>
                                    <li>Section 6 ' . $sec6 . '</li>
                                    <li>Land Possession ' . $poss . '</li>
                                    <li>Land Award ' . $award . '</li>
                                    <li>Payment ' . $payment . '</li>
                                        </ul>
                                </td>
                                <td data-title="Responsibility">' .
            $departments[$departmentScheme->land_acquisition_responsible];
    if ($departmentScheme->designation_step4) {
        $html .= "<br/>(" . $departmentScheme->designation_step4 . ')';
    }
    $html .= '</td>
    <td data-title="Timeline"><b>';
    $SchemeDistricts = TableRegistry::get('SchemesLogs');
    $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id, 'field_name' => 'land_acquisition_compl_date'], 'order' => ['SchemesLogs.id' => 'asc']])->all();
//                                        debug($choosen_nav_districts);
    $cons_Array = array();
    foreach ($choosen_nav_districts as $cons_civil_wor):
//                                            debug($departmentScheme->cons_civil_compl_date);
//                                            debug($cons_civil_wor->answer);
        if (date('Y-m-d', strtotime($departmentScheme->land_acquisition_compl_date)) !== $cons_civil_wor->answer) {
            array_push($cons_Array, $cons_civil_wor->answer);
        }

    endforeach;
//                                        debug($cons_Array);
    foreach ($cons_Array as $cons):
        $html .= '<del style="color:red;">' . date('j<\s\up>S</\s\up> F Y', strtotime($cons)) . '</del><br/>';
    endforeach;

    $html .= date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->land_acquisition_compl_date));
    $html .= '</b></td>
    <td data-title="Remarks" style="color:maroon">' . nl2br($departmentScheme->step4_remarks) . '&nbsp;</td>
    <td><img src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $departmentScheme->step4_status . '.PNG"></td>
    </tr>';
}
if ($departmentScheme->proc_goods_required == 'Yes') {

    $html .= '<tr nobr="true">
                                <td data-title="List of Activities"><b>Procurement of Goods</b></td>
                                <td data-title="Activity Status">';
    $g_adv = ($departmentScheme->proc_goods_tender_advertised == 'Yes') ? 'complete' : 'incomplete';
    $g_issu = ($departmentScheme->proc_goods_bidding_complete == 'Yes') ? 'complete' : 'incomplete';
    $g_isse2 = ($departmentScheme->proc_goods_po_issued == 'Yes') ? 'issued' : 'not issued';
    $g_del = ($departmentScheme->proc_goods_delivery_physical_verification_done == 'Yes') ? 'complete' : 'incomplete';
    $g_e = ($departmentScheme->proc_goods_distribution_equipments == 'Yes') ? 'complete' : 'incomplete';
    $html .= '<ul>
                                        <li>Advertisement ' . $g_adv . '</li>
                                    <li>Bidding ' . $g_issu . '</li>
                                    <li>Purchase orders ' . $g_isse2 . '</li>
                                    <li>Delivery ' . $g_del . '</li>
                                    <li>Distribution ' . $g_e . '</li>
            </ul>
                                </td>
                                <td data-title="Responsibility">' . $departments[$departmentScheme->proc_goods_responsible];
    if ($departmentScheme->designation_step5) {
        $html .= "<br/>(" . $departmentScheme->designation_step5 . ')';
    }
    $html .= '</td>
                                <td data-title="Timeline"><b>';
    $SchemeDistricts = TableRegistry::get('SchemesLogs');
    $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id, 'field_name' => 'proc_goods_compl_date'], 'order' => ['SchemesLogs.id' => 'asc']])->all();
//                                        debug($choosen_nav_districts);
    $cons_Array = array();
    foreach ($choosen_nav_districts as $cons_civil_wor):
//                                            debug($departmentScheme->cons_civil_compl_date);
//                                            debug($cons_civil_wor->answer);
        if (date('Y-m-d', strtotime($departmentScheme->proc_goods_compl_date)) !== $cons_civil_wor->answer) {
            array_push($cons_Array, $cons_civil_wor->answer);
        }

    endforeach;
//                                        debug($cons_Array);
    foreach ($cons_Array as $cons):
        $html .= '<del style="color:red;">' . date('j<\s\up>S</\s\up> F Y', strtotime($cons)) . '</del><br/>';
    endforeach;

    $html .= date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->proc_goods_compl_date));
    $html .= '</b></td>
                                <td data-title="Remarks" style="color:maroon">' . nl2br($departmentScheme->step5_remarks) . '&nbsp;</td>
                                <td data-title="T/L"><img src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $departmentScheme->step5_status . '.PNG"></td>
                            </tr>';
}
if ($departmentScheme->proc_services_required == 'Yes') {

    $html .= '<tr nobr="true">
                                <td data-title="List of Activities"><b>Procurement of Services</b></td>';
    $pc_tender = ($departmentScheme->proc_services_tender_advertised == 'Yes') ? 'complete' : 'incomplete';
    $pc_finance = ($departmentScheme->proc_services_tech_finance_proposal_received == 'Yes') ? 'received ' : 'not received';
    $pc_eval = ($departmentScheme->proc_services_evaluation_process_compl == 'Yes') ? 'complete' : 'incomplete';
    $pc_contr = ($departmentScheme->proc_services_contract_awarded == 'Yes') ? 'awarded' : 'not awarded';
    $pc_status = ($departmentScheme->proc_services_status) ? $departmentScheme->proc_services_status . '%' : 'Not started';
    $html .= '<td data-title="Activity Status"><ul><li>Advertisement ' . $pc_tender . '</li>
                                    <li>Technical/Financial Proposal ' . $pc_finance . '</li>
                                    <li>Evaluation of proposals ' . $pc_eval . '</li>
                                    <li>Contract ' . $pc_contr . '</li>
                                    <li>Completion Status: ' . $pc_status . '</li></ul></td>
                                <td data-title="Responsibility">' . $departments[$departmentScheme->proc_services_responsible];
    if ($departmentScheme->designation_step6) {
        $html .= "<br/>(" . $departmentScheme->designation_step6 . ')';
    }
    $html .= '</td><td data-title="Timeline"><b>';
    $SchemeDistricts = TableRegistry::get('SchemesLogs');
    $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id, 'field_name' => 'proc_services_compl_date'], 'order' => ['SchemesLogs.id' => 'asc']])->all();
//                                        debug($choosen_nav_districts);
    $cons_Array = array();
    foreach ($choosen_nav_districts as $cons_civil_wor):
//                                            debug($departmentScheme->cons_civil_compl_date);
//                                            debug($cons_civil_wor->answer);
        if (date('Y-m-d', strtotime($departmentScheme->proc_services_compl_date)) !== $cons_civil_wor->answer) {
            array_push($cons_Array, $cons_civil_wor->answer);
        }

    endforeach;
//                                        debug($cons_Array);
    foreach ($cons_Array as $cons):
        $html .= '<del style = "color:red;">' . date('j<\s\up>S</\s\up> F Y', strtotime($cons)) . '</del><br/>';
    endforeach;

    $html .= date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->proc_services_compl_date));
    $html .= '</b></td>
                                <td data-title="Remarks" style="color:maroon">' . nl2br($departmentScheme->step6_remarks) . '&nbsp;</td>
                                <td data-title="T/L"><img src = "http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $departmentScheme->step6_status . '.PNG"></td>
</tr>';
}

if ($departmentScheme->cons_civil_work_required == 'Yes') {

    $html .= '<tr nobr="true">
                                <td data-title="List of Activities"><b>Construction/civil works</b></td>
                                <td data-title="Activity Status">
                                    <ul>
                                        <li>Work by C & W: <b>' . $departmentScheme->is_work_carried_by_civil_works . '</b></li>
                                   <li>Work by Other Agency: <b>' . $departmentScheme->is_work_commisioned_privately . '</b></li>
                                    <div style="margin:10px;">';

    if ($departmentScheme->is_work_commisioned_privately == 'Yes') {
        if ($departmentScheme->cons_civil_private_type) {
            $m_array = ['single_source' => 'Single Source', 'open_tender' => 'Open Tendering'];
            $html .= "<li>Work Type: " . $m_array[$departmentScheme->cons_civil_private_type].'</li>';
        }
        if ($departmentScheme->cons_civil_private_type == 'open_tender') {
            $cons_tender = ($departmentScheme->is_work_tender_advertised == 'Yes') ? 'complete ' : 'incomplete';
            $cons_bidding = ($departmentScheme->is_work_bidding_compl == 'Yes') ? 'complete' : 'incomplete';
            $cons_issue = ($departmentScheme->is_work_order_issued == 'Yes') ? 'issued' : 'not issued';
            $html .= '<ul>
                                        <li>Advertisement ' . $cons_tender . '</li>
                                                <li>Bidding ' . $cons_bidding . '</li>
                                                <li>Work Order ' . $cons_issue.'</li></ul>';
        }
    }
    $cons_begin = ($departmentScheme->is_work_begun == 'Yes') ? 'started' : 'not started';
    $html .= '<li>Work ' . $cons_begin . '</li>';
    if ($departmentScheme->is_work_begun == 'Yes') {
        $cons_status = ($departmentScheme->level_of_work_compl) ? $departmentScheme->level_of_work_compl . '%' : 'Not started';
        $html .= '<li>Completion Status:' . $cons_status.'</li>';
    }
    $html .= '</div></ul>

                                </td>
                                <td data-title="Responsibility">' . $departments[$departmentScheme->cons_civil_responsible];
    if ($departmentScheme->designation_step7) {
        $html .= "<br/>(" . $departmentScheme->designation_step7 . ')';
    }
    $html .= '</td> <td data-title="Timeline"><b>';
    $SchemeDistricts = TableRegistry::get('SchemesLogs');
    $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id, 'field_name' => 'cons_civil_compl_date'], 'order' => ['SchemesLogs.id' => 'asc']])->all();
//                                        debug($choosen_nav_districts);
    $cons_Array = array();
    foreach ($choosen_nav_districts as $cons_civil_wor):
//                                            debug($departmentScheme->cons_civil_compl_date);
//                                            debug($cons_civil_wor->answer);
        if (date('Y-m-d', strtotime($departmentScheme->cons_civil_compl_date)) !== $cons_civil_wor->answer) {
            array_push($cons_Array, $cons_civil_wor->answer);
        }

    endforeach;
//                                        debug($cons_Array);
    foreach ($cons_Array as $cons):
        $html .= '<del style="color:red;">' . date('j<\s\up>S</\s\up> F Y', strtotime($cons)) . '</del><br/>';
    endforeach;

    $html .= date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->cons_civil_compl_date));
    $html .= '</b></td>
                                <td data-title="Remarks" style="color:maroon">' . nl2br($departmentScheme->step7_remarks) . '&nbsp;</td>
                                <td data-title="T/L"><img src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $departmentScheme->step7_status . '.PNG"></td>
 </tr>';
}

foreach ($fetch_custom_details as $details):

    $html .= '<tr nobr="true">
                                <td><b>' . ucfirst($details->milestone_name) . '</b></td>
                                <td>' . nl2br(ucfirst($details->way_forward)) . '&nbsp;</td>
                                
                                <td>' . ucfirst($departments[$details->responsibility]) . '</td>
                                <td><b>' . date('j<\s\up>S</\s\up> F Y', strtotime($details->completion_date)) . '</b>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td><img src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $details->milestone_status . '.PNG"> &nbsp;</td>

                            </tr>';
endforeach;

$SchemeDistricts = TableRegistry::get('SchemesLogs');
$choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id], 'order' => ['SchemesLogs.id' => 'DESC']])->first();

$html .= '<tr nobr="true">
                            <td><b>Overall Status</b></td>
                            <td>';
if (file_exists(WWW_ROOT . 'img/scheme_files/' . $departmentScheme->scheme_file) && !empty($departmentScheme->scheme_file)) {

    $html .= '<strong>Existing Evidence: </strong><img src="http://cmdu.kp.gov.pk/portal/img/scheme_files/' . $departmentScheme->scheme_file . '" style="width:100%">';
}
$html .= '&nbsp;</td>
                            <td>&nbsp;</td>
                            <td><b>Updated:';
if (isset($choosen_nav_districts->created)) {
    $html .= date('j<\s\up>S</\s\up> F Y', strtotime($choosen_nav_districts->created));
} else {
    $html .= "-";
}
$html .= '</b></td>
                            <td>' . ucfirst($departmentScheme->final_comments) . '&nbsp;<b>Issue (if any):</b> '.ucfirst($departmentScheme->issues_list).'</td>
                            <td><img src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $departmentScheme->overall_status . '.PNG">&nbsp;</td>

                        </tr>
                        <tr nobr="true">
                            <td><b>Date of completion</b></td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td><span id="date"><b>' . date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->scheme_end_date)) . '</b></span>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>

                        </tr>';

//output the HTML content
//debug($html);
//exit();
$html .= '</table>';

//$html .='<br pagebreak="true"/>';

$html .= '<h4>Scheme Financial Progress Details</h4>
                <table cellpadding="2" cellspacing="0" border="1" style="margin-top:20px;width:100%">
                <tr>
                    <th>Title</th>
                    <th>Departmental Details</th>
                    </tr>
                    <tr nobr="true">
                        <th>Total cost  (in Rs. millions)</th>
                        <td><span>' . number_format($departmentScheme->cost_of_scheme, 3) . '</span></td>
                        
                    </tr>
                    <tr nobr="true">
                        <th>Current allocation  (in Rs. millions)</th>
                        <td><span>' . number_format($departmentScheme->allocation_for_cfy, 3) . '</span></td>
                       
                    </tr>
                    <tr nobr="true">
                        <th>Previous Expenditure (in Rs. millions)</th>
                        <td><span>' . number_format($departmentScheme->expenditure_till_date, 3) . '</span></td>
                        


                    </tr>
                    <tr nobr="true">
                        <th> Releases Current Year (in Rs. millions)</th>
                        <td><span>' . number_format($departmentScheme->release_for_cfy, 3) . '</span></td>
                      
                    </tr>
                    <tr nobr="true">
                        <th>Expenditure Current Year (in Rs. millions)</th>
                        <td><span>' . number_format($departmentScheme->progressive_expenditure, 3) . '</span></td>
                      
                    </tr>
                </table>';
//echo $html;exit;

$tcpdf->writeHTML($html, true, false, true, false, '');

//reset pointer to the last page
//$tcpdf->lastPage();
$tcpdf->Output($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')' . '.pdf', 'D');
exit();
//echo "javascript:history.go(-1);";
?>