<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');
?>

<div class="column-responsive column-80">
    <div class="departmentSchemes col-lg-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <?= $this->element('scheme_status_bar') ?>

                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Is hiring required?') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('hiring_required', ['required', 'class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
                    echo '</div><!--/row-->';
                    ?>

                    <div id='hirig_required_div' style="display:<?= ($departmentScheme->hiring_required == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">
                        <?php
                        $hiring_required = ($departmentScheme->hiring_required == 'Yes') ? 'required' : '';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Is SNE Required?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('sne_required', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $hiring_required]) . '</div>';
                        echo '</div><!--/row-->';
                        ?>
                        <div id='sne_required_div' style="display:<?= ($departmentScheme->sne_required == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">

                            <?php
                            $mnain_required = ($departmentScheme->sne_required == 'Yes') ? 'required' : '';

                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Has SNE been submitted to Finance Department?') . '</label></div>';
                            echo '<div class="col-sm-7">' . $this->Form->control('sne_submitted', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $mnain_required]) . '</div>';
                            echo '</div><!--/row-->';
                            ?>
                            <div id='sne_submitted_no' style="display:<?= ($departmentScheme->sne_submitted == 'No') ? 'block' : 'none'; ?>;margin:20px;">
                                <?php
//                                  debug($departmentScheme->sne_approved);
                                $q3_sne_submitted_no_required = ($departmentScheme->sne_submitted == 'No') ? 'required' : '';

//                                echo $this->Form->hidden('sne_submission_old_date', ['id' => 'sne_submission_old_date', 'value' => ($departmentScheme->sne_submission_date) ? date('d-m-Y', strtotime($departmentScheme->sne_submission_date)) : '']);

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Till when SNE will be submitted?') . '</label></div>';
                                echo '<div class="col-sm-7">';
                                if ($departmentScheme->locked == 'Yes' && $departmentScheme->sne_submission_date) {
                                    if ($myUser->users_roles_id == 'pm') { //cant do anything
                                        //display old date
                                        echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->sne_submission_date));
                                    } else { //cpo
                                        //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                        if ($departmentScheme->mega_project == 'Yes' || $departmentScheme->scheme_category == 'High Priority') {
                                            //cpo cant do anything too-display old date
                                            echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->sne_submission_date));
                                        } else {
                                            //cpo can do and show fields again
                                            echo $this->Form->control('sne_submission_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->sne_submission_date) ? date('d-m-Y', strtotime($departmentScheme->sne_submission_date)) : '', 'label' => false, $q3_sne_submitted_no_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                        }
                                    }
                                } else {
                                    //show fields to change
                                    echo $this->Form->control('sne_submission_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->sne_submission_date) ? date('d-m-Y', strtotime($departmentScheme->sne_submission_date)) : '', 'label' => false, $q3_sne_submitted_no_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                }
//                                if ($departmentScheme->locked == 'Yes' && $departmentScheme->sne_submission_date && $myUser->users_roles_id == 'pm' && $departmentScheme->mega_project == 'No') {
//                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->sne_submission_date));
//                                } else {
////                                    debug($departmentScheme->sne_submission_date);
//                                    echo $this->Form->control('sne_submission_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->sne_submission_date) ? date('d-m-Y', strtotime($departmentScheme->sne_submission_date)) : '', 'label' => false, $q3_sne_submitted_no_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy"]);
//                                }
                                echo '</div>';
                                echo '</div><!--/row-->';
                                ?>
                            </div>

                            <div id='sne_submitted_yes' style="display:<?= ($departmentScheme->sne_submitted == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">

                                <?php
                                $submitted_required = ($departmentScheme->sne_submitted == 'Yes') ? 'required' : '';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the SNE been approved?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('sne_approved', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $submitted_required]) . '</div>';
                                echo '</div><!--/row-->';
                                ?>

                            </div>
                            <div id='q3_sne_no' style="display:<?= ($departmentScheme->sne_approved == 'No') ? 'block' : 'none'; ?>;margin:20px;">
                                <?php
                                $q3_sne_no_required = ($departmentScheme->sne_approved == 'No') ? 'required' : '';

//                                echo $this->Form->hidden('sne_approval_old_date', ['id' => 'sne_approval_old_date', 'value' => date('Y-m-d', strtotime($departmentScheme->sne_approval_date))]);

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Till when SNE will be approved?') . '</label></div>';
                                echo '<div class="col-sm-7">';
                                if ($departmentScheme->locked == 'Yes' && $departmentScheme->sne_approval_date) {
                                    if ($myUser->users_roles_id == 'pm') { //cant do anything
                                        //display old date
                                        echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->sne_approval_date));
                                    } else { //cpo
                                        //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                        if ($departmentScheme->mega_project == 'Yes' || $departmentScheme->scheme_category == 'High Priority') {
                                            //cpo cant do anything too-display old date
                                            echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->sne_approval_date));
                                        } else {
                                            //cpo can do and show fields again
                                            echo $this->Form->control('sne_approval_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->sne_approval_date) ? date('d-m-Y', strtotime($departmentScheme->sne_approval_date)) : '', 'label' => false, $q3_sne_no_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                        }
                                    }
                                } else {
                                    //show fields to change
                                    echo $this->Form->control('sne_approval_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->sne_approval_date) ? date('d-m-Y', strtotime($departmentScheme->sne_approval_date)) : '', 'label' => false, $q3_sne_no_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                }
//                                if ($departmentScheme->locked == 'Yes' && $departmentScheme->sne_approval_date && $myUser->users_roles_id == 'pm' && $departmentScheme->mega_project == 'No') {
//                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->sne_approval_date));
//                                } else {
//                                    echo $this->Form->control('sne_approval_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->sne_approval_date) ? date('d-m-Y', strtotime($departmentScheme->sne_approval_date)) : '', 'label' => false, $q3_sne_no_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy"]);
//                                }
                                echo '</div>';
                                echo '</div><!--/row-->';
                                ?>
                            </div>
                        </div>

                        <div id='q3' style="display:<?= ($departmentScheme->sne_required == 'No' || $departmentScheme->sne_approved == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">

                            <?php
                            $q3_sne_required = ($departmentScheme->sne_required == 'No' || $departmentScheme->sne_approved == 'Yes') ? 'required' : '';

                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Will hiring be done through public service commission? ') . '</label></div>';
                            echo '<div class="col-sm-7">' . $this->Form->control('will_hiring_through_psc', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q3_sne_required]) . '</div>';
                            echo '</div><!--/row-->';
                            ?>
                            <div id="q3_psc" style="display:<?= ($departmentScheme->will_hiring_through_psc == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">
                                <?php
                                $q3_psc_required = ($departmentScheme->will_hiring_through_psc == 'Yes') ? 'required' : '';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Is the hiring been done through public service commission? ') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('hiring_through_psc', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q3_psc_required]) . '</div>';
                                echo '</div><!--/row-->';

//                                echo $this->Form->hidden('hiring_compl_old_date_psc', ['id' => 'hiring_compl_old_date_psc', 'value' => date('Y-m-d', strtotime($departmentScheme->hiring_compl_date_psc))]);

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('What is the expected completion date for hiring through public service commission?') . '</label></div>';
                                echo '<div class="col-sm-7">';
                                if ($departmentScheme->locked == 'Yes' && $departmentScheme->hiring_compl_date_psc) {
                                    if ($myUser->users_roles_id == 'pm') { //cant do anything
                                        //display old date
                                        echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_compl_date_psc));
                                    } else { //cpo
                                        //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                        if ($departmentScheme->mega_project == 'Yes' || $departmentScheme->scheme_category == 'High Priority') {
                                            //cpo cant do anything too-display old date
                                            echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_compl_date_psc));
                                        } else {
                                            //cpo can do and show fields again
                                            echo $this->Form->control('hiring_compl_date_psc', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->hiring_compl_date_psc) ? date('d-m-Y', strtotime($departmentScheme->hiring_compl_date_psc)) : '', 'empty' => true, 'label' => false, $q3_psc_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                        }
                                    }
                                } else {
                                    //show fields to change
                                    echo $this->Form->control('hiring_compl_date_psc', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->hiring_compl_date_psc) ? date('d-m-Y', strtotime($departmentScheme->hiring_compl_date_psc)) : '', 'empty' => true, 'label' => false, $q3_psc_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                }
//                                if ($departmentScheme->locked == 'Yes' && $departmentScheme->hiring_compl_date_psc && $myUser->users_roles_id == 'pm' && $departmentScheme->mega_project == 'No') {
//                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_compl_date_psc));
//                                } else {
//                                    echo $this->Form->control('hiring_compl_date_psc', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->hiring_compl_date_psc) ? date('d-m-Y', strtotime($departmentScheme->hiring_compl_date_psc)) : '', 'empty' => true, 'label' => false, $q3_psc_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy"]);
//                                }
                                echo '</div>';
                                echo '</div><!--/row-->';
                                $departments['Other'] = 'Other';
                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Who is responsible for the hiring process?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('responsible_psc', ['class' => 'form-control', 'label' => false, $q3_psc_required, 'empty' => 'Choose', 'options' => $departments]) . '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5">&nbsp;</div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('designation_step3_psc', ['class' => 'form-control', 'label' => false, 'placeholder' => 'Enter Details like Designation (optional)']) . '</div>';
                                echo '</div><!--/row-->';
                                ?>
                            </div>
                            <?php
                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Will hiring be done through internal posting?') . '</label></div>';
                            echo '<div class="col-sm-7">' . $this->Form->control('will_hiring_through_internal_posting', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q3_sne_required]) . '</div>';
                            echo '</div><!--/row-->';
                            ?>
                            <div id="q3_ip" style="display:<?= ($departmentScheme->will_hiring_through_internal_posting == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">

                                <?php
                                $q3_ip_required = ($departmentScheme->will_hiring_through_internal_posting == 'Yes') ? 'required' : '';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Is the hiring process completed?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('hiring_through_internal_posting', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q3_ip_required]) . '</div>';
                                echo '</div><!--/row-->';

//                                echo $this->Form->hidden('hiring_compl_old_date_internal_posting', ['id' => 'hiring_compl_old_date_internal_posting', 'value' => date('Y-m-d', strtotime($departmentScheme->hiring_compl_date_internal_posting))]);


                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Expected completion date?') . '</label></div>';
                                echo '<div class="col-sm-7">';
                                if ($departmentScheme->locked == 'Yes' && $departmentScheme->hiring_compl_date_internal_posting) {
                                    if ($myUser->users_roles_id == 'pm') { //cant do anything
                                        //display old date
                                        echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_compl_date_internal_posting));
                                    } else { //cpo
                                        //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                        if ($departmentScheme->mega_project == 'Yes' || $departmentScheme->scheme_category == 'High Priority') {
                                            //cpo cant do anything too-display old date
                                            echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_compl_date_internal_posting));
                                        } else {
                                            //cpo can do and show fields again
                                            echo $this->Form->control('hiring_compl_date_internal_posting', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->hiring_compl_date_internal_posting) ? date('d-m-Y', strtotime($departmentScheme->hiring_compl_date_internal_posting)) : '', 'empty' => true, 'label' => false, $q3_ip_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                        }
                                    }
                                } else {
                                    //show fields to change
                                    echo $this->Form->control('hiring_compl_date_internal_posting', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->hiring_compl_date_internal_posting) ? date('d-m-Y', strtotime($departmentScheme->hiring_compl_date_internal_posting)) : '', 'empty' => true, 'label' => false, $q3_ip_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                }
//                                if ($departmentScheme->locked == 'Yes' && $departmentScheme->hiring_compl_date_internal_posting && $myUser->users_roles_id == 'pm' && $departmentScheme->mega_project == 'No') {
//                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_compl_date_internal_posting));
//                                } else {
//                                    echo $this->Form->control('hiring_compl_date_internal_posting', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->hiring_compl_date_internal_posting) ? date('d-m-Y', strtotime($departmentScheme->hiring_compl_date_internal_posting)) : '', 'empty' => true, 'label' => false, $q3_ip_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy"]);
//                                }
                                echo '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Who is responsible for the internal hiring process?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('responsible_internal_posting', ['class' => 'form-control', 'label' => false, $q3_ip_required, 'empty' => 'Choose', 'options' => $departments]) . '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5">&nbsp;</div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('designation_step3_ip', ['class' => 'form-control', 'label' => false, 'placeholder' => 'Enter Details like Designation (optional)']) . '</div>';
                                echo '</div><!--/row-->';
                                ?>
                            </div>
                            <?php
                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Will hiring be done through the market/project policy/any other agency (please mention details in additional comments)?') . '</label></div>';
                            echo '<div class="col-sm-7">' . $this->Form->control('will_hiring_through_market', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q3_sne_required]) . '</div>';
                            echo '</div><!--/row-->';
                            ?>
                            <div id="q3_m" style="display:<?= ($departmentScheme->will_hiring_through_market == 'Yes') ? 'block' : 'none'; ?>;margin:20px;">

                                <?php
                                $q3_m_required = ($departmentScheme->will_hiring_through_market == 'Yes') ? 'required' : '';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Is the hiring been done through the market/project policy/any other agency?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('hiring_through_market', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q3_m_required]) . '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the position been advertised in social and traditional media?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('posting_though_market_media', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q3_m_required]) . '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Have entries from interested candidates been recorded?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('hiring_market_entries_recorded', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q3_m_required]) . '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Is scrutiny and shortlisting of candidates complete?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('hiring_market_scrutiny_compl', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q3_m_required]) . '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Have the interviews been conducted?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('hiring_market_intervies_cond', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q3_m_required]) . '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Have the appointment letters been issues?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('hiring_market_appoint_letter_issues', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $q3_m_required]) . '</div>';
                                echo '</div><!--/row-->';

//                                echo $this->Form->hidden('hiring_market_old_compl_date', ['id' => 'hiring_market_old_compl_date', 'value' => date('Y-m-d', strtotime($departmentScheme->hiring_market_compl_date))]);


                                echo '<div class="row"><div class="col-sm-5"><label>' . __('What is the completion date for hiring through the market?') . '</label></div>';
                                echo '<div class="col-sm-7">';
                                if ($departmentScheme->locked == 'Yes' && $departmentScheme->hiring_market_compl_date) {
                                    if ($myUser->users_roles_id == 'pm') { //cant do anything
                                        //display old date
                                        echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_market_compl_date));
                                    } else { //cpo
                                        //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                        if ($departmentScheme->mega_project == 'Yes' || $departmentScheme->scheme_category == 'High Priority') {
                                            //cpo cant do anything too-display old date
                                            echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_market_compl_date));
                                        } else {
                                            //cpo can do and show fields again
                                            echo $this->Form->control('hiring_market_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->hiring_market_compl_date) ? date('d-m-Y', strtotime($departmentScheme->hiring_market_compl_date)) : '', 'empty' => true, 'label' => false, $q3_m_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                        }
                                    }
                                } else {
                                    //show fields to change
                                    echo $this->Form->control('hiring_market_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->hiring_market_compl_date) ? date('d-m-Y', strtotime($departmentScheme->hiring_market_compl_date)) : '', 'empty' => true, 'label' => false, $q3_m_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                }
//                                if ($departmentScheme->locked == 'Yes' && $departmentScheme->hiring_market_compl_date && $myUser->users_roles_id == 'pm' && $departmentScheme->mega_project == 'No') {
//                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_market_compl_date));
//                                } else {
//                                    echo $this->Form->control('hiring_market_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->hiring_market_compl_date) ? date('d-m-Y', strtotime($departmentScheme->hiring_market_compl_date)) : '', 'empty' => true, 'label' => false, $q3_m_required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy"]);
//                                }
                                echo '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5"><label>' . __('Who is responsible for hiring through the market?') . '</label></div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('hiring_market_respons_person', ['class' => 'form-control', 'label' => false, $q3_m_required, 'empty' => 'Choose', 'options' => $departments]) . '</div>';
                                echo '</div><!--/row-->';

                                echo '<div class="row"><div class="col-sm-5">&nbsp;</div>';
                                echo '<div class="col-sm-7">' . $this->Form->control('designation_step3_market', ['class' => 'form-control', 'label' => false, 'placeholder' => 'Enter Details like Designation (optional)']) . '</div>';
                                echo '</div><!--/row-->';
                                ?>
                            </div>
                        </div>    

                        <?php
                        echo $this->Form->control('step3_old_remarks', ['value' => $departmentScheme->step3_remarks, 'type' => 'hidden']);

                        echo '<div class="row"><div class="col-sm-5"><label>Additional Comments</label><br/><small>(You can add your weekly updates here in this section too). </small></div>';

                        echo '<div class="col-sm-7">' . $this->Form->control('step3_remarks', ['class' => 'form-control', 'label' => false, 'placeholder' => '(Optional)']) . '</div>';
                        echo '</div><!--/row-->';
                        ?>
                    </div>


                    <?php
                    echo $this->Form->hidden('steps_array[1]', ['value' => $departmentScheme->step1_status]);
                    echo $this->Form->hidden('steps_array[2]', ['value' => $departmentScheme->step2_status]);
                    echo $this->Form->hidden('steps_array[3]', ['value' => $departmentScheme->step3_status]);
                    echo $this->Form->hidden('steps_array[4]', ['value' => $departmentScheme->step4_status]);
                    echo $this->Form->hidden('steps_array[5]', ['value' => $departmentScheme->step5_status]);
                    echo $this->Form->hidden('steps_array[6]', ['value' => $departmentScheme->step6_status]);
                    echo $this->Form->hidden('steps_array[7]', ['value' => $departmentScheme->step7_status]);
                    echo $this->Form->hidden('steps_array[8]', ['value' => $departmentScheme->custom_status]);
                    ?>

                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <a class="btn btn-primary pull-left" 
                   href="<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/step2/<?php echo $departmentScheme->id; ?>">
                    <i aria-hidden="true" class="fas fa-arrow-left"></i> Previous </a>
                <center>
                    <?php //echo '<strong>Milstones Status </strong><br/><img src="' . $this->request->getAttribute("webroot") . 'img/status.PNG" style="max-height:100px">';             ?>
                    <?php
                    if ($departmentScheme->locked && $departmentScheme->hiring_required == 'Yes' && $departmentScheme->mega_project == 'Yes') {
                        if ($schemeRequests == 0) {
                            ?>
                            <a class="modal-with-form" href="#modalForm">Request Change for Expected Completion Date of the Hiring Process?</a>
                            <?php
                        } else {
                            echo "Request already pending to change date.";
                        }
                    }
                    ?>
                </center>
                <button class="btn btn-primary" type="submit">Next <i aria-hidden="true" class="fas fa-arrow-right"></i></button>
                    <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>
<script>

    $(function () {

//        $('body').on('change', '#sne-approval-date', function () {
//
//            if ($('#sne_approval_old_date').val() !== '1970-01-01' && $('#sne_approval_old_date').val().trim() !== '') {
////                alert($('#pc2_compl_old_date').val());
//                if ($(this).val() !== $('#sne_approval_old_date').val()) {
//                    alert('Oops, it looks you have changed the SNE approval date, CMDU will get informed about this change.');
//                }
//            }
//        });
//
//        $('body').on('change', '#hiring-compl-date-psc', function () {
//
//            if ($('#hiring_compl_old_date_psc').val() !== '1970-01-01' && $('#hiring_compl_old_date_psc').val().trim() !== '') {
////                alert($('#pc2_compl_old_date').val());
//                if ($(this).val() !== $('#hiring_compl_old_date_psc').val()) {
//                    alert('Oops, it looks you have changed the hiring completion date for public service commision, CMDU will get informed about this change.');
//                }
//            }
//        });
//
//        $('body').on('change', '#hiring-compl-date-internal-posting', function () {
//
//            if ($('#hiring_compl_old_date_internal_posting').val() !== '1970-01-01' && $('#hiring_compl_old_date_internal_posting').val().trim() !== '') {
////                alert($('#pc2_compl_old_date').val());
//                if ($(this).val() !== $('#hiring_compl_old_date_internal_posting').val()) {
//                    alert('Oops, it looks you have changed the internal porting date, CMDU will get informed about this change.');
//                }
//            }
//        });

//        $('body').on('change', '#hiring-market-compl-date', function () {
//
//            if ($('#hiring_market_old_compl_date').val() !== '1970-01-01' && $('#hiring_market_old_compl_date').val().trim() !== '') {
////                alert($('#pc2_compl_old_date').val());
//                if ($(this).val() !== $('#hiring_market_old_compl_date').val()) {
//                    alert('Oops, it looks you have changed the market hiring completion date, CMDU will get informed about this change.');
//                }
//            }
//        });


        //q3
        $('body').on('change', '#hiring-required', function () {
            if ($(this).val() == 'Yes') {

                $('#hirig_required_div').show('slow');
                $('#hirig_required_div').find('input').attr('required', true);
                $('#hirig_required_div').find('select').attr('required', true);

            } else {

                $('#hirig_required_div').hide('slow');

                $('#hirig_required_div').find('input').attr('required', false);
                $('#hirig_required_div').find('select').attr('required', false);
                $('#hirig_required_div').find('input').val('');
                $('#hirig_required_div').find('select').val('');
            }


        });

        $('body').on('change', '#sne-required', function () {
            if ($(this).val() == 'Yes') {
                $('#sne_required_div').show('slow');

                $('#sne_required_div').find('input').attr('required', true);
                $('#sne_required_div').find('select').attr('required', true);


                $('#q3').find('input').attr('required', false);
                $('#q3').find('select').attr('required', false);
                $('#q3').find('input').val('');
                $('#q3').find('select').val('');

                $('#q3').hide('slow');
            } else {
                $('#sne_required_div').find('input').attr('required', false);
                $('#sne_required_div').find('select').attr('required', false);
                $('#sne_required_div').find('input').val('');
                $('#sne_required_div').find('select').val('');

                $('#sne_required_div').hide('slow');

                $('#sne_submitted').hide('slow');

                $('#q3').show('slow');

                $('#q3').find('input').attr('required', true);
                $('#q3').find('select').attr('required', true);

                if ($('#will-hiring-through-psc').val() == 'No') {
                    $('#q3_psc').find('input').attr('required', false);
                    $('#q3_psc').find('select').attr('required', false);
                    $('#q3_psc').find('input').val('');
                    $('#q3_psc').find('select').val('');
                }
                if ($('#will-hiring-through-internal-posting').val() == 'No') {
                    $('#q3_ip').find('input').attr('required', false);
                    $('#q3_ip').find('select').attr('required', false);
                    $('#q3_ip').find('input').val('');
                    $('#q3_ip').find('select').val('');
                }
                if ($('#will-hiring-through-market').val() == 'No') {
                    $('#q3_m').find('input').attr('required', false);
                    $('#q3_m').find('select').attr('required', false);
                    $('#q3_m').find('input').val('');
                    $('#q3_m').find('select').val('');
                }

            }
            $('#designation-step3-psc').attr('required', false);
            $('#designation-step3-ip').attr('required', false);
            $('#designation-step3-market').attr('required', false);

        });

        $('body').on('change', '#sne-submitted', function () {
            if ($(this).val() == 'Yes') {
//                    alert('q1');
                $('#sne_submitted_yes').show('slow');

                $('#sne_submitted_yes').find('input').attr('required', true);
                $('#sne_submitted_yes').find('select').attr('required', true);

                $('#sne_submitted_no').hide('slow');
                $('#sne_submitted_no').find('input').attr('required', false);


                //why this below was written?

//                $('#q3_sne').find('input').attr('required', false);
//                $('#q3_sne').find('select').attr('required', false);
//                $('#q3_sne').find('input').val('');
//                $('#q3_sne').find('select').val('');


            } else if ($(this).val() == 'No') {
                $('#sne_submitted_yes').find('input').attr('required', false);
                $('#sne_submitted_yes').find('select').attr('required', false);
                $('#sne_submitted_yes').find('input').val('');
                $('#sne_submitted_yes').find('select').val('');

                $('#sne_submitted_yes').hide('slow');

                $('#sne_submitted_no').show('slow');
                $('#sne_submitted_no').find('input').attr('required', true);

                $('#q3_sne_no').find('input').attr('required', false);
            }

//            else {
//                $('#q3_submitted').find('input').attr('required', false);
//                $('#q3_submitted').find('select').attr('required', false);
//                $('#q3_q3_submittedsne').find('input').val('');
//                $('#q3_q3_submittedsne').find('select').val('');
//
//                $('#q3_submitted').hide('slow');
//
//                $('#q3_sne_no').hide('slow');
//                $('#q3_sne_no').find('input').attr('required', false);
//            }
//            $('#designation-step3-psc').attr('required', false);
//            $('#designation-step3-ip').attr('required', false);
//            $('#designation-step3-market').attr('required', false);
        });

        //q3_sne
        $('body').on('change', '#sne-approved', function () {
            if ($(this).val() == 'Yes') {
//                    alert('q1');
                $('#q3').show('slow');

                $('#q3').find('input').attr('required', true);
                $('#q3').find('select').attr('required', true);


                $('#q3_sne_no').hide('slow');
                $('#q3_sne_no').find('input').attr('required', false);

                $('#q3_psc').hide();
                $('#q3_ip').hide();
                $('#q3_m').hide();


//                $('#q3_sne_no').hide('slow');
//                $('#q3_sne_no').find('input').attr('required', false);
//                $('#q3_psc').hide('slow');


                //why this below was written?

//                $('#q3_sne').find('input').attr('required', false);
//                $('#q3_sne').find('select').attr('required', false);
//                $('#q3_sne').find('input').val('');
//                $('#q3_sne').find('select').val('');


            } else if ($(this).val() == 'No') {
                $('#q3').find('input').attr('required', false);
                $('#q3').find('select').attr('required', false);
                $('#q3').find('input').val('');
                $('#q3').find('select').val('');

                $('#q3').hide('slow');

                $('#q3_sne_no').show('slow');
                $('#q3_sne_no').find('input').attr('required', true);
            }

//        else {
//                $('#q3_sne').find('input').attr('required', false);
//                $('#q3_sne').find('select').attr('required', false);
//                $('#q3_sne').find('input').val('');
//                $('#q3_sne').find('select').val('');
//
//                $('#q3_sne').hide('slow');
//
//                $('#q3_sne_no').hide('slow');
//                $('#q3_sne_no').find('input').attr('required', false);
//            }
//            $('#designation-step3-psc').attr('required', false);
//            $('#designation-step3-ip').attr('required', false);
//            $('#designation-step3-market').attr('required', false);
        });


        $('body').on('change', '#will-hiring-through-psc', function () {
            if ($(this).val() == 'Yes') {
                $('#q3_psc').show('slow');

                $('#q3_psc').find('input').attr('required', true);
                $('#q3_psc').find('select').attr('required', true);

                $('#responsible-psc option')
                        .filter(function () {
                            return $.trim($(this).text()) == 'Establishment';
                        })
                        .attr('selected', true);
            } else {
                $('#q3_psc').find('input').attr('required', false);
                $('#q3_psc').find('select').attr('required', false);
                $('#q3_psc').find('input').val('');
                $('#q3_psc').find('select').val('');

                $('#q3_psc').hide('slow');

            }

            $('#designation-step3-psc').attr('required', false);
            $('#designation-step3-ip').attr('required', false);
            $('#designation-step3-market').attr('required', false);
        });

        $('body').on('change', '#will-hiring-through-internal-posting', function () {
            if ($(this).val() == 'Yes') {
                $('#q3_ip').show('slow');

                $('#q3_ip').find('input').attr('required', true);
                $('#q3_ip').find('select').attr('required', true);
                $('#responsible-internal-posting').val(<?= $departmentScheme->department_id ?>);
            } else {
                $('#q3_ip').find('input').attr('required', false);
                $('#q3_ip').find('select').attr('required', false);
                $('#q3_ip').find('input').val('');
                $('#q3_ip').find('select').val('');

                $('#q3_ip').hide('slow');

            }

            $('#designation-step3-psc').attr('required', false);
            $('#designation-step3-ip').attr('required', false);
            $('#designation-step3-market').attr('required', false);
        });

        $('body').on('change', '#will-hiring-through-market', function () {
            if ($(this).val() == 'Yes') {
                $('#q3_m').show('slow');


                $('#q3_m').find('input').attr('required', true);
                $('#q3_m').find('select').attr('required', true);
                $('#hiring-market-respons-person').val(<?= $departmentScheme->department_id ?>);

            } else {
                $('#q3_m').find('input').attr('required', false);
                $('#q3_m').find('select').attr('required', false);
                $('#q3_m').find('input').val('');
                $('#q3_m').find('select').val('');

                $('#q3_m').hide('slow');

            }
            $('#designation-step3-psc').attr('required', false);
            $('#designation-step3-ip').attr('required', false);
            $('#designation-step3-market').attr('required', false);
        });

        $('form').on('submit', function () {

            if ($('#hiring-required').val() == 'Yes' && $('#will-hiring-through-psc').val() == 'No' && $('#will-hiring-through-internal-posting').val() == 'No' && $('#will-hiring-through-market').val() == 'No') {
                alert('Warning: You must choose a hiring procedure, else you can not proceed.');
                return false;
            }

        });
    }
    );
</script>
