<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');
?>

<div class="column-responsive column-80">
    <div class="departmentSchemes col-lg-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __(ucfirst($departmentScheme->scheme_code . '-' . $departmentScheme->scheme_name) . ' (' . $departmentScheme->scheme_type . ')') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <?= $this->element('scheme_status_bar') ?>

                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Is procurement of services required?') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('proc_services_required', ['required', 'class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
                    echo '</div><!--/row-->';
                    ?>
                    <div id="q6" style="display:<?= ($departmentScheme->proc_services_required == 'Yes') ? 'block' : 'none'; ?>; margin:20px;">
                        <?php
                        $required = ($departmentScheme->proc_services_required == 'Yes') ? 'required' : '';


                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the tender been advertised?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_services_tender_advertised', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the technical and financial proposal been received?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_services_tech_finance_proposal_received', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Is evaluation of proposals complete?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_services_evaluation_process_compl', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the contract been awarded?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_services_contract_awarded', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('What is the completion status of the provision of service?') . '</label></div>';
                        $prog = array();
                        for ($i = 0; $i <= 100;):
//                            array_push($prog, $i);
                            $prog[$i] = $i;

                            $i = $i + 5;
                        endfor;
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_services_status', ['class' => 'form-control', 'label' => false, 'empty' => 'Choose', 'options' => $prog, $required]) . '</div>';
                        echo '</div><!--/row-->';

//                        echo $this->Form->hidden('proc_services_old_compl_date', ['id' => 'proc_services_old_compl_date', 'value' => date('Y-m-d', strtotime($departmentScheme->proc_services_compl_date))]);


                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Expected completion date for procurement of services?') . '</label></div>';
                        echo '<div class="col-sm-7">';
                        if ($departmentScheme->locked == 'Yes' && $departmentScheme->proc_services_compl_date) {
                            if ($myUser->users_roles_id == 'pm') { //cant do anything
                                //display old date
                                echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->proc_services_compl_date));
                            } else { //cpo
                                //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                if ($departmentScheme->mega_project == 'Yes' || $departmentScheme->scheme_category == 'High Priority') {
                                    //cpo cant do anything too-display old date
                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->proc_services_compl_date));
                                } else {
                                    //cpo can do and show fields again
                                    echo $this->Form->control('proc_services_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'empty' => true, 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($departmentScheme->proc_services_compl_date) ? date('d-m-Y', strtotime($departmentScheme->proc_services_compl_date)) : '', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                }
                            }
                        } else {
                            //show fields to change
                            echo $this->Form->control('proc_services_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'empty' => true, 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($departmentScheme->proc_services_compl_date) ? date('d-m-Y', strtotime($departmentScheme->proc_services_compl_date)) : '', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                        }

//                        if ($departmentScheme->locked == 'Yes' && $departmentScheme->proc_services_compl_date && $myUser->users_roles_id == 'pm' && $departmentScheme->mega_project == 'No') {
//                            echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->proc_services_compl_date));
//                        } else {
//                            echo $this->Form->control('proc_services_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'empty' => true, 'label' => false, $required, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'value' => ($departmentScheme->proc_services_compl_date) ? date('d-m-Y', strtotime($departmentScheme->proc_services_compl_date)) : '']);
//                        }
                        echo '</div>';
                        echo '</div><!--/row-->';
                        $departments['Other'] = 'Other';
                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Who is responsible for the procurement of services?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('proc_services_responsible', ['class' => 'form-control', 'label' => false, $required, 'empty' => 'Choose', 'options' => $departments]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5">&nbsp;</div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('designation_step6', ['class' => 'form-control', 'label' => false, 'placeholder' => 'Enter Details like Designation (optional)']) . '</div>';
                        echo '</div><!--/row-->';

                        echo $this->Form->control('step6_old_remarks', ['value' => $departmentScheme->step6_remarks, 'type' => 'hidden']);

                        echo '<div class="row"><div class="col-sm-5"><label>Additional Comments</label><br/><small>(You can add your weekly updates here in this section too). </small></div>';

                        echo '<div class="col-sm-7">' . $this->Form->control('step6_remarks', ['class' => 'form-control', 'label' => false, 'placeholder' => '(Optional)']) . '</div>';
                        echo '</div><!--/row-->';
                        ?>
                    </div>
                    <?php
                    echo $this->Form->hidden('steps_array[1]', ['value' => $departmentScheme->step1_status]);
                    echo $this->Form->hidden('steps_array[2]', ['value' => $departmentScheme->step2_status]);
                    echo $this->Form->hidden('steps_array[3]', ['value' => $departmentScheme->step3_status]);
                    echo $this->Form->hidden('steps_array[4]', ['value' => $departmentScheme->step4_status]);
                    echo $this->Form->hidden('steps_array[5]', ['value' => $departmentScheme->step5_status]);
                    echo $this->Form->hidden('steps_array[6]', ['value' => $departmentScheme->step6_status]);
                    echo $this->Form->hidden('steps_array[7]', ['value' => $departmentScheme->step7_status]);
                    echo $this->Form->hidden('steps_array[8]', ['value' => $departmentScheme->custom_status]);
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <a class="btn btn-primary pull-left" 
                   href="<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/step5/<?php echo $departmentScheme->id; ?>">
                    <i aria-hidden="true" class="fas fa-arrow-left"></i> Previous </a>
                <center>
                    <?php //echo '<strong>Milstones Status </strong><br/><img src="' . $this->request->getAttribute("webroot") . 'img/status.PNG" style="max-height:100px">';       ?>
                    <?php
                    if ($departmentScheme->locked == 'Yes' && $departmentScheme->proc_services_required == 'Yes' && $departmentScheme->mega_project == 'Yes') {
                        if ($schemeRequests == 0) {
                            ?>
                            <a class="modal-with-form" href="#modalForm">Request Change for Expected Completion Date of the procurement of services Process?</a>
                            <?php
                        } else {
                            echo "Request already pending to change date.";
                        }
                    }
                    ?>
                </center>
                <button class="btn btn-primary" type="submit">Next <i aria-hidden="true" class="fas fa-arrow-right"></i></button>
                    <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>
<script>

    $(function () {

        //q6
        $('body').on('change', '#proc-services-required', function () {
            if ($(this).val() == 'Yes') {
//                    alert('q1');
                $('#q6').show('slow');
                $('#q6').find('input').attr('required', true);
                $('#q6').find('select').attr('required', true);
                $('#proc-services-responsible').val(<?= $departmentScheme->department_id ?>);
            } else {
                $('#q6').find('input').attr('required', false);
                $('#q6').find('select').attr('required', false);
                $('#q6').find('input').val('');
                $('#q6').find('select').val('');


                $('#q6').hide('slow');
            }
            $('#designation-step6').attr('required', false);

        });

//        $('body').on('change', '#proc-services-compl-date', function () {
//
//            if ($('#proc_services_old_compl_date').val() !== '1970-01-01' && $('#proc_services_old_compl_date').val().trim() !== '') {
////                alert($('#pc2_compl_old_date').val());
//                if ($(this).val() !== $('#proc_services_old_compl_date').val()) {
//                    alert('Oops, it looks you have changed the completion date, CMDU will get informed about this change.');
//                }
//            }
//        });

    });
</script>
