<?php

declare(strict_types = 1);

namespace App\Controller\Admin;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;

//use Cake\Mailer\Email;

/**
 * Districts Controller
 *
 * @property \App\Model\Table\DistrictsTable $Districts
 * @method \App\Model\Entity\District[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class DistrictsController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        //$this->Auth->allow(['index']);
        if ($this->Authentication->getResult()->getData() && in_array($this->Authentication->getResult()->getData()->users_roles_id, ['cpo', 'pm', 'chief'])) {
            if (in_array($this->getRequest()->getParam('action'), ['view'])) {

                $this->Flash->error(__('Oops, you are not allowed that location'));

                $this->redirect(['controller' => 'Users', 'action' => 'view']);
            }
        }
    }

    public function beforeFilter(\Cake\Event\EventInterface $event) {
        parent::beforeFilter($event);
        // Configure the login action to not require authentication, preventing
        // the infinite redirect loop issue
//        $this->Authentication->addUnauthenticatedActions([]);
        $this->Authentication->addUnauthenticatedActions(['view']);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index() {
        $cond = array();
        $cond[] = ['Districts.deleted' => 0];

        if (isset($_GET['name']) && $_GET['name'] !== '') {
            $cond[] = ['Districts.name like' => '%' . $_GET['name'] . '%'];
        }
        $this->paginate = [
//            'contain' => ['UsersRoles'],
            'conditions' => $cond,
            'order' => ['name'],
            'limit' => 50
        ];
        $districts = $this->paginate($this->Districts);

        $this->set(compact('districts'));
    }

    /**
     * View method
     *
     * @param string|null $id District id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
//        $district = $this->Districts->get($id, [
//            'contain' => ['SchemeDistricts'],
//        ]);
        $district = $this->Districts->find('all', ['conditions' => ['Districts.name' => $id]])->first();
//        debug();
        $connection = ConnectionManager::get('default');
//        $statement = $connection->execute(
//                        'SELECT * FROM table WHERE table.id = :id', ['id' => $id]
//                )->fetchAll('assoc');

        $statement = $connection->execute(
                        'SELECT department_scheme_id FROM `scheme_districts` s where s.district_id = :id and s.`department_scheme_id`  not in (select si.`department_scheme_id` '
                        . 'from scheme_districts si where si.`district_id` <> :id)', ['id' => $district->id]
                )->fetchAll('assoc');

//        debug($statement);
        
        $fresh_array=array();
        foreach($statement as $st):
//            debug($st['department_scheme_id']);
            array_push($fresh_array, $st['department_scheme_id']);
        endforeach;

        $this->viewBuilder()->setLayout('default-public');

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0],
                    'contain' => ['DepartmentSchemes' => ['conditions' => ['deleted' => 0, 'DepartmentSchemes.id in ' => $fresh_array]]]
                ])->all();
//        debug($departments);
        $this->set(compact('departments'));
//        exit;
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add() {
        $district = $this->Districts->newEmptyEntity();
        if ($this->request->is('post')) {

            if (isset($this->request->getData()['type'])) {
//                debug($this->request->getData());
//                exit;

                $district = $this->Districts->patchEntity($district, $this->request->getData());
                $district->type = implode(',', $this->request->getData()['type']);
                $district->created_by = $this->request->getAttribute('identity')->getIdentifier();
                $district->modified_by = $this->request->getAttribute('identity')->getIdentifier();
                if ($this->Districts->save($district)) {
                    $this->Flash->success(__('The district has been saved.'));

                    return $this->redirect(['action' => 'index']);
                }
                $this->Flash->error(__('The district could not be saved. Please, try again.'));
            } else {
                $this->Flash->error(__('You must choose 1 district type'));
            }
        }
        $this->set(compact('district'));
    }

    /**
     * Edit method
     *
     * @param string|null $id District id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null) {
        $district = $this->Districts->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            if (isset($this->request->getData()['type'])) {

                $district = $this->Districts->patchEntity($district, $this->request->getData());
                $district->type = implode(',', $this->request->getData()['type']);

                $district->modified_by = $this->request->getAttribute('identity')->getIdentifier();

                if ($this->Districts->save($district)) {
                    $this->Flash->success(__('The district has been saved.'));

                    return $this->redirect(['action' => 'index']);
                }
                $this->Flash->error(__('The district could not be saved. Please, try again.'));
            } else {
                $this->Flash->error(__('You must choose 1 district type'));
            }
        }
        $this->set(compact('district'));
    }

    /**
     * Delete method
     *
     * @param string|null $id District id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
        $this->request->allowMethod(['post', 'delete']);
        $district = $this->Districts->get($id);

//        if ($this->Districts->delete($district)) {

        $mUserData['deleted'] = '1';

        //$mUserData['password'] = 'deleted_'. $user['password'];

        $district = $this->Districts->patchEntity($district, $mUserData);
        if ($this->Districts->save($district)) {

            $this->Flash->success(__('The district has been deleted.'));
        } else {
            $this->Flash->error(__('The district could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

}
