<?php

declare(strict_types = 1);

namespace App\Controller\Admin;

use App\Controller\AppController;

/**
 * SchemeStatuses Controller
 *
 * @property \App\Model\Table\SchemeStatusesTable $SchemeStatuses
 * @method \App\Model\Entity\SchemeStatus[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class SchemeStatusesController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        //$this->Auth->allow(['index']);
        if ($this->Authentication->getResult()->getData() && $this->Authentication->getResult()->getData()->users_roles_id == 'cpo') {
            $this->Flash->error(__('Oops, you are not allowed that location'));

            $this->redirect(['controller' => 'Users', 'action' => 'view', 'prefix' => false]);
        }
    }

    public function beforeFilter(\Cake\Event\EventInterface $event) {
        parent::beforeFilter($event);
        // Configure the login action to not require authentication, preventing
        // the infinite redirect loop issue
        $this->Authentication->addUnauthenticatedActions([]);
    }

    public function costreport() {
        
    }

    public function notifications() {
        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['conditions' => ['deleted' => 0], 'order' => ['department_name' => 'asc']])->all()->toArray();

        $cond = array();
//        $cond[] = ['DepartmentSchemes.deleted' => 0];
        $cond[] = ['SchemesLogs.answer NOT IN' => ['', '1970-01-01']];
        $cond[] = ['SchemesLogs.field_name NOT IN' => ['step_name','department_scheme_id']];


        if (isset($_GET['department'])) {
            $cond[] = ['SchemesLogs.department_id IN' => $_GET['department']];
        }
        if (isset($_GET['start']) && $_GET['start'] !== '') {
            $cond[] = ['SchemesLogs.created >' => date('Y-m-d', strtotime($_GET['start'])) . ' 00:00:00'];
        } else {
            $cond[] = ['SchemesLogs.created >' => date('Y-m-d') . ' 00:00:00'];
        }
        if (isset($_GET['end']) && $_GET['end'] !== '') {
            $cond[] = ['SchemesLogs.created <' => date('Y-m-d', strtotime($_GET['end'])) . ' 23:59:59'];
        } else {
            $cond[] = ['SchemesLogs.created <' => date('Y-m-d') . ' 23:59:59'];
        }


        $this->loadModel('SchemesLogs');
        $logs = $this->SchemesLogs->find('all', ['conditions' => $cond, 'contain' => ['Departments', 'DepartmentSchemes']])->all();
        $this->set(compact('logs', 'departments'));
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index() {
        $this->paginate = [
//            'contain' => ['UsersRoles'],
            'conditions' => ['SchemeStatuses.deleted' => 0],
//            'order' => ['name']
        ];
        $schemeStatuses = $this->paginate($this->SchemeStatuses);

        $this->set(compact('schemeStatuses'));
    }

    /**
     * View method
     *
     * @param string|null $id Scheme Status id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
        $schemeStatus = $this->SchemeStatuses->get($id, [
            'contain' => ['DepartmentSchemes'],
        ]);

        $this->set(compact('schemeStatus'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add() {
        $schemeStatus = $this->SchemeStatuses->newEmptyEntity();
        if ($this->request->is('post')) {
            $mValidated = true;
            $mPostData = $this->request->getData();
            unset($mPostData['status_color_pattern']);
            $schemeStatus = $this->SchemeStatuses->patchEntity($schemeStatus, $mPostData);

            if ($this->request->getData()['status_color_pattern']->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $this->request->getData()['status_color_pattern']->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'status_patterns' . DS . $new_name;
                    $image = $this->request->getData()['status_color_pattern'];
                    $image->moveTo($path);
                    $schemeStatus->status_color_pattern = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                $schemeStatus->status_color_pattern = '';
            }
            if ($mValidated == true) {
                $schemeStatus->created_by = $this->request->getAttribute('identity')->getIdentifier();
                $schemeStatus->modified_by = $this->request->getAttribute('identity')->getIdentifier();

                if ($this->SchemeStatuses->save($schemeStatus)) {
                    $this->Flash->success(__('The scheme status has been saved.'));

                    return $this->redirect(['action' => 'index']);
                }
            }
            $this->Flash->error(__('The scheme status could not be saved. Please, try again.'));
        }
        $this->set(compact('schemeStatus'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Scheme Status id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null) {
        $schemeStatus = $this->SchemeStatuses->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $mValidated = true;

            //password
            $mPostData = $this->request->getData();
            unset($mPostData['status_color_pattern']);
            $schemeStatus = $this->SchemeStatuses->patchEntity($schemeStatus, $mPostData);
            $image = $this->request->getData()['status_color_pattern'];

            if ($image->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $image->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'status_patterns' . DS . $new_name;
                    $image->moveTo($path);
                    $schemeStatus->status_color_pattern = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                unset($schemeStatus->status_color_pattern);
            }
//            debug($schemeStatus);
//            exit;
            if ($mValidated == true) {
                $schemeStatus->modified_by = $this->request->getAttribute('identity')->getIdentifier();
                if ($this->SchemeStatuses->save($schemeStatus)) {
                    $this->Flash->success(__('The scheme status has been saved.'));

                    return $this->redirect(['action' => 'index']);
                }
            }
            $this->Flash->error(__('The scheme status could not be saved. Please, try again.'));
        }
        $this->set(compact('schemeStatus'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Scheme Status id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
        $this->request->allowMethod(['post', 'delete']);
        $schemeStatus = $this->SchemeStatuses->get($id);

//        if ($this->SchemeStatuses->delete($schemeStatus)) {

        $mUserData['deleted'] = '1';

        //$mUserData['password'] = 'deleted_'. $user['password'];

        $schemeStatus = $this->SchemeStatuses->patchEntity($schemeStatus, $mUserData);
        if ($this->SchemeStatuses->save($schemeStatus)) {

            $this->Flash->success(__('The scheme status has been deleted.'));
        } else {
            $this->Flash->error(__('The scheme status could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

}
