<?php

declare(strict_types = 1);

namespace App\Controller\Admin;

use App\Controller\AppController;
use Cake\Mailer\Email;
use Cake\Datasource\ConnectionManager;

/**
 * Users Controller
 *
 * @property \App\Model\Table\UsersTable $Users
 * @method \App\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class UsersController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        $this->Authentication->addUnauthenticatedActions(['forgot', 'reset']);

//        debug($this->Authentication->getResult()->getData());exit;
        if ($this->Authentication->getResult()->getData() && in_array($this->Authentication->getResult()->getData()->users_roles_id, ['cpo', 'pm'])) {
//            echo __LINE__;exit;
            if (!in_array($this->getRequest()->getParam('action'), ['viewer', 'ceviewer', 'ssviewer', 'flaggedviewer'])) {
                $this->Flash->error(__('Oops, you are not allowed that location as CPO/PM'));

                $this->redirect(['controller' => 'Users', 'action' => 'view', 'prefix' => false]);
            }
        } else
        if ($this->Authentication->getResult()->getData() && in_array($this->Authentication->getResult()->getData()->users_roles_id, ['chief'])) {
//            echo $this->getRequest()->getParam('action');exit;
            if (!in_array($this->getRequest()->getParam('action'), ['login', 'megadashboard', 'normaldashboard', 'swatdashboard', 'dashboard', 'logout', 'view', 'edit', 'remove', 'viewer', 'ceviewer', 'rcviewer', 'categorywise', 'ssviewer', 'flaggedviewer'])) {
//                debug($this->getRequest()->getParam('action'));exit;
                $this->Flash->error(__('You are not allowed to access that location.'));
                $this->redirect(['controller' => 'Users', 'action' => 'view']);
            }
        }
    }

    public function viewer() {
//        $this->loadModel('UsersRoles');
//        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();
//
//
//        $this->set(compact(['usersRoles']));
        $this->viewBuilder()->setLayout('default-public');

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0],
                    'contain' => ['DepartmentSchemes' => ['conditions' => ['deleted' => 0, 'flag' => 0]]]
                ])->all();
        $this->loadModel('Districts');
        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();
        $this->set(compact('departments', 'districts'));
    }
    
//    public function sector() {
////        $this->loadModel('UsersRoles');
////        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();
////
////
////        $this->set(compact(['usersRoles']));
//        $this->viewBuilder()->setLayout('default-public');
//
//        $this->loadModel('DepartmentSchemes');
//        $departments = $this->DepartmentSchemes->find('all', ['order' => ['sector'], 'conditions' => ['deleted' => 0],
//                    'contain' => ['DepartmentSchemes' => ['conditions' => ['deleted' => 0, 'flag' => 0]]]
//                ])->all();
//        $this->loadModel('Districts');
//        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();
//        $this->set(compact('departments', 'districts'));
//    }

    public function flaggedviewer() {
//        $this->loadModel('UsersRoles');
//        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();
//
//
//        $this->set(compact(['usersRoles']));
        $this->viewBuilder()->setLayout('default-public');

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0],
                    'contain' => ['DepartmentSchemes' => ['conditions' => ['deleted' => 0, 'flag' => 1]]]
                ])->all();
        $this->loadModel('Districts');
        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();
        $this->set(compact('departments', 'districts'));
    }

    public function categorywise($choosen = null) {
//        echo __LINE__;exit;



        $this->loadModel('UsersRoles');
        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();


        $this->set(compact(['usersRoles']));

        $this->loadModel('DepartmentSchemes');
        $cond = array();
        $cond[] = ['DepartmentSchemes.deleted' => 0];


        if ($choosen) {
//            debug($dept_id);exit;

            $cond[] = ['DepartmentSchemes.department_id' => $choosen];
        }
        $schemes = $this->DepartmentSchemes->find('all', ['fields' => ['overall_status', 'scheme_category', 'mega_project'], 'conditions' => $cond])->all();
        $this->set(compact('schemes', 'choosen'));

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['department_name'], 'conditions' => ['deleted' => 0],
//                    'contain' => ['DepartmentSchemes' => ['conditions' => ['deleted' => 0]]]
                ])->all();
        $this->set(compact('departments'));
    }

    public function ceviewer() {
//        $this->loadModel('UsersRoles');
//        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();
//
//
//        $this->set(compact(['usersRoles']));
        $this->viewBuilder()->setLayout('default-public');

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0],
                    'contain' => ['DepartmentSchemes' => ['conditions' => ['deleted' => 0, 'id_chief_economist' => '1']]]
                ])->all();
        $this->set(compact('departments'));
    }

    public function peshawar() {
//        $this->loadModel('UsersRoles');
//        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();
//
//
//        $this->set(compact(['usersRoles']));
        $this->viewBuilder()->setLayout('default-public');

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0],
                    'contain' => ['DepartmentSchemes' => ['conditions' => ['deleted' => 0, 'is_peshawar' => '1']]]
                ])->all();
        $this->set(compact('departments'));
    }

    public function ssviewer() {
//        $this->loadModel('UsersRoles');
//        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();
//
//
//        $this->set(compact(['usersRoles']));
        $this->viewBuilder()->setLayout('default-public');

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0, 'Departments.id NOT IN' => ['16', '5']],
                    'contain' => ['DepartmentSchemes' => ['conditions' => ['deleted' => 0, 'id_chief_economist' => '0', 'scheme_category' => 'High Priority']]]
                ])->all();
        $this->set(compact('departments'));
    }

    public function dashboard() {

        $this->loadModel('UsersRoles');
        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();


        $this->set(compact(['usersRoles']));

        $cond = array();
        $cond[] = ['DepartmentSchemes.deleted' => 0];
//        $cond[] = ['DepartmentSchemes.flag' => 1];

        if (isset($_GET['mega_project_search']) && $_GET['mega_project_search'] !== '') {
            if ($_GET['mega_project_search'] == 'Mega') {
                $cond[] = ['DepartmentSchemes.mega_project' => 'Yes'];
            } else if ($_GET['mega_project_search'] == 'Normal') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'Normal'];
            } else if ($_GET['mega_project_search'] == 'High Priority') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'High Priority'];
            } else if ($_GET['mega_project_search'] == 'DFC (Two Years)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Two Years)'];
            } else if ($_GET['mega_project_search'] == 'DFC (Current Year)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Current Year)'];
            } else if ($_GET['mega_project_search'] == 'After Assembly') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'After Assembly'];
            }
        }
        if (isset($_GET['district']) && $_GET['district'] !== '') {
//            debug($_GET['district']);
//            exit;
//            $this->loadModel('SchemeDistricts');
//            $fetch_schemes = $this->SchemeDistricts->find('list', ['conditions' => [
//                            'SchemeDistricts.district_id IN ' => $_GET['district'],
////                            'SchemeDistricts.department_id IN ' => $_GET['department']
//                ]])->all()->toArray();
////            debug($fetch_schemes);
////            exit;
//            if ($fetch_schemes) {
//                $cond[] = ['DepartmentSchemes.id IN' => $fetch_schemes];
//            } else {
//                $cond[] = ['DepartmentSchemes.id IN' => array('1234567890')];
//            }


            $connection = ConnectionManager::get('default');
            $statement = $connection->execute('SELECT department_scheme_id FROM `scheme_districts` s where s.district_id IN (' . implode(',', $_GET['district']) . ') and s.`department_scheme_id`  not in (select si.`department_scheme_id` from scheme_districts si where si.`district_id` NOT IN (' . implode(',', $_GET['district']) . '))')->fetchAll('assoc');

//        debug($statement);

            $fresh_array = array();
            foreach ($statement as $st):
//            debug($st['department_scheme_id']);
                array_push($fresh_array, $st['department_scheme_id']);
            endforeach;

            if ($fresh_array) {
                $cond[] = ['DepartmentSchemes.id IN' => $fresh_array];
            } else {
                $cond[] = ['DepartmentSchemes.id IN' => array('1234567890')];
            }
        }

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0], 'contain' => ['DepartmentSchemes' => ['conditions' => $cond]]])->all();
        $this->set(compact('departments'));


        $this->loadModel('Districts');
        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();
        $this->set(compact('districts'));
    }

    public function rcviewer() {
        $this->loadModel('UsersRoles');
        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();


        $this->set(compact(['usersRoles']));

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0], 'contain' => ['DepartmentSchemes' => ['conditions' => ['deleted' => 0]]]])->all();
        $this->set(compact('departments'));
    }

    public function megadashboard() {

        $this->loadModel('UsersRoles');
        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();


        $this->set(compact(['usersRoles']));

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0],
                    'contain' => ['DepartmentSchemes' => ['conditions' => ['mega_project' => 'Yes', 'deleted' => 0]]]
                ])->all();
        $this->set(compact('departments'));
    }

    public function normaldashboard() {

        $this->loadModel('UsersRoles');
        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();


        $this->set(compact(['usersRoles']));

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0],
                    'contain' => ['DepartmentSchemes' => ['conditions' => ['scheme_category' => 'Normal', 'deleted' => 0]]]
                ])->all();
        $this->set(compact('departments'));
    }

    public function swatdashboard() {
        $this->loadModel('UsersRoles');
        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();


        $this->set(compact(['usersRoles']));


        $this->loadModel('SchemeDistricts');
        $fetch_schemes = $this->SchemeDistricts->find('list', ['conditions' => [
                        'SchemeDistricts.district_id' => 18,
//                            'SchemeDistricts.department_id IN ' => $_GET['department']
            ]])->all()->toArray();
//        debug($fetch_schemes);
//        exit;

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0],
                    'contain' => ['DepartmentSchemes' => ['conditions' => ['mega_project' => 'Yes', 'deleted' => 0, 'id in' => $fetch_schemes]]]
                ])->all();
        $this->set(compact('departments'));
    }

    public function forgot() {
        //$this->viewBuilder()->layout('client');
        $this->loadModel('Requests');
        $request = $this->Requests->newEmptyEntity();

        if ($this->request->is('post')) {
//            debug($this->request->getData());
//            exit;
            $count = $this->Users->find('all', array('conditions' => array('email' => $this->request->getData()['email'])))->first();
//            exit;
//            debug();exit;
            if ($count) {
//                debug($count);
//                exit;
                $Req['created'] = date('Y-m-d');
                $Req['ip'] = $this->request->clientIp();
                $Req['request'] = base64_encode($count['id'] . "," . $count['email'] . "," . date("Y-m-d") . "," . $this->request->clientIp());
                $Req['username'] = $count['email'];
//                debug($Req);exit;
                $request = $this->Requests->patchEntity($request, $Req);
//                debug($request);
                if ($this->Requests->save($request)) {
                    //send email setTo user
                    $this->send_email_forgot_password_link($count, $Req);
                    // return $this->redirect(array('controller' => 'Users', 'action' => 'forgot', 'success'));
                    return $this->redirect(array('controller' => 'Users', 'action' => 'forgot', 'success'));
                } else {

                    $this->Flash->error(__('The request could not be saved. Please, try again.'));
                }
            } else {
                $this->set('error', 'Wrong Email address given');
            }
        }
        $this->viewBuilder()->setLayout('default-login');
    }

    private function send_email_forgot_password_link($count = null, $data = null) {
        //email code starts here
        $email = new Email();
        $email->viewBuilder()->setTemplate('forgot', 'default');
        $email->setEmailFormat('html')
                ->setTo($this->request->getData()['email'])
                ->setFrom(['info@cmdu.kp.gov.pk' => 'cmdu.kp.gov.pk'])
                ->setBcc('info@cmdu.kp.gov.pk')
                ->setSubject('cmdu.kp.gov.pk - Forgot Password Request')
                ->setViewVars(['userdata' => $count, 'request' => $data])
                ->send();


//sms starts
        $message = 'Dear ' . ucwords($count['fname'] . ' ' . $count['lname']) . ', we got your request to change the password,'
                . ' you can change that by clicking the link: '
                . ' http://' . $_SERVER['SERVER_NAME'] . $this->request->getAttribute("webroot") . 'admin/users/reset/' . $data['request'];
        $this->loadComponent('Sms');
        $this->Sms->sms(str_replace(' ', '', $count['tel1']), $message);
//        echo $response;
        //sms ends
//        exit;
    }

    public function reset($id = null) {
        //$this->viewBuilder()->layout('client');
        $findfields = explode(',', base64_decode($id));
//        debug($findfields);
        $this->loadModel('Requests');
        $count = $this->Requests->find('all', array('conditions' => array('username' => $findfields[1], 'ip' => $findfields[3])))->first();
//        debug($count);exit;
        if (!$this->Users->exists($findfields[0])) {
            throw new NotFoundException(__('Invalid User'));
        }

        if ($count) {
            $nowtime = date("Y-m-d");
            $requestedtime = $findfields[2];
//            debug($nowtime);
//            debug($requestedtime);exit;
            $date1 = date_create($nowtime);
            $date2 = date_create($requestedtime);
            $diff = date_diff($date1, $date2);

            if ($diff->format("%a") == 0) {
                $this->set('change', 'change');
            }
        } else {
            $this->set('error', 'error');
        }

        if ($this->request->is('post')) {
//            debug($this->request->getData());exit;
            $user = $this->Users->get($findfields[0], [
                'contain' => []
            ]);
            //debug($user);exit;
            $user = $this->Users->patchEntity($user, $this->request->getData());
            if ($this->Users->save($user)) {
                $this->Requests->deleteAll(array('Request.username' => $findfields[1]), false);
                //  echo "454";exit;
                $this->Flash->success(__('Your profile has been updated.'));
                return $this->redirect(array('controller' => 'Users', 'action' => 'login'));
            } else {
                $this->Flash->error(__('Unable setTo update the password, try again'));
            }

            //return $this->redirect(array('controller' => 'Users', 'action' => 'login'));
        }
        $this->viewBuilder()->setLayout('default-login');
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index($dept_id = null) {
        $cond = array();
        $cond[] = ['Users.deleted' => 0];


        if ($dept_id) {
//            debug($dept_id);exit;
            $department = $this->Users->Departments->find('all', ['conditions' => ['id' => $dept_id]])->first()->toArray();
//            debug($department);
//            exit;
            $this->set(compact('department'));
            $cond[] = ['Users.department_id' => $department['id']];
            $cond[] = ['Users.users_roles_id IN' => ['cpo', 'pm']];
        } else {
            $cond[] = ['Users.users_roles_id IN' => ['admin', 'chief', 'sub-admin']];
        }

        if (isset($_GET['name']) && $_GET['name'] !== '') {

            $cond[] = ['OR' => ['Users.fname like' => '%' . $_GET['name'] . '%', 'Users.lname like' => '%' . $_GET['name'] . '%', 'Users.email like' => '%' . $_GET['name'] . '%', 'Users.users_roles_id like' => '%' . $_GET['name'] . '%']];
        }
//debug($cond);exit;


        $this->paginate = [
            'contain' => ['UsersRoles'],
            'conditions' => $cond,
            'order' => ['Users.users_roles_id' => 'asc']
        ];
        $users = $this->paginate($this->Users);

        $this->set(compact('users'));
    }

    public function beforeFilter(\Cake\Event\EventInterface $event) {
        parent::beforeFilter($event);
        // Configure the login action to not require authentication, preventing
        // the infinite redirect loop issue
        $this->Authentication->addUnauthenticatedActions(['login', 'viewer', 'ceviewer', 'ssviewer', 'peshawar', 'flaggedviewer','sector']);
    }

    public function login() {

        $this->viewBuilder()->setLayout('default-login');

        $this->request->allowMethod(['get', 'post']);
        $result = $this->Authentication->getResult();
        // regardless of POST or GET, redirect if user is logged in
        if ($result->isValid()) {
            if ($result->getData()->locked || $result->getData()->deleted || in_array($result->getData()->users_roles_id, ['cpo', 'pm'])) {
                $this->Authentication->logout();
                $this->Flash->error(__('You are not allowed to login, please contact administrator'));
            } else {

                $redirect = $this->Authentication->getLoginRedirect() ?? '/admin/users/dashboard?mega_project_search=Mega';

                // redirect to /articles after login success
//                $redirect = $this->request->getQuery('redirect', [
//                    'controller' => 'Users',
//                    'action' => 'dashboard',
//                ]);

                return $this->redirect($redirect);
            }
        }
        // display error if user submitted and authentication failed
        if ($this->request->is('post') && !$result->isValid()) {
            $this->Flash->error(__('Invalid email or password'));
        }
//    debug($result);
    }

// in src/Controller/UsersController.php
    public function logout() {
        $result = $this->Authentication->getResult();
        // regardless of POST or GET, redirect if user is logged in
        if ($result->isValid()) {
            $this->Authentication->logout();
            return $this->redirect(['controller' => 'Users', 'action' => 'login']);
        }
    }

    /**
     * View method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
        if ($id == null) {
            $id = $this->request->getAttribute('identity')->getIdentifier();
        }
        $user = $this->Users->get($id, [
            'contain' => ['UsersRoles'],
        ]);

        $this->set(compact('user'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add($dept_id = null) {

        if ($dept_id) {
//            debug($dept_id);exit;
            $department = $this->Users->Departments->find('all', ['conditions' => ['id' => $dept_id]])->first()->toArray();
//            debug($department);
//            exit;
            $this->set(compact('department'));
        }

        $user = $this->Users->newEmptyEntity();
        if ($this->request->is('post')) {
            $mPostData = $this->request->getData();
//            debug($mPostData['avatar']);
//            exit;
            $mValidated = true;

            if ($mPostData['password_new'] == '') {
                $this->Flash->error(__('No password supplied.  Password is required.'));
                $mValidated = false;
            }
            if ($mPostData['password_conf'] == '') {
                $this->Flash->error(__('No password confirmation supplied.  Password confirmation is required.'));
                $mValidated = false;
            }
            if ($mPostData['password_new'] <> $mPostData['password_conf']) {
                $this->Flash->error(__('Password and password confirmation do not match.  Please enter a valid password and confirm it.'));
                $mValidated = false;
            }


            unset($mPostData['avatar']);
            $mPostData['password'] = $mPostData['password_new'];
            $user = $this->Users->patchEntity($user, $mPostData);

            if ($this->request->getData()['avatar']->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $this->request->getData()['avatar']->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . end($img_ext);
//                debug($slider->image);
                if (in_array(end($img_ext), $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'users' . DS . $new_name;
                    $image = $this->request->getData()['avatar'];
                    $image->moveTo($path);
                    $user->avatar = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                $user->avatar = '';
            }
            if ($mValidated == true) {
                $user->created_by = $this->request->getAttribute('identity')->getIdentifier();
                $user->modified_by = $this->request->getAttribute('identity')->getIdentifier();
                if ($dept_id) {
                    $user->department_id = $dept_id;
                    $user->users_roles_id = 'cpo';
                }
                if ($this->Users->save($user)) {
                    $this->Flash->success(__('The user has been saved.'));

                    if ($dept_id) {
                        return $this->redirect(['action' => 'index', $dept_id]);
                    }

                    return $this->redirect(['action' => 'index']);
                }
            }
            $this->Flash->error(__('The user could not be saved. Please, try again.'));
        }
        $usersRoles = $this->Users->UsersRoles->find('list', ['limit' => 200]);
        $this->set(compact('user', 'usersRoles'));
    }

    /**
     * Edit method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null) {
        $user = $this->Users->get($id, [
            'contain' => ['Departments'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $mValidated = true;

            //password
            $mPostData = $this->request->getData();

            if ($mPostData['password_new'] <> '') {

                if ($mPostData['password_conf'] <> $mPostData['password_new']) {
                    $this->Flash->error(__('Password confirmation does not match new password.'));
                    $mValidated = false;
                } else {
                    //password & conf match
                    $mPostData['password'] = $mPostData['password_new'];
                }
            }
            unset($mPostData['avatar']);

            $user = $this->Users->patchEntity($user, $mPostData);
//            debug($this->request->getData()['avatar']);
//            exit;
            $image = $this->request->getData()['avatar'];

            if ($image->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $image->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . end($img_ext);
//                debug($slider->image);
                if (in_array(end($img_ext), $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'users' . DS . $new_name;
                    $image->moveTo($path);
                    $user->avatar = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                unset($user->avatar);
            }
//            debug($user);
//            exit;
            if ($mValidated == true) {
                $user->modified_by = $this->request->getAttribute('identity')->getIdentifier();
                if ($this->Users->save($user)) {
                    $this->Flash->success(__('The user has been saved.'));
                    if ($user->department_id) {
                        return $this->redirect(['action' => 'index', $user->department_id]);
                    }
                    return $this->redirect(['action' => 'view', $user->id]);
                }
            }
            $this->Flash->error(__('The user could not be saved. Please, try again.'));
        }
        $usersRoles = $this->Users->UsersRoles->find('list', ['limit' => 200]);
        $this->set(compact('user', 'usersRoles'));
    }

    public function remove($id = null) {
        $departmentScheme = $this->Users->get($id);
        unlink(WWW_ROOT . 'img' . DS . 'users' . DS . $departmentScheme->avatar);
        $departmentScheme->avatar = '';
        if ($this->Users->save($departmentScheme)) {

            $this->Flash->success(__('Avatar has been removed.'));

            return $this->redirect(['action' => 'edit', $id]);
        }
    }

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
        $this->request->allowMethod(['post', 'delete']);
        $user = $this->Users->get($id);

        $dept_id = $user->department_id;

//        if ($this->Users->delete($user)) {

        $mUserData['email'] = 'deleted_' . date('YmdHis', time()) . $user['email'];
        $mUserData['deleted'] = '1';
        $mUserData['locked'] = '1';
        //$mUserData['password'] = 'deleted_'. $user['password'];

        $user = $this->Users->patchEntity($user, $mUserData);
        if ($this->Users->save($user)) {

            $this->Flash->success(__('The user has been deleted.'));
        } else {
            $this->Flash->error(__('The user could not be deleted. Please, try again.'));
        }
        if ($dept_id) {
            return $this->redirect(['action' => 'index', $dept_id]);
        }

        return $this->redirect(['action' => 'index']);
    }

}
