<?php

declare(strict_types = 1);

namespace App\Controller;

/**
 * AttachedFormations Controller
 *
 * @property \App\Model\Table\AttachedFormationsTable $AttachedFormations
 * @method \App\Model\Entity\AttachedFormation[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class AttachedFormationsController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        //$this->Auth->allow(['index']);
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {

            $this->Flash->error(__('You are not allowed to access that location.'));
            $this->redirect(['controller' => 'Users', 'action' => 'view']);
        }
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index() {
        $this->paginate = [
            'contain' => ['Users'],
            'conditions'=>['AttachedFormations.department_id' => $this->Authentication->getResult()->getData()->department_id]
        ];
        $attachedFormations = $this->paginate($this->AttachedFormations);

        $this->set(compact('attachedFormations'));
    }

    /**
     * View method
     *
     * @param string|null $id Attached Formation id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
        $attachedFormation = $this->AttachedFormations->get($id, [
            'contain' => ['AttachedFormations', 'AttachedFormations', 'Users'],
        ]);

        $this->set(compact('attachedFormation'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add() {
        $attachedFormation = $this->AttachedFormations->newEmptyEntity();
        if ($this->request->is('post')) {

//            $attachedFormation = $this->AttachedFormations->patchEntity($attachedFormation, $this->request->getData());
//            if ($this->AttachedFormations->save($attachedFormation)) {
//                $this->Flash->success(__('The attached formation has been saved.'));
//
//                return $this->redirect(['action' => 'index']);
//            }
//            $this->Flash->error(__('The attached formation could not be saved. Please, try again.'));

            $mValidated = true;
            $mPostData = $this->request->getData();
//            debug($mPostData);exit;
            unset($mPostData['logo']);
            $attachedFormation = $this->AttachedFormations->patchEntity($attachedFormation, $mPostData);
            if ($this->request->getData()['logo']->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $this->request->getData()['logo']->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'departments' . DS . $new_name;
                    $image = $this->request->getData()['logo'];
                    $image->moveTo($path);
                    $attachedFormation->logo = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                $attachedFormation->logo = '';
            }
            if ($mValidated == true) {
                $attachedFormation->created_by = $this->request->getAttribute('identity')->getIdentifier();
                $attachedFormation->modified_by = $this->request->getAttribute('identity')->getIdentifier();
                $attachedFormation->department_id = $this->Authentication->getResult()->getData()->department_id;
//                debug($attachedFormation);exit;
                if ($this->AttachedFormations->save($attachedFormation)) {
                    $this->Flash->success(__('The attached formation has been saved.'));

                    return $this->redirect(['action' => 'index']);
                }
            }
            $this->Flash->error(__('The attached formation could not be saved. Please, try again.'));
        }
//        $attachedFormations = $this->AttachedFormations->AttachedFormations->find('list', ['limit' => 200]); , 'departments'

        $this->set(compact('attachedFormation'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Attached Formation id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null) {
        $attachedFormation = $this->AttachedFormations->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
//            $attachedFormation = $this->AttachedFormations->patchEntity($attachedFormation, $this->request->getData());
//            if ($this->AttachedFormations->save($attachedFormation)) {
//                $this->Flash->success(__('The attached formation has been saved.'));
//
//                return $this->redirect(['action' => 'index']);
//            }
//            $this->Flash->error(__('The attached formation could not be saved. Please, try again.'));

            $mValidated = true;

            //password
            $mPostData = $this->request->getData();
//            debug($mPostData);exit;
            unset($mPostData['logo']);

            $attachedFormation = $this->AttachedFormations->patchEntity($attachedFormation, $mPostData);
            $image = $this->request->getData()['logo'];

            if ($image->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $image->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . $img_ext[1];
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'departments' . DS . $new_name;
                    $image->moveTo($path);
                    $attachedFormation->logo = $new_name;
//                      debug($attachedFormation);exit;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                unset($attachedFormation->logo);
            }
//            debug($attachedFormation);
//            exit;
            if ($mValidated == true) {
                $attachedFormation->modified_by = $this->request->getAttribute('identity')->getIdentifier();
//                debug($attachedFormation);exit;
                if ($this->AttachedFormations->save($attachedFormation)) {
                    $this->Flash->success(__('The attached formation has been saved.'));

                    return $this->redirect(['action' => 'index']);
                }
            }
            $this->Flash->error(__('The attached formation could not be saved. Please, try again.'));
        }
//        $attachedFormations = $this->AttachedFormations->AttachedFormations->find('list', ['limit' => 200]); , 'departments'
        $this->set(compact('attachedFormation'));
    }

    public function remove($id = null) {
        $departmentScheme = $this->AttachedFormations->get($id);
        unlink(WWW_ROOT . 'img' . DS . 'departments' . DS . $departmentScheme->logo);
        $departmentScheme->logo = '';
        if ($this->AttachedFormations->save($departmentScheme)) {

            $this->Flash->success(__('Logo has been removed.'));

            return $this->redirect(['action' => 'edit', $id]);
        }
    }

    /**
     * Delete method
     *
     * @param string|null $id Attached Formation id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
        $this->request->allowMethod(['post', 'delete']);
        $attachedFormation = $this->AttachedFormations->get($id);
        if ($this->AttachedFormations->delete($attachedFormation)) {
            $this->Flash->success(__('The attached formation has been deleted.'));
        } else {
            $this->Flash->error(__('The attached formation could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

}
