<?php

declare(strict_types = 1);

namespace App\Controller;

use Cake\I18n\FrozenTime;
use Cake\Mailer\Email;
use Cake\Datasource\ConnectionManager;

/**
 * DepartmentSchemes Controller
 *
 * @property \App\Model\Table\DepartmentSchemesTable $DepartmentSchemes
 * @method \App\Model\Entity\DepartmentScheme[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class DepartmentSchemesController extends AppController {

    /**
     * Initialize controller
     *
     * @return void
     */
    public function initialize(): void {
        parent::initialize();
        $this->viewBuilder()->setLayout('default-admin');
        //$this->Auth->allow(['index']);
        $this->Authentication->addUnauthenticatedActions(['checkstatus', 'megaschemes', 'swatmegaschemes', 'onetime', 'updateschemecategory', 'sendnotifications']);
    }

    public function sendnotifications() {

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', [
                    'contain' => [
                        'Users' => ['conditions' => ['deleted' => 0, 'users_roles_id' => 'cpo']],
                        'DepartmentSchemes' => ['sort' => ['DepartmentSchemes.overall_status' => 'DESC'], 'conditions' => ['deleted' => 0, 'overall_status IN ' => ['5', '4', '1']]]],
                    'conditions' => ['deleted' => 0]])->all();
        $departments_array = [];
        foreach ($departments as $dept):
            $schemes_array = array();
            if ($dept->department_schemes) {
                foreach ($dept->department_schemes as $danger):
                    $schemes_array[] = '<img width="25" src="http://cmdu.kp.gov.pk/portal/img/milestones_status/' . $danger->overall_status . '.PNG" />' . ' ' . $danger->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($danger->scheme_name)) . ' (' . $danger->scheme_type . ')';
                endforeach;
                $this->send_mail_to_dept($dept->users, $schemes_array, $dept->department_name);
                array_push($departments_array, $dept->department_name);
            }

        endforeach;
        echo "sent on " . date('Y-m-d h:i a') . ' to ' . implode(',', $departments_array);
        exit;
    }

    function send_mail_to_dept($users, $schemes, $dept_name) {
        $users_array = array();
        foreach ($users as $user):
            array_push($users_array, $user->email);
        endforeach;
//        debug($users_array);
//        debug($schemes);
//        debug($dept_name);

        $email = new Email();
        $email->viewBuilder()->setTemplate('department_email_schemes', 'default');
        $email->setEmailFormat('html')
                ->setTo($users_array)
//                ->setTo('ahsanali.dev@yahoo.com')
                ->setFrom(['info@cmdu.kp.gov.pk' => 'cmdu.kp.gov.pk'])
//                ->setBcc('ahsanali.dev@yahoo.com')
                //->from($this->request->getData()['email'])
                ->setSubject('cmdu.kp.gov.pk - List of All Critically Delayed, Off Target and Non Started Departmental Schemes of ' . $dept_name . ' Department')
                ->setViewVars(['schemes' => $schemes, 'dept_name' => $dept_name])
                ->send();
    }

    public function sendrequest() {
        $this->loadModel('SchemeRequests');
        $departmentScheme = $this->SchemeRequests->newEmptyEntity();
        if ($this->request->is('post')) {

            $mPostData = $this->request->getData();
            $departmentScheme = $this->SchemeRequests->patchEntity($departmentScheme, $mPostData);
            $departmentScheme->status = 'pending';
            $departmentScheme->user_id = $this->request->getAttribute('identity')->getIdentifier();
            $departmentScheme->department_id = $this->Authentication->getResult()->getData()->department_id;
//            debug($departmentScheme);exit;

            if ($result = $this->SchemeRequests->save($departmentScheme)) {
                $this->send_mail($result->id);
                echo json_encode('saved');
            } else {
                debug($departmentScheme);
                echo json_encode('not saved');
            }
        }
//        debug($_POST);
        exit;
    }

    function send_mail($request_id = null) {
//        echo $request_id;

        $this->loadModel('SchemeRequests');
        $schemeRequest = $this->SchemeRequests->get($request_id, [
            'contain' => ['Departments', 'DepartmentSchemes', 'Users'],
        ]);
        $steps_Array = ['schemeprofile' => 'Scheme Profile', 'step1' => 'Is PC-II Required?', 'step2' => 'Is the PC-1 approved?', 'step3' => 'Is Hiring Required?', 'step4' => 'Is Land Acquisition Required?', 'step5' => 'Is Procurement of Goods Required?', 'step6' => 'Is Procurement of Services Required?', 'step7' => 'Is Construction/Civil Work Required?', 'custom' => 'Custom Milestone'];

        $email = new Email();
        $email->viewBuilder()->setTemplate('schemerequest', 'default');
        $email->setEmailFormat('html')
                ->setTo('cmdukp@gmail.com')
                ->setFrom(['info@cmdu.kp.gov.pk' => 'cmdu.kp.gov.pk'])
                ->setBcc('info@cmdu.kp.gov.pk')
                ->setSubject('cmdu.kp.gov.pk - Date Change Request')
                ->setViewVars(['schemeRequest' => $schemeRequest, 'steps_Array' => $steps_Array])
                ->send();

//sms starts
        $message = 'Dear Admin, We got new date change request from Department: "' . ucfirst($schemeRequest->department->department_name) . '" Against Scheme: "'
                . ucfirst($schemeRequest->department_scheme->scheme_name) . '" for the step: "' . h($steps_Array[$schemeRequest->step_name])
                . '" with remarks: "' . ucfirst($schemeRequest->request_details) . '". Kindly login to the admin section in order to approve or reject the request.';
        $this->loadComponent('Sms');
        $this->Sms->sms(str_replace(' ', '', "03329962604,03339329637"), $message);
//        echo $response;
        //sms ends
//        exit;
    }

    public function megaschemes() {
        $this->viewBuilder()->setLayout('default-public');

        $this->loadModel('UsersRoles');
        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();


        $this->set(compact(['usersRoles']));

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0],
                    'contain' => ['DepartmentSchemes' => ['conditions' => ['mega_project' => 'Yes']]]
                ])->all();
        $this->set(compact('departments'));
    }

    public function exportall() {
        $output_type = 'D';

        $file = 'schemes_list.xlsx';
        $cond = array();
        $cond[] = ['DepartmentSchemes.deleted' => 0, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id];

        if (isset($_GET['department'])) {
            $cond[] = ['DepartmentSchemes.department_id IN' => $_GET['department']];

//            $this->loadModel('Departments');
//
//            $department = $this->Departments->find('all', ['conditions' => ['id' => $dept_id]])->first();
//
//            $this->set(compact('department'));
        }
//        debug($department);exit;
        if (isset($_GET['status']) && $_GET['status'] !== '') {
            $cond[] = ['DepartmentSchemes.overall_status' => $_GET['status']];
        }

        if (isset($_GET['directive_search']) && $_GET['directive_search'] !== '') {
            $cond[] = ['DepartmentSchemes.directive' => $_GET['directive_search']];
        }
        if (isset($_GET['mega_project']) && $_GET['mega_project'] !== '') {
            if ($_GET['mega_project'] == 'Mega') {
                $cond[] = ['DepartmentSchemes.mega_project' => 'Yes'];
            } else if ($_GET['mega_project'] == 'Normal') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'Normal'];
            } else if ($_GET['mega_project'] == 'High Priority') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'High Priority'];
            } else if ($_GET['mega_project'] == 'DFC (Two Years)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Two Years)'];
            } else if ($_GET['mega_project'] == 'DFC (Current Year)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Current Year)'];
            } else if ($_GET['mega_project'] == 'After Assembly') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'After Assembly'];
            }
        }
        if (isset($_GET['foreign_funded']) && $_GET['foreign_funded'] !== '') {
            $cond[] = ['DepartmentSchemes.foreign_funded' => $_GET['foreign_funded']];
        }

        if (isset($_GET['scheme_type']) && $_GET['scheme_type'] !== '') {
            $cond[] = ['DepartmentSchemes.scheme_type' => $_GET['scheme_type']];
        }

        if (isset($_GET['name']) && $_GET['name'] !== '') {
//            if (is_numeric($_GET['name'])) {
//                $cond[] = ['OR' => ['DepartmentSchemes.scheme_code' => $_GET['name']]];
//            }
//            if (!is_numeric($_GET['name'])) {
//                $cond[] = ['OR' => ['DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
//            }
            $cond[] = ['OR' => ['DepartmentSchemes.scheme_code like ' => '%' . $_GET['name'] . '%', 'DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
        }

        if (isset($_GET['district']) && $_GET['district'] !== '') {
//            debug($_GET['district']);
//            exit;
            $this->loadModel('SchemeDistricts');
            $fetch_schemes = $this->SchemeDistricts->find('list', ['conditions' => [
                            'SchemeDistricts.district_id IN ' => $_GET['district'],
//                            'SchemeDistricts.department_id IN ' => $_GET['department']
                ]])->all()->toArray();
//            debug($fetch_schemes);
//            exit;
            if ($fetch_schemes) {
                $cond[] = ['DepartmentSchemes.id IN' => $fetch_schemes];
            } else {
                $cond[] = ['DepartmentSchemes.id IN' => array('1234567890')];
            }
        }
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['DepartmentSchemes.department_id IN ' => $get_departments];
        }

//        debug($cond);exit;
//        $this->loadModel('SchemeDistricts');
//        $this->paginate = [
//            'limit' => 200,
//            'conditions' => $cond,
//            'order' => ['id' => 'desc'],
////            'contain' => ['SchemeDistricts'],
//            'fields' => ['id', 'id_chief_economist', 'overall_status', 'scheme_name', 'scheme_code', 'scheme_type', 'department_id', 'last_modified', 'locked', 'directive', 'mega_project', 'issues_list']//,'SchemeStatuses.status_color_pattern'
//        ];
//        debug($cond);exit;
        $departmentSchemes = $this->DepartmentSchemes->find('all', [
                    'conditions' => $cond,
                    'order' => ['id' => 'desc'],
//            'contain' => ['SchemeDistricts'],
                    'fields' => ['id', 'id_chief_economist', 'overall_status', 'scheme_name', 'scheme_code', 'scheme_type', 'department_id', 'last_modified', 'locked', 'directive', 'mega_project', 'issues_list']
                ])->all();

        $this->loadModel('Districts');
        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();

        $cond = array();
//        $cond[] = ['Departments.deleted' => 0
////            ,'Departments.department_name NOT LIKE'=>'Other'
//        ];
        $this->loadModel('Departments');
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'chief') {
            $this->loadModel('AssignChiefDepartments');
            $get_departments = $this->AssignChiefDepartments->find('list', ['conditions' => ['user_id' => $this->request->getAttribute('identity')->getIdentifier()], 'limit' => 200, 'keyField' => 'department_id', 'valueField' => 'department_id'])->toArray();
//            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
//            debug($get_departments);exit;
            $cond[] = ['Departments.id IN ' => $get_departments];
        }
//        $departments_assigned = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();
        $departments = $this->Departments->find('list', ['conditions' => $cond, 'order' => ['department_name' => 'asc']])->all()->toArray();

//        debug($districts);exit;
        $project_types = $this->send_types();

        $this->set(compact('departmentSchemes', 'districts', 'departments', 'project_types', 'output_type', 'file'));

        $this->viewBuilder()->setLayout('xls/default');
        $this->viewBuilder()->setTemplate('xls/exportall');
        $this->RequestHandler->respondAs('xlsx');
        $this->render();
    }

    public function exportexcel($id = null) {
        $output_type = 'D';

        $departmentScheme = $this->DepartmentSchemes->get($id, [
//            'contain' => ['Departments', 'SchemeStatuses', 'SchemeDistricts'],
        ]);

        $file = 'tracker_' . preg_replace('/\s+/', '_', $departmentScheme->scheme_name) . '.xlsx';

        $this->loadModel('Departments');

        $departments = $this->Departments->find('list')->all()->toArray();

        $this->loadModel('CustomMilestones');
        $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['department_scheme_id' => $id], 'order' => ['id' => 'asc']])->all();

//        debug($departments);
//        exit;
        $this->set(compact('departmentScheme', 'departments', 'output_type', 'file', 'fetch_custom_details'));
        $this->viewBuilder()->setLayout('xls/default');
        $this->viewBuilder()->setTemplate('xls/exportexcel');
        $this->RequestHandler->respondAs('xlsx');
        $this->render();
    }

    public function swatmegaschemes() {
        $this->viewBuilder()->setLayout('default-public');

        $this->loadModel('UsersRoles');
        $usersRoles = $this->UsersRoles->find('list', ['fields' => ['id', 'role_name']])->toArray();


        $this->set(compact(['usersRoles']));


        $this->loadModel('SchemeDistricts');
        $fetch_schemes = $this->SchemeDistricts->find('list', ['conditions' => [
                        'SchemeDistricts.district_id' => 18,
//                            'SchemeDistricts.department_id IN ' => $_GET['department']
            ]])->all()->toArray();
//        debug($fetch_schemes);
//        exit;

        $this->loadModel('Departments');
        $departments = $this->Departments->find('all', ['order' => ['department_name'], 'conditions' => ['deleted' => 0],
                    'contain' => ['DepartmentSchemes' => ['conditions' => ['mega_project' => 'Yes', 'id in' => $fetch_schemes]]]
                ])->all();
        $this->set(compact('departments'));
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index() {

        $cond = array();

        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $cond[] = ['DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()];
        }

        $cond[] = ['DepartmentSchemes.deleted' => 0, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id];

        if (isset($_GET['status']) && $_GET['status'] !== '') {
            $cond[] = ['DepartmentSchemes.overall_status' => $_GET['status']];
        }

        if (isset($_GET['directive']) && $_GET['directive'] !== '') {
            $cond[] = ['DepartmentSchemes.directive' => $_GET['directive']];
        }
        if (isset($_GET['mega_project']) && $_GET['mega_project'] !== '') {
            if ($_GET['mega_project'] == 'Mega') {
                $cond[] = ['DepartmentSchemes.mega_project' => 'Yes'];
            } else if ($_GET['mega_project'] == 'Normal') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'Normal'];
            } else if ($_GET['mega_project'] == 'High Priority') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'High Priority'];
            } else if ($_GET['mega_project'] == 'DFC (Two Years)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Two Years)'];
            } else if ($_GET['mega_project'] == 'DFC (Current Year)') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'DFC (Current Year)'];
            } else if ($_GET['mega_project'] == 'After Assembly') {
                $cond[] = ['DepartmentSchemes.scheme_category' => 'After Assembly'];
            }
        }

        if (isset($_GET['foreign_funded']) && $_GET['foreign_funded'] !== '') {
            $cond[] = ['DepartmentSchemes.foreign_funded' => $_GET['foreign_funded']];
        }

        if (isset($_GET['scheme_type']) && $_GET['scheme_type'] !== '') {
            $cond[] = ['DepartmentSchemes.scheme_type' => $_GET['scheme_type']];
        }

        if (isset($_GET['formations']) && $_GET['formations'] !== '') {
            $cond[] = ['DepartmentSchemes.attached_formation_id IN' => $_GET['formations']];
        }

        if (isset($_GET['name']) && $_GET['name'] !== '') {
//            if (is_numeric($_GET['name'])) {
            $cond[] = ['OR' => ['DepartmentSchemes.scheme_code like ' => '%' . $_GET['name'] . '%', 'DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
//            }
//            if (!is_numeric($_GET['name'])) {
//                $cond[] = ['OR' => ['DepartmentSchemes.scheme_name like' => '%' . $_GET['name'] . '%']];
//            }
        }

        if (isset($_GET['district']) && $_GET['district'] !== '') {
//            debug($_GET['district']);
//            exit;
            $this->loadModel('SchemeDistricts');
            $fetch_schemes = $this->SchemeDistricts->find('list', ['conditions' => [
                            'SchemeDistricts.district_id IN ' => $_GET['district'],
                            'SchemeDistricts.department_id' => $this->Authentication->getResult()->getData()->department_id
                ]])->all()->toArray();
//            debug($fetch_schemes);
//            exit;
            if ($fetch_schemes) {
                $cond[] = ['DepartmentSchemes.id IN' => $fetch_schemes];
            } else {
                $cond[] = ['DepartmentSchemes.id IN' => array('1034567890')];
            }
        }
//        debug($cond);exit;
//        $this->loadModel('SchemeDistricts');

        $this->paginate = [
            'conditions' => $cond,
            'limit' => 200,
            'order' => ['id' => 'desc'],
            'contain' => ['AttachedFormations'],
//            'fields' => ['id', 'overall_status', 'scheme_name','scheme_code','SchemeDistricts.*']//,'SchemeStatuses.status_color_pattern'
        ];
        $departmentSchemes = $this->paginate($this->DepartmentSchemes);

        $this->loadModel('Districts');
        $districts = $this->Districts->find('list', ['conditions' => ['deleted' => 0], 'order' => ['name' => 'asc']])->all()->toArray();
        $this->loadModel('AttachedFormations');
        $formations = $this->AttachedFormations->find('list', ['conditions' => ['AttachedFormations.department_id' => $this->Authentication->getResult()->getData()->department_id], 'order' => ['name' => 'asc']])->all()->toArray();
//        debug($departmentSchemes);exit;
        $project_types = $this->send_types();

        $this->loadModel('Users');
        $pms = $this->Users->find('list', ['conditions' => ['deleted' => 0, 'users_roles_id' => 'pm', 'department_id' => $this->Authentication->getResult()->getData()->department_id], 'order' => ['fname' => 'asc']])->all()->toArray();

        $this->set(compact('departmentSchemes', 'districts', 'project_types', 'formations', 'pms'));
    }

    public function changepm() {
//        debug($_GET);
        $this->loadModel('Users');

        $departmentScheme = $this->DepartmentSchemes->get($_GET['id']);
        $get_attached_formation = $this->Users->get($_GET['user_id']);
        $departmentScheme->user_id = $_GET['user_id'];
        $departmentScheme->attached_formation_id = $get_attached_formation->attached_formation_id;

        $this->DepartmentSchemes->save($departmentScheme);
        echo json_encode('yes');
        exit;
    }

    public function exportpdf($id = null) {
        $this->viewBuilder()->setLayout('');


        $departmentScheme = $this->DepartmentSchemes->get($id, [
//            'contain' => ['Departments', 'SchemeStatuses', 'SchemeDistricts'],
        ]);

        $this->loadModel('Departments');

        $departments = $this->Departments->find('list')->all()->toArray();
//        debug($departments);
//        exit;
        $this->loadModel('CustomMilestones');
        $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['department_scheme_id' => $id], 'order' => ['id' => 'asc']])->all();

        $this->set(compact('departmentScheme', 'departments', 'fetch_custom_details'));
    }

    /**
     * View method
     *
     * @param string|null $id Department Scheme id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null) {
		$departmentScheme = $this->DepartmentSchemes->get($id, [
            'contain' => ['Comments' => ['Users']],
        ]);

        if ($departmentScheme->parent_scheme_code && $departmentScheme->parent_scheme_code !== '0' && $departmentScheme->parent_scheme_code !== 0) {
            $get_parent = $this->DepartmentSchemes->find('all', ['conditions' => ['scheme_code' => $departmentScheme->parent_scheme_code]])->first();
//           debug($get_parent);exit;
            $this->set(compact('get_parent'));
        }

        if ($departmentScheme->scheme_code && $departmentScheme->scheme_code !== '0' && $departmentScheme->scheme_code !== 0) {
//            debug($departmentScheme->scheme_code);exit;
            $get_childs = $this->DepartmentSchemes->find('all', ['conditions' => ['parent_scheme_code' => $departmentScheme->scheme_code]])->all();
//           debug($get_childs);exit;
            $this->set(compact('get_childs'));
        }

        $this->loadModel('Departments');

        $departments = $this->Departments->find('list')->all()->toArray();
//        debug($departments);
//        exit;
        $this->loadModel('CustomMilestones');
        if ($departmentScheme->custom_milestone_required == 'Yes') {
            $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['department_scheme_id' => $id], 'order' => ['display_order' => 'asc', 'id' => 'asc']])->all();
            $this->set(compact('fetch_custom_details'));
        }
        $this->set(compact('departmentScheme', 'departments'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add_full() {
        $departmentScheme = $this->DepartmentSchemes->newEmptyEntity();
        if ($this->request->is('post')) {
            $mValidated = true;

            //password
            $mPostData = $this->request->getData();

//            debug($mPostData);
//            exit;


            unset($mPostData['scheme_file']);
            unset($mPostData['proc_goods_evidence_of_distribution']);

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $mPostData);
//            debug($this->request->getData()['scheme_file']);
//            exit;
            $scheme_file = $this->request->getData()['scheme_file'];
            $evidence = $this->request->getData()['proc_goods_evidence_of_distribution'];


            if ($scheme_file->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $scheme_file->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . end($img_ext);
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $new_name;
                    $scheme_file->moveTo($path);
                    $departmentScheme->scheme_file = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                unset($departmentScheme->scheme_file);
            }
            if ($evidence->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $evidence->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . end($img_ext);
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $new_name;
                    $evidence->moveTo($path);
                    $departmentScheme->scheme_file = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                unset($departmentScheme->scheme_file);
            }
//            debug($departmentScheme);
//            exit;
            if ($mValidated == true) {
                $departmentScheme->active = 1;
                $departmentScheme->created_by = $this->request->getAttribute('identity')->getIdentifier();
                $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
                $departmentScheme->department_id = $this->Authentication->getResult()->getData()->department_id;
                $departmentScheme->scheme_status_id = 1;


                if ($this->DepartmentSchemes->save($departmentScheme)) {
                    $this->Flash->success(__('The department scheme has been saved.'));

                    return $this->redirect(['action' => 'index']);
                }
                debug($departmentScheme);
                $this->Flash->error(__('The department scheme could not be saved. Please, try again.'));
            }
        }
//        $departments = $this->DepartmentSchemes->Departments->find('list', ['limit' => 200]);  'departments', 
        $schemeStatuses = $this->DepartmentSchemes->SchemeStatuses->find('list', ['limit' => 200, 'keyField' => 'status_name', 'valueField' => 'status_name']);
        $this->set(compact('departmentScheme', 'schemeStatuses'));
    }

    private function savelog($dept_id = null, $id = null, $form_data = null) {
        //scheme saving starts here
        $array_to_Save = array();
        $this->loadModel('SchemesLogs');
        foreach ($form_data as $key => $data):
            $array_to_Save['department_scheme_id'] = $id;
            $array_to_Save['department_id'] = $dept_id;
            $array_to_Save['field_name'] = $key;
            $array_to_Save['answer'] = $data;
            $array_to_Save['user_id'] = $this->request->getAttribute('identity')->getIdentifier();

            if ($data) {
                $check_before = $this->SchemesLogs->find('all', ['conditions' => ['SchemesLogs.department_id' => $dept_id, 'SchemesLogs.department_scheme_id' => $id, 'SchemesLogs.field_name' => $key, 'SchemesLogs.answer' => $data]])->first();
//            debug($array_to_Save);
//            exit;

                if ($check_before == null) {

                    $entity = $this->SchemesLogs->newEntity($array_to_Save);
                    if ($this->SchemesLogs->save($entity)) {
                        //saved
                        $schemeRequest = $this->DepartmentSchemes->get($id);
                        $schemeRequest->last_modified = date('Y-m-d G:i:s');
//                        exit;

                        $this->DepartmentSchemes->save($schemeRequest);
                    } else {
//                        debug($entity);
//                        exit;
                    }
                }
            }
        endforeach;
        //scheme saving ends here
    }

    public function onetime() {
//        $this->loadModel('SchemesLogs');
        $get_all_schemes = $this->DepartmentSchemes->find('all', ['order' => ['id' => 'desc'], 'limit' => '1200', 'fields' => ['id', 'scheme_code', 'year'],
                    'conditions' => ['deleted' => 0, 'scheme_code !=' => 0, 'scheme_category IS NULL']])->all()->toArray();
//        echo json_encode($get_all_schemes);
        $this->set(compact('get_all_schemes'));
//        exit;
    }

    public function updateschemecategory() {
//        echo $_GET['id'];
//        echo $_GET['scheme_category'];
        $departmentScheme = $this->DepartmentSchemes->get($_GET['id']);
        $departmentScheme->scheme_category = $_GET['scheme_category'];
        $departmentScheme->cost_of_scheme = $_GET['cost'];
        $departmentScheme->expenditure_till_date = $_GET['previousExp'];
        $departmentScheme->progressive_expenditure = $_GET['ProgressiveExp'];
        $departmentScheme->allocation_for_cfy = $_GET['Allocation'];
        $departmentScheme->release_for_cfy = $_GET['ProgReleases'];
        $departmentScheme->sector = $_GET['SectorName'];

        $this->DepartmentSchemes->save($departmentScheme);

        exit;
    }

    public function onetime_last_modified_field() {
        $this->loadModel('SchemesLogs');
        $get_all_schemes = $this->DepartmentSchemes->find('all')->all();
        foreach ($get_all_schemes as $scheme):
            $choosen_nav_districts = $this->SchemesLogs->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $scheme->id], 'order' => ['SchemesLogs.id' => 'DESC']])->first();
            if (isset($choosen_nav_districts->created)) {
                $scheme->last_modified = $choosen_nav_districts->created;
            }
//            debug($scheme);
//            $entity = $this->DepartmentSchemes->newEntity($single_array);
            if ($this->DepartmentSchemes->save($scheme)) {
                echo $scheme->id . ' Updated <br/>';
            } else {
                debug($scheme);
            }
        endforeach;

        exit;
    }

    private function send_types() {
        return ["ADP" => "ADP", 'MA-ADP' => 'MA-ADP', "AIP" => "AIP", 'PSDP' => 'PSDP', 'Own_source' => 'Own Source', 'CPEC' => 'CPEC', 'Other' => 'Other'];
    }

    public function add() {
        $departmentScheme = $this->DepartmentSchemes->newEmptyEntity();
        if ($this->request->is('post')) {

            $mPostData = $this->request->getData();
//            debug($mPostData);
//            exit;
            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $mPostData);

            $departmentScheme->active = 1;
            $departmentScheme->flag = 0;
            $departmentScheme->created_by = $this->request->getAttribute('identity')->getIdentifier();
            $departmentScheme->user_id = $this->request->getAttribute('identity')->getIdentifier();
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
            $departmentScheme->department_id = $this->Authentication->getResult()->getData()->department_id;
            $departmentScheme->attached_formation_id = $this->Authentication->getResult()->getData()->attached_formation_id;
            $departmentScheme->scheme_start_date = date('Y-m-d', strtotime($mPostData['scheme_start_date']));
            $departmentScheme->scheme_end_date = date('Y-m-d', strtotime($mPostData['scheme_end_date']));
            if ($mPostData['pc1_approval_date']) {
                $departmentScheme->pc1_approval_date = date('Y-m-d', strtotime($mPostData['pc1_approval_date']));
            }
//            debug($departmentScheme);exit;
//            if ($mPostData['step1_status'] > $mPostData['step2_status']) {
//                $departmentScheme->overall_status = $mPostData['step1_status'];
//            } else {
//                $departmentScheme->overall_status = $mPostData['step2_status'];
//            }
            $departmentScheme->overall_status = 1;



            if ($result = $this->DepartmentSchemes->save($departmentScheme)) {
                $this->Flash->success(__('New scheme has been saved.'));

                return $this->redirect(['action' => 'schemeprofile', $result->id]);
            }
//            debug($departmentScheme);
//            exit;
            $this->Flash->error(__('New scheme could not be saved. Please, try again.'));
        }
//        $departments = $this->DepartmentSchemes->Departments->find('list', ['limit' => 200]);  'departments', 
//        $schemeStatuses = $this->DepartmentSchemes->SchemeStatuses->find('list', ['limit' => 200, 'keyField' => 'status_name', 'valueField' => 'status_name']); , 'schemeStatuses'
        $project_types = $this->send_types();
        $this->set(compact('departmentScheme', 'project_types'));
    }

    public function schemeprofile($id = null) {
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->first();
        } else {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id]])->first();
        }
//debug($departmentScheme);exit;
        if ($this->request->is(['patch', 'post', 'put'])) {

//          
            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $this->request->getData());
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
            if (isset($this->request->getData()['scheme_start_date'])) {
                $departmentScheme->scheme_start_date = date('Y-m-d', strtotime($this->request->getData()['scheme_start_date']));
                $departmentScheme->scheme_end_date = date('Y-m-d', strtotime($this->request->getData()['scheme_end_date']));
            }
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                $this->savelog($departmentScheme->department_id, $id, $this->request->getData());

                $this->Flash->success(__('The scheme profile has been saved.'));

                return $this->redirect(['action' => 'reldistricts', $id]);
            }
//            debug($departmentScheme);
            $this->Flash->error(__('The scheme profile could not be saved. Please, try again.'));
        }
        $project_types = $this->send_types();

        $this->loadModel('SchemeRequests');
        $schemeRequests = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $this->Authentication->getResult()->getData()->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'schemeprofile'
            ]])->count();
//        debug($schemeRequests);
//        exit;

        $this->set(compact('departmentScheme', 'project_types', 'schemeRequests'));
    }

    public function reldistricts($id = null) {
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->first();
        } else {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id]])->first();
        }
        $this->loadModel('SchemeDistricts');

        if ($this->request->is(['patch', 'post', 'put'])) {

            if ($this->request->getData()) {
                $single_array = [];
//                debug($this->request->getData());exit;
                $this->SchemeDistricts->deleteAll(['department_scheme_id' => $id]);
                foreach ($this->request->getData()['disid'] as $data):

                    $articles = $this->getTableLocator()->get('SchemeDistricts');
                    $query = $articles->query();
                    $query->insert(['district_id', 'department_scheme_id', 'department_id', 'created_by', 'modified_by', 'created', 'modified'])
                            ->values([
                                'district_id' => $data,
                                'department_scheme_id' => $id,
                                'department_id' => $this->Authentication->getResult()->getData()->department_id,
                                'created_by' => $this->request->getAttribute('identity')->getIdentifier(),
                                'modified_by' => $this->request->getAttribute('identity')->getIdentifier(),
                                'created' => date('Y-m-d'),
                                'modified' => date('Y-m-d'),
                            ])
                            ->execute();
                endforeach;

//                $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $this->request->getData());
//                if ($this->DepartmentSchemes->save($departmentScheme)) {
                $this->Flash->success(__('Related districts has been saved.'));

                return $this->redirect(['action' => 'step1', $id]);
//                }
//                $this->Flash->error(__('The department scheme could not be saved. Please, try again.'));
            } else {
                $this->Flash->error(__('You must Choose atleast 1 district'));
            }
        }
        $choosen_districts = $this->SchemeDistricts->find('list', ['keyField' => 'district_id', 'valueField' => 'district_id', 'conditions' => ['SchemeDistricts.department_scheme_id' => $id]])->all()->toArray();
//        debug($choosen_districts);
//        exit;
        $this->loadModel('Districts');
//        debug($departmentScheme->geo_coverage);//exit;
        $districts = $this->Districts->find('list', ['conditions' => ['Districts.deleted' => 0, 'Districts.type like' => '%' . $departmentScheme->geo_coverage . '%'], 'order' => ['name' => 'asc']])->all();

        $this->set(compact('departmentScheme', 'districts', 'choosen_districts'));
    }

    public function checkstatus() {

        $departmentSchemes = $this->DepartmentSchemes->find('all', ['contain' => ['CustomMilestones' => ['conditions' => ['is_completed' => 'No']]], 'conditions' => ['overall_status IN ' => [3, 4], 'deleted' => 0]])->all();
        foreach ($departmentSchemes as $scheme):
//            debug();exit;
            $steps_array = array();
            $steps_array[1] = $scheme->step1_status;
            $steps_array[2] = $scheme->step2_status;
            $steps_array[3] = $scheme->step3_status;
            $steps_array[4] = $scheme->step4_status;
            $steps_array[5] = $scheme->step5_status;
            $steps_array[6] = $scheme->step6_status;
            $steps_array[7] = $scheme->step7_status;
            $steps_array[8] = $scheme->custom_status;

//            debug($steps_array);
            //check step1 for Off track or On Track
            if ($scheme->step1_status == 3 || $scheme->step1_status == 4) {
//                debug($scheme['pc2_compl_date']);exit;

                if ($scheme['pc2_compl_date'] && $scheme['pc2_compl_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {
                    $scheme->step1_status = '3';
                } else { //off_track zone or danger zone
                    $time = new FrozenTime($scheme['pc2_compl_date']);

                    if ($time->diffInDays() > 15) { //danger zone
                        $scheme->step1_status = '5';
                    } else { //off_track zone
                        $scheme->step1_status = '4';
                    }
                }

                $steps_array[1] = $scheme->step1_status;
//                debug($steps_array);
            }

//            exit;
            //check step2 for Off track or On Track
            if ($scheme->step2_status == 3 || $scheme->step2_status == 4) {
//                debug('check step2');
                if ($scheme['pc1_compl_date'] && $scheme['pc1_compl_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {
                    $scheme->step2_status = '3';
                } else { //off_track zone or danger zone
                    $time = new FrozenTime($scheme['pc1_compl_date']);

                    if ($time->diffInDays() > 15) { //danger zone
                        $scheme->step2_status = '5';
                    } else { //off_track zone
                        $scheme->step2_status = '4';
                    }
                }
                $steps_array[2] = $scheme->step2_status;
            }
            //check step3 for Off track or On Track
            if ($scheme->step3_status == 3 || $scheme->step3_status == 4) {
//                debug('check step3');
                if ($scheme['sne_required'] == 'Yes') {
                    if ($scheme['sne_submitted'] == 'Yes') {
                        if ($scheme['sne_approved'] == 'Yes') {
                            //other hiring questions

                            if ($scheme['will_hiring_through_psc'] == 'Yes' && $scheme['will_hiring_through_internal_posting'] == 'Yes' && $scheme['will_hiring_through_market'] == 'Yes' &&
                                    $scheme['hiring_through_psc'] == 'Yes' && $scheme['hiring_through_internal_posting'] == 'Yes' && $scheme['hiring_through_market'] == 'Yes') {
//all three + three are yes then green signal and nohting to do
                                $scheme->step3_status = '2';
                            } else {
                                $step3_hiring_array = array();
                                if ($scheme['will_hiring_through_psc'] == 'Yes') {
                                    if ($scheme['hiring_through_psc'] == 'Yes') {
                                        array_push($step3_hiring_array, 2);
                                    } else {
                                        if ($scheme['hiring_compl_date_psc'] && $scheme['hiring_compl_date_psc']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {

                                            array_push($step3_hiring_array, 3);
                                        } else {
                                            //check date thing
                                            $time = new FrozenTime($scheme['hiring_compl_date_psc']);

                                            if ($time->diffInDays() > 15) { //danger zone
                                                array_push($step3_hiring_array, 5);
                                            } else { //off_track zone
                                                array_push($step3_hiring_array, 4);
                                            }
                                        }
                                    }
                                }
                                if ($scheme['will_hiring_through_internal_posting'] == 'Yes') {
                                    if ($scheme['hiring_through_internal_posting'] == 'Yes') {
                                        array_push($step3_hiring_array, 2);
                                    } else {
                                        if ($scheme['hiring_compl_date_internal_posting'] && $scheme['hiring_compl_date_internal_posting']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {

                                            array_push($step3_hiring_array, 3);
                                        } else {
                                            //check date thing
                                            $time = new FrozenTime($scheme['hiring_compl_date_internal_posting']);

                                            if ($time->diffInDays() > 15) { //danger zone
                                                array_push($step3_hiring_array, 5);
                                            } else { //off_track zone
                                                array_push($step3_hiring_array, 4);
                                            }
                                        }
                                    }
                                }
                                if ($scheme['will_hiring_through_market'] == 'Yes') {
                                    if ($scheme['hiring_through_market'] == 'Yes' && $scheme['posting_though_market_media'] == 'Yes' && $scheme['hiring_market_entries_recorded'] == 'Yes' &&
                                            $scheme['hiring_market_scrutiny_compl'] == 'Yes' && $scheme['hiring_market_intervies_cond'] == 'Yes' && $scheme['hiring_market_appoint_letter_issues'] == 'Yes') {
                                        array_push($step3_hiring_array, 2);
                                    } else {
                                        if ($scheme['hiring_market_compl_date'] && $scheme['hiring_market_compl_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {

                                            array_push($step3_hiring_array, 3);
                                        } else {
                                            //check date thing
                                            $time = new FrozenTime($scheme['hiring_market_compl_date']);

                                            if ($time->diffInDays() > 15) { //danger zone
                                                array_push($step3_hiring_array, 5);
                                            } else { //off_track zone
                                                array_push($step3_hiring_array, 4);
                                            }
                                        }
                                    }
                                }

//                        debug($post);
//                        exit;
//                        debug($step3_hiring_array);exit;
                                //count max of it and that will be the status
                                $scheme->step3_status = (int) max($step3_hiring_array);
                            }
                        } else { //SNE -> NO => Directly compare the dates and make status thing
                            if ($scheme['sne_approval_date'] && $scheme['sne_approval_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {
                                $scheme->step3_status = '3';
                            } else { //off_track zone or danger zone
                                $time = new FrozenTime($scheme['sne_approval_date']);

                                if ($time->diffInDays() > 15) { //danger zone
                                    $scheme->step3_status = '5';
                                } else { //off_track zone
                                    $scheme->step3_status = '4';
                                }
                            }
                        }
                    } else {
                        if ($scheme['sne_submission_date'] && $scheme['sne_submission_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {
                            $scheme->step3_status = '3';
                        } else { //off_track zone or danger zone
                            $time = new FrozenTime($scheme['sne_submission_date']);
                            if ($time->diffInDays() > 15) { //danger zone
                                $scheme->step3_status = '5';
                                $scheme->overall_status = '5';
                            } else { //off_track zone
                                $scheme->step3_status = '4';
                            }
                        }
                    }
                } else {

                    //directly check the answers for hiring through other 3 steps
                    if ($scheme['will_hiring_through_psc'] == 'Yes' && $scheme['will_hiring_through_internal_posting'] == 'Yes' && $scheme['will_hiring_through_market'] == 'Yes' &&
                            $scheme['hiring_through_psc'] == 'Yes' && $scheme['hiring_through_internal_posting'] == 'Yes' && $scheme['hiring_through_market'] == 'Yes') {
//all three + three are yes then green signal and nohting to do
                        $scheme->step3_status = '2';
                    } else {
                        $step3_hiring_array = array();
                        if ($scheme['will_hiring_through_psc'] == 'Yes') {
                            if ($scheme['hiring_through_psc'] == 'Yes') {
                                array_push($step3_hiring_array, 2);
                            } else {
                                if ($scheme['hiring_compl_date_psc'] && $scheme['hiring_compl_date_psc']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {

                                    array_push($step3_hiring_array, 3);
                                } else {
                                    //check date thing
                                    $time = new FrozenTime($scheme['hiring_compl_date_psc']);

                                    if ($time->diffInDays() > 15) { //danger zone
                                        array_push($step3_hiring_array, 5);
                                    } else { //off_track zone
                                        array_push($step3_hiring_array, 4);
                                    }
                                }
                            }
                        }
                        if ($scheme['will_hiring_through_internal_posting'] == 'Yes') {
                            if ($scheme['hiring_through_internal_posting'] == 'Yes') {
                                array_push($step3_hiring_array, 2);
                            } else {
                                if ($scheme['hiring_compl_date_internal_posting'] && $scheme['hiring_compl_date_internal_posting']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {

                                    array_push($step3_hiring_array, 3);
                                } else {
                                    //check date thing
                                    $time = new FrozenTime($scheme['hiring_compl_date_internal_posting']);

                                    if ($time->diffInDays() > 15) { //danger zone
                                        array_push($step3_hiring_array, 5);
                                    } else { //off_track zone
                                        array_push($step3_hiring_array, 4);
                                    }
                                }
                            }
                        }
                        if ($scheme['will_hiring_through_market'] == 'Yes') {
                            if ($scheme['hiring_through_market'] == 'Yes' && $scheme['posting_though_market_media'] == 'Yes' && $scheme['hiring_market_entries_recorded'] == 'Yes' &&
                                    $scheme['hiring_market_scrutiny_compl'] == 'Yes' && $scheme['hiring_market_intervies_cond'] == 'Yes' && $scheme['hiring_market_appoint_letter_issues'] == 'Yes') {
                                array_push($step3_hiring_array, 2);
                            } else {
                                if ($scheme['hiring_market_compl_date'] && $scheme['hiring_market_compl_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {

                                    array_push($step3_hiring_array, 3);
                                } else {
                                    //check date thing
                                    $time = new FrozenTime($scheme['hiring_market_compl_date']);

                                    if ($time->diffInDays() > 15) { //danger zone
                                        array_push($step3_hiring_array, 5);
                                    } else { //off_track zone
                                        array_push($step3_hiring_array, 4);
                                    }
                                }
                            }
                        }

//                        debug($post);
//                        exit;
//                        debug($step3_hiring_array);exit;
                        //count max of it and that will be the status
                        $scheme->step3_status = (int) max($step3_hiring_array);
                    }
                }
            }
            //check step4 for Off track or On Track
            if ($scheme->step4_status == 3 || $scheme->step4_status == 4) {
//                debug('check step4');
                if ($scheme['land_acquisition_compl_date'] && $scheme['land_acquisition_compl_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {
                    $scheme->step4_status = '3';
                } else {
                    $time = new FrozenTime($scheme['land_acquisition_compl_date']);

                    if ($time->diffInDays() > 15) { //danger zone
                        $scheme->step4_status = '5';
                    } else { //off track
                        $scheme->step4_status = '4';
                    }
                }
                $steps_array[4] = $scheme->step4_status;
            }
            //check step5 for Off track or On Track
            if ($scheme->step5_status == 3 || $scheme->step5_status == 4) {
//                debug('check step5');
                if ($scheme['proc_goods_compl_date'] && $scheme['proc_goods_compl_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {
                    $scheme->step5_status = '3';
                } else {
                    $time = new FrozenTime($scheme['proc_goods_compl_date']);

                    if ($time->diffInDays() > 15) { //danger zone
                        $scheme->step5_status = '5';
                    } else {
                        $scheme->step5_status = '4';
                    }
                }
                $steps_array[5] = $scheme->step5_status;
            }
            //check step6 for Off track or On Track
            if ($scheme->step6_status == 3 || $scheme->step6_status == 4) {
//                debug('check step6');
                if ($scheme['proc_services_compl_date'] && $scheme['proc_services_compl_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {
                    $scheme->step6_status = '3';
                } else {
                    $time = new FrozenTime($scheme['proc_services_compl_date']);

                    if ($time->diffInDays() > 15) { //danger zone
                        $scheme->step6_status = '5';
                    } else { //off track
                        $scheme->step6_status = '4';
                    }
                }
                $steps_array[6] = $scheme->step6_status;
            }

            //check step7 for Off track or On Track
            if ($scheme->step7_status == 3 || $scheme->step7_status == 4) {
//                debug('check step7');
                $step7_cons_array = array();

                if ($scheme['is_work_carried_by_civil_works'] == 'Yes') {
                    if ($scheme['is_work_begun'] == 'Yes' && $scheme['level_of_work_compl'] == '100') {
                        array_push($step7_cons_array, 2);
                    } else {
                        if ($scheme['cons_civil_compl_date'] && $scheme['cons_civil_compl_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {
                            array_push($step7_cons_array, 3);
                        } else {
                            //check date thing
                            $time = new FrozenTime($scheme['cons_civil_compl_date']);

                            if ($time->diffInDays() > 15) { //danger zone
                                array_push($step7_cons_array, 5);
                            } else { //off_track zone
                                array_push($step7_cons_array, 4);
                            }
                        }
                    }
                }
//                debug($post);
//                exit;
                if ($scheme['is_work_commisioned_privately'] == 'Yes') {
                    if ($scheme['cons_civil_private_type'] == 'single_source') {
                        if ($scheme['is_work_begun'] == 'Yes' && $scheme['level_of_work_compl'] == '100') {
                            array_push($step7_cons_array, 2);
                        } else {
                            if ($scheme['cons_civil_compl_date'] && $scheme['cons_civil_compl_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {
                                array_push($step7_cons_array, 3);
                            } else {
                                //check date thing
                                $time = new FrozenTime($scheme['cons_civil_compl_date']);

                                if ($time->diffInDays() > 15) { //danger zone
                                    array_push($step7_cons_array, 5);
                                } else { //off_track zone
                                    array_push($step7_cons_array, 4);
                                }
                            }
                        }
                    } else {
                        if ($scheme['is_work_begun'] == 'Yes' && $scheme['level_of_work_compl'] == '100' && $scheme['is_work_tender_advertised'] == 'Yes' &&
                                $scheme['is_work_bidding_compl'] == 'Yes' && $scheme['is_work_order_issued'] == 'Yes') {
                            array_push($step7_cons_array, 2);
                        } else {
                            if ($scheme['cons_civil_compl_date'] && $scheme['cons_civil_compl_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {
                                array_push($step7_cons_array, 3);
                            } else {
                                //check date thing
                                $time = new FrozenTime($scheme['cons_civil_compl_date']);

                                if ($time->diffInDays() > 15) { //danger zone
                                    array_push($step7_cons_array, 5);
                                } else { //off_track zone
                                    array_push($step7_cons_array, 4);
                                }
                            }
                        }
                    }
                }

//                        debug($post);
//                        exit;
//                        debug($step3_hiring_array);exit;
                //count max of it and that will be the status
                $scheme->step7_status = (int) max($step7_cons_array);
                $steps_array[7] = $scheme->step7_status;
            }

            //step8-starts here
            //check step7 for Off track or On Track
            if ($scheme->custom_status == 3 || $scheme->custom_status == 4) {
//                debug('check step7');
                $custom_array = array();
                $this->loadModel('CustomMilestones');
                foreach ($scheme->custom_milestones as $milestone):
//                    debug($milestone);
//                    if ($milestone->is_completed == 'No') {
//                        debug($milestone);
                    $customMilestone = $this->CustomMilestones->get($milestone['id']);

                    if ($milestone['completion_date'] && $milestone['completion_date']->i18nFormat('YYY-MM-dd') >= date('Y-m-d')) {
                        $dec = 3;
                    } else {
                        //check date thing
                        $time = new FrozenTime($milestone['completion_date']);

                        if ($time->diffInDays() > 15) { //danger zone
                            $dec = 5;
                        } else { //off_track zone
                            $dec = 4;
                        }
                    }
                    $customMilestone->milestone_status = $dec;
                    $this->CustomMilestones->save($customMilestone);
                    array_push($custom_array, $dec);

//                    }

                endforeach;
//                debug($custom_array);
//                exit;

                $scheme->custom_status = (int) max($custom_array);
                $steps_array[8] = $scheme->custom_status;
            }
            //step8 ends here
            //final over all status of this scheme
            $scheme->overall_status = (int) max($steps_array);
            $scheme->last_cron_job_date = date('Y-m-d');

//            debug($scheme);
//            $entity = $this->DepartmentSchemes->newEntity($single_array);
            if ($this->DepartmentSchemes->save($scheme)) {
                echo $scheme->id . ' Updated <br/>';
            } else {
                debug($scheme);
            }
//            exit;
        endforeach;
        exit; //dont have view files thats why ending here
    }

    public function step1($id = null) {
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->first();
        } else {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id]])->first();
        }
        if ($this->request->is(['patch', 'post', 'put'])) {
            $post = $this->request->getData();

            if (trim($post['step1_remarks']) !== trim($post['step1_old_remarks'])) {
                $post['step1_date_change'] = date('Y-m-d');
            }

            if (isset($post['pc2_compl_date']) && $post['pc2_compl_date']) {
//                echo __LINE__;exit;
                $post['pc2_compl_date'] = ($post['pc2_compl_date']) ? date('Y-m-d', strtotime($post['pc2_compl_date'])) : '';
            } else {
                $post['pc2_compl_date'] = ($departmentScheme->pc2_compl_date) ? $departmentScheme->pc2_compl_date->i18nFormat('YYY-MM-dd') : '';
            }
            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
//status thing starts here
//             debug($post);exit;
            if ($post['pc2_required'] == 'Yes') {
                //required, now need to check if completed,on_track or off_track or critically_delayed
                if ($post['pc2_approved'] == 'Yes' && $post['consultant_hired'] == 'Yes' && $post['cons_subt_report'] == 'Yes') {
                    $departmentScheme->step1_status = '2';
                } else {

                    if ($post['pc2_compl_date'] >= date('Y-m-d')) {
                        $departmentScheme->step1_status = '3';
                    } else { //off_track zone or danger zone
                        $now = time(); // or your date as well
                        $your_date = strtotime($post['pc2_compl_date']);
                        $datediff = $now - $your_date;

                        $diff = round($datediff / (60 * 60 * 24));
                        if ($diff > 15) { //danger zone
                            $departmentScheme->step1_status = '5';
                            $departmentScheme->overall_status = '5';
                        } else { //off_track zone
                            $departmentScheme->step1_status = '4';
                        }
                    }
                }
            } else if ($post['pc2_required'] == 'No') {
                //not required so kind of completed
                $departmentScheme->step1_status = '2';
            } else {
                //if null or empty as from the first time
                $departmentScheme->step1_status = '1';
            }

//            debug($departmentScheme->step1_status);
            //calculating over_all_status

            if ($departmentScheme->step1_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step1_status; //commented to know about the status of other milesstones
                $post['steps_array'][1] = $departmentScheme->step1_status;
// && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            }
            //status thing ends here
//            debug($departmentScheme->overall_status);
//            exit;
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                //call log here
                unset($post['steps_array']);
//                debug($post);exit;
                $this->savelog($departmentScheme->department_id, $id, $post);

                $this->Flash->success(__('PC-2 requirement has been saved.'));

                return $this->redirect(['action' => 'step2', $id]);
            }
//            debug($departmentScheme);exit;
            $this->Flash->error(__('PC-2 requirement could not be saved. Please, try again.'));
        }
        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'conditions' => ['Departments.deleted' => 0], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();


        $this->loadModel('SchemeRequests');
        $schemeRequests = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $this->Authentication->getResult()->getData()->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step1'
            ]])->count();
//        debug($schemeRequests);
//        exit;

        $this->set(compact('departmentScheme', 'departments', 'schemeRequests'));
    }
	
	public function addSubActivity($id = null) {
		//die($id);
		$sub_activity = $this->getTableLocator()->get('SubActivity');
		$query = $sub_activity->query();
		$query->insert(['department_scheme_id', 'activity', 'title', 'start_date', 'end_date', 'responsibility', 'remarks', 'created', 'modified', 'status'])
				->values([
					'department_scheme_id' => $id,
					'activity' => $this->request->getData()['activity'],
					'title' => $this->request->getData()['title'],
					'responsibility' => $this->request->getData()['responsibility'],
					'start_date' => ($this->request->getData()['start_date']) ? date('Y-m-d', strtotime($this->request->getData()['start_date'])) : '',
					'end_date' => ($this->request->getData()['end_date']) ? date('Y-m-d', strtotime($this->request->getData()['end_date'])) : '',
					'remarks' => $this->request->getData()['remarks'],
					'milestone_status' => 1,
					'status' => 1,
					'created' => date('Y-m-d'),
					'modified' => date('Y-m-d'),
				])
				->execute();
				
		//return $this->redirect(['action' => 'view', $id]);		
		$this->redirect($this->referer());
	}

    public function step2($id = null) {
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->first();
        } else {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id]])->first();
        }
        if ($this->request->is(['patch', 'post', 'put'])) {
            $post = $this->request->getData();
//            debug($post);
//            exit;

            if (trim($post['step2_remarks']) !== trim($post['step2_old_remarks'])) {
                $post['step2_date_change'] = date('Y-m-d');
            }

            if (isset($post['pc1_approval_date']) && $post['pc1_approval_date']) {
                $post['pc1_approval_date'] = date('Y-m-d', strtotime($post['pc1_approval_date']));
            } else {
                $post['pc1_approval_date'] = ($departmentScheme->pc1_approval_date) ? $departmentScheme->pc1_approval_date->i18nFormat('YYY-MM-dd') : '';
            }
            if (isset($post['pc1_compl_date']) && $post['pc1_compl_date']) {
                $post['pc1_compl_date'] = date('Y-m-d', strtotime($post['pc1_compl_date']));
            } else {
                $post['pc1_compl_date'] = ($departmentScheme->pc1_compl_date) ? $departmentScheme->pc1_compl_date->i18nFormat('YYY-MM-dd') : '';
            }
//                debug($post['pc1_compl_date']);exit;
            if ($post['pc1_required'] == 'Yes') {





                if ($post['pc1_approved'] == 'No') {
                    //required, now need to check if completed,on_track or off_track or critically_delayed

                    if ($post['pc1_compl_date'] >= date('Y-m-d')) {
                        $departmentScheme->step2_status = '3';
                    } else { //off_track zone or danger zone
                        $now = time(); // or your date as well
                        $your_date = strtotime($post['pc1_compl_date']);
                        $datediff = $now - $your_date;

                        $diff = round($datediff / (60 * 60 * 24));
                        if ($diff > 15) { //danger zone
                            $departmentScheme->step2_status = '5';
                            $departmentScheme->overall_status = '5';
                        } else { //off_track zone
                            $departmentScheme->step2_status = '4';
                        }
                    }
                } else if ($post['pc1_approved'] == 'Yes') {
                    //not required so kind of completed
                    $departmentScheme->step2_status = '2';
                } else {
                    //if null or empty as from the first time
                    $departmentScheme->step2_status = '1';
                }
            } else {
                $departmentScheme->step2_status = '2';
            }


            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
//status thing starts here
//            debug($departmentScheme->step1_status);
            //calculating over_all_status

            if ($departmentScheme->step2_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step2_status;
                $post['steps_array'][2] = $departmentScheme->step2_status;
// && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            }
            //status thing ends here
//            debug($departmentScheme->overall_status);
//            exit;
//            debug($departmentScheme->step2_date_change);exit;
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('PC-1 requirement has been saved.'));

                return $this->redirect(['action' => 'step3', $id]);
            }
            debug($departmentScheme);
            exit;
            $this->Flash->error(__('PC-1 requirement could not be saved. Please, try again.'));
        }

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'conditions' => ['Departments.deleted' => 0], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $schemeRequests = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $this->Authentication->getResult()->getData()->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step2'
            ]])->count();
//        debug($schemeRequests);
//        exit;

        $this->set(compact('departmentScheme', 'departments', 'schemeRequests'));
    }

    public function step3($id = null) {
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->first();
        } else {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id]])->first();
        }
        if ($this->request->is(['patch', 'post', 'put'])) {

            $post = $this->request->getData();

            if (trim($post['step3_remarks']) !== trim($post['step3_old_remarks'])) {
                $post['step3_date_change'] = date('Y-m-d');
            }

            if (isset($post['hiring_compl_date_psc']) && $post['hiring_compl_date_psc']) {
                $post['hiring_compl_date_psc'] = date('Y-m-d', strtotime($post['hiring_compl_date_psc']));
            } else {
                $post['hiring_compl_date_psc'] = ($departmentScheme->hiring_compl_date_psc) ? $departmentScheme->hiring_compl_date_psc->i18nFormat('YYY-MM-dd') : '';
            }

            if (isset($post['hiring_compl_date_internal_posting']) && $post['hiring_compl_date_internal_posting']) {
                $post['hiring_compl_date_internal_posting'] = date('Y-m-d', strtotime($post['hiring_compl_date_internal_posting']));
            } else {
                $post['hiring_compl_date_internal_posting'] = ($departmentScheme->hiring_compl_date_internal_posting) ? $departmentScheme->hiring_compl_date_internal_posting->i18nFormat('YYY-MM-dd') : '';
            }

            if (isset($post['hiring_market_compl_date']) && $post['hiring_market_compl_date']) {
                $post['hiring_market_compl_date'] = date('Y-m-d', strtotime($post['hiring_market_compl_date']));
            } else {
                $post['hiring_market_compl_date'] = ($departmentScheme->hiring_market_compl_date) ? $departmentScheme->hiring_market_compl_date->i18nFormat('YYY-MM-dd') : '';
            }

            if (isset($post['sne_submission_date']) && $post['sne_submission_date']) {
                $post['sne_submission_date'] = date('Y-m-d', strtotime($post['sne_submission_date']));
            } else {
                $post['sne_submission_date'] = ($departmentScheme->sne_submission_date) ? $departmentScheme->sne_submission_date->i18nFormat('YYY-MM-dd') : '';
            }
            if (isset($post['sne_approval_date']) && $post['sne_approval_date']) {
                $post['sne_approval_date'] = date('Y-m-d', strtotime($post['sne_approval_date']));
            } else {
                $post['sne_approval_date'] = ($departmentScheme->sne_approval_date) ? $departmentScheme->sne_approval_date->i18nFormat('YYY-MM-dd') : '';
            }

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();

            //status thing starts here
//            debug($post);
//            exit;
            if ($post['hiring_required'] == 'Yes') {

                if ($post['sne_required'] == 'Yes') {
                    if ($post['sne_submitted'] == 'Yes') {
                        if ($post['sne_approved'] == 'Yes') {
                            //other hiring questions

                            if ($post['will_hiring_through_psc'] == 'Yes' && $post['will_hiring_through_internal_posting'] == 'Yes' && $post['will_hiring_through_market'] == 'Yes' &&
                                    $post['hiring_through_psc'] == 'Yes' && $post['hiring_through_internal_posting'] == 'Yes' && $post['hiring_through_market'] == 'Yes') {
//all three + three are yes then green signal and nohting to do
                                $departmentScheme->step3_status = '2';
                            } else {
                                $step3_hiring_array = array();
                                if ($post['will_hiring_through_psc'] == 'Yes') {
                                    if ($post['hiring_through_psc'] == 'Yes') {
                                        array_push($step3_hiring_array, 2);
                                    } else {
                                        if ($post['hiring_compl_date_psc'] >= date('Y-m-d')) {

                                            array_push($step3_hiring_array, 3);
                                        } else {
                                            //check date thing
                                            $now = time(); // or your date as well
                                            $your_date = strtotime($post['hiring_compl_date_psc']);
                                            $datediff = $now - $your_date;

                                            $diff = round($datediff / (60 * 60 * 24));
                                            if ($diff > 15) { //danger zone
                                                array_push($step3_hiring_array, 5);
                                                $departmentScheme->overall_status = '5';
                                            } else { //off_track zone
                                                array_push($step3_hiring_array, 4);
                                            }
                                        }
                                    }
                                }
                                if ($post['will_hiring_through_internal_posting'] == 'Yes') {
                                    if ($post['hiring_through_internal_posting'] == 'Yes') {
                                        array_push($step3_hiring_array, 2);
                                    } else {
                                        if ($post['hiring_compl_date_internal_posting'] >= date('Y-m-d')) {

                                            array_push($step3_hiring_array, 3);
                                        } else {
                                            //check date thing
                                            $now = time(); // or your date as well
                                            $your_date = strtotime($post['hiring_compl_date_internal_posting']);
                                            $datediff = $now - $your_date;

                                            $diff = round($datediff / (60 * 60 * 24));
                                            if ($diff > 15) { //danger zone
                                                array_push($step3_hiring_array, 5);
                                                $departmentScheme->overall_status = '5';
                                            } else { //off_track zone
                                                array_push($step3_hiring_array, 4);
                                            }
                                        }
                                    }
                                }
                                if ($post['will_hiring_through_market'] == 'Yes') {
                                    if ($post['hiring_through_market'] == 'Yes' && $post['posting_though_market_media'] == 'Yes' && $post['hiring_market_entries_recorded'] == 'Yes' &&
                                            $post['hiring_market_scrutiny_compl'] == 'Yes' && $post['hiring_market_intervies_cond'] == 'Yes' && $post['hiring_market_appoint_letter_issues'] == 'Yes') {
                                        array_push($step3_hiring_array, 2);
                                    } else {
                                        if ($post['hiring_market_compl_date'] >= date('Y-m-d')) {

                                            array_push($step3_hiring_array, 3);
                                        } else {
                                            //check date thing
                                            $now = time(); // or your date as well
                                            $your_date = strtotime($post['hiring_market_compl_date']);
                                            $datediff = $now - $your_date;

                                            $diff = round($datediff / (60 * 60 * 24));
                                            if ($diff > 15) { //danger zone
                                                array_push($step3_hiring_array, 5);
                                                $departmentScheme->overall_status = '5';
                                            } else { //off_track zone
                                                array_push($step3_hiring_array, 4);
                                            }
                                        }
                                    }
                                }

//                        debug($post);
//                        exit;
//                        debug($step3_hiring_array);exit;
                                //count max of it and that will be the status
                                $departmentScheme->step3_status = (int) max($step3_hiring_array);
                            }
                        } else { //SNE -> NO => Directly compare the dates and make status thing
                            if ($post['sne_approval_date'] >= date('Y-m-d')) {
                                $departmentScheme->step3_status = '3';
                            } else { //off_track zone or danger zone
                                $now = time(); // or your date as well
                                $your_date = strtotime($post['sne_approval_date']);
                                $datediff = $now - $your_date;

                                $diff = round($datediff / (60 * 60 * 24));
                                if ($diff > 15) { //danger zone
                                    $departmentScheme->step3_status = '5';
                                    $departmentScheme->overall_status = '5';
                                } else { //off_track zone
                                    $departmentScheme->step3_status = '4';
                                }
                            }
                        }
                    } else {
                        if ($post['sne_submission_date'] >= date('Y-m-d')) {
                            $departmentScheme->step3_status = '3';
                        } else { //off_track zone or danger zone
                            $now = time(); // or your date as well
                            $your_date = strtotime($post['sne_submission_date']);
                            $datediff = $now - $your_date;

                            $diff = round($datediff / (60 * 60 * 24));
                            if ($diff > 15) { //danger zone
                                $departmentScheme->step3_status = '5';
                                $departmentScheme->overall_status = '5';
                            } else { //off_track zone
                                $departmentScheme->step3_status = '4';
                            }
                        }
                    }
                } else {
                    //directly check the answers for hiring through other 3 steps
                    if ($post['will_hiring_through_psc'] == 'Yes' && $post['will_hiring_through_internal_posting'] == 'Yes' && $post['will_hiring_through_market'] == 'Yes' &&
                            $post['hiring_through_psc'] == 'Yes' && $post['hiring_through_internal_posting'] == 'Yes' && $post['hiring_through_market'] == 'Yes') {
//all three + three are yes then green signal and nohting to do
                        $departmentScheme->step3_status = '2';
                    } else {
                        $step3_hiring_array = array();
                        if ($post['will_hiring_through_psc'] == 'Yes') {
                            if ($post['hiring_through_psc'] == 'Yes') {
                                array_push($step3_hiring_array, 2);
                            } else {
                                if ($post['hiring_compl_date_psc'] >= date('Y-m-d')) {

                                    array_push($step3_hiring_array, 3);
                                } else {
                                    //check date thing
                                    $now = time(); // or your date as well
                                    $your_date = strtotime($post['hiring_compl_date_psc']);
                                    $datediff = $now - $your_date;

                                    $diff = round($datediff / (60 * 60 * 24));
                                    if ($diff > 15) { //danger zone
                                        array_push($step3_hiring_array, 5);
                                        $departmentScheme->overall_status = '5';
                                    } else { //off_track zone
                                        array_push($step3_hiring_array, 4);
                                    }
                                }
                            }
                        }
                        if ($post['will_hiring_through_internal_posting'] == 'Yes') {
                            if ($post['hiring_through_internal_posting'] == 'Yes') {
                                array_push($step3_hiring_array, 2);
                            } else {
                                if ($post['hiring_compl_date_internal_posting'] >= date('Y-m-d')) {

                                    array_push($step3_hiring_array, 3);
                                } else {
                                    //check date thing
                                    $now = time(); // or your date as well
                                    $your_date = strtotime($post['hiring_compl_date_internal_posting']);
                                    $datediff = $now - $your_date;

                                    $diff = round($datediff / (60 * 60 * 24));
                                    if ($diff > 15) { //danger zone
                                        array_push($step3_hiring_array, 5);
                                        $departmentScheme->overall_status = '5';
                                    } else { //off_track zone
                                        array_push($step3_hiring_array, 4);
                                    }
                                }
                            }
                        }
                        if ($post['will_hiring_through_market'] == 'Yes') {
                            if ($post['hiring_through_market'] == 'Yes' && $post['posting_though_market_media'] == 'Yes' && $post['hiring_market_entries_recorded'] == 'Yes' &&
                                    $post['hiring_market_scrutiny_compl'] == 'Yes' && $post['hiring_market_intervies_cond'] == 'Yes' && $post['hiring_market_appoint_letter_issues'] == 'Yes') {
                                array_push($step3_hiring_array, 2);
                            } else {
                                if ($post['hiring_market_compl_date'] >= date('Y-m-d')) {

                                    array_push($step3_hiring_array, 3);
                                } else {
                                    //check date thing
                                    $now = time(); // or your date as well
                                    $your_date = strtotime($post['hiring_market_compl_date']);
                                    $datediff = $now - $your_date;

                                    $diff = round($datediff / (60 * 60 * 24));
                                    if ($diff > 15) { //danger zone
                                        array_push($step3_hiring_array, 5);
                                        $departmentScheme->overall_status = '5';
                                    } else { //off_track zone
                                        array_push($step3_hiring_array, 4);
                                    }
                                }
                            }
                        }

//                        debug($post);
//                        exit;
//                        debug($step3_hiring_array);exit;
                        //count max of it and that will be the status
                        $departmentScheme->step3_status = (int) max($step3_hiring_array);
                    }
                }
            } else if ($post['hiring_required'] == 'No') {
                //not required so kind of completed
                $departmentScheme->step3_status = '2';
            } else {
                //if null or empty as from the first time
                $departmentScheme->step3_status = '1';
            }

//            debug($departmentScheme->step1_status);
            //calculating over_all_status

            if ($departmentScheme->step3_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step3_status;
                $post['steps_array'][3] = $departmentScheme->step3_status;
//                debug($post['steps_array']);exit; 
//                 && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            }
            //status thing ends here
//            debug($departmentScheme->overall_status);
//            exit;

            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('Hiring requirement has been saved.'));

                return $this->redirect(['action' => 'step4', $id]);
            }
            $this->Flash->error(__('Hiring requirement could not be saved. Please, try again.'));
        }

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'conditions' => ['Departments.deleted' => 0], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $schemeRequests = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $this->Authentication->getResult()->getData()->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step3'
            ]])->count();
//        debug($schemeRequests);
//        exit;

        $this->set(compact('departmentScheme', 'departments', 'schemeRequests'));
    }

    public function step4($id = null) {
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->first();
        } else {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id]])->first();
        }
        if ($this->request->is(['patch', 'post', 'put'])) {

            $post = $this->request->getData();

            if (trim($post['step4_remarks']) !== trim($post['step4_old_remarks'])) {
                $post['step4_date_change'] = date('Y-m-d');
            }

            if (isset($post['land_acquisition_compl_date']) && $post['land_acquisition_compl_date']) {
                $post['land_acquisition_compl_date'] = date('Y-m-d', strtotime($post['land_acquisition_compl_date']));
            } else {
                $post['land_acquisition_compl_date'] = ($departmentScheme->land_acquisition_compl_date) ? $departmentScheme->land_acquisition_compl_date->i18nFormat('YYY-MM-dd') : '';
            }

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
//status thing starts here
//            debug($post);exit;
            if ($post['land_acquisition_required'] == 'Yes') {



                //required, now need to check if completed,on_track or off_track or critically_delayed 
                if ($post['land_identified'] == 'Yes' && $post['land_section4_compl'] == 'Yes' && $post['land_section6_comp'] == 'Yes' &&
                        $post['land_possision_taken_over'] == 'Yes' && $post['land_award_been_issued'] == 'Yes' && $post['land_payment_made'] == 'Yes') {
                    $departmentScheme->step4_status = '2';
                } else {

                    if ($post['land_acquisition_compl_date'] >= date('Y-m-d')) {
                        $departmentScheme->step4_status = '3';
                    } else {
                        $now = time(); // or your date as well
                        $your_date = strtotime($post['land_acquisition_compl_date']);
                        $datediff = $now - $your_date;

                        $diff = round($datediff / (60 * 60 * 24));
                        if ($diff > 15) { //danger zone
                            $departmentScheme->step4_status = '5';
                            $departmentScheme->overall_status = '5';
                        } else { //off track
                            $departmentScheme->step4_status = '4';
                        }
                    }
                }
            } else if ($post['land_acquisition_required'] == 'No') {
                //not required so kind of completed
                $departmentScheme->step4_status = '2';
            } else {
                //if null or empty as from the first time
                $departmentScheme->step4_status = '1';
            }
            //calculating over_all_status
            if ($departmentScheme->step4_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step4_status;
                $post['steps_array'][4] = $departmentScheme->step4_status;
// && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            }
//status thing ends here
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('Land requirement has been saved.'));

                return $this->redirect(['action' => 'step5', $id]);
            }
            $this->Flash->error(__('Land requirement could not be saved. Please, try again.'));
        }

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'conditions' => ['Departments.deleted' => 0], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $schemeRequests = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $this->Authentication->getResult()->getData()->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step4'
            ]])->count();
//        debug($schemeRequests);
//        exit;

        $this->set(compact('departmentScheme', 'departments', 'schemeRequests'));
    }

    public function step5($id = null) {
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->first();
        } else {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id]])->first();
        }
        if ($this->request->is(['patch', 'post', 'put'])) {
            $mValidated = true;

            //password
            $post = $this->request->getData();

            if (trim($post['step5_remarks']) !== trim($post['step5_old_remarks'])) {
                $post['step5_date_change'] = date('Y-m-d');
            }

            if (isset($post['proc_goods_compl_date']) && $post['proc_goods_compl_date']) {
                $post['proc_goods_compl_date'] = date('Y-m-d', strtotime($post['proc_goods_compl_date']));
            } else {
                $post['proc_goods_compl_date'] = ($departmentScheme->proc_goods_compl_date) ? $departmentScheme->proc_goods_compl_date->i18nFormat('YYY-MM-dd') : '';
            }

//            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);


            unset($post['proc_goods_evidence_of_distribution']);

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();


            $evidence = $this->request->getData()['proc_goods_evidence_of_distribution'];
//            debug($mPostData);
//            exit;
            if ($evidence->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $evidence->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . end($img_ext);
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $new_name;
                    $evidence->moveTo($path);
                    $departmentScheme->proc_goods_evidence_of_distribution = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {
                if ($departmentScheme->proc_goods_required == 'Yes') {
                    unset($departmentScheme->proc_goods_evidence_of_distribution);
                } else {
                    $departmentScheme->proc_goods_evidence_of_distribution = '';
                }
            }
//            debug($departmentScheme);
//            exit;
            if ($mValidated == true) {

//status thing starts here
//                $post = $this->request->getData();
//            debug($post['pc2_compl_date']);
                if ($post['proc_goods_required'] == 'Yes') {


                    //required, now need to check if completed,on_track or off_track or critically_delayed 
                    if ($post['proc_goods_tender_advertised'] == 'Yes' && $post['proc_goods_bidding_complete'] == 'Yes' && $post['proc_goods_po_issued'] == 'Yes' &&
                            $post['proc_goods_delivery_physical_verification_done'] == 'Yes' && $post['proc_goods_distribution_equipments'] == 'Yes') {
                        $departmentScheme->step5_status = '2';
                    } else {

                        if ($post['proc_goods_compl_date'] >= date('Y-m-d')) {
                            $departmentScheme->step5_status = '3';
                        } else {
                            $now = time(); // or your date as well
                            $your_date = strtotime($post['proc_goods_compl_date']);
                            $datediff = $now - $your_date;

                            $diff = round($datediff / (60 * 60 * 24));
                            if ($diff > 15) {
                                $departmentScheme->step5_status = '5';
                                $departmentScheme->overall_status = '5';
                            } else {
                                $departmentScheme->step5_status = '4';
                            }
                        }
                    }
                } else if ($post['proc_goods_required'] == 'No') {
                    //not required so kind of completed
                    $departmentScheme->step5_status = '2';
                } else {
                    //if null or empty as from the first time
                    $departmentScheme->step5_status = '1';
                }
                //calculating over_all_status
                if ($departmentScheme->step5_status !== '5') { //skip this step
                    $departmentScheme->overall_status = (int) $departmentScheme->step5_status;
                    $post['steps_array'][5] = $departmentScheme->step5_status;
// && array_sum($post['steps_array']) > 10
                    if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                        $departmentScheme->overall_status = (int) max($post['steps_array']);
                    } else {
                        $departmentScheme->overall_status = 1;
                    }
                }
//status thing ends here

                if ($this->DepartmentSchemes->save($departmentScheme)) {
                    unset($post['steps_array']);
                    $this->savelog($departmentScheme->department_id, $id, $post);


                    $this->Flash->success(__('Goods requirement has been saved.'));

                    return $this->redirect(['action' => 'step6', $id]);
                }
            }
            $this->Flash->error(__('Goods requirement could not be saved. Please, try again.'));
        }
        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'conditions' => ['Departments.deleted' => 0], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $schemeRequests = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $this->Authentication->getResult()->getData()->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step5'
            ]])->count();
//        debug($schemeRequests);
//        exit;

        $this->set(compact('departmentScheme', 'departments', 'schemeRequests'));
    }

    public function removeStep5Evidence($id = null) {
        $departmentScheme = $this->DepartmentSchemes->get($id);
        unlink(WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $departmentScheme->proc_goods_evidence_of_distribution);
        $departmentScheme->proc_goods_evidence_of_distribution = '';
        if ($this->DepartmentSchemes->save($departmentScheme)) {

            $this->Flash->success(__('Evidence of distribution file details has been removed.'));

            return $this->redirect(['action' => 'step5', $id]);
        }
    }

    public function step6($id = null) {
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->first();
        } else {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id]])->first();
        }
        if ($this->request->is(['patch', 'post', 'put'])) {
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();

//status thing starts here
            $post = $this->request->getData();

            if (trim($post['step6_remarks']) !== trim($post['step6_old_remarks'])) {
                $post['step6_date_change'] = date('Y-m-d');
            }

            if (isset($post['proc_services_compl_date']) && $post['proc_services_compl_date']) {
                $post['proc_services_compl_date'] = date('Y-m-d', strtotime($post['proc_services_compl_date']));
            } else {
                $post['proc_services_compl_date'] = ($departmentScheme->proc_services_compl_date) ? $departmentScheme->proc_services_compl_date->i18nFormat('YYY-MM-dd') : '';
            }

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);


//            debug($post['pc2_compl_date']);
            if ($post['proc_services_required'] == 'Yes') {



                //required, now need to check if completed,on_track or off_track or critically_delayed 
                if ($post['proc_services_tender_advertised'] == 'Yes' && $post['proc_services_tech_finance_proposal_received'] == 'Yes' && $post['proc_services_evaluation_process_compl'] == 'Yes' &&
                        $post['proc_services_contract_awarded'] == 'Yes' && $post['proc_services_status'] == '100') {
                    $departmentScheme->step6_status = '2';
                } else {

                    if ($post['proc_services_compl_date'] >= date('Y-m-d')) {
                        $departmentScheme->step6_status = '3';
                    } else {
                        $now = time(); // or your date as well
                        $your_date = strtotime($post['proc_services_compl_date']);
                        $datediff = $now - $your_date;

                        $diff = round($datediff / (60 * 60 * 24));
                        if ($diff > 15) { //danger zone
                            $departmentScheme->step6_status = '5';
                            $departmentScheme->overall_status = '5';
                        } else { //off track
                            $departmentScheme->step6_status = '4';
                        }
                    }
                }
            } else if ($post['proc_services_required'] == 'No') {
                //not required so kind of completed
                $departmentScheme->step6_status = '2';
            } else {
                //if null or empty as from the first time
                $departmentScheme->step6_status = '1';
            }

            if ($departmentScheme->step6_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step6_status;
                $post['steps_array'][6] = $departmentScheme->step6_status;
//                 && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            }
//status thing ends here
//            debug($departmentScheme->step6_status);
//            debug($departmentScheme->overall_status);
//            exit;
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('Land requirement has been saved.'));

                return $this->redirect(['action' => 'step7', $id]);
            }
            $this->Flash->error(__('Land requirement could not be saved. Please, try again.'));
        }

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'conditions' => ['Departments.deleted' => 0], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $schemeRequests = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $this->Authentication->getResult()->getData()->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step6'
            ]])->count();
//        debug($schemeRequests);
//        exit;

        $this->set(compact('departmentScheme', 'departments', 'schemeRequests'));
    }

    public function step7($id = null) {
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->first();
        } else {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id]])->first();
        }
        if ($this->request->is(['patch', 'post', 'put'])) {
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();

            //status thing starts here
            $post = $this->request->getData();

            if (trim($post['step7_remarks']) !== trim($post['step7_old_remarks'])) {
                $post['step7_date_change'] = date('Y-m-d');
            }

            if (isset($post['cons_civil_compl_date']) && $post['cons_civil_compl_date']) {
                $post['cons_civil_compl_date'] = date('Y-m-d', strtotime($post['cons_civil_compl_date']));
            } else {
                $post['cons_civil_compl_date'] = ($departmentScheme->cons_civil_compl_date) ? $departmentScheme->cons_civil_compl_date->i18nFormat('YYY-MM-dd') : '';
            }

            if (isset($post['cons_start_date']) && $post['cons_start_date']) {
                $post['cons_start_date'] = date('Y-m-d', strtotime($post['cons_start_date']));
            } else {
                $post['cons_start_date'] = ($departmentScheme->cons_start_date) ? $departmentScheme->cons_start_date->i18nFormat('YYY-MM-dd') : '';
            }

//            debug($post['cons_civil_compl_date']);exit;
            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);

//            debug($post);
//            exit;
            if ($post['cons_civil_work_required'] == 'Yes') {



                //required, now need to check if completed,on_track or off_track or critically_delayed 

                $step7_cons_array = array();

                if ($post['is_work_carried_by_civil_works'] == 'Yes') {
                    if ($post['is_work_begun'] == 'Yes' && $post['level_of_work_compl'] == '100') {
                        array_push($step7_cons_array, 2);
                    } else {
                        //check date thing

                        if ($post['cons_civil_compl_date'] >= date('Y-m-d')) {
                            array_push($step7_cons_array, 3);
                        } else {
                            $now = time(); // or your date as well
                            $your_date = strtotime($post['cons_civil_compl_date']);
                            $datediff = $now - $your_date;

                            $diff = round($datediff / (60 * 60 * 24));
                            if ($diff > 15) { //danger zone
                                array_push($step7_cons_array, 5);
                                $departmentScheme->overall_status = '5';
                            } else { //off_track zone
                                array_push($step7_cons_array, 4);
                            }
                        }
                    }
                }
//                debug($post);
//                exit;
                if ($post['is_work_commisioned_privately'] == 'Yes') {
                    if ($post['cons_civil_private_type'] == 'single_source') {
                        if ($post['is_work_begun'] == 'Yes' && $post['level_of_work_compl'] == '100') {
                            array_push($step7_cons_array, 2);
                        } else {
                            //check date thing
                            if ($post['cons_civil_compl_date'] >= date('Y-m-d')) {
                                array_push($step7_cons_array, 3);
                            } else {
                                $now = time(); // or your date as well
                                $your_date = strtotime($post['cons_civil_compl_date']);
                                $datediff = $now - $your_date;

                                $diff = round($datediff / (60 * 60 * 24));
                                if ($diff > 15) { //danger zone
                                    array_push($step7_cons_array, 5);
                                    $departmentScheme->overall_status = '5';
                                } else { //off_track zone
                                    array_push($step7_cons_array, 4);
                                }
                            }
                        }
                    } else {
                        if ($post['is_work_begun'] == 'Yes' && $post['level_of_work_compl'] == '100' && $post['is_work_tender_advertised'] == 'Yes' &&
                                $post['is_work_bidding_compl'] == 'Yes' && $post['is_work_order_issued'] == 'Yes') {
                            array_push($step7_cons_array, 2);
                        } else {
                            if ($post['cons_civil_compl_date'] >= date('Y-m-d')) {
                                array_push($step7_cons_array, 3);
                            } else {
                                //check date thing
                                $now = time(); // or your date as well
                                $your_date = strtotime($post['cons_civil_compl_date']);
                                $datediff = $now - $your_date;

                                $diff = round($datediff / (60 * 60 * 24));
                                if ($diff > 15) { //danger zone
                                    array_push($step7_cons_array, 5);
                                    $departmentScheme->overall_status = '5';
                                } else { //off_track zone
                                    array_push($step7_cons_array, 4);
                                }
                            }
                        }
                    }
                }

//                        debug($post);
//                        exit;
//                        debug($step3_hiring_array);exit;
                //count max of it and that will be the status
                $departmentScheme->step7_status = (int) max($step7_cons_array);
            } else if ($post['cons_civil_work_required'] == 'No') {
                //not required so kind of completed
                $departmentScheme->step7_status = '2';
            } else {
                //if null or empty as from the first time
                $departmentScheme->step7_status = '1';
            }
//status thing ends here
//            debug($departmentScheme->step7_status);
//            exit;
            if ($departmentScheme->step7_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->step7_status;
                $post['steps_array'][7] = $departmentScheme->step7_status;
//                 && array_sum($post['steps_array']) > 10
//                debug(count(array_filter($post['steps_array'])));
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
//                debug($departmentScheme->overall_status);exit;
            }
//debug($departmentScheme->overall_status);exit;
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('Construction requirement has been saved.'));

                return $this->redirect(['action' => 'custom', $id]);
            }
//            debug($departmentScheme);exit;
            $this->Flash->error(__('Construction requirement could not be saved. Please, try again.'));
        }

        $this->loadModel('Departments');
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'conditions' => ['Departments.deleted' => 0], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('SchemeRequests');
        $schemeRequests = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $this->Authentication->getResult()->getData()->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'step7'
            ]])->count();
//        debug($schemeRequests);
//        exit;

        $this->set(compact('departmentScheme', 'departments', 'schemeRequests'));
    }

    public function custom($id = null) {
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->first();
        } else {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id]])->first();
        }
        $departments = $this->Departments->find('list', ['order' => ['Departments.department_name'], 'conditions' => ['Departments.deleted' => 0], 'keyField' => 'id', 'valueField' => 'department_name'])->toArray();

        $this->loadModel('CustomMilestones');
        $fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['department_scheme_id' => $id], 'order' => ['display_order' => 'asc', 'id' => 'asc']])->all();

        $this->loadModel('SchemeRequests');
        $schemeRequests = $this->SchemeRequests->find('all', [
                    'conditions' => [
                        'department_id' => $this->Authentication->getResult()->getData()->department_id,
                        'department_scheme_id' => $id, 'status' => 'pending', 'step_name' => 'custom'
            ]])->count();

        $this->set(compact('departmentScheme', 'departments', 'fetch_custom_details', 'schemeRequests'));
        if ($this->request->is(['patch', 'post', 'put'])) {
//            debug($this->request->getData());
//            exit;
            $post = $this->request->getData();
            $all_statuses = array();
//            $this->CustomMilestones->deleteAll(['department_scheme_id' => $id]);

            if ($post['custom_milestone_required'] == 'Yes') {


                foreach ($this->request->getData()['way_forward'] as $key => $data):



                    if (isset($this->request->getData()['pid'][$key])) {
                        //update query
                        $customMilestone = $this->CustomMilestones->get($this->request->getData()['pid'][$key]);

                        $status = ($this->request->getData()['is_completed'][$key] == 'Yes') ? '2' : '9';
//                    debug($status);
                        if ($status == '9') {
                            $compare_date = isset($this->request->getData()['completion_date'][$key]) ? date('Y-m-d', strtotime($this->request->getData()['completion_date'][$key])) : $customMilestone->completion_date->i18nFormat('YYY-MM-dd');
                            if ($compare_date >= date('Y-m-d')) {
                                $status = '3';
                            } else {
                                $now = time(); // or your date as well
                                $your_date = strtotime($customMilestone->completion_date->i18nFormat('YYY-MM-dd'));
                                $datediff = $now - $your_date;

                                $diff = round($datediff / (60 * 60 * 24));
                                if ($diff > 15) { //danger zone
                                    $status = '5';
                                } else { //off track
                                    $status = '4';
                                }
                            }
                        }
                        array_push($all_statuses, $status);
                        if (isset($this->request->getData()['completion_date'][$key])) {
                            $customMilestone->completion_date = date('Y-m-d', strtotime($this->request->getData()['completion_date'][$key]));
                            $customMilestone->milestone_name = $this->request->getData()['milestone_name'][$key];
                        }
//                        $customMilestone->milestone_name = $this->request->getData()['milestone_name'][$key] ;
                        $customMilestone->display_order = $this->request->getData()['display_order'][$key];
                        $customMilestone->way_forward = $data;
                        if (trim($data) !== trim($this->request->getData()['way_forward_old'][$key])) {
                            $customMilestone->last_modified = date('Y-m-d');
                        }
                        $customMilestone->is_completed = $this->request->getData()['is_completed'][$key];
                        $customMilestone->responsibility = $this->request->getData()['responsibility'][$key];
                        $customMilestone->milestone_status = $status;


                        $this->CustomMilestones->save($customMilestone);
                    } else {
//                        debug($this->request->getData());exit;
                        $status = ($this->request->getData()['is_completed'][$key] == 'Yes') ? '2' : '9';
//                    debug($status);
                        if ($status == '9') {
                            $compare_date = date('Y-m-d', strtotime($this->request->getData()['completion_date'][$key]));
                            if ($compare_date >= date('Y-m-d')) {
                                $status = '3';
                            } else {
                                $now = time(); // or your date as well
                                $your_date = strtotime($this->request->getData()['completion_date'][$key]);
                                $datediff = $now - $your_date;

                                $diff = round($datediff / (60 * 60 * 24));
                                if ($diff > 15) { //danger zone
                                    $status = '5';
                                } else { //off track
                                    $status = '4';
                                }
                            }
                        }
                        array_push($all_statuses, $status);

                        $articles = $this->getTableLocator()->get('CustomMilestones');
                        $query = $articles->query();
                        $query->insert(['milestone_name', 'department_scheme_id', 'display_order', 'way_forward', 'is_completed', 'completion_date', 'responsibility', 'created', 'modified', 'milestone_status'])
                                ->values([
                                    'milestone_name' => $this->request->getData()['milestone_name'][$key],
                                    'department_scheme_id' => $id,
                                    'display_order' => $this->request->getData()['display_order'][$key],
                                    'way_forward' => $this->request->getData()['way_forward'][$key],
                                    'is_completed' => $this->request->getData()['is_completed'][$key],
                                    'completion_date' => ($this->request->getData()['completion_date'][$key]) ? date('Y-m-d', strtotime($this->request->getData()['completion_date'][$key])) : '',
                                    'responsibility' => $this->request->getData()['responsibility'][$key],
                                    'milestone_status' => $status,
                                    'created' => date('Y-m-d'),
                                    'modified' => date('Y-m-d'),
                                ])
                                ->execute();
                    }
                endforeach;
            } else {
                array_push($all_statuses, 2);
            }
//            debug($all_statuses);exit;
            //calculating over_all_status

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $post);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();
            $departmentScheme->last_modified = date('Y-m-d h:i:s');

            $departmentScheme->custom_status = max($all_statuses);
            $post['steps_array'][8] = max($all_statuses);
//            debug($post['steps_array']);exit;
            //calculating over_all_status
            if ($departmentScheme->custom_status !== '5') { //skip this step
                $departmentScheme->overall_status = (int) $departmentScheme->custom_status;

// && array_sum($post['steps_array']) > 10
                if (max($post['steps_array']) && count(array_filter($post['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = max($post['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
            } else {
                $departmentScheme->overall_status = 5;
            }

//            debug($departmentScheme);
//            exit;
//status thing ends here
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                unset($post['steps_array']);
//                $this->savelog($departmentScheme->department_id, $id, $post);


                $this->Flash->success(__('Custom milestone has been saved.'));

                return $this->redirect(['action' => 'finish', $id]);
            }
//            debug($departmentScheme);exit;
            $this->Flash->error(__('Custom milestone could not be saved. Please, try again.'));

//            exit;
        }
    }

    public function finish($id = null) {
        if ($this->Authentication->getResult()->getData()->users_roles_id == 'pm') {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.user_id' => $this->request->getAttribute('identity')->getIdentifier()]])->first();
        } else {
            $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['DepartmentSchemes.id' => $id, 'DepartmentSchemes.department_id' => $this->Authentication->getResult()->getData()->department_id]])->first();
        }
        if ($this->request->is(['patch', 'post', 'put'])) {
            $mValidated = true;

            //password
            $mPostData = $this->request->getData();

            unset($mPostData['scheme_file']);

            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $mPostData);
            $departmentScheme->modified_by = $this->request->getAttribute('identity')->getIdentifier();


            $evidence = $this->request->getData()['scheme_file'];
//            debug($mPostData);
//            exit;
            if ($evidence->getClientFileName()) {

                $ext_array = array('jpg', 'JPG', 'png', 'PNG', 'jpeg', 'JPEG', 'gif', 'GIF');
                $img_ext = explode('.', $evidence->getClientFileName());
                $new_name = 'img-' . date('ymdhis') . '.' . end($img_ext);
//                debug($slider->image);
                if (in_array($img_ext[1], $ext_array)) {
                    $path = WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $new_name;
                    $evidence->moveTo($path);
                    $departmentScheme->scheme_file = $new_name;
                } else {
                    $mValidated = false;
                    $this->Flash->error(__('Invalid image type provided.'));
                }
            } else {

                unset($departmentScheme->scheme_file);
            }
//            debug($departmentScheme);
//            exit;
            if ($mValidated == true) {
                if (max($mPostData['steps_array']) && count(array_filter($mPostData['steps_array'])) > 6) { //added milestones sum to know the overallstatus
                    $departmentScheme->overall_status = (int) max($mPostData['steps_array']);
                } else {
                    $departmentScheme->overall_status = 1;
                }
                if ($this->DepartmentSchemes->save($departmentScheme)) {
                    $this->Flash->success(__('This scheme details has been saved.'));

                    return $this->redirect(['action' => 'view', $id]);
                }
            }
            $this->Flash->error(__('This scheme details could not be saved. Please, try again.'));
        }

        $this->set(compact('departmentScheme'));
    }

    public function finishEvidence($id = null) {
        $departmentScheme = $this->DepartmentSchemes->get($id);
        unlink(WWW_ROOT . 'img' . DS . 'scheme_files' . DS . $departmentScheme->scheme_file);

        $departmentScheme->scheme_file = '';
        if ($this->DepartmentSchemes->save($departmentScheme)) {
            $this->Flash->success(__('Scheme file details has been removed.'));

            return $this->redirect(['action' => 'finish', $id]);
        }
    }

    /**
     * Edit method
     *
     * @param string|null $id Department Scheme id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function checkexisting() {

        $departmentScheme = $this->DepartmentSchemes->find('all', ['conditions' => ['scheme_code' => $_GET['scheme_code'], 'DepartmentSchemes.deleted' => 0], 'contain' => ['Users']])->first();
        echo json_encode($departmentScheme);
        exit;
    }

    public function edit($id = null) {
        $departmentScheme = $this->DepartmentSchemes->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $departmentScheme = $this->DepartmentSchemes->patchEntity($departmentScheme, $this->request->getData());
            if ($this->DepartmentSchemes->save($departmentScheme)) {
                $this->Flash->success(__('The department scheme has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The department scheme could not be saved. Please, try again.'));
        }
        $departments = $this->DepartmentSchemes->Departments->find('list', ['limit' => 200]);
        $schemeStatuses = $this->DepartmentSchemes->SchemeStatuses->find('list', ['limit' => 200]);
        $this->set(compact('departmentScheme', 'departments', 'schemeStatuses'));
    }

    public function addActivity($id = null, $detail = null) {
        
		if(isset($_POST) && !empty($_POST))
		{
			//die($id);
			$this->DepartmentSchemes->updateAll(['custom_milestone_required' => 'Yes'], ['id in' => [$id]]);
			
			$milestone = $this->getTableLocator()->get('CustomMilestones');
			$query = $milestone->query(); 
			
			$mean_of_verification = '';	
			$root_dir = str_replace(basename($_SERVER['SCRIPT_NAME']), '', $_SERVER['SCRIPT_NAME']);;
			$uploads_root_dir = $_SERVER['DOCUMENT_ROOT'].$root_dir.'uploads/mov/';
	
			if (!empty($_FILES) && isset($_FILES["mean_of_verification"]["name"])) 
			{
                //echo '<pre>';print_r($uploads_root_dir);exit;
                $name = $_FILES["mean_of_verification"]["name"];
                $ext  = explode('.', $_FILES["mean_of_verification"]["name"]);
                $ext  = trim(strtolower($ext[count($ext) - 1]));
				$exts =  array('jpeq', 'jpg', 'png', 'pdf');
                if (in_array($ext, $exts)) 
				{
                    $filename = preg_replace('/[^A-Za-z0-9\-]/', '', str_replace($ext, '', $_FILES["mean_of_verification"]['name']));
                    $filename = date('ymdhis') . $filename . '.' . $ext;

                    if (move_uploaded_file($_FILES["mean_of_verification"]["tmp_name"], $uploads_root_dir . basename($filename))) {
                        $mean_of_verification = $filename;
                    }
				}
            }
					
			$this->loadModel('CustomMilestones');		
			$CustomMilestone = $this->CustomMilestones->newEmptyEntity();
			$CustomMilestone->department_scheme_id = $id;
			$CustomMilestone->milestone_name = $this->request->getData()['milestone_name'];
			$CustomMilestone->mean_of_verification = $mean_of_verification;
			if($CustomMilestone->milestone_name == 'Other'){
				$CustomMilestone->milestone_name = $this->request->getData()['other_milestone_name'];
			}
			$CustomMilestone->is_completed = $this->request->getData()['is_completed'];
			$CustomMilestone->responsibility = $this->request->getData()['responsibility'];
			$CustomMilestone->district_id = $this->request->getData()['district'];
			$CustomMilestone->type = $this->request->getData()['type'];
			$CustomMilestone->completed_percent = $this->request->getData()['completed_percent'];
			if($CustomMilestone->type == 'Other'){
				if($this->request->getData()['other_type'] != ''){
					$CustomMilestone->type = $this->request->getData()['other_type'];
				}
			}
			$CustomMilestone->completion_date = '';
			//($this->request->getData()['completion_date']) ? date('Y-m-d', strtotime($this->request->getData()['completion_date'])) : '';
			$CustomMilestone->milestone_status = 2;
			$CustomMilestone->display_order = 1;
			$CustomMilestone->created = date('Y-m-d');
			$CustomMilestone->modified = date('Y-m-d');
			$this->CustomMilestones->save($CustomMilestone);
			$last_id = $CustomMilestone->id;
			
			$completion_date = date('Y-m-d');
			$activity_start_date = '2050-01-01';
			if(!empty($_POST['title'])){
				foreach($_POST['title'] as $i => $title){
					
					$end_date = ($this->request->getData()['end_date'][$i]) ? date('Y-m-d', strtotime($this->request->getData()['end_date'][$i])) : date('Y-m-d');
					$start_date = ($this->request->getData()['start_date'][$i]) ? date('Y-m-d', strtotime($this->request->getData()['start_date'][$i])) : date('Y-m-d');
					if(strtotime($end_date) > strtotime($completion_date))
					{
						$completion_date = $end_date;
					}
					
					if(strtotime($start_date) < strtotime($activity_start_date))
					{
						$activity_start_date = $start_date;
					}
					
					$sub_activity = $this->getTableLocator()->get('SubActivity');
					$query = $sub_activity->query();
					$query->insert(['department_scheme_id', 'activity', 'title', 'start_date', 'end_date', 'responsibility', 'remarks', 'created', 'modified', 'status'])
							->values([
								'department_scheme_id' => $id,
								'activity' => $last_id,
								'title' => $this->request->getData()['title'][$i],
								'responsibility' => $this->request->getData()['department'][$i],
								'start_date' => $start_date,
								'end_date' => $end_date,
								'remarks' => $this->request->getData()['remarks'][$i],
								'status' => $this->request->getData()['status'][$i],
								'created' => date('Y-m-d'),
								'modified' => date('Y-m-d'),
							])
							->execute();
				}
			}
			
			$connection = ConnectionManager::get('default');
			$sub_activities = $connection->execute('SELECT MAX(end_date) as end_date FROM `sub_activities` WHERE activity = '.$last_id)->fetchAll('assoc');
			if(!empty($sub_activities)){
				$this->CustomMilestones->updateAll(['completion_date' => $sub_activities[0]['end_date']], ['id in' => [$last_id]]);			
			}
			
			$sub_activities = $connection->execute('SELECT MIN(start_date) as start_date FROM `sub_activities` WHERE activity = '.$last_id)->fetchAll('assoc');
			if(!empty($sub_activities)){
				$this->CustomMilestones->updateAll(['start_date' => $sub_activities[0]['start_date']], ['id in' => [$last_id]]);			
			}

			$custom_milestones = $connection->execute('SELECT MAX(completion_date) as completion_date FROM `custom_milestones` WHERE department_scheme_id = '.$id)->fetchAll('assoc');
			if(!empty($custom_milestones)){
				$this->DepartmentSchemes->updateAll(['scheme_end_date' => $custom_milestones[0]['completion_date']], ['id in' => [$id]]);
			}
			
			$custom_milestones = $connection->execute('SELECT MIN(start_date) as start_date FROM `custom_milestones` WHERE department_scheme_id = '.$id)->fetchAll('assoc');
			if(!empty($custom_milestones)){
				$this->DepartmentSchemes->updateAll(['scheme_start_date' => $custom_milestones[0]['start_date']], ['id in' => [$id]]);
			}
			
			//return $this->redirect(['action' => 'view', $id]);		
			$this->redirect( '/department-schemes/view/'.$id );
		}else{
			$this->loadModel('DepartmentSchemes');
			$departmentScheme = $this->DepartmentSchemes->get($id);
			$this->loadModel('Departments');
			$departments = $this->Departments->find('list')->all()->toArray();
			$this->loadModel('Districts');
			$districts = $this->Districts->find('list')->all()->toArray();
			$this->set(compact('id', 'departments', 'departmentScheme', 'districts'));
		}
    }
	
    public function editActivity($departmentScheme_id = null, $id = null) {
        
		if(isset($_POST) && !empty($_POST))
		{
			//echo '<pre>';print_r($_POST);exit;
			$this->loadModel('CustomMilestones');
			$completion_date = '';//date('Y-m-d');
			$activity_start_date = '2050-01-01';
			
			$mean_of_verification = '';	
			$root_dir = str_replace(basename($_SERVER['SCRIPT_NAME']), '', $_SERVER['SCRIPT_NAME']);;
			$uploads_root_dir = $_SERVER['DOCUMENT_ROOT'].$root_dir.'uploads/mov/';

			if (!empty($_FILES) && isset($_FILES["mean_of_verification"]["name"])) 
			{
                //echo '<pre>';print_r($uploads_root_dir);exit;
                $name = $_FILES["mean_of_verification"]["name"];
                $ext  = explode('.', $_FILES["mean_of_verification"]["name"]);
                $ext  = trim(strtolower($ext[count($ext) - 1]));
				$exts =  array('jpeq', 'jpg', 'png', 'pdf');
                if (in_array($ext, $exts)) 
				{
                    $filename = preg_replace('/[^A-Za-z0-9\-]/', '', str_replace($ext, '', $_FILES["mean_of_verification"]['name']));
                    $filename = date('ymdhis') . $filename . '.' . $ext;

                    if (move_uploaded_file($_FILES["mean_of_verification"]["tmp_name"], $uploads_root_dir . basename($filename))) {
                        $mean_of_verification = $filename;
                    }
				}
            }	
			
			if(!empty($_POST['title'])){
				$this->loadModel('SubActivity');				
				$this->SubActivity->deleteAll(['activity' => $id]);
				
				foreach($_POST['title'] as $i => $title){
					if( $this->request->getData()['title'][$i] != '' &&  $this->request->getData()['start_date'][$i] != '' &&  $this->request->getData()['end_date'][$i] != ''){
						$sub_activity = $this->getTableLocator()->get('SubActivity');
						$query = $sub_activity->query();
						
						$end_date = ($this->request->getData()['end_date'][$i]) ? date('Y-m-d', strtotime($this->request->getData()['end_date'][$i])) : date('Y-m-d');
						$start_date = ($this->request->getData()['start_date'][$i]) ? date('Y-m-d', strtotime($this->request->getData()['start_date'][$i])) : date('Y-m-d');
						if($completion_date == ''){
							$completion_date = $end_date;
						}
						
						if(strtotime($end_date) > strtotime($completion_date))
						{
							$completion_date = $end_date;
						}
						
						if(strtotime($start_date) < strtotime($activity_start_date))
						{
							$activity_start_date = $start_date;
						}
						
						$query->insert(['department_scheme_id', 'activity', 'title', 'start_date', 'end_date', 'responsibility', 'remarks', 'created', 'modified', 'status'])
								->values([
									'department_scheme_id' => $departmentScheme_id,
									'activity' => $id,
									'title' => $this->request->getData()['title'][$i],
									'responsibility' => $this->request->getData()['department'][$i],
									'start_date' => $start_date,
									'end_date' => $end_date,
									'remarks' => $this->request->getData()['remarks'][$i],
									'status' => $this->request->getData()['status'][$i],
									'created' => date('Y-m-d'),
									'modified' => date('Y-m-d'),
								])
								->execute();
					}
				}
			}
			
			$milestone_type = $this->request->getData()['type'];
			if($milestone_type == 'Other'){
				if($this->request->getData()['other_type'] != ''){
					$milestone_type = $this->request->getData()['other_type'];
				}
			}
			
			$district_id = $this->request->getData()['district'];
			if(!in_array(strtolower($this->request->getData()['milestone_name']),array('civil works'))){
				$district_id = 0;
			}
			
			
			$params = ['milestone_name' => $this->request->getData()['milestone_name'], 'completed_percent' => $this->request->getData()['completed_percent'], 'is_completed' => $this->request->getData()['is_completed'], 'responsibility' => $this->request->getData()['responsibility'], 'district_id' => $district_id, 'type' => $milestone_type, 'remarks' => $this->request->getData()['activity-remarks'], 'completion_date' => $completion_date, 'start_date' => $activity_start_date];
			if($mean_of_verification != ''){
				$params['mean_of_verification'] = $mean_of_verification;
			}
			
			$this->CustomMilestones->updateAll($params, ['id in' => [$id]]);
			
			//$this->DepartmentSchemes->updateAll(['scheme_end_date' => $completion_date, 'scheme_start_date' => $activity_start_date], ['id in' => [$departmentScheme_id]]);
			
			$connection = ConnectionManager::get('default');
			$sub_activities = $connection->execute('SELECT MAX(end_date) as end_date FROM `sub_activities` WHERE activity = '.$id)->fetchAll('assoc');
			if(!empty($sub_activities)){
				$this->CustomMilestones->updateAll(['completion_date' => $sub_activities[0]['end_date']], ['id in' => [$id]]);			
			}
			
			$sub_activities = $connection->execute('SELECT MIN(start_date) as start_date FROM `sub_activities` WHERE activity = '.$id)->fetchAll('assoc');
			if(!empty($sub_activities)){
				$this->CustomMilestones->updateAll(['start_date' => $sub_activities[0]['start_date']], ['id in' => [$id]]);			
			}

			$custom_milestones = $connection->execute('SELECT MAX(completion_date) as completion_date FROM `custom_milestones` WHERE department_scheme_id = '.$departmentScheme_id)->fetchAll('assoc');
			if(!empty($custom_milestones)){
				$this->DepartmentSchemes->updateAll(['scheme_end_date' => $custom_milestones[0]['completion_date']], ['id in' => [$departmentScheme_id]]);
			}
			
			$custom_milestones = $connection->execute('SELECT MIN(start_date) as start_date FROM `custom_milestones` WHERE department_scheme_id = '.$departmentScheme_id)->fetchAll('assoc');
			if(!empty($custom_milestones)){
				$this->DepartmentSchemes->updateAll(['scheme_start_date' => $custom_milestones[0]['start_date']], ['id in' => [$departmentScheme_id]]);
			}
			
			//return $this->redirect(['action' => 'view', $id]);		
			$this->redirect( '/department-schemes/view/'.$departmentScheme_id );
		}else{
			$this->loadModel('Departments');
			$departments = $this->Departments->find('list')->all()->toArray();
			
			$this->loadModel('CustomMilestones');
        	$fetch_custom_details = $this->CustomMilestones->find('all', ['conditions' => ['id' => $id], 'order' => ['display_order' => 'asc', 'id' => 'asc']])->all();
			$fetch_custom_details = json_decode(json_encode($fetch_custom_details));
			
			$this->loadModel('SubActivity');
        	$SubActivity = $this->SubActivity->find('all', ['conditions' => ['activity' => $id], 'order' => ['start_date' => 'asc']])->all();
			$SubActivity = json_decode(json_encode($SubActivity));
			$this->loadModel('Districts');
			$districts = $this->Districts->find('list')->all()->toArray();
			
			//echo '<pre>';print_r(json_decode(json_encode($fetch_custom_details)));exit;
			$this->set(compact('id', 'departments', 'fetch_custom_details', 'SubActivity', 'departmentScheme_id', 'districts'));
		}
    }
	
	public function update_scheme_status() {
        $departmentScheme = $this->DepartmentSchemes->get($_GET['id']); 
        $departmentScheme->overall_status = $_GET['overall_status'] == 2.5 ? 1 : $_GET['overall_status'];
        $this->DepartmentSchemes->save($departmentScheme);
        echo json_encode('yes');
        exit;
    }

    /**
     * Delete method
     *
     * @param string|null $id Department Scheme id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null) {
//        $this->request->allowMethod(['post', 'delete']);
//        $departmentScheme = $this->DepartmentSchemes->get($id);
//        if ($this->DepartmentSchemes->delete($departmentScheme)) {
//            $this->Flash->success(__('The department scheme has been deleted.'));
//        } else {
//            $this->Flash->error(__('The department scheme could not be deleted. Please, try again.'));
//        }

        return $this->redirect(['action' => 'index']);
    }

}
