<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * AttachedFormation Entity
 *
 * @property int $id
 * @property int $department_id
 * @property string $name
 * @property string|null $logo
 * @property string|null $detail
 * @property \Cake\I18n\FrozenDate $created
 * @property \Cake\I18n\FrozenDate $modified
 * @property int $created_by
 * @property int $modified_by
 *
 * @property \App\Model\Entity\Department $department
 * @property \App\Model\Entity\DepartmentScheme[] $department_schemes
 * @property \App\Model\Entity\User[] $users
 */
class AttachedFormation extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
    ];
}
