<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Department Entity
 *
 * @property int $id
 * @property string $department_name
 * @property string|null $department_logo
 * @property string|null $department_responsibilities
 * @property string $active
 * @property \Cake\I18n\FrozenDate $created
 * @property \Cake\I18n\FrozenDate $modified
 * @property int $created_by
 * @property int $modified_by
 * @property bool $deleted
 *
 * @property \App\Model\Entity\DepartmentScheme[] $department_schemes
 * @property \App\Model\Entity\User[] $users
 * @property \App\Model\Entity\SchemeDistrict[] $scheme_districts
 */
class Department extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'department_name' => true,
        'department_logo' => true,
        'department_responsibilities' => true,
        'active' => true,
        'created' => true,
        'modified' => true,
        'created_by' => true,
        'modified_by' => true,
        'deleted' => true,
        'department_schemes' => true,
        'users' => true,
        'scheme_districts' => true,
    ];
}
