<?php

declare(strict_types = 1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SchemesLog Entity
 *
 * @property int $id
 * @property int $department_scheme_id
 * @property string $field_name
 * @property string $answer
 * @property \Cake\I18n\FrozenTime $created
 *
 * @property \App\Model\Entity\DepartmentScheme $department_scheme
 */
class SchemesLog extends Entity {

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'department_scheme_id' => true,
        'department_id' => true,
        'field_name' => true,
        'answer' => true,
        'created' => true,
        'department_scheme' => true,
        'user_id' => true,
    ];

}
