<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * CustomMilestones Model
 *
 * @property \App\Model\Table\DepartmentSchemesTable&\Cake\ORM\Association\BelongsTo $DepartmentSchemes
 *
 * @method \App\Model\Entity\CustomMilestone newEmptyEntity()
 * @method \App\Model\Entity\CustomMilestone newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\CustomMilestone[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\CustomMilestone get($primaryKey, $options = [])
 * @method \App\Model\Entity\CustomMilestone findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\CustomMilestone patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\CustomMilestone[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\CustomMilestone|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\CustomMilestone saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\CustomMilestone[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\CustomMilestone[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\CustomMilestone[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\CustomMilestone[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class CustomMilestonesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('custom_milestones');

        $this->addBehavior('Timestamp');

        $this->belongsTo('DepartmentSchemes', [
            'foreignKey' => 'department_scheme_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('id')
            ->requirePresence('id', 'create')
            ->notEmptyString('id');

        $validator
            ->scalar('milestone_name')
            ->maxLength('milestone_name', 255)
            ->requirePresence('milestone_name', 'create')
            ->notEmptyString('milestone_name');

        $validator
            ->scalar('way_forward')
            ->requirePresence('way_forward', 'create')
            ->notEmptyString('way_forward');

        $validator
            ->scalar('is_completed')
            ->requirePresence('is_completed', 'create')
            ->notEmptyString('is_completed');

        $validator
            ->date('completion_date')
            ->requirePresence('completion_date', 'create')
            ->notEmptyDate('completion_date');

        $validator
            ->integer('responsibility')
            ->requirePresence('responsibility', 'create')
            ->notEmptyString('responsibility');

        $validator
            ->integer('milestone_status')
            ->requirePresence('milestone_status', 'create')
            ->notEmptyString('milestone_status');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['department_scheme_id'], 'DepartmentSchemes'), ['errorField' => 'department_scheme_id']);

        return $rules;
    }
}
