<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SchemesLogs Model
 *
 * @property \App\Model\Table\DepartmentSchemesTable&\Cake\ORM\Association\BelongsTo $DepartmentSchemes
 *
 * @method \App\Model\Entity\SchemesLog newEmptyEntity()
 * @method \App\Model\Entity\SchemesLog newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\SchemesLog[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\SchemesLog get($primaryKey, $options = [])
 * @method \App\Model\Entity\SchemesLog findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\SchemesLog patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\SchemesLog[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\SchemesLog|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\SchemesLog saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\SchemesLog[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\SchemesLog[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\SchemesLog[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\SchemesLog[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class SchemesLogsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('schemes_logs');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('DepartmentSchemes', [
            'foreignKey' => 'department_scheme_id',
            'joinType' => 'INNER',
        ]);
        
         $this->belongsTo('Departments', [
            'foreignKey' => 'department_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->scalar('field_name')
            ->maxLength('field_name', 60)
            ->requirePresence('field_name', 'create')
            ->notEmptyString('field_name');

//        $validator
//            ->scalar('answer')
//            ->requirePresence('answer', 'create')
//            ->notEmptyString('answer');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['department_scheme_id'], 'DepartmentSchemes'), ['errorField' => 'department_scheme_id']);
        $rules->add($rules->existsIn(['department_id'], 'Departments'), ['errorField' => 'department_id']);

        return $rules;
    }
}
