<script src="https://polyfill.io/v3/polyfill.min.js?features=default"></script>

<style>
    sup {
        font-size: x-small
    }

    /* Always set the map height explicitly to define the size of the div
     * element that contains the map. */
    #map {
        height: 300px;
    }

    /* Optional: Makes the sample page fill the window. */
    /*    html,
        body {
            height: 100%;
            margin: 0;
            padding: 0;
        }*/
</style>

<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');

use Cake\ORM\TableRegistry;
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit Department Scheme'), ['action' => 'schemeprofile', $departmentScheme->id], ['escape' => false]) ?></li>
        <!--<li><?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete Department Scheme'), ['action' => 'delete', $departmentScheme->id], ['confirm' => __('Are you sure you want to delete # {0}?', $departmentScheme->id), 'escape' => false]) ?></li>-->
<!--        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Department Schemes'), ['action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['action' => 'add'], ['escape' => false]) ?></li>-->
<!--        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape' => false]) ?> </li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape' => false]) ?> </li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Scheme Statuses'), ['controller' => 'SchemeStatuses', 'action' => 'index'], ['escape' => false]) ?> </li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme Status'), ['controller' => 'SchemeStatuses', 'action' => 'add'], ['escape' => false]) ?> </li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Scheme Districts'), ['controller' => 'SchemeDistricts', 'action' => 'index'], ['escape' => false]) ?> </li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme District'), ['controller' => 'SchemeDistricts', 'action' => 'add'], ['escape' => false]) ?> </li>-->
    </ul>
</nav>
<div class="row">
    <div class="col-sm-9 col-md-9">
        <section class="card pull-left float-left masturat">


            <header class="card-header">
                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title pull-left"><?= __($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')') ?></h2>
                <div class="btn-group flex-wrap float-right">
                    <button type="button" class="mb-1 mt-0 mr-1 btn btn-default dropdown-toggle" data-toggle="dropdown">Actions <span class="caret"></span></button>
                    <div class="dropdown-menu" role="menu">
                        <?= $this->Html->link(__('<i class="fas fa-download"></i> Export to Excel'), ['action' => 'exportexcel', $departmentScheme->id], ['class' => 'dropdown-item text-1', 'escape' => false]) ?>
                    </div>
                </div>
            </header>
            <div class="departmentSchemes card-body content">

                <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered">
                    <thead>
                        <tr style="color:white;background-color:darkgreen;">
                            <th>List of Activities </th>
                            <th>Activity Status</th>
                            <th>Responsibility</th>
                            <th>Timeline</th>
                            <th>Remarks</th>
                            <th>T/L</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $departments['Other'] = 'Other';
//                    $array_of_7_q = array(5 => 'img-210107074838.jpg', 4 => 'img-210107074652.jpg', 3 => 'img-210107074816.jpg', 2 => 'img-210107073217.jpg', 1 => 'img-210107074900.jpg');
                        if ($departmentScheme->pc2_required == 'Yes') {
                            ?>

                            <tr>
                                <td data-title="List of Activities"><b>PC-II</b></td>
                                <td data-title="Activity Status">PC-II <?= ($departmentScheme->pc2_approved == 'Yes') ? 'approved' : 'not approved' ?><br/>
                                    Consultant <?= ($departmentScheme->consultant_hired == 'Yes') ? 'hired' : 'not hired yet' ?><br/>
                                    Consultant <?= ($departmentScheme->cons_subt_report == 'Yes') ? 'submitted report' : 'haven\'t submitted report yet ' ?></td>
                                <td data-title="Responsibility"><?=
                                    $departments[$departmentScheme->responsible_pc2_compl];
                                    if ($departmentScheme->designation_step1) {
                                        echo "<br/>(" . $departmentScheme->designation_step1 . ')';
                                    }
                                    ?></td>
                                <td data-title="Timeline"><b><?= date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc2_compl_date)); ?> </b></td>
                                <td data-title="Remarks" style="color:maroon"><?= nl2br($departmentScheme->step1_remarks); ?>&nbsp;</td>
                                <td data-title="T/L"><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $departmentScheme->step1_status . '.PNG"> '; ?></td>
                            </tr>

                            <?php
                        }

                        if ($departmentScheme->pc1_approved) { //we need it in either case
//                    debug($departmentScheme->pc1_approved);
                            ?>
                            <tr>
                                <td data-title="List of Activities"><b>PC-1</b></td>
                                <td data-title="Activity Status"><?= ($departmentScheme->pc1_approved == 'Yes') ? 'Approved' : ucfirst($departmentScheme->pc1_stage) . ' stage'; ?></td>
                                <td data-title="Responsibility"><?=
                                    ($departmentScheme->pc1_approved == 'No') ? $departments[$departmentScheme->pc1_responsible] : 'Planning & Development';
                                    if ($departmentScheme->designation_step2) {
                                        echo "<br/>(" . $departmentScheme->designation_step2 . ')';
                                    }
                                    ?></td>
                                <td data-title="Timeline"><b><?= ($departmentScheme->pc1_approved == 'No') ? date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc1_compl_date)) : date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc1_approval_date)); ?></b> </td>
                                <td data-title="Remarks" style="color:maroon"><?= nl2br($departmentScheme->step2_remarks); ?>&nbsp;</td>
                                <td data-title="T/L"><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $departmentScheme->step2_status . '.PNG"> '; ?></td>


                            </tr>
                            <?php
                        }

                        if ($departmentScheme->hiring_required == 'Yes') {
                            ?>
                            <tr>
                                <td data-title="List of Activities"><b>Hiring</b></td>
                                <td data-title="Activity Status">
                                    SNE <?=
                                    ($departmentScheme->sne_required == 'Yes') ? 'required' : 'not required';
//                        debug($departmentScheme->will_hiring_through_psc);
                                    if ($departmentScheme->sne_required == 'Yes') {
                                        echo "<br/>";
                                        ?>
                                        SNE <?=
                                        ($departmentScheme->sne_submitted == 'Yes') ? 'submitted' : 'not submitted';
//                        debug($departmentScheme->will_hiring_through_psc);
                                        ?>
                                        <?=
                                        'to Finance Department';
                                        if ($departmentScheme->sne_submitted == 'Yes') {
                                            ?>
                                            <br/> SNE <?=
                                            ($departmentScheme->sne_approved == 'Yes') ? 'approved' : 'not approved';
                                        }
                                    }

//                        debug($departmentScheme->will_hiring_through_psc);
                                    ?>
                                    <div style="margin:10px;">
                                        <?php
                                        if ($departmentScheme->will_hiring_through_psc == 'Yes') {
                                            $ver = ($departmentScheme->hiring_through_psc == 'Yes') ? 'complete' : 'incomplete';
                                            echo '<br/>' . "Hiring through PSC " . $ver;
                                        }
                                        if ($departmentScheme->will_hiring_through_internal_posting == 'Yes') {
                                            $ver = ($departmentScheme->hiring_through_internal_posting == 'Yes') ? 'complete' : 'incomplete';
                                            echo '<br/>' . "Hiring through Internal Posting " . $ver;
                                        }
                                        if ($departmentScheme->will_hiring_through_market == 'Yes') {
                                            $ver = ($departmentScheme->hiring_through_market == 'Yes' && $departmentScheme->posting_though_market_media == 'Yes' &&
                                                    $departmentScheme->hiring_market_entries_recorded == 'Yes' && $departmentScheme->hiring_market_scrutiny_compl == 'Yes' &&
                                                    $departmentScheme->hiring_market_intervies_cond == 'Yes' && $departmentScheme->hiring_market_appoint_letter_issues == 'Yes') ? 'complete' : 'incomplete';
                                            echo '<br/>' . "Hiring through Market " . $ver;
                                            ?>
                                            <div style="margin:10px;">

                                                Advertising <?= ($departmentScheme->posting_though_market_media == 'Yes') ? 'complete' : 'incomplete' ?><br/>
                                                Entries <?= ($departmentScheme->hiring_market_entries_recorded == 'Yes') ? 'recorded' : 'not recorded' ?><br/>
                                                Scrutiny / Shortlisting  <?= ($departmentScheme->hiring_market_scrutiny_compl == 'Yes') ? 'completed' : 'incomplete' ?><br/>
                                                Interviews <?= ($departmentScheme->hiring_market_intervies_cond == 'Yes') ? 'conducted' : 'not conducted so far' ?><br/>
                                                Appointment letters <?= ($departmentScheme->hiring_market_appoint_letter_issues == 'Yes') ? 'issued' : 'not issued' ?>
                                            </div>
                                        <?php }
                                        ?>
                                    </div>
                                </td>
                                <td data-title="Responsibility">

                                    <?php
                                    echo "<br/>";
                                    if ($departmentScheme->sne_submitted == 'No') {
                                        echo $departments[$departmentScheme->department_id];
                                    }
                                    echo "<br/>";
                                    if ($departmentScheme->sne_approved == 'No') {
                                        echo 'Finance';
                                    }
                                    ?>
                                    <div style="margin:10px;">

                                        <?php
                                        if ($departmentScheme->will_hiring_through_psc == 'Yes') {

                                            echo '<br/><br/>' . "PSC: " . $departments[$departmentScheme->responsible_psc];
                                            if ($departmentScheme->designation_step3_psc) {
                                                echo "<br/>(" . $departmentScheme->designation_step3_psc . ')';
                                            }
                                        }
                                        if ($departmentScheme->will_hiring_through_internal_posting == 'Yes') {
                                            echo '<br/><br/>' . "Internal Posting: " . $departments[$departmentScheme->responsible_internal_posting];
                                            if ($departmentScheme->designation_step3_ip) {
                                                echo "<br/>(" . $departmentScheme->designation_step3_ip . ')';
                                            }
                                        }
                                        if ($departmentScheme->will_hiring_through_market == 'Yes') {
                                            echo '<br/><br/>' . "Market: " . $departments[$departmentScheme->hiring_market_respons_person];
                                            if ($departmentScheme->designation_step3_market) {
                                                echo "<br/>(" . $departmentScheme->designation_step3_market . ')';
                                            }
                                        }
                                        ?>
                                    </div>
                                </td>
                                <td data-title="Timeline">
                                  <b>  <br/>
                                    <?= ($departmentScheme->sne_submitted == 'No') ? date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->sne_submission_date)) : ''; ?>
                                    <br/>
                                    <?= ($departmentScheme->sne_approved == 'No') ? '' . date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->sne_approval_date)) : ''; ?>
                                    <div style="margin:10px;">
                                        <?php
                                        if ($departmentScheme->will_hiring_through_psc == 'Yes') {

                                            echo '<br/><br/>' . "PSC: " . date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_compl_date_psc));
                                        }
                                        echo "<br/>";
                                        if ($departmentScheme->will_hiring_through_internal_posting == 'Yes') {
                                            echo '<br/>' . "Internal Posting: " . date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_compl_date_internal_posting));
                                        }
                                        if ($departmentScheme->will_hiring_through_market == 'Yes') {
                                            echo '<br/>' . "Market: " . date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->hiring_market_compl_date));
                                        }
                                        ?>
                                    </div>
                                    </b>
                                </td>
                                <td data-title="Remarks" style="color:maroon"><?= nl2br($departmentScheme->step3_remarks); ?>&nbsp;</td>
                                <td data-title="T/L"><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $departmentScheme->step3_status . '.PNG"> '; ?></td>


                            </tr>
                            <?php
                        }

                        if ($departmentScheme->land_acquisition_required == 'Yes') {
                            ?>
                            <tr>
                                <td data-title="List of Activities"><b>Land Acquisition</b></td>
                                <td data-title="Activity Status"> 
                                    Land Identification <?= ($departmentScheme->land_identified == 'Yes') ? 'complete' : 'incomplete' ?><br/>
                                    Section 4 <?= ($departmentScheme->land_section4_compl == 'Yes') ? 'complete' : 'incomplete' ?><br/>
                                    Section 6 <?= ($departmentScheme->land_section6_comp == 'Yes') ? 'complete' : 'incomplete' ?><br/>
                                    Land Possession <?= ($departmentScheme->land_possision_taken_over == 'Yes') ? 'taken over' : 'not taken over' ?><br/>
                                    Land Award <?= ($departmentScheme->land_award_been_issued == 'Yes') ? 'been issued' : 'not issued' ?><br/>
                                    Payment <?= ($departmentScheme->land_payment_made == 'Yes') ? 'made' : 'not made' ?>
                                </td>
                                <td data-title="Responsibility"><?=
                                    $departments[$departmentScheme->land_acquisition_responsible];
                                    if ($departmentScheme->designation_step4) {
                                        echo "<br/>(" . $departmentScheme->designation_step4 . ')';
                                    }
                                    ?></td>
                                <td data-title="Timeline"><b><?= date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->land_acquisition_compl_date)); ?></b></td>
                                <td data-title="Remarks" style="color:maroon"><?= nl2br($departmentScheme->step4_remarks); ?>&nbsp;</td>
                                <td><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $departmentScheme->step4_status . '.PNG"> '; ?></td>


                            </tr>
                            <?php
                        }

                        if ($departmentScheme->proc_goods_required == 'Yes') {
                            ?>
                            <tr>
                                <td data-title="List of Activities"><b>Procurement of Goods</b></td>
                                <td data-title="Activity Status">
                                    Advertisement <?= ($departmentScheme->proc_goods_tender_advertised == 'Yes') ? 'complete' : 'incomplete' ?><br/>
                                    Bidding <?= ($departmentScheme->proc_goods_bidding_complete == 'Yes') ? 'complete' : 'incomplete' ?><br/>
                                    Purchase orders <?= ($departmentScheme->proc_goods_po_issued == 'Yes') ? 'issued' : 'not issued' ?><br/>
                                    Delivery <?= ($departmentScheme->proc_goods_delivery_physical_verification_done == 'Yes') ? 'complete' : 'incomplete' ?><br/>
                                    Distribution <?= ($departmentScheme->proc_goods_distribution_equipments == 'Yes') ? 'complete' : 'incomplete' ?>

                                </td>
                                <td data-title="Responsibility"><?=
                                    $departments[$departmentScheme->proc_goods_responsible];
                                    if ($departmentScheme->designation_step5) {
                                        echo "<br/>(" . $departmentScheme->designation_step5 . ')';
                                    }
                                    ?></td>
                                <td data-title="Timeline"><b><?= date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->proc_goods_compl_date)); ?></b></td>
                                <td data-title="Remarks" style="color:maroon"><?= nl2br($departmentScheme->step5_remarks); ?>&nbsp;</td>
                                <td data-title="T/L"><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $departmentScheme->step5_status . '.PNG"> '; ?></td>


                            </tr>
                            <?php
                        }

                        if ($departmentScheme->proc_services_required == 'Yes') {
                            ?>
                            <tr>
                                <td data-title="List of Activities"><b>Procurement of Services</b></td>
                                <td data-title="Activity Status">Advertisement <?= ($departmentScheme->proc_services_tender_advertised == 'Yes') ? 'complete' : 'incomplete' ?><br/>
                                    Technical/Financial Proposal <?= ($departmentScheme->proc_services_tech_finance_proposal_received == 'Yes') ? 'received ' : 'not received' ?><br/>
                                    Evaluation of proposals <?= ($departmentScheme->proc_services_evaluation_process_compl == 'Yes') ? 'complete' : 'incomplete' ?><br/>
                                    Contract <?= ($departmentScheme->proc_services_contract_awarded == 'Yes') ? 'awarded' : 'not awarded' ?><br/>
                                    Completion Status: <?= ($departmentScheme->proc_services_status) ? $departmentScheme->proc_services_status . '%' : 'Not started' ?></td>
                                <td data-title="Responsibility"><?=
                                    $departments[$departmentScheme->proc_services_responsible];
                                    if ($departmentScheme->designation_step6) {
                                        echo "<br/>(" . $departmentScheme->designation_step6 . ')';
                                    }
                                    ?></td>
                                <td data-title="Timeline"><b><?= date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->proc_services_compl_date)); ?></b></td>
                                <td data-title="Remarks" style="color:maroon"><?= nl2br($departmentScheme->step6_remarks); ?>&nbsp;</td>
                                <td data-title="T/L"><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $departmentScheme->step6_status . '.PNG"> '; ?></td>


                            </tr>
                            <?php
                        }

                        if ($departmentScheme->cons_civil_work_required == 'Yes') {
                            ?>
                            <tr>
                                <td data-title="List of Activities"><b>Construction/civil works</b></td>
                                <td data-title="Activity Status">
                                    Work by C & W: <?= $departmentScheme->is_work_carried_by_civil_works ?><br/>
                                    Work by Other Agency: <?= $departmentScheme->is_work_commisioned_privately ?><br/>
                                    <div style="margin:10px;">
                                        <?php
                                        if ($departmentScheme->is_work_commisioned_privately == 'Yes') {
                                            if ($departmentScheme->cons_civil_private_type) {
                                                $m_array = ['single_source' => 'Single Source', 'open_tender' => 'Open Tendering'];
                                                echo "Work Type: " . $m_array[$departmentScheme->cons_civil_private_type];
                                            }
                                            if ($departmentScheme->cons_civil_private_type == 'open_tender') {
                                                ?>
                                                <br/>Advertisement <?= ($departmentScheme->is_work_tender_advertised == 'Yes') ? 'complete ' : 'incomplete' ?><br/>
                                                Bidding <?= ($departmentScheme->is_work_bidding_compl == 'Yes') ? 'complete' : 'incomplete' ?><br/>
                                                Work Order <?= ($departmentScheme->is_work_order_issued == 'Yes') ? 'issued' : 'not issued' ?>
                                                <?php
                                            }
                                        }
                                        ?>
                                        <br/>Work <?= ($departmentScheme->is_work_begun == 'Yes') ? 'started' : 'not started'; ?><br/>
                                        <?php if ($departmentScheme->is_work_begun == 'Yes') { ?>
                                            Completion Status: <?= ($departmentScheme->level_of_work_compl) ? $departmentScheme->level_of_work_compl . '%' : 'Not started' ?>
                                        <?php } ?>
                                    </div>

                                </td>
                                <td data-title="Responsibility"><?=
                                    $departments[$departmentScheme->cons_civil_responsible];
                                    if ($departmentScheme->designation_step7) {
                                        echo "<br/>(" . $departmentScheme->designation_step7 . ')';
                                    }
                                    ?></td>
                                <td data-title="Timeline"><b><?= date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->cons_civil_compl_date)); ?></b></td>
                                <td data-title="Remarks" style="color:maroon"><?= nl2br($departmentScheme->step7_remarks); ?>&nbsp;</td>
                                <td data-title="T/L"><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $departmentScheme->step7_status . '.PNG"> '; ?></td>


                            </tr>
                            <?php
                        }
                        $SchemeDistricts = TableRegistry::get('SchemesLogs');
                        $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id], 'order' => ['SchemesLogs.id' => 'DESC']])->first();
                        ?>
                        <tr>
                            <td><b>Overall Status</b></td>
                            <td><?php
                                if (file_exists(WWW_ROOT . 'img/scheme_files/' . $departmentScheme->scheme_file) && !empty($departmentScheme->scheme_file)) {

                                    echo '<strong>Existing Evidence: </strong><img src="' . $this->request->getAttribute("webroot") . 'img/scheme_files/' . $departmentScheme->scheme_file . '" style="width:100%">';
                                }
                                ?>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td><b>Updated: <?php
                                if (isset($choosen_nav_districts->created)) {
                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($choosen_nav_districts->created));
                                } else {
                                    echo "-";
                                }
                                ?></b></td>
                            <td><?= ucfirst($departmentScheme->final_comments); ?>&nbsp;</td>
                            <td><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $departmentScheme->overall_status . '.PNG"> '; ?>&nbsp;</td>

                        </tr>
                        <tr>
                            <td><b>Date of completion</b></td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td><span id="date"><b><?= date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->scheme_end_date)) ?></b></span>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>

                        </tr>

                    </tbody>
                </table>
                <h4>Scheme Financial Progress Details</h4>
                <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered">
                    <thead>
                    <th>Title</th>
                    <th>Departmental Details</th>
                    <th>PCFMS Details</th>
                    </thead>
                    <tr>
                        <th>Total cost  (in Rs. millions)</th>
                        <td><span><?= number_format($departmentScheme->cost_of_scheme, 3); ?></span></td>
                        <td><span id="ttl_cost">&nbsp;</span></td>

                    </tr>
                    <tr>
                        <th>Current allocation  (in Rs. millions)</th>
                        <td><span><?= number_format($departmentScheme->allocation_for_cfy, 3); ?></span></td>
                        <td><span id="crnt_allocation">&nbsp;</span></td>


                    </tr>
                    <tr>
                        <th>Previous Expenditure  (in Rs. millions)</th>
                        <td><span><?= number_format($departmentScheme->expenditure_till_date, 3); ?></span></td>
                        <td><span id="exp_till_date">&nbsp;</span></td>


                    </tr>
                    <tr>
                        <th>Releases Current Year  (in Rs. millions)</th>
                        <td><span><?= number_format($departmentScheme->release_for_cfy, 3); ?></span></td>
                        <td><span id="progressive_release">&nbsp;</span></td>

                    </tr>
                    <tr>
                        <th> Expenditure Current Year (in Rs. millions)</th>
                        <td><span><?= number_format($departmentScheme->progressive_expenditure, 3); ?></span></td>
                        <td><span id="progressive-expenditure">&nbsp;</span></td>

                    </tr>
                </table>
            </div><!--/content-->

        </section>
    </div>
    <div class="col-sm-3 col-md-3">
        <div id="searchform_sidebar"style="position: static; top: 10px;">

            <?= '<img class="img-fluid" src="' . $this->request->getAttribute("webroot") . 'img/status.PNG" style="margin-top:125px;"> '; ?>
            <?php
//            debug($departmentScheme->parent_scheme_code);
            if (isset($get_parent)) {
                echo "<h4>Parent Scheme:</h4>";
                ?>
                <!--debug($get_parent);-->
                <?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $get_parent->overall_status . '.PNG"> '; ?>
                <?= $this->Html->link(__($get_parent->scheme_code . '-' . $get_parent->scheme_name), ['action' => 'view', $get_parent->id], ['escape' => false]); ?>
                <?php
            }

            if (isset($get_childs) && $get_childs->toArray()) {
                echo "<h4>Child Scheme(s):</h4>";

                foreach ($get_childs as $child):
//                    debug($child);
                    echo '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $child->overall_status . '.PNG">' . $this->Html->link(__($child->scheme_code . '-' . $child->scheme_name), ['action' => 'view', $child->id], ['escape' => false]) . '<br/>';
                endforeach;
            }
            ?>
        </div>
        <br/>
        <div id="map"></div>

    </div>
</div>

<?php
//june tak 20 and july mai 21
//if (date('m') > 6) {
//    $make_year = date('Y');
//} else {
//    $make_year = date('Y', strtotime("-1 year"));
//}
?>
<script>
//    const nth = function (d) {
//        if (d > 3 && d < 21)
//            return 'th';
//        switch (d % 10) {
//            case 1:
//                return "st";
//            case 2:
//                return "nd";
//            case 3:
//                return "rd";
//            default:
//                return "th";
//        }
//    }


    $(function () {
//        alert(302)

//        $(window).scroll(function () {
//            //        alert(304)
//
//            //        var otop = $(".scroll-top").offset().top;
//
//            //        alert($('.masturat').height());
//            var adjust_height = $('.masturat').height() - 50;
//            if ($(window).scrollTop() > 170 && $(window).scrollTop() < adjust_height && $(window).width() > 575)
//            {
//                //            alert($(window).scrollTop());
//                $(".content_left").css('position', 'fixed').css('top', '5px');
//                $("#searchform_sidebar").css('position', 'fixed').css('top', '10px').css('width', '25%');
//            } else
//            {
//                $(".content_left").css('position', 'static');
//                $("#searchform_sidebar").css('position', 'static').css('width', '100%');
//            }
//        });


        //get current year financial position
        var scheme_code = '<?= $departmentScheme->scheme_code; ?>';

//            alert($('#cost-of-scheme').val());

        var dd = {YearID: <?= $departmentScheme->year; ?>, Token: 'be7ee177-229e-4689-a356-12a904c5d2dd', SchemeCode: scheme_code};
        var myJSON = JSON.stringify(dd);
        $.ajax({
            url: "https://pcfms.pndkp.gov.pk:9002/api/ADP/GetSchemeDetail",
            type: 'POST',
            contentType: 'application/json; charset=utf-8',
            data: myJSON,
            dataType: 'json',
            success: function (data) {
                $('.loader').hide();

                if (data.CODE == 'SUCCESS' && data.Message == 'SUCCESS') {

                    $.each(data.Data.SchemeDetail, function (key, item) {
//

                        $('#ttl_cost').html(item.Cost);
                        $('#crnt_allocation').html(item.Allocation);
                        $('#exp_till_date').html(item.previousExp);
                        $('#progressive-expenditure').html(item.ProgressiveExp.toFixed(3));
                        $('#progressive_release').html(item.ProgReleases.toFixed(3));

//
//                        if (item.EndDate) {
//                            const fortnightAway = new Date(+new Date(item.EndDate));
//                            const date = fortnightAway.getDate();
////    alert(date);
//                            const month = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"][fortnightAway.getMonth()];
//
//                            document.getElementById("date").innerHTML = `${date}<sup>${nth(date)}</sup> ${month} ${fortnightAway.getFullYear()}`;
//                        }
//
//
                    });
                    if (Object.keys(data.Data.SchemeLocation).length) {
                        var latt = 0;
                        var longg = 0;
                        $.each(data.Data.SchemeLocation, function (key, item) {
                            //intial center marker
//                            alert(item.Type);
                            if (item.Type === 'Point') {
                                latt = parseFloat(item.Latitude);
                                longg = parseFloat(item.Longitude);
                                return false;
                            }
                        });

                        var fields = [];
                        $.each(data.Data.SchemeLocation, function (key, item) {
//                                alert(key);
                            if (item.Type == 'Line') {
                                fields.push({
                                    lat: parseFloat(item.Latitude),
                                    lng: parseFloat(item.Longitude)
                                });
                            }
                        });
//                            alert(fields);
                        console.log(fields);
                        // This example creates a 2-pixel-wide red polyline showing the path of
                        // the first trans-Pacific flight between Oakland, CA, and Brisbane,
                        // Australia which was made by Charles Kingsford Smith.
//                            function initMap() {
//                                alert('490');
//                            alert(latt);
//                            alert(longg);




                        const map = new google.maps.Map(document.getElementById("map"), {
                            zoom: 8,
                            center: {lat: latt, lng: longg},
                            mapTypeId: "terrain",
                        });

                        marker = new google.maps.Marker({
                            position: new google.maps.LatLng(latt, longg),
                            map: map
                        });

                        const flightPlanCoordinates = fields;
                        const flightPath = new google.maps.Polyline({
                            path: flightPlanCoordinates,
                            geodesic: true,
                            strokeColor: "#FF0000",
                            strokeOpacity: 1.0,
                            strokeWeight: 2,
                        });
                        flightPath.setMap(map);
//                            }

                    }
                } else {
                    alert(data.CODE + ': ' + data.Message);
                }
            }
        });
    });

</script>
<script
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCFbZJYbp6hfEYoy9ndetQ7VdmwqFRK9yc&libraries=&v=weekly"
    async
></script>
