<?php

use Cake\ORM\TableRegistry;

require_once (APP . 'Vendor' . DS . 'xtcpdf.php');
$tcpdf = new XTCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$html = '<table><tr><td><img height="50" src="http://cmdu.kp.gov.pk/portal/img/cmdu.jpg"></td><td align="right"><img style="float:right;" height="50" src="http://cmdu.kp.gov.pk/portal/img/kp_logo.jpg"></td></tr></table>';
$html .= '<br/><hr><br/><hr><br/>';
$textfont = 'helvetica'; // looks better, finer, and more condensed than 'dejavusans'

$tcpdf->AddPage(); // Front Page
///$tcpdf->setY(-240);
//$tcpdf->SetTextColor(0, 0, 0);
$tcpdf->SetFont($textfont, '', 9);
$tcpdf->setListIndentWidth(4);

$html .= 
	'<table cellpadding="2" cellspacing="0" border="1" style="margin-top:20px;width:100%">
		<tr style="color:white;background-color:darkgreen;">
			<th width="20%">Scheme Name</th>
			<th width="15%">Department</th>
			<th width="15%">Scheme Code</th>
			<th width="15%">Start Date</th>
			<th width="15%">Deadline</th>
			<th width="10%">Scheme Type</th>
			<th width="10%">T/L</th>
		</tr>';

foreach ($DepartmentSchemes as $rec):

    $html .= 
	'<tr>
		<td>'.$rec->scheme_name.'</td>
		<td>'.(!empty($rec->d) ? $rec->d->department_name : 'N/A').'</td>
		<td>'.$rec->scheme_code.'</td>
		<td>'.date('d M, Y', strtotime($rec->scheme_start_date)).'</td>
		<td>'.date('d M, Y', strtotime($rec->scheme_end_date)).'</td>
		<td>'.$rec->scheme_type.'</td>
		<td><img src="http://cmdu.kp.gov.pk/portal/img/milestones_status/'. $rec->milestone_status . '.PNG"> &nbsp;</td>	
	</tr>';
	
	if(!empty($rec->activities)){
		$html .= 
	'<tr>
		<td colspan="7" style="padding-left:20px;">
			<table cellpadding="2" cellspacing="0" border="1" style="margin-top:20px;width:100%">
				<thead>
					<tr style="color:white;background-color:darkgreen;">
						<th width="20%">Activity</th>
						<th width="15%">Start Date</th>
						<th width="15%">Deadline</th>
						<th width="20%">Responsibility</th>
						<th width="15%">Remarks</th>
						<th width="15%">T/L</th>
					</tr>
				</thead>';
		foreach($rec->activities as $activity){
			$html .= '<tr>
						<td>'.$activity->milestone_name.'</td>
						<td>'.date('d M, Y', strtotime($activity->start_date)).'</td>
						<td>'.date('d M, Y', strtotime($activity->completion_date)).'</td>
						<td>'.$activity->responsibility.'</td>
						<td>'.$activity->remarks.'</td>
						<td><img src="http://cmdu.kp.gov.pk/portal/img/milestones_status/'.$activity->overall_status_img.'.PNG" /></td>
					</tr>';
					
			if(!empty($activity->sub_activities)){
				$html .= '<tr>
							<td colspan="7" style="padding-left:20px;">
								<table cellpadding="2" cellspacing="0" border="1" style="margin-top:20px;width:100%">
									<thead>
										<tr style="color:white;background-color:darkgreen;">
											<th width="20%">Sub-Activity</th>
											<th width="15%">Start Date</th>
											<th width="15%">Deadline</th>
											<th width="20%">Responsibility</th>
											<th width="15%">Remarks</th>
											<th width="15%">T/L</th>
										</tr>
									</thead>';
				foreach($activity->sub_activities as $sub_activity){
					$html .= '<tr>
								<td>'.$sub_activity->title.'</td>
								<td>'.date('d M, Y', strtotime($sub_activity->start_date)).'</td>
								<td>'.date('d M, Y', strtotime($sub_activity->end_date)).'</td>
								<td>'.$sub_activity->responsibility.'</td>
								<td>'.$sub_activity->remarks.'</td>
								<td><img src="http://cmdu.kp.gov.pk/portal/img/milestones_status/'.$sub_activity->img.'.PNG" /></td>
							</tr>';
				}
				
				$html .= '</table></td></tr>';
			}
		}
		
		$html .= '</table></td></tr>';
	}
	
endforeach;

$html .= '</table>';
//echo $html;exit;
//$html .='<br pagebreak="true"/>';

$tcpdf->writeHTML($html, true, false, true, false, '');
//reset pointer to the last page
//$tcpdf->lastPage();
$tcpdf->Output('Schemes-' . str_replace("(AIP)", "", ucfirst('Schemes')) . ' (Schemes)' . '.pdf', 'D');
exit();
//echo "javascript:history.go(-1);";
?>