<?php

use Cake\ORM\TableRegistry;

require_once(APP . 'Vendor' . DS . 'PHPExcel' . DS . 'PHPExcel.php');

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator($this->request->getSession()->read('Auth.User.username'));

$styleArray = array(
    'font' => array(
        'bold' => true,
    ),
    'borders' => array(
        'top' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        ),
        'bottom' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        ),
        'left' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        ),
        'right' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN,
            'color' => array('argb' => '0000'),
        )
    )
);

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(50);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);//->setAutoSize(false);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);//->setAutoSize(false);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);//->setAutoSize(false);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);//->setAutoSize(false);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(30);//->setAutoSize(false);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(30);//->setAutoSize(false);
//$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);

$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);

//HEADER

$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'Scheme Name');
$objPHPExcel->getActiveSheet()->setCellValue('B1', 'Department');
$objPHPExcel->getActiveSheet()->setCellValue('C1', 'Scheme Code');
$objPHPExcel->getActiveSheet()->setCellValue('D1', 'Start Date');
$objPHPExcel->getActiveSheet()->setCellValue('E1', 'Deadline');
$objPHPExcel->getActiveSheet()->setCellValue('F1', 'Scheme Type');
$objPHPExcel->getActiveSheet()->setCellValue('G1', 'T/L');
$objPHPExcel->getActiveSheet()->setCellValue('H1', 'Activities:');
$objPHPExcel->getActiveSheet()->setCellValue('I1', 'Activity');
$objPHPExcel->getActiveSheet()->setCellValue('J1', 'Start Date');
$objPHPExcel->getActiveSheet()->setCellValue('K1', 'Deadline');
$objPHPExcel->getActiveSheet()->setCellValue('L1', 'Responsibility');
$objPHPExcel->getActiveSheet()->setCellValue('M1', 'Remarks');
$objPHPExcel->getActiveSheet()->setCellValue('N1', 'T/L');
$objPHPExcel->getActiveSheet()->setCellValue('O1', 'Sub-Activity');
$objPHPExcel->getActiveSheet()->setCellValue('P1', 'Start Date');
$objPHPExcel->getActiveSheet()->setCellValue('Q1', 'Deadline');	
$objPHPExcel->getActiveSheet()->setCellValue('R1', 'Responsibility');	
$objPHPExcel->getActiveSheet()->setCellValue('S1', 'Remarks');			
$objPHPExcel->getActiveSheet()->setCellValue('T1', 'T/L');


$i = 2;
foreach ($DepartmentSchemes as $details):
	//echo '<pre>';print_r($details->d->department_name);exit;
    $objPHPExcel->getActiveSheet()->setCellValue('A' . $i, ucfirst($details->scheme_name));
    $objPHPExcel->getActiveSheet()->setCellValue('B' . $i, nl2br(ucfirst($details->d->department_name)));
    $objPHPExcel->getActiveSheet()->setCellValue('C' . $i, ucfirst($details->scheme_code));
    $objPHPExcel->getActiveSheet()->setCellValue('D' . $i, date('j F Y', strtotime($details->scheme_start_date)));
    $objPHPExcel->getActiveSheet()->setCellValue('E' . $i, date('j F Y', strtotime($details->scheme_end_date)));
    $objPHPExcel->getActiveSheet()->setCellValue('F' . $i, $details->scheme_type);

	$details->milestone_status = ($details->milestone_status == '') ? 0 : $details->milestone_status;
    $objDrawing = new PHPExcel_Worksheet_Drawing();
    $objDrawing->setName('Logo');
    $objDrawing->setDescription('Logo');
    $logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $details->milestone_status . '.PNG'; // Provide path to your logo file

    $objDrawing->setPath($logo);

    $objDrawing->setCoordinates('G' . $i);
    $objDrawing->setHeight(20); // logo height
    $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
	
	if(!empty($details->activities)){
		foreach($details->activities as $activity){
			
			$objPHPExcel->getActiveSheet()->setCellValue('I' . $i, ucfirst($activity->milestone_name));
			$objPHPExcel->getActiveSheet()->setCellValue('J' . $i, date('j F Y', strtotime($activity->start_date)));
			$objPHPExcel->getActiveSheet()->setCellValue('K' . $i, date('j F Y', strtotime($activity->completion_date)));
			$objPHPExcel->getActiveSheet()->setCellValue('L' . $i, $activity->responsibility);
			$objPHPExcel->getActiveSheet()->setCellValue('M' . $i, $activity->remarks);
		
			$activity->overall_status_img = ($activity->overall_status_img == '') ? 0 : $activity->overall_status_img;
			$objDrawing = new PHPExcel_Worksheet_Drawing();
			$objDrawing->setName('Logo');
			$objDrawing->setDescription('Logo');
			$logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $activity->overall_status_img . '.PNG'; // Provide path to your logo file
		
			$objDrawing->setPath($logo);
		
			$objDrawing->setCoordinates('N' . $i);
			$objDrawing->setHeight(20); // logo height
			$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
			
			if(!empty($activity->sub_activities)){
				foreach($activity->sub_activities as $sub_activity){
					
					$objPHPExcel->getActiveSheet()->setCellValue('O' . $i, ucfirst($sub_activity->title));
					$objPHPExcel->getActiveSheet()->setCellValue('P' . $i, date('j F Y', strtotime($sub_activity->start_date)));
					$objPHPExcel->getActiveSheet()->setCellValue('Q' . $i, date('j F Y', strtotime($sub_activity->end_date)));
					$objPHPExcel->getActiveSheet()->setCellValue('R' . $i, $sub_activity->responsibility);
					$objPHPExcel->getActiveSheet()->setCellValue('S' . $i, $sub_activity->remarks);
				
					$sub_activity->status = ($sub_activity->status == '') ? 0 : $sub_activity->status;
					$objDrawing = new PHPExcel_Worksheet_Drawing();
					$objDrawing->setName('Logo');
					$objDrawing->setDescription('Logo');
					$logo = getcwd() . DS . 'img' . DS . 'milestones_status' . DS . $sub_activity->status . '.PNG'; // Provide path to your logo file
				
					$objDrawing->setPath($logo);
				
					$objDrawing->setCoordinates('T' . $i);
					$objDrawing->setHeight(20); // logo height
					$objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
					
					$i++;
				}
			}
			$i++;
		}
	}

    $i++;
endforeach;
$i++;

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Tracker');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

//call the function in the controller with $output_type = F and $file with complete path to the file, to generate the file in the server for example attach to email
if (isset($output_type) && $output_type == 'F') {
    echo "132";
    exit;
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $objWriter->save($file);
} else {
//    echo "136";exit;
    // Redirect output to a client's web browser (Excel2007)
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $file . '"');
    header('Cache-Control: max-age=0');
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $objWriter->save('php://output');
}