<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\District[]|\Cake\Collection\CollectionInterface $districts
 */
$this->assign('title', 'Listing Districts');
?>

<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New District'), ['action' => 'add'], ['escape' => false]) ?></li>

<!--        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Scheme Districts'), ['controller' => 'SchemeDistricts', 'action' => 'index'], ['escape' => false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme District'), ['controller' => 'SchemeDistricts', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>

<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>
            <h3><?= __('Districts') ?></h3>
        </header>

        <div class="districts card-body content">
            <?php echo $this->Form->create(null, array('role' => 'form', 'class' => 'form-horizontal', 'type' => 'get')); ?>

            <div class="row">

                <div class="col-sm-9">
                    <?= $this->Form->control('name', ['placeholder' => 'Search by district name', 'class' => 'form-control', 'value' => isset($_GET['name']) ? $_GET['name'] : '']); ?>
                    <br/>
                </div>


                <div class="col-sm-2">
                    <?= $this->Form->button(__('Search'), ['class' => 'btn btn-primary', 'style' => 'margin-top:30px;']) ?>
                    <br/>
                </div>

            </div>
            <?= $this->Form->end() ?>
            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <thead>
                    <tr>
                        <!--<th scope="col"><?= $this->Paginator->sort('id') ?></th>-->
                        <th scope="col"><?= $this->Paginator->sort('name') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('type') ?></th>

<!--                        <th scope="col"><?= $this->Paginator->sort('created_by') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('modified_by') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('created') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('modified') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('deleted') ?></th>-->
                        <th scope="col" class="actions"><?= __('Actions') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($districts as $district): ?>
                        <tr>
                            <!--<td class="text-right" data-title="Id"><?= $this->Number->format($district->id) ?></td>-->
                            <td class="text-left" data-title="Name"><?= ucfirst($district->name) ?></td>
                            <td class="text-left" data-title="Name"><?= ucfirst($district->type) ?></td>

                    <!--                            <td class="text-right" data-title="Created By"><?= $this->Number->format($district->created_by) ?></td>
                                            <td class="text-right" data-title="Modified By"><?= $this->Number->format($district->modified_by) ?></td>
                                            <td class="text-left" data-title="Created"><?= h($district->created) ?></td>
                                            <td class="text-left" data-title="Modified"><?= h($district->modified) ?></td>
                                            <td class="text-left" data-title="Deleted"><?= h($district->deleted) ?></td>-->
                            <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View dashboard'), ['controller' => 'Users', 'action' => 'dashboard?district[]=' . $district->id], ['escape' => false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View report'), ['controller' => 'Districts', 'action' => 'view' , $district->name], ['escape' => false,'target'=>'_blank']) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['action' => 'edit', $district->id], ['escape' => false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $district->id], ['confirm' => __('Are you sure you want to delete # {0}?', ucfirst($district->name)), 'escape' => false]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <footer class="card-footer text-right">
                <div class="paginator">
                    <ul class="pagination">
                        <?= $this->Paginator->first('<< ' . __('first')) ?>
                        <?= $this->Paginator->prev('< ' . __('previous')) ?>
                        <?= $this->Paginator->numbers() ?>
                        <?= $this->Paginator->next(__('next') . ' >') ?>
                        <?= $this->Paginator->last(__('last') . ' >>') ?>
                    </ul>
                    <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                </div>
            </footer>
        </div>
    </section>
</div><!--/row-->
