<?php
/**
* @var \App\View\AppView $this
* @var \App\Model\Entity\RecordNoteDetail $recordNoteDetail
*/
$this->assign('title', 'Viewing Record Note Detail');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit Record Note Detail'), ['action' => 'edit', $recordNoteDetail->id], ['escape'=>false]) ?></li>
        <li><?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete Record Note Detail'), ['action' => 'delete', $recordNoteDetail->id], ['confirm' => __('Are you sure you want to delete # {0}?', $recordNoteDetail->id), 'escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Record Note Details'), ['action' => 'index'], ['escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Record Note Detail'), ['action' => 'add'], ['escape'=>false]) ?></li>
                                                                                <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Record Notes'), ['controller' => 'RecordNotes', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Record Note'), ['controller' => 'RecordNotes', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                                                                                </ul>
</nav>
<div class="row">
    <section class="card">

        
        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>

            <h2 class="card-title">Record Note Details</h2>
        </header>

    <div class="recordNoteDetails card-body content">

        <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                                                                                                <tr>
                            <th scope="row"><?= __('Record Note') ?></th>
                            <td><?= $recordNoteDetail->has('record_note') ? $this->Html->link($recordNoteDetail->record_note->id, ['controller' => 'RecordNotes', 'action' => 'view', $recordNoteDetail->record_note->id]) : '' ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Progress Made') ?></th>
                            <td><?= h($recordNoteDetail->progress_made) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Responsibility') ?></th>
                            <td><?= h($recordNoteDetail->responsibility) ?></td>
                        </tr>
                                                                                                            <tr>
                        <th scope="row"><?= __('Id') ?></th>
                        <td><?= $this->Number->format($recordNoteDetail->id) ?></td>
                    </tr>
                                                                            <tr>
                        <th scope="row"><?= __('Timeline') ?></th>
                        <td><?= h($recordNoteDetail->timeline) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Created') ?></th>
                        <td><?= h($recordNoteDetail->created) ?></td>
                    </tr>
                                                </table>
                                    <div class="row">
                    <h4><?= __('Decision Made') ?></h4>
                    
                        <?= $this->Text->autoParagraph(h($recordNoteDetail->decision_made)); ?>
                  
                </div>
                            <div class="row">
                    <h4><?= __('Notes') ?></h4>
                    
                        <?= $this->Text->autoParagraph(h($recordNoteDetail->notes)); ?>
                  
                </div>
                                        </div><!--/content-->
    </section>
</div><!--/row-->
