<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\RecordNote $recordNote
 */
$this->assign('title', 'Adding Record Note');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Record Notes'), ['action' => 'index'], ['escape' => false]) ?></li>
<!--                        <li><?= $this->Html->link(__('List Record Note Details'), ['controller' => 'RecordNoteDetails', 'action' => 'index'], ['escape' => false]) ?></li>
<li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Record Note Detail'), ['controller' => 'RecordNoteDetails', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>
<div class="column-responsive column-80">
    <div class="recordNotes col-lg-12 content">
        <?= $this->Form->create($recordNote, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __('Add Record Note') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Department') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('department_id', ['class' => 'form-control', 'label' => false, 'empty' => 'Choose Department', 'required']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Subject') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('subject', ['class' => 'form-control', 'label' => false]) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Meeting Date') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('meeting_date', ['class' => 'form-control', 'label' => false, 'value' => date('d-m-Y'), 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", 'data-plugin-options' => '{"orientation":"bottom"}']) . '</div>';
                    echo '</div><!--/row-->';

                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Attachment') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('attachment', ['class' => 'form-control', 'label' => false, 'type' => 'file']) . '</div>';
                    echo '</div><!--/row-->';

//                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Created By') . '</label></div>';
//                        echo '<div class="col-sm-7">' . $this->Form->control('created_by', ['class'=>'form-control', 'label'=>false]) . '</div>';
//                        echo '</div><!--/row-->';
//
//                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Modified By') . '</label></div>';
//                        echo '<div class="col-sm-7">' . $this->Form->control('modified_by', ['class'=>'form-control', 'label'=>false]) . '</div>';
//                        echo '</div><!--/row-->';
                    ?>
                    <table id="tbl_invTruck" cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                        <thead>
                            <tr>
                                <th scope="col">Decision Made </th>
                                <th scope="col">Is this meeting minute completed?</th>
                                <th scope="col">Timeline</th>
                                <th scope="col">Notes</th>
                                <th scope="col">Responsibility</th>
                                <th scope="col">Responsible Departments</th>
                                <th scope="col" width="30">&nbsp;</th>

                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $key = 0;
                            ?>
                            <tr class="tr_clone">
                                <td scope="col"><?= $this->Form->control('decision_made[' . $key . ']', ['required', 'class' => 'form-control', 'label' => false, 'type' => 'textarea']) ?></td>
                                <td scope="col"><?= $this->Form->control('completed[' . $key . ']', ['required', 'class' => 'form-control', 'label' => false, 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) ?></td>
                                <td scope="col"><?= $this->Form->control('timeline_label[' . $key . ']', ['required', 'class' => 'form-control', 'label' => false, 'options' => ['' => 'Choose', 'immediate' => 'Immediate', '1week' => '1 Week', '2week' => '2 Week', '3week' => '3 Week', '1month' => '1 Month']]) ?></td>
                                <td scope="col"><?= $this->Form->control('notes[' . $key . ']', ['class' => 'form-control', 'label' => false, 'type' => 'textarea', 'placeholder' => 'Additional Notes']) ?></td>
                                <td scope="col"><?= $this->Form->control('responsibility[' . $key . ']', ['required', 'class' => 'form-control', 'label' => false, 'type' => 'textarea', 'placeholder' => 'You can comma seperated responsibile persons here']) ?></td>
                                <td scope="col"><?= $this->Form->control('respons_depts[' . $key . '][]', ['required', 'options' => $departments, 'label' => false, 'multiple', 'data-plugin-multiselect', 'data-plugin-options' => '{ "maxHeight": 200, "includeSelectAllOption": true ,"enableCaseInsensitiveFiltering": true}', 'class' => 'form-control']); ?></td>
                                <td class="add_delete">&nbsp;</td>

                            </tr>


                        </tbody>
                    </table>
                    
                    <a style="cursor:pointer;color:white;" id="add_more" class="btn btn-primary pull-right"> <i aria-hidden="true" class="fas fa-plus-circle"></i> Add more</a>
                    <input class="form-control" type="number" value="1" id="add_rows" min="1" max="99" style="width:50px; float:right;margin-right:10px;" />

                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary']) ?>
                <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
    <script>

        $(function () {
            $('body').on('click', '#add_more', function () {
//               alert($('#add_rows').val());
               for(var myi=1;myi<=parseInt($('#add_rows').val());myi++){
                var $tableBody = $('#tbl_invTruck').find("tbody"),
                        $trLast = $tableBody.find("tr:last");
                var attach_key = $('#tbl_invTruck tr').length;
                var mykey = attach_key - 1;
                var mynewstring = '{ "maxHeight": 200, "includeSelectAllOption": true ,"enableCaseInsensitiveFiltering": true}';
//                var last_value = parseInt($trLast.clone().find('[name="display_order[' + mykey + ']"]').val()) + 1;

                var new_row = '<tr class="tr_clone">\n\
                                <td scope="col"><div class="input textarea"><textarea name="decision_made[' + mykey + ']" class="form-control" id="decision-made-0" rows="5"></textarea></div></td>\n\
                                <td scope="col"><div class="input select"><select name="completed[' + mykey + ']" class="form-control" id="completed-0"><option value="">Choose</option><option value="Yes">Yes</option><option value="No">No</option></select></div></td>\n\
                                <td scope="col"><div class="input select"><select name="timeline_label[' + mykey + ']" class="form-control" id="timeline-label-0"><option value="">Choose</option><option value="immediate">Immediate</option><option value="1week">1 Week</option><option value="2week">2 Week</option><option value="3week">3 Week</option><option value="1month">1 Month</option></select></div></td>\n\
                                <td scope="col"><div class="input textarea"><textarea name="notes[' + mykey + ']" class="form-control" placeholder="Additional Notes" id="notes-0" rows="5"></textarea></div></td>\n\
                                <td scope="col"><div class="input textarea"><textarea name="responsibility[' + mykey + ']" class="form-control" placeholder="You can comma seperated responsibile persons here" id="responsibility-0" rows="5"></textarea></div></td>\n\
                                <td scope="col"><div class="input select"><select multiple="multiple" data-plugin-multiselect="data-plugin-multiselect" name="respons_depts[' + mykey + '][]" class="form-control" id="completed-' + mykey + '">\n\
                                <option value="">Choose</option><option value="1">Administration</option><option value="2">Agriculture</option><option value="4">Auqaf</option><option value="3">C &amp; W</option><option value="35">Culture, Sports, Tourism, Archaeology &amp; Youth Affairs</option><option value="7">E &amp; SE</option><option value="5">Energy &amp; Power</option><option value="12">Establishment</option><option value="13">Excise &amp; Taxation</option><option value="14">Finance</option><option value="15">Food</option><option value="10">Forest, Environment and Wildlife</option><option value="16">Health</option><option value="21">Higher Education</option><option value="22">Home &amp; Tribal Affairs</option><option value="23">Housing</option><option value="18">Industries</option><option value="8">Information &amp; Public Relations</option><option value="24">IPC</option><option value="19">Irrigation</option><option value="20">Labour</option><option value="6">Law</option><option value="26">LG &amp; RDD</option><option value="27">Minerals Development</option><option value="30">PHE</option><option value="28">Planning &amp; Development</option><option value="29">Population Welfare</option><option value="11">Relief Rehabilitation &amp; Settlement</option><option value="31">Revenue</option><option value="32">Social Welfare</option><option value="9">ST &amp; IT</option><option value="34">Transport</option><option value="25">Zakat &amp; Ushr</option><option value="36">Other</option></select></div></td>\n\
                               <td class="add_delete"><a class="delete_parent" style="cursor:pointer" tabindex="0"><i class="fas fa-trash" style="color:red;"></i></a>&nbsp;</td>\n\
                            </tr>';

                $('#tbl_invTruck').append(new_row);
                $('#completed-' + mykey).attr('data-plugin-options', mynewstring);
            }
                $.getScript("<?php echo $this->request->getAttribute("webroot"); ?>porto-admin/js/theme.init.js");

            });
             $('body').on('click', '.delete_parent', function () {

            if (confirm('Are you sure you want to delete this row?')) {
                $(this).parents("tr").remove();
            }

        });
        });
    </script>