<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\SchemeRequest $schemeRequest
 */
   $this->assign('title', 'Editing Scheme Request');

?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
                        <li><?= $this->Form->postLink(
                __('<i class="fas fa-trash"></i> Delete'),
                ['action' => 'delete', $schemeRequest->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $schemeRequest->id), 'escape'=>false]
                ) ?></li>
                    <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Scheme Requests'), ['action' => 'index'], ['escape'=>false]) ?></li>
                        <li><?= $this->Html->link(__('List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape'=>false]) ?></li>
            <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape'=>false]) ?></li>
            <li><?= $this->Html->link(__('List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape'=>false]) ?></li>
            <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape'=>false]) ?></li>
                </ul>
</nav>
<div class="column-responsive column-80">
    <div class="schemeRequests col-lg-6 content">
        <?= $this->Form->create($schemeRequest, ['class'=>'form-horizontal']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __('Edit Scheme Request') ?>
                </h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <fieldset>
                    <?php
                                            echo '<div class="row"><div class="col-sm-5"><label>' . __('Department Id') . '</label></div>';
                        echo '<div class="col-sm-7">' .  $this->Form->control('department_id', ['options' => $departments, 'class'=>'form-control' ]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Scheme Profile Id') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('scheme_profile_id', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('User Id') . '</label></div>';
                        echo '<div class="col-sm-7">' .  $this->Form->control('user_id', ['options' => $users, 'class'=>'form-control' ]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Step Name') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('step_name', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Request Details') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('request_details', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Status') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('status', ['class'=>'form-control', 'label'=>false]) . '</div>';
                        echo '</div><!--/row-->';

                            ?>
                        </fieldset>

                    </div><!--card-body-->

                    <footer class="card-footer text-right">
                        <?= $this->Form->button(__('Submit'), ['class'=>'btn btn-primary']) ?>
                        <?= $this->Form->end() ?>
                    </footer>

                </section>
            </div>