<?php
/**
* @var \App\View\AppView $this
* @var \App\Model\Entity\SchemeRequest $schemeRequest
*/
$this->assign('title', 'Viewing Scheme Request');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit Scheme Request'), ['action' => 'edit', $schemeRequest->id], ['escape'=>false]) ?></li>
        <li><?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete Scheme Request'), ['action' => 'delete', $schemeRequest->id], ['confirm' => __('Are you sure you want to delete # {0}?', $schemeRequest->id), 'escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Scheme Requests'), ['action' => 'index'], ['escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Scheme Request'), ['action' => 'add'], ['escape'=>false]) ?></li>
                                                                                <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                    <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                                                                                </ul>
</nav>
<div class="row">
    <section class="card">

        
        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>

            <h2 class="card-title">Scheme Requests</h2>
        </header>

    <div class="schemeRequests card-body content">

        <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                                                                                                <tr>
                            <th scope="row"><?= __('Department') ?></th>
                            <td><?= $schemeRequest->has('department') ? $this->Html->link($schemeRequest->department->department_name, ['controller' => 'Departments', 'action' => 'view', $schemeRequest->department->id]) : '' ?></td>
                        </tr>
                                                                                                        <tr>
                            <th scope="row"><?= __('User') ?></th>
                            <td><?= $schemeRequest->has('user') ? $this->Html->link($schemeRequest->user->id, ['controller' => 'Users', 'action' => 'view', $schemeRequest->user->id]) : '' ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Step Name') ?></th>
                            <td><?= h($schemeRequest->step_name) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Status') ?></th>
                            <td><?= h($schemeRequest->status) ?></td>
                        </tr>
                                                                                                            <tr>
                        <th scope="row"><?= __('Id') ?></th>
                        <td><?= $this->Number->format($schemeRequest->id) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Scheme Profile Id') ?></th>
                        <td><?= $this->Number->format($schemeRequest->scheme_profile_id) ?></td>
                    </tr>
                                                                            <tr>
                        <th scope="row"><?= __('Created') ?></th>
                        <td><?= h($schemeRequest->created) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Modified') ?></th>
                        <td><?= h($schemeRequest->modified) ?></td>
                    </tr>
                                                </table>
                                    <div class="row">
                    <h4><?= __('Request Details') ?></h4>
                    
                        <?= $this->Text->autoParagraph(h($schemeRequest->request_details)); ?>
                  
                </div>
                                        </div><!--/content-->
    </section>
</div><!--/row-->
