<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\SchemeStatus[]|\Cake\Collection\CollectionInterface $schemeStatuses
 */
$this->assign('title', 'Listing Schemes Log');
$questions_array = [
    //Scheme profile
    'scheme_code' => 'Scheme #', 'parent_scheme_code' => 'Parent scheme code (if any)', 'scheme_name' => 'Name of the scheme',
    'scheme_type_drop' => 'Scheme Type', 'scheme_type' => 'Scheme Type', 'foreign_funded_drop' => 'Is the scheme Foreign Funded?', 'foreign_funded' => 'Is the scheme Foreign Funded?',
    'cost_of_scheme' => 'Total cost of the scheme (in Rs. millions)', 'expenditure_till_date' => 'Previous Expenditure (in Rs. millions)',
    'progressive_expenditure' => 'Progressive Expenditure  (in Rs. millions)', 'allocation_for_cfy' => 'Allocation for current financial year (in Rs. millions)',
    'release_for_cfy' => 'Release of funds in current financial year (in Rs. millions)', 'geo_coverage' => 'Geographical coverage of the scheme',
    'year' => 'Year', 'scheme_start_date' => 'Scheme Start Date<br/>(From the first consideration/review in PDWP)', 'scheme_start_date_disabled' => 'Scheme Start Date<br/>(From the first consideration/review in PDWP)',
    'scheme_end_date' => 'Scheme End Date', 'scheme_end_date_disabled' => 'Scheme End Date','is_ppp'=>'Is the scheme PPP (public private parternship)?','issues_list'=>'Issue with the scheme (if any)',
    //Step2
    //Step1
    'pc2_required' => 'Is PC-II required?', 'pc2_approved' => 'Has the PC-II been submitted to P & D?', 'consultant_hired' => 'Has the consultant been hired?',
    'cons_subt_report' => 'Has the consultant submitted the report?', 'pc2_compl_date' => 'What is the expected completion date of the PC-II process?',
    'responsible_pc2_compl' => 'Who is responsible for the PC-II completion process?', 'designation_step1' => 'Person/Company of concern for the PC-II completion process?',
    'step1_remarks' => 'Additional Comments about PC-II proceess', 'pc2_compl_old_date' => 'What was the old expected completion date of the PC-II process?',
    //Step2
    'pc1_required' => 'Is PC-1 required?','pc1_approved' => 'Has the PC-1 been approved?', 'pc1_approval_date' => 'What was the approval date for PC-1?', 'pc1_stage' => 'What stage is the PC-1 on?',
    'pc1_compl_date' => 'What is the expected completion date for the PC-1 process?', 'pc1_responsible' => 'Who is responsible for the PC-1 completion process?',
    'designation_step2' => 'Person/Company of concern for the PC-I completion process?', 'step2_remarks' => 'Additional Comments about PC-I proceess',
    'pc1_compl_old_date' => 'What was the old expected completion date for the PC-1 process?', 'pc1_approval_date_disabled' => 'What was the approval date for PC-1?',
    //step3
    'hiring_required' => 'Is hiring required?', 'sne_submitted' => 'Has SNE been submitted to Finance Department?', 'sne_approved' => 'Has the SNE been approved?',
    'will_hiring_through_psc' => 'Will hiring be done through public service commission?', 'hiring_through_psc' => 'Is the hiring been done through public service commission?',
    'hiring_compl_date_psc' => 'What is the expected completion date for hiring through public service commission?', 'responsible_psc' => 'Who is responsible for the hiring process?',
    'designation_step3_psc' => 'Person/Company of concern for the PSC hiring completion process?', 'will_hiring_through_internal_posting' => 'Will hiring be done through internal posting?',
    'hiring_through_internal_posting' => 'Is the hiring process completed?', 'hiring_compl_date_internal_posting' => 'Expected completion date of internal posting?',
    'responsible_internal_posting' => 'Who is responsible for the internal hiring process?', 'designation_step3_ip' => 'Person/Company of concern for the IP hiring completion process?',
    'will_hiring_through_market' => 'Will hiring be done through the market/project policy/any other agency?', 'hiring_through_market' => 'Is the hiring been done through the market/project policy/any other agency?',
    'posting_though_market_media' => 'Has the position been advertised in social and traditional media?', 'sne_required' => 'Is SNE required?',
    'hiring_market_entries_recorded' => 'Have entries from interested candidates been recorded?','request_details'=>'Date Change Request',
    'hiring_market_scrutiny_compl' => 'Is scrutiny and shortlisting of candidates complete?', 'hiring_market_intervies_cond' => 'Have the interviews been conducted?',
    'hiring_market_appoint_letter_issues' => 'Have the appointment letters been issues?', 'hiring_market_compl_date' => 'What is the completion date for hiring through the market?',
    'hiring_market_respons_person' => 'Who is responsible for hiring through the market?', 'designation_step3_market' => 'Person/Company of concern for the Market hiring completion process?',
    'sne_approval_date' => 'Till when SNE will be approved?', 'sne_submission_date' => 'Till when SNE will be submitted?', 'step3_remarks' => 'Additional Comments about Hiring proceess',
    'hiring_compl_old_date_psc' => 'What was the expected completion date for hiring through public service commission?',
    'hiring_compl_old_date_internal_posting' => 'Old expected completion date of internal posting?', 'hiring_market_old_compl_date' => 'What was the completion date for hiring through the market?',
    'sne_approval_old_date' => 'SNE old submission date?', 'sne_submission_old_date' => 'SNE old submission date?',
    //step4
    'land_acquisition_required' => 'Is land acquisition required?', 'land_identified' => 'Has the land been identified?', 'land_section4_compl' => 'Is Section 4 complete?',
    'land_section6_comp' => 'Is Section 6 complete?', 'land_possision_taken_over' => 'Has the possession of the land been taken over?', 'land_award_been_issued' => 'Has the award been issued?',
    'land_payment_made' => 'Has the payment been made?', 'land_acquisition_compl_date' => 'What is the expected completion date for land acquisition?',
    'land_acquisition_responsible' => 'Who is responsible for the land acquisition process?', 'designation_step4' => 'Person/Company of concern for the Land Acquisition completion process?',
    'step4_remarks' => 'Additional Comments about Land Acquisition proceess', 'land_acquisition_old_compl_date' => 'What was the old expected completion date for land acquisition?',
    //step5
    'proc_goods_required' => 'Is procurement of goods required?', 'proc_goods_tender_advertised' => 'Has the tender been advertised?',
    'proc_goods_bidding_complete' => 'Is the bidding and selection process complete?', 'proc_goods_po_issued' => 'Have the purchase orders been issued?',
    'proc_goods_delivery_physical_verification_done' => 'Has delivery/physical verification of goods been done?',
    'proc_goods_distribution_equipments' => 'Has the distribution of equipment been done?', 'proc_goods_evidence_of_distribution' => 'supporting notification/photographic evidence/ letter',
    'proc_goods_compl_date' => 'What is the completion date for procurement of goods?', 'proc_goods_responsible' => 'Who is responsible for the procurement of goods?',
    'designation_step5' => 'Person/Company of concern for the Procurement of Goods completion process?', 'step5_remarks' => 'Additional Comments about Procurement of Goods proceess',
    'proc_goods_old_compl_date' => 'What was the old completion date for procurement of goods?',
    //step6
    'proc_services_required' => 'Is procurement of services required?', 'proc_services_tender_advertised' => 'Has the tender been advertised?',
    'proc_services_tech_finance_proposal_received' => 'Has the technical and financial proposal been received?', 'proc_services_evaluation_process_compl' => 'Is evaluation of proposals complete?',
    'proc_services_contract_awarded' => 'Has the contract been awarded?', 'proc_services_status' => 'What is the completion status of the provision of service?',
    'proc_services_compl_date' => 'Expected completion date for procurement of services?', 'proc_services_responsible' => 'Who is responsible for the procurement of services?',
    'designation_step6' => 'Person/Company of concern for the Procurement of Services completion process?', 'step6_remarks' => 'Additional Comments about Procurement of Services proceess',
    'proc_services_old_compl_date' => 'Old expected completion date for procurement of services?',
    //step7
    'cons_civil_work_required' => 'Is construction/civil work required?', 'is_work_carried_by_civil_works' => 'Is the work to be carried out by C & W?',
    'is_work_commisioned_privately' => 'Is the construction commissioned through other agency?',
    'cons_civil_private_type' => 'Will the agency for civil works hired through Single sourcing/ Open Tendering?', 'is_work_tender_advertised' => 'Has the tender been advertised?',
    'is_work_bidding_compl' => 'Is the bidding and selection process complete?', 'is_work_order_issued' => 'Have the work orders been issued?',
    'is_work_begun' => 'Has the work begun?', 'level_of_work_compl' => 'What is the level of work completed so far?',
    'cons_civil_compl_date' => 'Expected completion date for construction/civil works?', 'cons_civil_responsible' => 'Who is responsible for the construction/civil works process?',
    'designation_step7' => 'Person/Company of concern for the construction/civil works completion process?', 'step7_remarks' => 'Additional Comments about construction/civil works',
    'cons_civil_old_compl_date' => 'Old expected completion date for construction/civil works?'
];
?>



<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>
            <h3><?= __('Schemes Log') ?></h3>
        </header>

        <div class="schemeStatuses card-body content">
            <?php echo $this->Form->create(null, array('role' => 'form', 'class' => 'form-horizontal', 'type' => 'get')); ?>

            <div class="row">

                <div class="col-sm-5">
                    <label>Date Range</label>
                    <div class="input-daterange input-group" data-plugin-datepicker data-date-format = "dd-mm-yyyy" data-plugin-options = '{"orientation":"bottom"}'>
                        <span class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="fas fa-calendar-alt"></i>
                            </span>
                        </span>
                        <!--<input type="text" class="form-control" name="start">-->
                        <?= $this->Form->control('start', ['class' => 'form-control', 'label' => false, 'style' => 'width:100%;', 'value' => isset($_GET['start']) ? $_GET['start'] : date('d-m-Y')]); ?>

                        <span class="input-group-text border-left-0 border-right-0 rounded-0">
                            to
                        </span>
                        <!--<input type="text" class="form-control" name="end">-->
                        <?= $this->Form->control('end', ['class' => 'form-control', 'label' => false, 'style' => 'width:100%;', 'value' => isset($_GET['end']) ? $_GET['end'] : date('d-m-Y')]); ?>

                        <?php // $this->Form->control('end', ['class' => 'form-control', 'data-plugin-datepicker', "data-date-format" => "yyyy-mm-dd", 'data-plugin-options' => '{"orientation":"bottom"}', 'value' => isset($_GET['date_of_service']) ? $_GET['date_of_service'] : '']);     ?>

                    </div>

                </div>
                <div class="col-sm-5">
                    <label for="district">Choose Department(s)</label><br/>
                    <?php
                    //debug($Departments);
                    echo $this->Form->control('department[]', ['options' => $departments, 'label' => false, 'multiple', 'data-plugin-multiselect', 'data-plugin-options' => '{ "maxHeight": 200, "includeSelectAllOption": true ,"enableCaseInsensitiveFiltering": true}', 'class' => 'form-control', 'value' => isset($_GET['department']) ? $_GET['department'] : '']);
                    ?>

                </div>
                <div class="col-sm-2">
                    <br/>
                    <?= $this->Form->button(__('Search'), ['class' => 'btn btn-primary']) ?>

                </div>

            </div>

            <?= $this->Form->end() ?>
            <hr/>
            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <thead>
                    <tr>
                        <th scope="col">Department</th>
                        <th scope="col">Department Schemes</th>
                        <th scope="col">Question</th>
                        <th scope="col">Answer</th>
                        <th scope="col">Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $departments['Other'] = 'Other';
                    foreach ($logs as $log):
//                        debug($log);
                        ?>
                        <tr>
                            <td class="text-left" data-title="Status Name"><?= ucfirst($log->department->department_name) ?></td>
                            <td class="text-left" data-title="Status Name"><?= ucfirst($log->department_scheme->scheme_name) ?></td>
                            <td class="text-left" data-title="Status Name"><?= ucfirst($questions_array[$log->field_name]) ?></td>
                            <td class="text-left" data-title="Status Name"><?php
//                                debug(DateTime::createFromFormat('Y-m-d H:i:s', $log->answer));
                                if (strtotime($log->answer) && strpos($log->answer, '-') !== false) {
                                    echo date('d-m-Y', strtotime($log->answer));
                                } else {
                                    if (strpos($questions_array[$log->field_name], 'Who is responsible for') !== false) {
                                        echo $departments[$log->answer];
                                    } else {
                                        echo ucfirst($log->answer);
                                    }
                                }
                                ?></td>
                            <td class="text-left" data-title="Date"><?= date('d-m-Y h:i a', strtotime($log->created)); ?></td>


                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </section>
</div><!--/row-->
