<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User[]|\Cake\Collection\CollectionInterface $users
 */
$set_title = 'Listing Admin Users';
$subheading = 'Admin Users';

$add_text = 'New Admin User';

$setid = '';
if (isset($this->request->getParam('pass')[0])) {
    $setid = $this->request->getParam('pass')[0];
    $set_title = 'Listing ' . ucfirst($department['department_name']) . ' CPO\'s';
    $subheading = ucfirst($department['department_name']) . ' CPO\'s';
    $add_text = 'New CPO';
}

$this->assign('title', $set_title);
?>

<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> ' . $add_text), ['action' => 'add', $setid], ['escape' => false]) ?></li>

        <!--<li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users Roles'), ['controller' => 'UsersRoles', 'action' => 'index'], ['escape' => false]) ?></li>-->
        <!--<li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Users Role'), ['controller' => 'UsersRoles', 'action' => 'add'], ['escape' => false]) ?></li>-->
    </ul>
</nav>

<div class="row">
    <section class="card">


        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>
            <h3><?= __($subheading) ?></h3>
        </header>

        <div class="users card-body content">
            <?php echo $this->Form->create(null, array('role' => 'form', 'class' => 'form-horizontal', 'type' => 'get')); ?>

            <div class="row">

                <div class="col-sm-10">
                    <?= $this->Form->control('name', ['placeholder' => 'Search by first name, last name, email, user type etc', 'class' => 'form-control', 'value' => isset($_GET['name']) ? $_GET['name'] : '']); ?>
                    <br/>
                </div>


                <div class="col-sm-2">
                    <?= $this->Form->button(__('Search'), ['class' => 'btn btn-primary', 'style' => 'margin-top:30px;']) ?>
                    <br/>
                </div>

            </div>
            <?= $this->Form->end() ?>
            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <thead>
                    <tr>
                        <!--<th scope="col"><?= $this->Paginator->sort('id') ?></th>-->
                        <th scope="col"><?= $this->Paginator->sort('fname', 'First Name') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('lname', 'Last Name') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('email') ?></th>
                        <!--<th scope="col"><?= $this->Paginator->sort('password') ?></th>-->
                        <th scope="col"><?= $this->Paginator->sort('locked') ?></th>
                        <!--<th scope="col"><?= $this->Paginator->sort('active') ?></th>-->
                        <th scope="col"><?= $this->Paginator->sort('users_roles_id') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('avatar') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('tel1', 'Mobile') ?></th>
 <!--                         <th scope="col"><?= $this->Paginator->sort('tel2') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('fax') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('addr1') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('addr2') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('city') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('state') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('postal') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('country') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('login_failures') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('last_login_failure') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('last_login_success') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('created_by') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('created') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('modified_by') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('modified') ?></th>
                         <th scope="col"><?= $this->Paginator->sort('deleted') ?></th>-->
                        <th scope="col" class="actions"><?= __('Actions') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $user): ?>
                        <tr>
                            <!--<td class="text-right" data-title="Id"><?= $this->Number->format($user->id) ?></td>-->
                            <td class="text-left" data-title="Fname"><?= ucfirst($user->fname) ?></td>
                            <td class="text-left" data-title="Lname"><?= ucfirst($user->lname) ?></td>
                            <td class="text-left" data-title="Email"><?= h($user->email) ?></td>
                            <!--<td class="text-left" data-title="Password"><?= h($user->password) ?></td>-->
                            <td class="text-right" data-title="Locked"><?= ($user->locked) ? '<span style="color:red;">Yes</span>' : '<span style="color:green;">No</span>'; ?></td>
                            <!--<td class="text-right" data-title="Active"><?= $this->Number->format($user->active) ?></td>-->
                            <td><?= $user->has('users_role') ? $user->users_role->id : '' ?></td>
                            <td class="text-left" data-title="Avatar">
                                <?php
                                if (file_exists(WWW_ROOT . 'img/users/' . $user->avatar) && !empty($user->avatar)) {

                                    echo '<img src="' . $this->request->getAttribute("webroot") . 'img/users/' . $user->avatar . '" style="max-height:100px">';
                                }
                                ?>
                            </td>
                            <td class="text-left" data-title="Tel1"><?= h($user->tel1) ?></td>
    <!--                        <td class="text-left" data-title="Tel2"><?= h($user->tel2) ?></td>
                        <td class="text-left" data-title="Fax"><?= h($user->fax) ?></td>
                        <td class="text-left" data-title="Addr1"><?= h($user->addr1) ?></td>
                        <td class="text-left" data-title="Addr2"><?= h($user->addr2) ?></td>
                        <td class="text-left" data-title="City"><?= h($user->city) ?></td>
                        <td class="text-left" data-title="State"><?= h($user->state) ?></td>
                        <td class="text-left" data-title="Postal"><?= h($user->postal) ?></td>
                        <td class="text-left" data-title="Country"><?= h($user->country) ?></td>
                        <td class="text-right" data-title="Login Failures"><?= $this->Number->format($user->login_failures) ?></td>
                        <td class="text-left" data-title="Last Login Failure"><?= h($user->last_login_failure) ?></td>
                        <td class="text-left" data-title="Last Login Success"><?= h($user->last_login_success) ?></td>
                        <td class="text-right" data-title="Created By"><?= $this->Number->format($user->created_by) ?></td>
                        <td class="text-left" data-title="Created"><?= h($user->created) ?></td>
                        <td class="text-right" data-title="Modified By"><?= $this->Number->format($user->modified_by) ?></td>
                        <td class="text-left" data-title="Modified"><?= h($user->modified) ?></td>
                        <td class="text-right" data-title="Deleted"><?= $this->Number->format($user->deleted) ?></td>-->
                            <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['action' => 'view', $user->id], ['escape' => false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['action' => 'edit', $user->id], ['escape' => false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $user->id], ['confirm' => __('Are you sure you want to delete # {0}?', ucwords($user->fname . ' ' . $user->lname)), 'escape' => false]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <footer class="card-footer text-right">
                <div class="paginator">
                    <ul class="pagination">
                        <?= $this->Paginator->first('<< ' . __('first')) ?>
                        <?= $this->Paginator->prev('< ' . __('previous')) ?>
                        <?= $this->Paginator->numbers() ?>
                        <?= $this->Paginator->next(__('next') . ' >') ?>
                        <?= $this->Paginator->last(__('last') . ' >>') ?>
                    </ul>
                    <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                </div>
            </footer>
        </div>
    </section>
</div><!--/row-->
