<?php
/**
* @var \App\View\AppView $this
* @var \App\Model\Entity\AttachedFormation $attachedFormation
*/
$this->assign('title', 'Viewing Attached Formation');
?>
<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit Attached Formation'), ['action' => 'edit', $attachedFormation->id], ['escape'=>false]) ?></li>
        <li><?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete Attached Formation'), ['action' => 'delete', $attachedFormation->id], ['confirm' => __('Are you sure you want to delete # {0}?', $attachedFormation->id), 'escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Attached Formations'), ['action' => 'index'], ['escape'=>false]) ?></li>
        <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Attached Formation'), ['action' => 'add'], ['escape'=>false]) ?></li>
                                                                                <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Departments'), ['controller' => 'Departments', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department'), ['controller' => 'Departments', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                                                                            <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Department Schemes'), ['controller' => 'DepartmentSchemes', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['controller' => 'DepartmentSchemes', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                    <li><?= $this->Html->link(__('<i class="fas fa-list-alt"></i> List Users'), ['controller' => 'Users', 'action' => 'index'], ['escape'=>false]) ?> </li>
                    <li><?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New User'), ['controller' => 'Users', 'action' => 'add'], ['escape'=>false]) ?> </li>
                                                                                                        </ul>
</nav>
<div class="row">
    <section class="card">

        
        <header class="card-header">
            <div class="card-actions">
                <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
            </div>

            <h2 class="card-title">Attached Formations</h2>
        </header>

    <div class="attachedFormations card-body content">

        <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                                                                                                <tr>
                            <th scope="row"><?= __('Department') ?></th>
                            <td><?= $attachedFormation->has('department') ? $this->Html->link($attachedFormation->department->department_name, ['controller' => 'Departments', 'action' => 'view', $attachedFormation->department->id]) : '' ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Name') ?></th>
                            <td><?= h($attachedFormation->name) ?></td>
                        </tr>
                                                                                <tr>
                            <th scope="row"><?= __('Logo') ?></th>
                            <td><?= h($attachedFormation->logo) ?></td>
                        </tr>
                                                                                                            <tr>
                        <th scope="row"><?= __('Id') ?></th>
                        <td><?= $this->Number->format($attachedFormation->id) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Created By') ?></th>
                        <td><?= $this->Number->format($attachedFormation->created_by) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Modified By') ?></th>
                        <td><?= $this->Number->format($attachedFormation->modified_by) ?></td>
                    </tr>
                                                                            <tr>
                        <th scope="row"><?= __('Created') ?></th>
                        <td><?= h($attachedFormation->created) ?></td>
                    </tr>
                                    <tr>
                        <th scope="row"><?= __('Modified') ?></th>
                        <td><?= h($attachedFormation->modified) ?></td>
                    </tr>
                                                </table>
                                    <div class="row">
                    <h4><?= __('Detail') ?></h4>
                    
                        <?= $this->Text->autoParagraph(h($attachedFormation->detail)); ?>
                  
                </div>
                                                                        <div class="related">
                <h4><?= __('Related Department Schemes') ?></h4>
                <?php if (!empty($attachedFormation->department_schemes)) : ?>
                <div class="table-responsive">
                    <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                        <tr>
                                                            <th scope="col"><?= __('Id') ?></th>
                                                                <th scope="col"><?= __('Year') ?></th>
                                                                <th scope="col"><?= __('Department Id') ?></th>
                                                                <th scope="col"><?= __('Attached Formation Id') ?></th>
                                                                <th scope="col"><?= __('User Id') ?></th>
                                                                <th scope="col"><?= __('Overall Status') ?></th>
                                                                <th scope="col"><?= __('Step1 Status') ?></th>
                                                                <th scope="col"><?= __('Step2 Status') ?></th>
                                                                <th scope="col"><?= __('Step3 Status') ?></th>
                                                                <th scope="col"><?= __('Step4 Status') ?></th>
                                                                <th scope="col"><?= __('Step5 Status') ?></th>
                                                                <th scope="col"><?= __('Step6 Status') ?></th>
                                                                <th scope="col"><?= __('Step7 Status') ?></th>
                                                                <th scope="col"><?= __('Scheme Code') ?></th>
                                                                <th scope="col"><?= __('Scheme Name') ?></th>
                                                                <th scope="col"><?= __('Scheme Type') ?></th>
                                                                <th scope="col"><?= __('Scheme Detail') ?></th>
                                                                <th scope="col"><?= __('Active') ?></th>
                                                                <th scope="col"><?= __('Directive') ?></th>
                                                                <th scope="col"><?= __('Cost Of Scheme') ?></th>
                                                                <th scope="col"><?= __('Expenditure Till Date') ?></th>
                                                                <th scope="col"><?= __('Allocation For Cfy') ?></th>
                                                                <th scope="col"><?= __('Release For Cfy') ?></th>
                                                                <th scope="col"><?= __('Geo Coverage') ?></th>
                                                                <th scope="col"><?= __('Scheme Start Date') ?></th>
                                                                <th scope="col"><?= __('Scheme End Date') ?></th>
                                                                <th scope="col"><?= __('Pc2 Required') ?></th>
                                                                <th scope="col"><?= __('Pc2 Approved') ?></th>
                                                                <th scope="col"><?= __('Consultant Hired') ?></th>
                                                                <th scope="col"><?= __('Cons Subt Report') ?></th>
                                                                <th scope="col"><?= __('Pc2 Compl Date') ?></th>
                                                                <th scope="col"><?= __('Responsible Pc2 Compl') ?></th>
                                                                <th scope="col"><?= __('Pc1 Approved') ?></th>
                                                                <th scope="col"><?= __('Pc1 Approval Date') ?></th>
                                                                <th scope="col"><?= __('Pc1 Stage') ?></th>
                                                                <th scope="col"><?= __('Pc1 Compl Date') ?></th>
                                                                <th scope="col"><?= __('Pc1 Responsible') ?></th>
                                                                <th scope="col"><?= __('Hiring Required') ?></th>
                                                                <th scope="col"><?= __('Sne Required') ?></th>
                                                                <th scope="col"><?= __('Sne Submitted') ?></th>
                                                                <th scope="col"><?= __('Sne Submission Date') ?></th>
                                                                <th scope="col"><?= __('Sne Approved') ?></th>
                                                                <th scope="col"><?= __('Sne Approval Date') ?></th>
                                                                <th scope="col"><?= __('Will Hiring Through Psc') ?></th>
                                                                <th scope="col"><?= __('Hiring Through Psc') ?></th>
                                                                <th scope="col"><?= __('Hiring Compl Date Psc') ?></th>
                                                                <th scope="col"><?= __('Responsible Psc') ?></th>
                                                                <th scope="col"><?= __('Will Hiring Through Internal Posting') ?></th>
                                                                <th scope="col"><?= __('Hiring Through Internal Posting') ?></th>
                                                                <th scope="col"><?= __('Hiring Compl Date Internal Posting') ?></th>
                                                                <th scope="col"><?= __('Responsible Internal Posting') ?></th>
                                                                <th scope="col"><?= __('Will Hiring Through Market') ?></th>
                                                                <th scope="col"><?= __('Hiring Through Market') ?></th>
                                                                <th scope="col"><?= __('Posting Though Market Media') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Entries Recorded') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Scrutiny Compl') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Intervies Cond') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Appoint Letter Issues') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Compl Date') ?></th>
                                                                <th scope="col"><?= __('Hiring Market Respons Person') ?></th>
                                                                <th scope="col"><?= __('Land Acquisition Required') ?></th>
                                                                <th scope="col"><?= __('Land Identified') ?></th>
                                                                <th scope="col"><?= __('Land Section4 Compl') ?></th>
                                                                <th scope="col"><?= __('Land Section6 Comp') ?></th>
                                                                <th scope="col"><?= __('Land Possision Taken Over') ?></th>
                                                                <th scope="col"><?= __('Land Award Been Issued') ?></th>
                                                                <th scope="col"><?= __('Land Payment Made') ?></th>
                                                                <th scope="col"><?= __('Land Acquisition Compl Date') ?></th>
                                                                <th scope="col"><?= __('Land Acquisition Responsible') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Required') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Tender Advertised') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Bidding Complete') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Po Issued') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Delivery Physical Verification Done') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Distribution Equipments') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Evidence Of Distribution') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Compl Date') ?></th>
                                                                <th scope="col"><?= __('Proc Goods Responsible') ?></th>
                                                                <th scope="col"><?= __('Proc Services Required') ?></th>
                                                                <th scope="col"><?= __('Proc Services Tender Advertised') ?></th>
                                                                <th scope="col"><?= __('Proc Services Tech Finance Proposal Received') ?></th>
                                                                <th scope="col"><?= __('Proc Services Evaluation Process Compl') ?></th>
                                                                <th scope="col"><?= __('Proc Services Contract Awarded') ?></th>
                                                                <th scope="col"><?= __('Proc Services Status') ?></th>
                                                                <th scope="col"><?= __('Proc Services Compl Date') ?></th>
                                                                <th scope="col"><?= __('Proc Services Responsible') ?></th>
                                                                <th scope="col"><?= __('Cons Civil Work Required') ?></th>
                                                                <th scope="col"><?= __('Is Work Carried By Civil Works') ?></th>
                                                                <th scope="col"><?= __('Is Work Commisioned Privately') ?></th>
                                                                <th scope="col"><?= __('Cons Civil Private Type') ?></th>
                                                                <th scope="col"><?= __('Is Work Tender Advertised') ?></th>
                                                                <th scope="col"><?= __('Is Work Bidding Compl') ?></th>
                                                                <th scope="col"><?= __('Is Work Order Issued') ?></th>
                                                                <th scope="col"><?= __('Is Work Begun') ?></th>
                                                                <th scope="col"><?= __('Level Of Work Compl') ?></th>
                                                                <th scope="col"><?= __('Cons Civil Compl Date') ?></th>
                                                                <th scope="col"><?= __('Cons Civil Responsible') ?></th>
                                                                <th scope="col"><?= __('Comments') ?></th>
                                                                <th scope="col"><?= __('Scheme File') ?></th>
                                                                <th scope="col"><?= __('Designation Step1') ?></th>
                                                                <th scope="col"><?= __('Designation Step2') ?></th>
                                                                <th scope="col"><?= __('Designation Step3 Psc') ?></th>
                                                                <th scope="col"><?= __('Designation Step3 Ip') ?></th>
                                                                <th scope="col"><?= __('Designation Step3 Market') ?></th>
                                                                <th scope="col"><?= __('Designation Step4') ?></th>
                                                                <th scope="col"><?= __('Designation Step5') ?></th>
                                                                <th scope="col"><?= __('Designation Step6') ?></th>
                                                                <th scope="col"><?= __('Designation Step7') ?></th>
                                                                <th scope="col"><?= __('Step1 Remarks') ?></th>
                                                                <th scope="col"><?= __('Step2 Remarks') ?></th>
                                                                <th scope="col"><?= __('Step3 Remarks') ?></th>
                                                                <th scope="col"><?= __('Step4 Remarks') ?></th>
                                                                <th scope="col"><?= __('Step5 Remarks') ?></th>
                                                                <th scope="col"><?= __('Step6 Remarks') ?></th>
                                                                <th scope="col"><?= __('Step7 Remarks') ?></th>
                                                                <th scope="col"><?= __('Last Cron Job Date') ?></th>
                                                                <th scope="col"><?= __('Created') ?></th>
                                                                <th scope="col"><?= __('Modified') ?></th>
                                                                <th scope="col"><?= __('Created By') ?></th>
                                                                <th scope="col"><?= __('Modified By') ?></th>
                                                                <th scope="col"><?= __('Deleted') ?></th>
                                                            <th  scope="col" class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($attachedFormation->department_schemes as $departmentSchemes) : ?>
                        <tr>
                                                            <td><?= h($departmentSchemes->id) ?></td>
                                                            <td><?= h($departmentSchemes->year) ?></td>
                                                            <td><?= h($departmentSchemes->department_id) ?></td>
                                                            <td><?= h($departmentSchemes->attached_formation_id) ?></td>
                                                            <td><?= h($departmentSchemes->user_id) ?></td>
                                                            <td><?= h($departmentSchemes->overall_status) ?></td>
                                                            <td><?= h($departmentSchemes->step1_status) ?></td>
                                                            <td><?= h($departmentSchemes->step2_status) ?></td>
                                                            <td><?= h($departmentSchemes->step3_status) ?></td>
                                                            <td><?= h($departmentSchemes->step4_status) ?></td>
                                                            <td><?= h($departmentSchemes->step5_status) ?></td>
                                                            <td><?= h($departmentSchemes->step6_status) ?></td>
                                                            <td><?= h($departmentSchemes->step7_status) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_code) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_name) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_type) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_detail) ?></td>
                                                            <td><?= h($departmentSchemes->active) ?></td>
                                                            <td><?= h($departmentSchemes->directive) ?></td>
                                                            <td><?= h($departmentSchemes->cost_of_scheme) ?></td>
                                                            <td><?= h($departmentSchemes->expenditure_till_date) ?></td>
                                                            <td><?= h($departmentSchemes->allocation_for_cfy) ?></td>
                                                            <td><?= h($departmentSchemes->release_for_cfy) ?></td>
                                                            <td><?= h($departmentSchemes->geo_coverage) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_start_date) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_end_date) ?></td>
                                                            <td><?= h($departmentSchemes->pc2_required) ?></td>
                                                            <td><?= h($departmentSchemes->pc2_approved) ?></td>
                                                            <td><?= h($departmentSchemes->consultant_hired) ?></td>
                                                            <td><?= h($departmentSchemes->cons_subt_report) ?></td>
                                                            <td><?= h($departmentSchemes->pc2_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->responsible_pc2_compl) ?></td>
                                                            <td><?= h($departmentSchemes->pc1_approved) ?></td>
                                                            <td><?= h($departmentSchemes->pc1_approval_date) ?></td>
                                                            <td><?= h($departmentSchemes->pc1_stage) ?></td>
                                                            <td><?= h($departmentSchemes->pc1_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->pc1_responsible) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_required) ?></td>
                                                            <td><?= h($departmentSchemes->sne_required) ?></td>
                                                            <td><?= h($departmentSchemes->sne_submitted) ?></td>
                                                            <td><?= h($departmentSchemes->sne_submission_date) ?></td>
                                                            <td><?= h($departmentSchemes->sne_approved) ?></td>
                                                            <td><?= h($departmentSchemes->sne_approval_date) ?></td>
                                                            <td><?= h($departmentSchemes->will_hiring_through_psc) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_through_psc) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_compl_date_psc) ?></td>
                                                            <td><?= h($departmentSchemes->responsible_psc) ?></td>
                                                            <td><?= h($departmentSchemes->will_hiring_through_internal_posting) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_through_internal_posting) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_compl_date_internal_posting) ?></td>
                                                            <td><?= h($departmentSchemes->responsible_internal_posting) ?></td>
                                                            <td><?= h($departmentSchemes->will_hiring_through_market) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_through_market) ?></td>
                                                            <td><?= h($departmentSchemes->posting_though_market_media) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_entries_recorded) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_scrutiny_compl) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_intervies_cond) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_appoint_letter_issues) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->hiring_market_respons_person) ?></td>
                                                            <td><?= h($departmentSchemes->land_acquisition_required) ?></td>
                                                            <td><?= h($departmentSchemes->land_identified) ?></td>
                                                            <td><?= h($departmentSchemes->land_section4_compl) ?></td>
                                                            <td><?= h($departmentSchemes->land_section6_comp) ?></td>
                                                            <td><?= h($departmentSchemes->land_possision_taken_over) ?></td>
                                                            <td><?= h($departmentSchemes->land_award_been_issued) ?></td>
                                                            <td><?= h($departmentSchemes->land_payment_made) ?></td>
                                                            <td><?= h($departmentSchemes->land_acquisition_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->land_acquisition_responsible) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_required) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_tender_advertised) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_bidding_complete) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_po_issued) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_delivery_physical_verification_done) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_distribution_equipments) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_evidence_of_distribution) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->proc_goods_responsible) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_required) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_tender_advertised) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_tech_finance_proposal_received) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_evaluation_process_compl) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_contract_awarded) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_status) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->proc_services_responsible) ?></td>
                                                            <td><?= h($departmentSchemes->cons_civil_work_required) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_carried_by_civil_works) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_commisioned_privately) ?></td>
                                                            <td><?= h($departmentSchemes->cons_civil_private_type) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_tender_advertised) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_bidding_compl) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_order_issued) ?></td>
                                                            <td><?= h($departmentSchemes->is_work_begun) ?></td>
                                                            <td><?= h($departmentSchemes->level_of_work_compl) ?></td>
                                                            <td><?= h($departmentSchemes->cons_civil_compl_date) ?></td>
                                                            <td><?= h($departmentSchemes->cons_civil_responsible) ?></td>
                                                            <td><?= h($departmentSchemes->comments) ?></td>
                                                            <td><?= h($departmentSchemes->scheme_file) ?></td>
                                                            <td><?= h($departmentSchemes->designation_step1) ?></td>
                                                            <td><?= h($departmentSchemes->designation_step2) ?></td>
                                                            <td><?= h($departmentSchemes->designation_step3_psc) ?></td>
                                                            <td><?= h($departmentSchemes->designation_step3_ip) ?></td>
                                                            <td><?= h($departmentSchemes->designation_step3_market) ?></td>
                                                            <td><?= h($departmentSchemes->designation_step4) ?></td>
                                                            <td><?= h($departmentSchemes->designation_step5) ?></td>
                                                            <td><?= h($departmentSchemes->designation_step6) ?></td>
                                                            <td><?= h($departmentSchemes->designation_step7) ?></td>
                                                            <td><?= h($departmentSchemes->step1_remarks) ?></td>
                                                            <td><?= h($departmentSchemes->step2_remarks) ?></td>
                                                            <td><?= h($departmentSchemes->step3_remarks) ?></td>
                                                            <td><?= h($departmentSchemes->step4_remarks) ?></td>
                                                            <td><?= h($departmentSchemes->step5_remarks) ?></td>
                                                            <td><?= h($departmentSchemes->step6_remarks) ?></td>
                                                            <td><?= h($departmentSchemes->step7_remarks) ?></td>
                                                            <td><?= h($departmentSchemes->last_cron_job_date) ?></td>
                                                            <td><?= h($departmentSchemes->created) ?></td>
                                                            <td><?= h($departmentSchemes->modified) ?></td>
                                                            <td><?= h($departmentSchemes->created_by) ?></td>
                                                            <td><?= h($departmentSchemes->modified_by) ?></td>
                                                            <td><?= h($departmentSchemes->deleted) ?></td>
                                                                                    <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['controller' => 'DepartmentSchemes', 'action' => 'view', $departmentSchemes->id], ['escape'=>false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['controller' => 'DepartmentSchemes', 'action' => 'edit', $departmentSchemes->id], ['escape'=>false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['controller' => 'DepartmentSchemes', 'action' => 'delete', $departmentSchemes->id], ['confirm' => __('Are you sure you want to delete # {0}?', $departmentSchemes->id), 'escape'=>false]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
                                            <div class="related">
                <h4><?= __('Related Users') ?></h4>
                <?php if (!empty($attachedFormation->users)) : ?>
                <div class="table-responsive">
                    <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                        <tr>
                                                            <th scope="col"><?= __('Id') ?></th>
                                                                <th scope="col"><?= __('Department Id') ?></th>
                                                                <th scope="col"><?= __('Attached Formation Id') ?></th>
                                                                <th scope="col"><?= __('Fname') ?></th>
                                                                <th scope="col"><?= __('Lname') ?></th>
                                                                <th scope="col"><?= __('Email') ?></th>
                                                                <th scope="col"><?= __('Password') ?></th>
                                                                <th scope="col"><?= __('Locked') ?></th>
                                                                <th scope="col"><?= __('Active') ?></th>
                                                                <th scope="col"><?= __('Users Roles Id') ?></th>
                                                                <th scope="col"><?= __('Avatar') ?></th>
                                                                <th scope="col"><?= __('Tel1') ?></th>
                                                                <th scope="col"><?= __('Tel2') ?></th>
                                                                <th scope="col"><?= __('Fax') ?></th>
                                                                <th scope="col"><?= __('Addr1') ?></th>
                                                                <th scope="col"><?= __('Addr2') ?></th>
                                                                <th scope="col"><?= __('City') ?></th>
                                                                <th scope="col"><?= __('State') ?></th>
                                                                <th scope="col"><?= __('Postal') ?></th>
                                                                <th scope="col"><?= __('Country') ?></th>
                                                                <th scope="col"><?= __('Comments') ?></th>
                                                                <th scope="col"><?= __('Login Failures') ?></th>
                                                                <th scope="col"><?= __('Last Login Failure') ?></th>
                                                                <th scope="col"><?= __('Last Login Success') ?></th>
                                                                <th scope="col"><?= __('Created By') ?></th>
                                                                <th scope="col"><?= __('Created') ?></th>
                                                                <th scope="col"><?= __('Modified By') ?></th>
                                                                <th scope="col"><?= __('Modified') ?></th>
                                                                <th scope="col"><?= __('Deleted') ?></th>
                                                            <th  scope="col" class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($attachedFormation->users as $users) : ?>
                        <tr>
                                                            <td><?= h($users->id) ?></td>
                                                            <td><?= h($users->department_id) ?></td>
                                                            <td><?= h($users->attached_formation_id) ?></td>
                                                            <td><?= h($users->fname) ?></td>
                                                            <td><?= h($users->lname) ?></td>
                                                            <td><?= h($users->email) ?></td>
                                                            <td><?= h($users->password) ?></td>
                                                            <td><?= h($users->locked) ?></td>
                                                            <td><?= h($users->active) ?></td>
                                                            <td><?= h($users->users_roles_id) ?></td>
                                                            <td><?= h($users->avatar) ?></td>
                                                            <td><?= h($users->tel1) ?></td>
                                                            <td><?= h($users->tel2) ?></td>
                                                            <td><?= h($users->fax) ?></td>
                                                            <td><?= h($users->addr1) ?></td>
                                                            <td><?= h($users->addr2) ?></td>
                                                            <td><?= h($users->city) ?></td>
                                                            <td><?= h($users->state) ?></td>
                                                            <td><?= h($users->postal) ?></td>
                                                            <td><?= h($users->country) ?></td>
                                                            <td><?= h($users->comments) ?></td>
                                                            <td><?= h($users->login_failures) ?></td>
                                                            <td><?= h($users->last_login_failure) ?></td>
                                                            <td><?= h($users->last_login_success) ?></td>
                                                            <td><?= h($users->created_by) ?></td>
                                                            <td><?= h($users->created) ?></td>
                                                            <td><?= h($users->modified_by) ?></td>
                                                            <td><?= h($users->modified) ?></td>
                                                            <td><?= h($users->deleted) ?></td>
                                                                                    <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View'), ['controller' => 'Users', 'action' => 'view', $users->id], ['escape'=>false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit'), ['controller' => 'Users', 'action' => 'edit', $users->id], ['escape'=>false]) ?>
                                <?= $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['controller' => 'Users', 'action' => 'delete', $users->id], ['confirm' => __('Are you sure you want to delete # {0}?', $users->id), 'escape'=>false]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            </div><!--/content-->
    </section>
</div><!--/row-->
