<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme[]|\Cake\Collection\CollectionInterface $departmentSchemes
 */
$this->assign('title', 'Listing Department Schemes');

//$array_of_7_q = array(5 => 'img-210107074838.jpg', 4 => 'img-210107074652.jpg', 3 => 'img-210107074816.jpg', 2 => 'img-210107073217.jpg', 1 => 'img-210107074900.jpg');
use Cake\ORM\TableRegistry;
?>

<nav class="large-3 medium-4 columns" id="actions-sidebar">
    <ul class="side-nav">
        <li class="heading"><?= __('Actions') ?></li>
        <li> <?= $this->Html->link(__('<i class="fas fa-plus-square"></i> New Department Scheme'), ['action' => 'add'], ['escape' => false]) ?></li>
    </ul>
</nav>


<section class="card">


    <header class="card-header">
        <div class="card-actions">
            <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
            <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
        </div>
        <h3><?= __('Department Schemes') ?></h3>
    </header>

    <div class="departmentSchemes card-body content">
        <?php echo $this->Form->create(null, array('role' => 'form', 'class' => 'form-horizontal', 'type' => 'get')); ?>

        <div class="row">

            <div class="col-sm-4">
                <?= $this->Form->control('name', ['placeholder' => 'Search by Scheme name or code', 'label' => 'Scheme code or scheme name', 'class' => 'form-control', 'value' => isset($_GET['name']) ? $_GET['name'] : '']); ?>
                <br/>
            </div>

            <div class="col-sm-2">
                <?php
                //debug($Departments);
                echo $this->Form->control('status', ['label' => 'Choose Status', 'options' => [5 => 'Critically Delayed', 4 => 'Off Target', 3 => 'On Target', 2 => 'Completed', 1 => 'Not Started'], 'class' => 'form-control', 'empty' => 'Choose', 'value' => isset($_GET['status']) ? $_GET['status'] : '']);
                ?>
            </div>
            <div class="col-sm-2">

                <?= $this->Form->control('directive', ['class' => 'form-control', 'label' => 'Directive', 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['PM' => 'PM', 'CM' => 'CM', 'Cabinet' => 'Cabinet', 'CS' => 'CS', 'ACS' => 'ACS', 'Court' => 'Court'], 'value' => isset($_GET['directive']) ? $_GET['directive'] : '']) ?>

            </div>
            <div class="col-sm-2">

                <?= $this->Form->control('mega_project', ['class' => 'form-control', 'label' => 'Scheme Category', 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Mega' => 'Mega Schemes', 'High Priority' => 'High Priority Schemes', 'DFC (Two Years)' => 'DFC (Two Years) Schemes', 'DFC (Current Year)' => 'DFC (Current Year) Schemes', 'Normal' => 'Normal Schemes', 'All' => 'All Schemes'], 'value' => isset($_GET['mega_project']) ? $_GET['mega_project'] : '']) ?>

            </div>
            <div class="col-sm-2">

                <?= $this->Form->control('foreign_funded', ['class' => 'form-control', 'label' => 'Foreign Funded?', 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], 'value' => isset($_GET['foreign_funded']) ? $_GET['foreign_funded'] : '']) ?>

            </div>
            <div class="col-sm-2">

                <?= $this->Form->control('scheme_type', ['class' => 'form-control', 'label' => 'Scheme Type', 'empty' => 'Choose', 'options' => $project_types, 'value' => isset($_GET['scheme_type']) ? $_GET['scheme_type'] : '']) ?>

            </div>
            <div class="col-sm-2">
                <label for="Formations">Choose Formation(s)</label><br/>
                <?php
                //debug($Departments);
                echo $this->Form->control('formations[]', ['options' => $formations, 'label' => false, 'multiple', 'data-plugin-multiselect', 'data-plugin-options' => '{ "maxHeight": 200, "includeSelectAllOption": true ,"enableCaseInsensitiveFiltering": true}', 'class' => 'form-control', 'value' => isset($_GET['formations']) ? $_GET['formations'] : '']);
                ?>

            </div>
            <div class="col-sm-6">
                <label for="district">Choose District(s)</label><br/>
                <?php
                //debug($Departments);
                echo $this->Form->control('district[]', ['options' => $districts, 'label' => false, 'multiple', 'data-plugin-multiselect', 'data-plugin-options' => '{ "maxHeight": 200, "includeSelectAllOption": true ,"enableCaseInsensitiveFiltering": true}', 'class' => 'form-control', 'value' => isset($_GET['district']) ? $_GET['district'] : '']);
                ?>

            </div>
            <div class="col-sm-1">
                <br/>
                <?= $this->Form->button(__('Search'), ['class' => 'btn btn-primary']) ?>
                <br/>
            </div>

        </div>
        <?= $this->Form->end() ?>
        <hr>
        <?php
//        debug($pms);
        if ($departmentSchemes->toArray()) {
            ?>
            <center><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/horizental_status.jpg" style="height:50px;"> '; ?></center>
            <?= $this->Html->link(__('<i class="fas fa-download"></i> Export all schemes to Excel'), ['action' => 'exportall'], ['id' => 'makeurl', 'escape' => false, 'style' => 'float:right;']) ?>

            <table cellpadding="0" cellspacing="0" class="table table-no-more table-bordered table-striped mb-0">
                <thead>
                    <tr>
                        <?php if ($myUser->users_roles_id == 'cpo') { ?>
                            <th scope="col"><?= $this->Paginator->sort('attached_formation_id') ?></th>
                        <?php } ?>
                        <th scope="col"><?= $this->Paginator->sort('scheme_status_id') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('scheme_code') ?></th>

                        <th scope="col"><?= $this->Paginator->sort('scheme_name') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('scheme_type') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('directive') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('mega_project') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('foreign_funded') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('last_modified', 'Last Updated') ?></th>
                        <th scope="col"><?= $this->Paginator->sort('issues_list', 'Issues') ?></th>

                        <th scope="col" class="actions"><?= __('Actions') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $SchemeDistricts = TableRegistry::get('SchemesLogs');
//
                    foreach ($departmentSchemes as $departmentScheme):
//                        debug($departmentScheme->attached_formation);exit;
//                        $choosen_nav_districts = $SchemeDistricts->find('all', ['conditions' => ['SchemesLogs.department_scheme_id' => $departmentScheme->id], 'order' => ['SchemesLogs.id' => 'DESC']])->first();
//                        exit;
                        ?>
                        <tr>
                            <?php if ($myUser->users_roles_id == 'cpo') { ?>

                                <td class="text-left" data-title="Attached Formation" style="min-width: 225px;">
                                    <?= isset($departmentScheme->attached_formation) ? $departmentScheme->attached_formation->name : '' ?>
                                    <?= $this->Form->control('user_id', ['class' => 'form-control pm_chk', 'scheme_id' => $departmentScheme->id, 'label' => false, 'default' => 'Choose PM', 'empty' => 'Choose PM', 'options' => $pms, 'value' => $departmentScheme->user_id]) ?>

                                </td>
                            <?php } ?>
                            <td><?= '<img src="' . $this->request->getAttribute("webroot") . 'img/milestones_status/' . $departmentScheme->overall_status . '.PNG">'; ?></td>
                            <td class="text-left" data-title="Scheme Code"><?= $departmentScheme->scheme_code ?></td>
                            <td class="text-left" data-title="Scheme Name"><?= ucfirst($departmentScheme->scheme_name) ?></td>
                            <td class="text-left" data-title="Scheme Type"><?= ucfirst($departmentScheme->scheme_type) ?></td>
                            <td class="text-left" data-title="Scheme Directive"><?= ($departmentScheme->directive); ?></td>
                            <td class="text-left" data-title="Mega Project"><?= ($departmentScheme->mega_project == 'Yes') ? 'Yes' : 'No'; ?></td>
                            <td class="text-left" data-title="Foreign Funded?"><?= ($departmentScheme->foreign_funded == 'Yes') ? 'Yes' : 'No'; ?></td>

                            <td class="text-left" data-title="Modified"><?php
                                if (isset($departmentScheme->last_modified)) {
                                    echo date('d-m-Y h:i a', strtotime($departmentScheme->last_modified));
                                } else {
                                    echo "-";
                                }
                                ?></td>
                            <td class="text-left" data-title="Issues"><?= $departmentScheme->issues_list; ?></td>


                            <td class="actions">
                                <?= $this->Html->link(__('<i class="fas fa-eye"></i> View Details'), ['action' => 'view', $departmentScheme->id], ['escape' => false]) ?>
                                <?= $this->Html->link(__('<i class="fas fa-edit"></i> Edit Details'), ['action' => 'schemeprofile', $departmentScheme->id], ['escape' => false]) ?>
                                <?php $this->Form->postLink(__('<i class="fas fa-trash"></i> Delete'), ['action' => 'delete', $departmentScheme->id], ['confirm' => __('Are you sure you want to delete # {0}?', $departmentScheme->id), 'escape' => false]) ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <footer class="card-footer text-right">
                <div class="paginator">
                    <ul class="pagination">
                        <?= $this->Paginator->first('<< ' . __('first')) ?>
                        <?= $this->Paginator->prev('< ' . __('previous')) ?>
                        <?= $this->Paginator->numbers() ?>
                        <?= $this->Paginator->next(__('next') . ' >') ?>
                        <?= $this->Paginator->last(__('last') . ' >>') ?>
                    </ul>
                    <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
                </div>
            </footer>

            <?php
        } else {
            echo "<h4>No Scheme Found.</h4>";
        }
        ?>
    </div>
</section>
<!--    </div>
    <div class="col-sm-3 col-md-3">
        <div id="searchform_sidebar"style="position: static; top: 10px;">

<?= '<img src="' . $this->request->getAttribute("webroot") . 'img/status.PNG" style="margin-top:125px;"> '; ?>

        </div>
    </div>
</div>/row-->
<script>
    $(function () {
//        alert(302)
//        $(window).scroll(function () {
////        alert(304)
//
////        var otop = $(".scroll-top").offset().top;
//
////        alert($('.masturat').height());
//            var adjust_height = $('.masturat').height() - 50;
//            if ($(window).scrollTop() > 170 && $(window).scrollTop() < adjust_height && $(window).width() > 575)
//            {
////            alert($(window).scrollTop());
//                $(".content_left").css('position', 'fixed').css('top', '5px');
//                $("#searchform_sidebar").css('position', 'fixed').css('top', '10px').css('width', '25%');
//            } else
//            {
//                $(".content_left").css('position', 'static');
//                $("#searchform_sidebar").css('position', 'static').css('width', '100%');
//            }
//        });
        $('.pm_chk').on('change', function () {

            var rec_id = $(this).attr('scheme_id');


            var status = $(this).val();


            $.ajax({
                type: "GET",
                url: '<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/changepm',
                data: {id: rec_id, user_id: status}, // serializes the form's elements.
                dataType: 'json',
                success: function (data)
                {

                    $('#div_' + rec_id).html(status);
                    $('#small_' + rec_id).html('updated');

                }
            });
        });

    });

    var href_path = window.location.href;
    var rem = href_path.split('?');
    if (rem[1] !== undefined) {
//alert(rem[1]);
//alert($('#makeurl').attr('href'));
        var this_url = $('#makeurl').attr('href') + '?' + rem[1];
//alert(this_url);
        $('#makeurl').attr('href', this_url);
    }
</script>       