<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\DepartmentScheme $departmentScheme
 */
$this->assign('title', $departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')');
?>

<div class="column-responsive column-80">
    <div class="departmentSchemes col-sm-12 content">
        <?= $this->Form->create($departmentScheme, ['class' => 'form-horizontal', 'type' => 'file']) ?>
        <section class="card">
            <header class="card-header">

                <div class="card-actions">
                    <!-- <a href="#" class="card-action card-action-toggle" data-card-toggle=""></a>
                    <a href="#" class="card-action card-action-dismiss" data-card-dismiss=""></a>-->
                </div>

                <h2 class="card-title"><?= __($departmentScheme->scheme_code . '-' . str_replace("(AIP)", "", ucfirst($departmentScheme->scheme_name)) . ' (' . $departmentScheme->scheme_type . ')') ?></h2>
                <p class="card-subtitle">

                </p>

            </header>
            <div class="card-body">
                <?= $this->element('scheme_status_bar') ?>

                <fieldset>
                    <?php
                    echo '<div class="row"><div class="col-sm-5"><label>' . __('Is PC-II required?') . '</label></div>';
                    echo '<div class="col-sm-7">' . $this->Form->control('pc2_required', ['required', 'class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No']]) . '</div>';
                    echo '</div><!--/row-->';
                    ?>
                    <div id="q1" style="display:<?= ($departmentScheme->pc2_required == 'Yes') ? 'block' : 'none'; ?>; margin:20px;">

                        <?php
                        $required = ($departmentScheme->pc2_required == 'Yes') ? 'required' : '';

//                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the PC-II been approved?') . '</label></div>';
                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the PC-II been submitted to P & D / DDWP?') . '</label></div>';

                        echo '<div class="col-sm-7">' . $this->Form->control('pc2_approved', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the consultant been hired?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('consultant_hired', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Has the consultant submitted the report?') . '</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('cons_subt_report', ['class' => 'form-control', 'label' => false, 'default' => 'Choose', 'empty' => 'Choose', 'options' => ['Yes' => 'Yes', 'No' => 'No'], $required]) . '</div>';
                        echo '</div><!--/row-->';

//                        echo $this->Form->hidden('pc2_compl_old_date', ['id' => 'pc2_compl_old_date', 'value' => date('Y-m-d', strtotime($departmentScheme->pc2_compl_date))]);
//                        debug($departmentScheme->pc2_compl_date);

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('What is the expected completion date of the PC-II process?') . '</label></div>';
                        echo '<div class="col-sm-7">';
                        if ($departmentScheme->locked == 'Yes' && $departmentScheme->pc2_compl_date) {
                            if ($myUser->users_roles_id == 'pm') { //cant do anything
                                //display old date
                                echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc2_compl_date));
                            } else { //cpo
                                //check if mega project, if mega then cpo cant do as well anything else cpo can change
                                if ($departmentScheme->mega_project == 'Yes' || $departmentScheme->scheme_category == 'High Priority') {
                                    //cpo cant do anything too-display old date
                                    echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc2_compl_date));
                                } else {
                                    //cpo can do and show fields again
                                    echo $this->Form->control('pc2_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->pc2_compl_date) ? date('d-m-Y', strtotime($departmentScheme->pc2_compl_date)) : '', 'label' => false, 'type' => 'text', 'data-plugin-datepicker', 'data-date-end-date' => "0d", "data-date-format" => "dd-mm-yyyy", $required, 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date))]);
                                }
                            }
                        } else {
                            //show fields to change
                            echo $this->Form->control('pc2_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->pc2_compl_date) ? date('d-m-Y', strtotime($departmentScheme->pc2_compl_date)) : '', 'label' => false, 'type' => 'text', 'data-plugin-datepicker', 'data-date-end-date' => date('d-m-Y', strtotime($departmentScheme->scheme_end_date)), "data-date-format" => "dd-mm-yyyy", $required]);
                        }
//                        if ($departmentScheme->locked == 'Yes' && $departmentScheme->pc2_compl_date && $myUser->users_roles_id == 'pm' && $departmentScheme->mega_project == 'No') {
//                            echo date('j<\s\up>S</\s\up> F Y', strtotime($departmentScheme->pc2_compl_date));
//                        } else {
//                            echo $this->Form->control('pc2_compl_date', ['autocomplete' => "off", 'class' => 'form-control', 'value' => ($departmentScheme->pc2_compl_date) ? date('d-m-Y', strtotime($departmentScheme->pc2_compl_date)) : '', 'label' => false, 'type' => 'text', 'data-plugin-datepicker', "data-date-format" => "dd-mm-yyyy", $required]);
//                        }
                        echo '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5"><label>' . __('Who is responsible for the PC-II completion process?') . '</label></div>';
//                        debug($departments);exit;
                        $departments['Other'] = 'Other';
                        echo '<div class="col-sm-7">' . $this->Form->control('responsible_pc2_compl', ['class' => 'form-control', 'label' => false, 'empty' => 'Choose', 'value' => $departmentScheme->department_id, 'options' => $departments, $required]) . '</div>';
                        echo '</div><!--/row-->';

                        echo '<div class="row"><div class="col-sm-5">&nbsp;</div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('designation_step1', ['class' => 'form-control', 'label' => false, 'placeholder' => 'Enter Details like Designation (optional)']) . '</div>';
                        echo '</div><!--/row-->';

                        echo $this->Form->control('step1_old_remarks', ['value' => $departmentScheme->step1_remarks, 'type' => 'hidden']);

                        echo '<div class="row"><div class="col-sm-5"><label>Additional Comments</label></div>';
                        echo '<div class="col-sm-7">' . $this->Form->control('step1_remarks', ['class' => 'form-control', 'label' => false, 'placeholder' => '(Optional)']) . '</div>';
                        echo '</div><!--/row-->';
                        ?>
                    </div>

                    <?php
                    echo $this->Form->hidden('steps_array[1]', ['value' => $departmentScheme->step1_status]);
                    echo $this->Form->hidden('steps_array[2]', ['value' => $departmentScheme->step2_status]);
                    echo $this->Form->hidden('steps_array[3]', ['value' => $departmentScheme->step3_status]);
                    echo $this->Form->hidden('steps_array[4]', ['value' => $departmentScheme->step4_status]);
                    echo $this->Form->hidden('steps_array[5]', ['value' => $departmentScheme->step5_status]);
                    echo $this->Form->hidden('steps_array[6]', ['value' => $departmentScheme->step6_status]);
                    echo $this->Form->hidden('steps_array[7]', ['value' => $departmentScheme->step7_status]);
                    echo $this->Form->hidden('steps_array[8]', ['value' => $departmentScheme->custom_status]);
                    ?>
                </fieldset>

            </div><!--card-body-->

            <footer class="card-footer text-right">
                <a class="btn btn-primary pull-left" 
                   href="<?php echo $this->request->getAttribute("webroot"); ?>DepartmentSchemes/reldistricts/<?php echo $departmentScheme->id; ?>">
                    <i aria-hidden="true" class="fas fa-arrow-left"></i> Previous </a>
                <center>
                    <?php //echo '<strong>Milstones Status </strong><br/><img src="' . $this->request->getAttribute("webroot") . 'img/status.PNG" style="max-height:100px">';        ?>
                    <?php
                    if ($departmentScheme->locked == 'Yes' && $departmentScheme->pc2_required == 'Yes' && $departmentScheme->mega_project == 'Yes') {
                        if ($schemeRequests == 0) {
                            ?>
                            <a class="modal-with-form" href="#modalForm">Request Change for Expected Completion Date of the PC-II Process?</a>
                            <?php
                        } else {
                            echo "Request already pending to change date.";
                        }
                    }
                    ?>
                </center>
                <button class="btn btn-primary" type="submit">Next <i aria-hidden="true" class="fas fa-arrow-right"></i></button>
                    <?= $this->Form->end() ?>
            </footer>

        </section>
    </div>
</div>
<script>

    $(function () {

//        var scheme_code =<?= $departmentScheme->scheme_code; ?>;
//        var year =<?= $departmentScheme->year; ?>
//
////            alert($('#cost-of-scheme').val());
//
//        var dd = {YearID: year, Token: 'be7ee177-229e-4689-a356-12a904c5d2dd', SchemeCode: scheme_code};
//        var myJSON = JSON.stringify(dd);
//        $.ajax({
//            url: "http://pcfms.pndkp.gov.pk:9002/api/ADP/GetSchemeDetail",
//            type: 'POST',
//            contentType: 'application/json; charset=utf-8',
//            data: myJSON,
//            dataType: 'json',
//            success: function (data) {
//                $('.loader').hide();
//
//                if (data.CODE == 'SUCCESS' && data.Message == 'SUCCESS') {
//
//                    $.each(data.Data.SchemeDetail, function (key, item) {
//                        if (item.IsPC2 == 'No') {
//
//                            $('#pc2-required').empty().append('<option value="No">No</option>').val('No');
//                            $('#pc2-required').attr('readonly', true);
//                            $('#q1').find('input').attr('required', false);
//                            $('#q1').find('select').attr('required', false);
//
//                        } else {
//                            $('#pc2-required').empty().append('<option value="Yes">Yes</option>').val('Yes');
//                            $('#pc2-required').attr('readonly', true);
////                            $('#q1').find('input').attr('required', true);
////                            $('#q1').find('select').attr('required', true);
//                        }
//
//                    });
//
//                } else {
//                    alert(data.CODE + ': ' + data.Message);
//                }
//            }
//        });


        //q1
        $('body').on('change', '#pc2-required', function () {
//            alert('q1');
            if ($(this).val() == 'Yes') {

                $('#q1').show('slow');
                $('#q1').find('input').attr('required', true);
                $('#q1').find('select').attr('required', true);
            } else {
                $('#q1').find('input').attr('required', false);
                $('#q1').find('select').attr('required', false);
                $('#q1').find('input').val('');
                $('#q1').find('select').val('');

                $('#q1').hide('slow');
            }
            $('#designation-step1').attr('required', false);
        });
        //completion date change thing

//        $('body').on('change', '#pc2-compl-date', function () {
//
//            if ($('#pc2_compl_old_date').val() !== '1970-01-01' && $('#pc2_compl_old_date').val().trim() !== '') {
////                alert($('#pc2_compl_old_date').val());
//                if ($(this).val() !== $('#pc2_compl_old_date').val()) {
//                    alert('Oops, it looks you have changed the completion date, CMDU will get informed about this change.');
//                }
//            }
//        });
    });
</script>
